/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkInstruction;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkTextFieldDialogPane;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.listener.FwkPopupMenuUnregisterListener;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DControlInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DBoundingBox;
import com.highqsoft.p2d.P2DComponent;
import com.highqsoft.p2d.P2DFrame;
import com.highqsoft.p2d.P2DMouseEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuListener;

public class P2DComponentControl
extends FwkInstruction
implements P2DControlInterface {
    public static final String version = "$Revision: 1.4 $";
    protected P2DFrame moving;
    protected Point2D startingPoint;
    protected BufferedImage image;

    public String getVersion() {
        return version;
    }

    public void release() {
        this.moving = null;
        this.startingPoint = null;
        this.image = null;
        super.release();
    }

    public P2DComponentControl() {
        this.initialize();
        this.install(null);
    }

    public void initialize() {
        this.moving = null;
        this.startingPoint = null;
        this.image = null;
    }

    public void release(P2DComponentInterface component) {
        this.release();
    }

    public void install(P2DComponentInterface component) {
    }

    public void uninstall(P2DComponentInterface component) {
        this.release(component);
    }

    public void revalidate(P2DComponentInterface component, boolean recursive) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(P2DComponentInterface component, Point2D p, MouseEvent e) {
        Object object;
        if (component.getInternalMouseListenerActive()) {
            object = component.getTreeLock();
            synchronized (object) {
                FwkArrayInterface components = component.getP2DComponents();
                int size = components.size();
                for (int i = 0; i < size; ++i) {
                    Object o = components.get(i);
                    if (!(o instanceof P2DComponent)) continue;
                    ((P2DComponentInterface)components.get(i)).mouseClicked(p, e);
                }
            }
        }
        object = component.getTreeLock();
        synchronized (object) {
            P2DBoundingBoxInterface box = component.getBoundingBox();
            if (box.contains(p)) {
                P2DMouseEvent ev = new P2DMouseEvent(component, e);
                FwkArrayInterface arr = component.getMouseListenerArray();
                int size = arr.size();
                for (int i = 0; i < size; ++i) {
                    MouseListener listener = (MouseListener)arr.get(i);
                    listener.mouseClicked(ev);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(P2DComponentInterface component, Point2D p, MouseEvent e) {
        Object object;
        if (component.getInternalMouseListenerActive()) {
            if ((e.getModifiers() & 0x10) != 0) {
                P2DContainerInterface container = null;
                try {
                    container = (P2DContainerInterface)e.getSource();
                }
                catch (Throwable tContainer) {
                    // empty catch block
                }
                if (container != null && component.getActive(container)) {
                    try {
                        if (component.getFrame().getArmedHandle(p) != -1) {
                            this.startingPoint = new Point2D.Double(p.getX(), p.getY());
                        }
                    }
                    catch (Throwable t) {}
                } else {
                    this.startingPoint = null;
                }
            }
            object = component.getTreeLock();
            synchronized (object) {
                FwkArrayInterface components = component.getP2DComponents();
                int size = components.size();
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        Object o = components.get(i);
                        if (!(o instanceof P2DComponent)) continue;
                        ((P2DComponentInterface)components.get(i)).mousePressed(p, e);
                    }
                }
            }
        }
        object = component.getTreeLock();
        synchronized (object) {
            P2DBoundingBoxInterface box = component.getBoundingBox();
            if (box.contains(p)) {
                P2DMouseEvent ev = new P2DMouseEvent(component, e);
                FwkArrayInterface arr = component.getMouseListenerArray();
                int size = arr.size();
                for (int i = 0; i < size; ++i) {
                    MouseListener listener = (MouseListener)arr.get(i);
                    listener.mousePressed(ev);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(P2DComponentInterface component, Point2D p, MouseEvent e) {
        Object object;
        if (component.isInternalMouseListenerActive()) {
            if (this.moving != null && (e.getModifiers() & 0x10) != 0) {
                this.startingPoint = null;
                component.setBoundingBox(new P2DBoundingBox(this.moving.getBoundingBox()));
                ((Component)e.getSource()).setCursor(P2D.getCursor(-1));
                this.moving = null;
                component.revalidate(false);
                component.repaint();
            }
            object = component.getTreeLock();
            synchronized (object) {
                FwkArrayInterface components = component.getP2DComponents();
                int size = components.size();
                for (int i = 0; i < size; ++i) {
                    Object o = components.get(i);
                    if (!(o instanceof P2DComponent)) continue;
                    ((P2DComponentInterface)components.get(i)).mouseReleased(p, e);
                }
            }
        } else {
            this.startingPoint = null;
            this.moving = null;
        }
        this.image = null;
        object = component.getTreeLock();
        synchronized (object) {
            P2DBoundingBoxInterface box = component.getBoundingBox();
            if (box.contains(p)) {
                P2DMouseEvent ev = new P2DMouseEvent(component, e);
                FwkArrayInterface arr = component.getMouseListenerArray();
                int size = arr.size();
                for (int i = 0; i < size; ++i) {
                    MouseListener listener = (MouseListener)arr.get(i);
                    listener.mouseReleased(ev);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseEntered(P2DComponentInterface component, Point2D p, MouseEvent e) {
        Object object;
        if (component.isInternalMouseListenerActive()) {
            object = component.getTreeLock();
            synchronized (object) {
                FwkArrayInterface components = component.getP2DComponents();
                int size = components.size();
                for (int i = 0; i < size; ++i) {
                    Object o = components.get(i);
                    if (!(o instanceof P2DComponent)) continue;
                    ((P2DComponentInterface)components.get(i)).mouseEntered(p, e);
                }
            }
        }
        object = component.getTreeLock();
        synchronized (object) {
            P2DBoundingBoxInterface box = component.getBoundingBox();
            if (box.contains(p)) {
                P2DMouseEvent ev = new P2DMouseEvent(component, e);
                FwkArrayInterface arr = component.getMouseListenerArray();
                int size = arr.size();
                for (int i = 0; i < size; ++i) {
                    MouseListener listener = (MouseListener)arr.get(i);
                    listener.mouseEntered(ev);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseExited(P2DComponentInterface component, Point2D p, MouseEvent e) {
        Object object;
        if (component.isInternalMouseListenerActive()) {
            object = component.getTreeLock();
            synchronized (object) {
                FwkArrayInterface components = component.getP2DComponents();
                int size = components.size();
                for (int i = 0; i < size; ++i) {
                    Object o = components.get(i);
                    if (!(o instanceof P2DComponent)) continue;
                    ((P2DComponentInterface)components.get(i)).mouseExited(p, e);
                }
            }
        }
        object = component.getTreeLock();
        synchronized (object) {
            P2DMouseEvent ev = new P2DMouseEvent(component, e);
            FwkArrayInterface arr = component.getMouseListenerArray();
            int size = arr.size();
            for (int i = 0; i < size; ++i) {
                MouseListener listener = (MouseListener)arr.get(i);
                listener.mouseExited(ev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focusGained(P2DComponentInterface component, Point2D p, FocusEvent e) {
        Object object = component.getTreeLock();
        synchronized (object) {
            FwkArrayInterface components = component.getP2DComponents();
            int size = components.size();
            for (int i = 0; i < size; ++i) {
                Object o = components.get(i);
                if (!(o instanceof P2DComponent)) continue;
                ((P2DComponentInterface)components.get(i)).focusGained(p, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focusLost(P2DComponentInterface component, Point2D p, FocusEvent e) {
        Object object = component.getTreeLock();
        synchronized (object) {
            FwkArrayInterface components = component.getP2DComponents();
            int size = components.size();
            for (int i = 0; i < size; ++i) {
                Object o = components.get(i);
                if (!(o instanceof P2DComponent)) continue;
                ((P2DComponentInterface)components.get(i)).focusLost(p, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(P2DComponentInterface component, Point2D p, MouseEvent e) {
        Object object;
        if (component.isInternalMouseListenerActive()) {
            object = component.getTreeLock();
            synchronized (object) {
                FwkArrayInterface components = component.getP2DComponents();
                int size = components.size();
                for (int i = 0; i < size; ++i) {
                    Object o = components.get(i);
                    if (!(o instanceof P2DComponent)) continue;
                    ((P2DComponentInterface)components.get(i)).mouseMoved(p, e);
                }
            }
        }
        object = component.getTreeLock();
        synchronized (object) {
            P2DBoundingBoxInterface box = component.getBoundingBox();
            if (box.contains(p)) {
                P2DMouseEvent ev = new P2DMouseEvent(component, e);
                FwkArrayInterface arr = component.getMouseMotionListenerArray();
                int size = arr.size();
                for (int i = 0; i < size; ++i) {
                    MouseMotionListener listener = (MouseMotionListener)arr.get(i);
                    listener.mouseMoved(ev);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(P2DComponentInterface component, Point2D p, MouseEvent e) {
        Object object;
        if (component.isInternalMouseListenerActive()) {
            if (this.startingPoint != null) {
                if (this.moving == null) {
                    this.moving = new P2DFrame(component.getFrame());
                    this.moving.setVisible(true);
                    Component c = (Component)e.getSource();
                    Dimension d = c.getSize();
                    this.image = (BufferedImage)c.createImage(d.width, d.height);
                    Graphics2D g = this.image.createGraphics();
                    c.paint(g);
                    g.dispose();
                }
                if (this.moving != null) {
                    ((Component)e.getSource()).setCursor(P2D.getCursor(component.getActiveHandle()));
                    try {
                        Point2D.Double cp = new Point2D.Double(p.getX(), p.getY());
                        P2DBoundingBoxInterface bb = component.calculateBoundingBoxRelativeTo(this.moving.getBoundingBox(), new Point2D.Double(p.getX() - this.startingPoint.getX(), p.getY() - this.startingPoint.getY()));
                        if (bb != null) {
                            this.startingPoint = cp;
                            ((Component)e.getSource()).setCursor(P2D.getCursor(component.getActiveHandle()));
                            this.moving.setBoundingBox(bb);
                            double dx = bb.getLower().getX() - component.getBoundingBox().getLower().getX();
                            double dy = bb.getLower().getY() - component.getBoundingBox().getLower().getY();
                            Component c = (Component)e.getSource();
                            Graphics2D graphics = (Graphics2D)c.getGraphics();
                            graphics.drawImage((Image)this.image, 0, 0, (ImageObserver)e.getSource());
                            Graphics2D g = (Graphics2D)graphics.create();
                            AffineTransform at = component.getTransform((P2DContainerInterface)e.getSource());
                            if (at != null) {
                                g.setTransform(at);
                                g.translate(dx, dy);
                                this.moving.paint(g);
                            }
                            graphics.dispose();
                            g.dispose();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            object = component.getTreeLock();
            synchronized (object) {
                FwkArrayInterface components = component.getP2DComponents();
                int size = components.size();
                for (int i = 0; i < size; ++i) {
                    Object o = components.get(i);
                    if (!(o instanceof P2DComponent)) continue;
                    ((P2DComponentInterface)components.get(i)).mouseDragged(p, e);
                }
            }
        }
        this.startingPoint = null;
        this.moving = null;
        object = component.getTreeLock();
        synchronized (object) {
            P2DBoundingBoxInterface box = component.getBoundingBox();
            if (box.contains(p)) {
                P2DMouseEvent ev = new P2DMouseEvent(component, e);
                FwkArrayInterface arr = component.getMouseMotionListenerArray();
                int size = arr.size();
                for (int i = 0; i < size; ++i) {
                    MouseMotionListener listener = (MouseMotionListener)arr.get(i);
                    listener.mouseDragged(ev);
                }
            }
        }
    }

    public void processFocusEvent(P2DComponentInterface component, Point2D p, FocusEvent e) {
        switch (e.getID()) {
            case 1004: {
                this.focusGained(component, p, e);
                break;
            }
            case 1005: {
                this.focusLost(component, p, e);
            }
        }
    }

    public void processMouseEvent(P2DComponentInterface component, Point2D p, MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                this.mousePressed(component, p, e);
                break;
            }
            case 502: {
                this.mouseReleased(component, p, e);
                break;
            }
            case 500: {
                this.mouseClicked(component, p, e);
                break;
            }
            case 505: {
                this.mouseExited(component, p, e);
                break;
            }
            case 504: {
                this.mouseEntered(component, p, e);
                break;
            }
            case 503: {
                this.mouseMoved(component, p, e);
                break;
            }
            case 506: {
                this.mouseDragged(component, p, e);
            }
        }
    }

    public String askForName(Container parent, P2DComponentInterface component, String title, String defaultValue) {
        if (title == null) {
            title = FwkPropertyBus.getProperty((String)"P2DComponent.Text.AskForNameTitle");
        }
        if (defaultValue == null) {
            defaultValue = component.getName();
        }
        String ret = null;
        FwkTextFieldDialogPane pane = new FwkTextFieldDialogPane();
        FwkDialogPaneValueInterface textValue = pane.getSelectedValue();
        textValue.setProperty("TextField", (Object)defaultValue);
        pane.setSelectedValue(textValue);
        textValue = FwkDialogFactory.showDialog((Component)parent, (String)title, (String)"", (FwkDialogPaneInterface)pane);
        if (textValue != null) {
            ret = (String)textValue.getProperty("TextField");
        }
        return ret;
    }

    public boolean openPopupMenu(P2DComponentInterface component, MouseEvent ev) {
        JPopupMenu popup;
        FwkCommandInterface[] commands = component.getCommands();
        if (commands != null && commands.length != 0 && (popup = FwkGUIFactory.createPopupMenu((String)component.getShortName(), (FwkCommandInterface[])commands, (boolean)false)) != null) {
            popup.addPopupMenuListener((PopupMenuListener)FwkPopupMenuUnregisterListener.getInstance());
            popup.show((Component)ev.getSource(), ev.getX(), ev.getY());
            return true;
        }
        return false;
    }
}

