/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkAppearance;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkInfoBusMember;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.command.FwkColorCommand;
import com.highqsoft.fwk.command.FwkColorSelectCommand;
import com.highqsoft.fwk.command.FwkMethodCommand;
import com.highqsoft.fwk.dialog.FwkColorDialogPane;
import com.highqsoft.fwk.dialog.FwkFontDialogPane;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.p2d.P2DBackgroundInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DFrameInterface;
import com.highqsoft.interfaces.p2d.P2DModelInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DBackground;
import com.highqsoft.p2d.P2DBoundingBox;
import com.highqsoft.p2d.P2DCanvas;
import com.highqsoft.p2d.P2DFrame;
import com.highqsoft.p2d.P2DUnselectCommand;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;

public class P2DComponentModel
extends FwkInfoBusMember
implements P2DModelInterface {
    public static final String version = "$Revision: 1.5 $";
    public static final String PROPERTIES_TEXT_KEY = "P2DComponent.Text.Properties";
    public static final String VISIBLE_TEXT_KEY = "P2DComponent.Text.Visible";
    public static final String BACKGROUND_VISIBLE_TEXT_KEY = "P2DComponent.Text.Background.Visible";
    public static final String COLOR_TEXT_KEY = "P2DComponent.Text.Color";
    public static final String COLOR_TOOLTIP_KEY = "P2DComponent.Tooltip.Color";
    public static final String BACKGROUND_COLOR_TEXT_KEY = "P2DComponent.Text.BackgroundColor";
    public static final String BACKGROUND_COLOR_TOOLTIP_KEY = "P2DComponent.Tooltip.BackgroundColor";
    public static final String FRAME_COLOR_TEXT_KEY = "P2DComponent.Text.FrameColor";
    public static final String FRAME_COLOR_TOOLTIP_KEY = "P2DComponent.Tooltip.FrameColor";
    public static final String FONT_TEXT_KEY = "P2DComponent.Text.Font";
    public static final String FONT_TOOLTIP_KEY = "P2DComponent.Tooltip.Font";
    public static final String COLOR_IDENT = "Color";
    public static final String BACKGROUND_COLOR_IDENT = "BackgroundColor";
    public static final String FRAME_COLOR_IDENT = "FrameColor";
    public static final String FONT_IDENT = "Font";
    protected P2DBackgroundInterface background;
    protected FwkAppearanceInterface appearance;
    protected P2DBoundingBoxInterface boundingBox;
    protected P2DFrameInterface frame;
    protected HashMap containerMap;
    protected boolean ratioFix = false;
    protected boolean decorated = true;
    protected boolean internalMouseListenerActive = true;
    protected static HashMap staticPanes = null;

    public String getVersion() {
        return version;
    }

    public void release() {
        this.background.release();
        this.appearance.release();
        this.boundingBox.release();
        if (this.containerMap != null) {
            this.containerMap.clear();
        }
        this.containerMap = null;
        super.release();
    }

    public P2DComponentModel() {
        this.initialize();
        this.install(null);
    }

    public void release(P2DComponentInterface component) {
        this.release();
    }

    public void uninstall(P2DComponentInterface component) {
        this.release(component);
    }

    public void initialize() {
        this.boundingBox = new P2DBoundingBox();
        this.appearance = new FwkAppearance();
        this.frame = new P2DFrame();
        this.frame.setVisible(false);
        this.background = new P2DBackground();
        this.background.setColor(P2D.white());
        this.background.setTransparency(1.0f);
    }

    public void install(P2DComponentInterface c) {
        this.frame.setBoundingBox(this.boundingBox);
        this.background.setBoundingBox(this.boundingBox);
    }

    public void revalidate(P2DComponentInterface component, boolean recursive) {
    }

    public void setRatioFix(P2DComponentInterface component, boolean flag) {
        if (this.ratioFix != flag) {
            this.ratioFix = flag;
            if (flag) {
                this.frame.setHandle(1, false);
                this.frame.setHandle(3, false);
                this.frame.setHandle(5, false);
                this.frame.setHandle(7, false);
            }
        }
    }

    public boolean getRatioFix(P2DComponentInterface component) {
        return this.ratioFix;
    }

    public void registerContainer(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g) {
        if (container != null) {
            if (this.containerMap == null) {
                this.containerMap = new HashMap();
            }
            Rectangle rect = g.getClipBounds();
            try {
                Dimension dim = ((P2DCanvas)container).getSize();
                if (rect == null || rect.width >= dim.width && rect.height >= dim.height) {
                    this.setTransform(component, container, g.getTransform());
                }
            }
            catch (Throwable t) {
                this.setTransform(component, container, g.getTransform());
            }
        }
    }

    public void unregisterContainer(P2DComponentInterface component, P2DContainerInterface container) {
        if (this.containerMap != null) {
            this.containerMap.remove(container);
        }
    }

    public Point2D transformPoint(P2DComponentInterface component, P2DContainerInterface container, Point2D p) {
        AffineTransform at = this.getTransform(component, container);
        Point2D.Double dst = new Point2D.Double();
        try {
            return at.inverseTransform(p, dst);
        }
        catch (Throwable t) {
            return p;
        }
    }

    public AffineTransform getTransform(P2DComponentInterface component, P2DContainerInterface container) {
        if (this.containerMap != null && container != null) {
            return (AffineTransform)this.containerMap.get(container);
        }
        return null;
    }

    public void setTransform(P2DComponentInterface component, P2DContainerInterface container, AffineTransform trans) {
        if (container != null) {
            if (this.containerMap == null) {
                this.containerMap = new HashMap();
            }
            this.containerMap.put(container, trans);
        }
    }

    public boolean isInside(P2DComponentInterface component, P2DComponentInterface child, Point2D p) {
        try {
            return this.boundingBox.getScaledBoundingBox().contains(p);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return true;
        }
    }

    public boolean isInside(P2DComponentInterface component, P2DComponentInterface child, P2DBoundingBoxInterface box) {
        return this.isInside(component, child, box.getScaledLower()) && this.isInside(component, child, box.getScaledUpper());
    }

    public boolean containsAllChildren(P2DComponentInterface component, Point2D lower, Point2D upper) {
        return this.containsAllChildren(component, new P2DBoundingBox(lower, upper));
    }

    public boolean containsAllChildren(P2DComponentInterface component, P2DBoundingBoxInterface box) {
        boolean result = true;
        FwkArrayInterface arr = component.getP2DComponents();
        int size = arr.size();
        P2DBoundingBoxInterface bb = box.getScaledBoundingBox();
        for (int i = 0; result && i < size; ++i) {
            if (!(arr.get(i) instanceof P2DComponentInterface)) continue;
            P2DComponentInterface comp = (P2DComponentInterface)arr.get(i);
            result = bb.isInside(comp.getBoundingBox());
        }
        return result;
    }

    public void setAppearance(P2DComponentInterface component, FwkAppearanceInterface appearance) {
        this.appearance = appearance;
    }

    public FwkAppearanceInterface getAppearance(P2DComponentInterface component) {
        return this.appearance;
    }

    public boolean isInternalMouseListenerActive(P2DComponentInterface component) {
        return this.internalMouseListenerActive;
    }

    public void setInternalMouseListenerActive(P2DComponentInterface component, boolean flag) {
        this.internalMouseListenerActive = flag;
    }

    public void setColor(Color c) {
        this.appearance.setColor(c);
    }

    public Color getColor() {
        return this.appearance.getColor();
    }

    public void setTransparency(float t) {
        this.appearance.setTransparency(t);
    }

    public float getTransparency() {
        return this.appearance.getTransparency();
    }

    public void setFont(Font font) {
        this.appearance.setFont(font);
    }

    public Font getFont() {
        return this.appearance.getFont();
    }

    public void setStroke(Stroke s) {
        this.appearance.setStroke(s);
    }

    public Stroke getStroke() {
        return this.appearance.getStroke();
    }

    public void setLineWidth(float w) {
        this.appearance.setLineWidth(w);
    }

    public float getLineWidth() {
        return this.appearance.getLineWidth();
    }

    public void setDashArray(float[] arr) {
        this.appearance.setDashArray(arr);
    }

    public float[] getDashArray() {
        return this.appearance.getDashArray();
    }

    public void setDashPhase(float phase) {
        this.appearance.setDashPhase(phase);
    }

    public float getDashPhase() {
        return this.appearance.getDashPhase();
    }

    public void setEndCap(int cap) {
        this.appearance.setEndCap(cap);
    }

    public int getEndCap() {
        return this.appearance.getEndCap();
    }

    public void setLineJoin(int join) {
        this.appearance.setLineJoin(join);
    }

    public int getLineJoin() {
        return this.appearance.getLineJoin();
    }

    public void setMiterLimit(float limit) {
        this.appearance.setMiterLimit(limit);
    }

    public float getMiterLimit() {
        return this.appearance.getMiterLimit();
    }

    public void setFill(Shape s) {
        this.appearance.setFill(s);
    }

    public Shape getFill() {
        return this.appearance.getFill();
    }

    public void setTransform(P2DComponentInterface component, AffineTransform t) {
    }

    public void setTranslation(P2DComponentInterface component, double x, double y) {
    }

    public Point2D getTranslation(P2DComponentInterface component) {
        return new Point2D.Double(0.0, 0.0);
    }

    public void setClip(double x, double y, double width, double height) {
        this.appearance.setClip(x, y, width, height);
    }

    public void setClip(Shape clip) {
        this.appearance.setClip(clip);
    }

    public Shape getClip() {
        return this.appearance.getClip();
    }

    public void configure(P2DComponentInterface component, Graphics2D g) {
        this.getAppearance(component).configure(g);
    }

    public boolean isVisible() {
        return this.appearance.isVisible();
    }

    public void setVisible(boolean flag) {
        this.appearance.setVisible(flag);
    }

    public boolean getVisible() {
        return this.appearance.isVisible();
    }

    public BasicStroke scaleStroke(P2DComponentInterface component, AffineTransform at) {
        return this.appearance.scaleStroke(at);
    }

    public BasicStroke scaleStroke(P2DComponentInterface component, AffineTransform at, float lw) {
        return this.appearance.scaleStroke(at, lw);
    }

    public synchronized void setBoundingBox(P2DComponentInterface component, P2DBoundingBoxInterface boundingBox) {
        if (!this.boundingBox.equals(boundingBox)) {
            this.boundingBox = boundingBox;
            this.frame.setBoundingBox(boundingBox);
            this.background.setBoundingBox(boundingBox);
        }
    }

    public P2DBoundingBoxInterface getBoundingBox(P2DComponentInterface component) {
        return this.boundingBox;
    }

    public P2DBoundingBoxInterface closestIntersection(P2DBoundingBoxInterface[] bounds) {
        return this.boundingBox.closestIntersection(bounds);
    }

    public boolean intersects(P2DBoundingBoxInterface bounds) {
        return this.boundingBox.intersects(bounds);
    }

    public boolean intersects(P2DBoundingBoxInterface[] bounds) {
        return this.boundingBox.intersects(bounds);
    }

    public boolean intersects(P2DBoundingBoxInterface[] bounds, P2DBoundingBoxInterface newBoundBox) {
        return this.boundingBox.intersects(bounds, newBoundBox);
    }

    public boolean intersects(P2DBoundingBoxInterface bounds, P2DBoundingBoxInterface newBoundBox) {
        return this.boundingBox.intersects(bounds, newBoundBox);
    }

    public boolean contains(Point2D p) {
        return this.boundingBox.contains(p);
    }

    public boolean contains(P2DBoundingBoxInterface box) {
        return this.boundingBox.contains(box);
    }

    public void getLower(Point2D lower) {
        this.boundingBox.getLower(lower);
    }

    public Point2D getUpper() {
        return this.boundingBox.getUpper();
    }

    public Point2D getLower() {
        return this.boundingBox.getLower();
    }

    public Point2D getScaledUpper() {
        return this.boundingBox.getScaledUpper();
    }

    public Point2D getScaledLower() {
        return this.boundingBox.getScaledLower();
    }

    public void getScaledUpper(Point2D upper) {
        this.boundingBox.getScaledUpper(upper);
    }

    public void getScaledLower(Point2D lower) {
        this.boundingBox.getScaledLower(lower);
    }

    public void getUpper(Point2D upper) {
        this.boundingBox.getUpper(upper);
    }

    public void setLower(Point2D lower) {
        this.boundingBox.getLower(lower);
    }

    public void setUpper(Point2D upper) {
        this.boundingBox.setUpper(upper);
    }

    public double getArea() {
        return this.boundingBox.getArea();
    }

    public double getWidth(P2DComponentInterface component) {
        return this.boundingBox.getWidth();
    }

    public double getHeight(P2DComponentInterface component) {
        return this.boundingBox.getHeight();
    }

    public double getScaledWidth() {
        return this.boundingBox.getScaledWidth();
    }

    public double getScaledHeight() {
        return this.boundingBox.getScaledHeight();
    }

    public void setWidth(double width) {
        this.boundingBox.setWidth(width);
    }

    public void setHeight(double height) {
        this.boundingBox.setHeight(height);
    }

    public Rectangle2D getRectangle() {
        return this.boundingBox.getRectangle();
    }

    public void move(double xDiff, double yDiff) {
        this.boundingBox.move(xDiff, yDiff);
    }

    public boolean isInside(P2DBoundingBoxInterface box) {
        return this.boundingBox.isInside(box);
    }

    public void setScale(double xFactor, double yFactor) {
        this.boundingBox.setScale(xFactor, yFactor);
    }

    public void setOffset(double xOffset, double yOffset) {
        this.boundingBox.setOffset(xOffset, yOffset);
    }

    public void setXScale(double offset, double scale) {
        this.boundingBox.setXScale(offset, scale);
    }

    public void setYScale(double offset, double scale) {
        this.boundingBox.setYScale(offset, scale);
    }

    public double getXFactor() {
        return this.boundingBox.getXFactor();
    }

    public double getYFactor() {
        return this.boundingBox.getYFactor();
    }

    public double getXOffset() {
        return this.boundingBox.getXOffset();
    }

    public double getYOffset() {
        return this.boundingBox.getYOffset();
    }

    public AffineTransform getTransform(P2DComponentInterface component) {
        return this.boundingBox.getTransform();
    }

    public AffineTransform getInverseTransform(P2DComponentInterface component) {
        return this.boundingBox.getInverseTransform();
    }

    public Point2D transformPoint(P2DComponentInterface component, Point2D p) {
        return this.boundingBox.transformPoint(p);
    }

    public Point2D inverseTransformPoint(P2DComponentInterface component, Point2D p) {
        return this.boundingBox.inverseTransformPoint(p);
    }

    public boolean getBackgroundVisible(P2DComponentInterface component) {
        return this.background.getVisible();
    }

    public void setBackgroundVisible(P2DComponentInterface component, boolean flag) {
        this.background.setVisible(flag);
    }

    public void setBackgroundColor(P2DComponentInterface component, Color color) {
        this.background.setColor(color);
    }

    public Color getBackgroundColor(P2DComponentInterface component) {
        return this.background.getColor();
    }

    public void setBackgroundTransparency(P2DComponentInterface component, float transparency) {
        this.background.setTransparency(transparency);
    }

    public float getBackgroundTransparency(P2DComponentInterface component) {
        return this.background.getTransparency();
    }

    public P2DFrameInterface getFrame(P2DComponentInterface component) {
        return this.frame;
    }

    public void setFrameVisible(P2DComponentInterface component, boolean flag) {
        this.frame.setVisible(flag);
    }

    public boolean getFrameVisible(P2DComponentInterface component) {
        return this.frame.getVisible();
    }

    public void setFrameLinesVisible(P2DComponentInterface component, boolean flag) {
        this.frame.setLinesVisible(flag);
    }

    public boolean getFrameLinesVisible(P2DComponentInterface component) {
        return this.frame.getLinesVisible();
    }

    public void setFrameHandlesVisible(P2DComponentInterface component, boolean flag) {
        this.frame.setHandlesVisible(flag);
    }

    public boolean getFrameHandlesVisible(P2DComponentInterface component) {
        return this.frame.getHandlesVisible();
    }

    public boolean frameHasHandles(P2DComponentInterface component) {
        return this.frame.hasHandles();
    }

    public void setFrameColor(P2DComponentInterface component, Color color) {
        this.frame.setColor(color);
    }

    public Color getFrameColor(P2DComponentInterface component) {
        return this.frame.getColor();
    }

    public void setFrameTransparency(P2DComponentInterface component, float transparency) {
        this.frame.setTransparency(transparency);
    }

    public float getFrameTransparency(P2DComponentInterface component) {
        return this.frame.getTransparency();
    }

    public void setActive(P2DComponentInterface component, P2DContainerInterface container, boolean flag) {
        this.frame.setVisible(flag);
    }

    public boolean getActive(P2DComponentInterface component, P2DContainerInterface container) {
        return this.frame.getVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveChild(P2DComponentInterface component, P2DContainerInterface container) {
        Object object = component.getTreeLock();
        synchronized (object) {
            boolean ret = false;
            FwkArrayInterface components = component.getP2DComponents();
            int i = components.size() - 1;
            while (i >= 0 && !ret) {
                ret = ((P2DComponentInterface)components.get(i--)).getActive(container);
            }
            return ret;
        }
    }

    public void resetActiveHandle(P2DComponentInterface component) {
        this.frame.resetArmedHandle();
    }

    public int getActiveHandle(P2DComponentInterface component) {
        return this.frame.getArmedHandle();
    }

    public void setActiveHandle(P2DComponentInterface component, int index) {
        this.frame.setArmedHandle(index);
    }

    public void getAllArmedComponents(P2DComponentInterface component, P2DContainerInterface container, double x, double y, FwkArrayInterface arr) {
        this.getAllArmedComponents(component, container, new Point2D.Double(x, y), arr);
    }

    public void getAllArmedComponents(P2DComponentInterface component, P2DContainerInterface container, Point2D p, FwkArrayInterface arr) {
        AffineTransform at;
        if (component.getSelectable() && (at = component.getTransform(container)) != null) {
            Point2D.Double t = new Point2D.Double();
            try {
                at.inverseTransform(p, t);
                if (this.boundingBox.contains(t)) {
                    FwkArrayInterface comps;
                    if (component.getSelectable()) {
                        arr.add((Object)component);
                    }
                    if ((comps = component.getP2DComponentArray()) != null) {
                        for (int i = comps.size() - 1; i >= 0; --i) {
                            P2DComponentInterface comp = (P2DComponentInterface)comps.get(i);
                            comp.getAllArmedComponents(container, t, arr);
                        }
                    }
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
        }
    }

    public P2DComponentInterface getChild(P2DComponentInterface component, Point2D p) {
        Point2D t;
        P2DComponentInterface ret = null;
        if (component.getSelectable() && this.boundingBox.contains(t = this.boundingBox.inverseTransformPoint(p))) {
            ret = component;
            this.frame.getArmedHandle(p);
            FwkArrayInterface arr = component.getP2DComponentArray();
            if (arr != null) {
                P2DComponentInterface armed = null;
                for (int i = arr.size() - 1; i >= 0 && armed == null; --i) {
                    P2DComponentInterface comp;
                    if (!(arr.get(i) instanceof P2DComponentInterface) || !(comp = (P2DComponentInterface)arr.get(i)).getSelectable() || comp.getChild(t) == null) continue;
                    armed = comp;
                }
                if (armed != null) {
                    ret = armed;
                }
            }
        }
        return ret;
    }

    public P2DComponentInterface getChild(P2DComponentInterface component, double x, double y) {
        return this.getChild(component, new Point2D.Double(x, y));
    }

    public HashMap getContainerMap(P2DComponentInterface component) {
        return this.containerMap;
    }

    public void setContainerMap(P2DComponentInterface component, HashMap map) {
        this.containerMap = map;
    }

    public P2DBackgroundInterface getBackground(P2DComponentInterface component) {
        return this.background;
    }

    public FwkCommandInterface[] getCommands(P2DComponentInterface component) {
        if (!this.commandsAvailable()) {
            super.getCommands();
            P2DUnselectCommand cb = new P2DUnselectCommand((FwkControllerInterface)component);
            component.addCommand(0, (FwkCommandInterface)cb);
            cb = new FwkCommand();
            cb.setSeparator(true);
            component.addCommand(0, (FwkCommandInterface)cb);
            FwkCommandInterface parent = this.getCommand("Help");
            if (parent == null) {
                parent = new FwkCommand((FwkControllerInterface)component);
                parent.setCommandName("Help");
                parent.setTextKey("P2D.Text.Help");
                this.addCommand(0, parent);
            }
            cb = new FwkCommand((FwkControllerInterface)component);
            cb.setCommandName("ComponentHelp");
            cb.setTextKey("P2D.Text.ComponentHelp");
            cb.setIconKey("Icon.HelpBrokerBrick");
            cb.setHelpID("com.highqsoft.p2d.P2DComponent");
            parent.addCommand(0, (FwkCommandInterface)cb);
            parent = new FwkCommand((FwkControllerInterface)component);
            parent.setTextKey("P2D.Text.Order");
            parent.setCommandName("Order");
            this.addCommand(0, parent);
            cb = new FwkMethodCommand((FwkControllerInterface)component);
            cb.setTextKey("P2D.Text.ToFront");
            cb.setCommandName("toFront");
            parent.addCommand((FwkCommandInterface)cb);
            cb = new FwkMethodCommand((FwkControllerInterface)component);
            cb.setTextKey("P2D.Text.ToBack");
            cb.setCommandName("toBack");
            parent.addCommand((FwkCommandInterface)cb);
            parent = new FwkCommand((FwkControllerInterface)component);
            parent.setTextKey("P2D.Text.FrameColor");
            parent.setCommandName("FrameColorMenu");
            component.addCommand(0, parent);
            cb = new FwkColorSelectCommand((FwkControllerInterface)component);
            cb.setTextKey("P2D.Text.FrameColor");
            cb.setCommandName(FRAME_COLOR_IDENT);
            parent.addCommand((FwkCommandInterface)cb);
            cb = new FwkColorCommand((FwkControllerInterface)component);
            cb.setTextKey("P2D.Text.Other");
            cb.setCommandName(FRAME_COLOR_IDENT);
            parent.addCommand((FwkCommandInterface)cb);
            parent = new FwkCommand((FwkControllerInterface)component);
            parent.setTextKey("P2D.Text.BackgroundColor");
            parent.setCommandName("BackgroundColorMenu");
            component.addCommand(0, parent);
            cb = new FwkColorSelectCommand((FwkControllerInterface)component);
            cb.setTextKey("P2D.Text.BackgroundColor");
            cb.setCommandName(BACKGROUND_COLOR_IDENT);
            parent.addCommand((FwkCommandInterface)cb);
            cb = new FwkColorCommand((FwkControllerInterface)component);
            cb.setTextKey("P2D.Text.Other");
            cb.setCommandName(BACKGROUND_COLOR_IDENT);
            parent.addCommand((FwkCommandInterface)cb);
            parent = new FwkCommand((FwkControllerInterface)component);
            parent.setTextKey("P2D.Text.Color");
            parent.setCommandName("ColorMenu");
            component.addCommand(0, parent);
            cb = new FwkColorSelectCommand((FwkControllerInterface)component);
            cb.setTextKey("P2D.Text.Color");
            cb.setCommandName(COLOR_IDENT);
            parent.addCommand((FwkCommandInterface)cb);
            cb = new FwkColorCommand((FwkControllerInterface)component);
            cb.setTextKey("P2D.Text.Other");
            cb.setCommandName(COLOR_IDENT);
            parent.addCommand((FwkCommandInterface)cb);
        }
        return super.getCommands((FwkControllerInterface)component);
    }

    protected HashMap createDialogPanes(P2DComponentInterface component) {
        FwkColorDialogPane pane;
        if (staticPanes == null) {
            staticPanes = new HashMap();
            pane = new FwkColorDialogPane();
            pane.setIdent(COLOR_IDENT);
            pane.setTitle(FwkPropertyBus.getProperty((String)COLOR_TEXT_KEY));
            pane.setTip(FwkPropertyBus.getProperty((String)COLOR_TOOLTIP_KEY));
            staticPanes.put(pane.getIdent(), pane);
            pane = new FwkColorDialogPane();
            pane.setIdent(BACKGROUND_COLOR_IDENT);
            pane.setTitle(FwkPropertyBus.getProperty((String)BACKGROUND_COLOR_TEXT_KEY));
            pane.setTip(FwkPropertyBus.getProperty((String)BACKGROUND_COLOR_TOOLTIP_KEY));
            staticPanes.put(pane.getIdent(), pane);
            pane = new FwkColorDialogPane();
            pane.setIdent(FRAME_COLOR_IDENT);
            pane.setTitle(FwkPropertyBus.getProperty((String)FRAME_COLOR_TEXT_KEY));
            pane.setTip(FwkPropertyBus.getProperty((String)FRAME_COLOR_TOOLTIP_KEY));
            staticPanes.put(pane.getIdent(), pane);
            pane = new FwkFontDialogPane();
            pane.setIdent(FONT_IDENT);
            pane.setTitle(FwkPropertyBus.getProperty((String)FONT_TEXT_KEY));
            pane.setTip(FwkPropertyBus.getProperty((String)FONT_TOOLTIP_KEY));
            staticPanes.put(pane.getIdent(), pane);
        }
        HashMap ret = this.getDialogPaneValues(component);
        Iterator it = staticPanes.keySet().iterator();
        while (it.hasNext()) {
            pane = (FwkDialogPaneInterface)it.next();
            FwkDialogPaneValueInterface value = (FwkDialogPaneValueInterface)ret.get(pane.getIdent());
            if (value == null) continue;
            pane.setSelectedValue(value);
        }
        return ret;
    }

    public HashMap getDialogPaneValues(P2DComponentInterface component) {
        if (staticPanes == null) {
            return this.createDialogPanes(component);
        }
        HashMap<String, FwkDialogPaneValueInterface> ret = new HashMap<String, FwkDialogPaneValueInterface>();
        FwkDialogPaneInterface pane = (FwkDialogPaneInterface)staticPanes.get(COLOR_IDENT);
        FwkDialogPaneValueInterface value = pane.getSelectedValue();
        value.setProperty(COLOR_IDENT, (Object)component.getColor());
        value.setProperty("Transparency", (Object)new Float(component.getTransparency()));
        ret.put(value.getIdent(), value);
        pane = (FwkDialogPaneInterface)staticPanes.get(BACKGROUND_COLOR_IDENT);
        value = pane.getSelectedValue();
        value.setProperty(COLOR_IDENT, (Object)component.getBackgroundColor());
        value.setProperty("Transparency", (Object)new Float(component.getBackgroundTransparency()));
        ret.put(value.getIdent(), value);
        pane = (FwkDialogPaneInterface)staticPanes.get(FRAME_COLOR_IDENT);
        value = pane.getSelectedValue();
        value.setProperty(COLOR_IDENT, (Object)component.getFrameColor());
        value.setProperty("Transparency", (Object)new Float(component.getFrameTransparency()));
        ret.put(value.getIdent(), value);
        pane = (FwkDialogPaneInterface)staticPanes.get(FONT_IDENT);
        value = pane.getSelectedValue();
        value.setIdent(pane.getIdent());
        value.setProperty(FONT_IDENT, (Object)this.appearance.getFont());
        ret.put(value.getIdent(), value);
        return ret;
    }

    public void setDialogPaneValues(P2DComponentInterface component, HashMap values) {
        Float f;
        FwkDialogPaneValueInterface paneValue = (FwkDialogPaneValueInterface)values.get(COLOR_IDENT);
        if (paneValue != null) {
            try {
                component.setColor((Color)paneValue.getProperty(COLOR_IDENT));
                f = (Float)paneValue.getProperty("Transparency");
                component.setTransparency(f.floatValue());
                values.remove(paneValue.getIdent());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if ((paneValue = (FwkDialogPaneValueInterface)values.get(BACKGROUND_COLOR_IDENT)) != null) {
            try {
                component.setBackgroundColor((Color)paneValue.getProperty(COLOR_IDENT));
                f = (Float)paneValue.getProperty("Transparency");
                component.setBackgroundTransparency(f.floatValue());
                values.remove(paneValue.getIdent());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if ((paneValue = (FwkDialogPaneValueInterface)values.get(FRAME_COLOR_IDENT)) != null) {
            try {
                component.setFrameColor((Color)paneValue.getProperty(COLOR_IDENT));
                f = (Float)paneValue.getProperty("Transparency");
                component.setFrameTransparency(f.floatValue());
                values.remove(paneValue.getIdent());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if ((paneValue = (FwkDialogPaneValueInterface)values.get(FONT_IDENT)) != null) {
            try {
                component.setFont((Font)paneValue.getProperty(FONT_IDENT));
                values.remove(paneValue.getIdent());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public FwkDialogPaneValueInterface getDialogPaneValue(P2DComponentInterface component, String ident) {
        HashMap ht = this.getDialogPaneValues(component);
        return (FwkDialogPaneValueInterface)ht.get(ident);
    }

    public HashMap getDialogPanes(P2DComponentInterface component) {
        Font f;
        FwkColorDialogPane ccp;
        this.createDialogPanes(component);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Color color = component.getColor();
        if (color != null) {
            ccp = (FwkColorDialogPane)staticPanes.get(COLOR_IDENT);
            ccp.setInitialColor(color);
            ccp.setInitialTransparency(component.getTransparency());
            ret.put(COLOR_IDENT, ccp);
        }
        color = component.getBackgroundColor();
        ccp = (FwkColorDialogPane)staticPanes.get(BACKGROUND_COLOR_IDENT);
        ccp.setInitialColor(color);
        ccp.setInitialTransparency(component.getBackgroundTransparency());
        ret.put(BACKGROUND_COLOR_IDENT, ccp);
        if (component.frameHasHandles()) {
            color = component.getFrameColor();
            ccp = (FwkColorDialogPane)staticPanes.get(FRAME_COLOR_IDENT);
            ccp.setInitialColor(color);
            ccp.setInitialTransparency(component.getFrameTransparency());
            ret.put(FRAME_COLOR_IDENT, ccp);
        }
        if ((f = component.getFont()) != null) {
            FwkFontDialogPane fcp = (FwkFontDialogPane)staticPanes.get(FONT_IDENT);
            fcp.setInitialFont(f);
            ret.put(FONT_IDENT, fcp);
        }
        return ret;
    }

    public FwkDialogPaneInterface getDialogPane(P2DComponentInterface component, String ident) {
        HashMap values;
        FwkDialogPaneValueInterface value;
        this.createDialogPanes(component);
        FwkDialogPaneInterface pane = (FwkDialogPaneInterface)staticPanes.get(ident);
        if (pane != null && (value = (FwkDialogPaneValueInterface)(values = this.getDialogPaneValues(component)).get(ident)) != null) {
            pane.setSelectedValue(value);
        }
        return pane;
    }

    public void addDialogPane(P2DComponentInterface component, FwkDialogPaneInterface pane, String ident) {
        this.createDialogPanes(component);
        staticPanes.put(ident, pane);
    }

    public void removeDialogPane(P2DComponentInterface component, String ident) {
        this.createDialogPanes(component);
        staticPanes.remove(ident);
    }

    public P2DBoundingBoxInterface calculateBoundingBoxRelativeTo(P2DComponentInterface component, P2DBoundingBoxInterface bb, Point2D ap) {
        P2DBoundingBoxInterface pb;
        Point2D.Double p = ap instanceof Point2D.Double ? new Point2D.Double(((Point2D.Double)ap).x, ((Point2D.Double)ap).y) : new Point2D.Double(((Point2D.Float)ap).x, ((Point2D.Float)ap).y);
        Point2D.Double lower = new Point2D.Double();
        bb.getLower(lower);
        Point2D.Double upper = new Point2D.Double();
        bb.getUpper(upper);
        int newActiveHandle = component.getActiveHandle();
        switch (newActiveHandle) {
            case 0: {
                double ratio;
                if (component.getRatioFix()) {
                    ratio = Math.abs(upper.x - lower.x) / Math.abs(upper.y - lower.y);
                    if (Math.abs(p.x) > Math.abs(p.y)) {
                        p.y = (upper.x - lower.x - p.x) / ratio - upper.y + lower.y;
                    } else {
                        p.x = ratio * (upper.y - lower.y - p.y) - upper.x + lower.x;
                    }
                }
                lower.x += p.x;
                if (lower.x > upper.x) {
                    p.x = lower.x;
                    lower.x = upper.x;
                    upper.x = p.x;
                    newActiveHandle = 2;
                }
                upper.y += p.y;
                if (!(upper.y < lower.y)) break;
                p.y = upper.y;
                upper.y = lower.y;
                lower.y = p.y;
                newActiveHandle = newActiveHandle == 0 ? 6 : 8;
                break;
            }
            case 1: {
                upper.y += p.y;
                if (!(upper.y < lower.y)) break;
                p.y = upper.y;
                upper.y = lower.y;
                lower.y = p.y;
                newActiveHandle = 7;
                break;
            }
            case 2: {
                double ratio;
                if (component.getRatioFix()) {
                    ratio = Math.abs(upper.x - lower.x) / Math.abs(upper.y - lower.y);
                    if (Math.abs(p.x) > Math.abs(p.y)) {
                        p.y = (upper.x - lower.x + p.x) / ratio - upper.y + lower.y;
                    } else {
                        p.x = ratio * (upper.y - lower.y + p.y) - upper.x + lower.x;
                    }
                }
                upper.x += p.x;
                if (upper.x < lower.x) {
                    p.x = upper.x;
                    upper.x = lower.x;
                    lower.x = p.x;
                    newActiveHandle = 0;
                }
                upper.y += p.y;
                if (!(upper.y < lower.y)) break;
                p.y = upper.y;
                upper.y = lower.y;
                lower.y = p.y;
                newActiveHandle = newActiveHandle == 2 ? 8 : 6;
                break;
            }
            case 3: {
                lower.x += p.x;
                if (!(lower.x > upper.x)) break;
                p.x = lower.x;
                lower.x = upper.x;
                upper.x = p.x;
                newActiveHandle = 5;
                break;
            }
            case 4: {
                lower.x += p.x;
                lower.y += p.y;
                upper.x += p.x;
                upper.y += p.y;
                break;
            }
            case 5: {
                upper.x += p.x;
                if (!(upper.x < lower.x)) break;
                p.x = upper.x;
                upper.x = lower.x;
                lower.x = p.x;
                newActiveHandle = 3;
                break;
            }
            case 6: {
                double ratio;
                if (component.getRatioFix()) {
                    ratio = Math.abs(upper.x - lower.x) / Math.abs(upper.y - lower.y);
                    if (Math.abs(p.x) > Math.abs(p.y)) {
                        p.y = (upper.x - lower.x + p.x) / ratio - upper.y + lower.y;
                    } else {
                        p.x = ratio * (upper.y - lower.y + p.y) - upper.x + lower.x;
                    }
                }
                lower.x += p.x;
                if (lower.x > upper.x) {
                    p.x = lower.x;
                    lower.x = upper.x;
                    upper.x = p.x;
                    newActiveHandle = 8;
                }
                lower.y += p.y;
                if (!(lower.y > upper.y)) break;
                p.y = lower.y;
                lower.y = upper.y;
                upper.y = p.y;
                newActiveHandle = newActiveHandle == 6 ? 0 : 2;
                break;
            }
            case 7: {
                lower.y += p.y;
                if (!(lower.y > upper.y)) break;
                p.y = lower.y;
                lower.y = upper.y;
                upper.y = p.y;
                newActiveHandle = 1;
                break;
            }
            case 8: {
                double ratio;
                if (component.getRatioFix()) {
                    ratio = Math.abs(upper.x - lower.x) / Math.abs(upper.y - lower.y);
                    if (Math.abs(p.x) > Math.abs(p.y)) {
                        p.y = (upper.x - lower.x - p.x) / ratio - upper.y + lower.y;
                    } else {
                        p.x = ratio * (upper.y - lower.y - p.y) - upper.x + lower.x;
                    }
                }
                lower.y += p.y;
                if (lower.y > upper.y) {
                    p.y = lower.y;
                    lower.y = upper.y;
                    upper.y = p.y;
                    newActiveHandle = 2;
                }
                upper.x += p.x;
                if (!(upper.x < lower.x)) break;
                p.x = upper.x;
                upper.x = lower.x;
                lower.x = p.x;
                newActiveHandle = newActiveHandle == 8 ? 6 : 0;
                break;
            }
        }
        boolean setNewValue = true;
        P2DComponentInterface parent = (P2DComponentInterface)component.getParentContainer();
        if (!(parent == null || (pb = parent.getBoundingBox().getScaledBoundingBox()).contains(lower) && pb.contains(upper))) {
            setNewValue = false;
        }
        if (setNewValue && newActiveHandle != 4) {
            setNewValue = component.boundsAcceptable(lower, upper);
        }
        if (setNewValue) {
            bb.setLower(lower);
            bb.setUpper(upper);
            component.setActiveHandle(newActiveHandle);
            return bb;
        }
        return null;
    }

    public String getShortName(P2DComponentInterface component) {
        return component.getName();
    }

    public boolean boundsAcceptable(P2DComponentInterface component, Point2D lower, Point2D upper) {
        return component.containsAllChildren(lower, upper);
    }

    public void setDecorated(P2DComponentInterface container, boolean flag) {
        this.decorated = flag;
    }

    public boolean getDecorated(P2DComponentInterface container) {
        return this.decorated;
    }
}

