/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DComponentConsumer;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemRequestedEvent;

public class P2DComponentProducer
extends FwkInfoBusProducer
implements FwkPropertyChangeListenerInterface {
    public static final String version = "$Revision: 1.4 $";
    protected static HashMap producerMap = new HashMap();
    protected HashMap components = new HashMap();
    protected HashMap flavorList = new HashMap();

    public String getVersion() {
        return version;
    }

    private P2DComponentProducer() {
        super("P2DComponentProducer@" + P2D.BUSNAME, FwkContainer.getMimeTypes((Class)P2DComponentInterface.class));
    }

    private P2DComponentProducer(String busName) {
        super("P2DComponentProducer@" + busName, FwkContainer.getMimeTypes((Class)P2DComponentInterface.class));
    }

    public static P2DComponentProducer getInstance() {
        return P2DComponentProducer.getInstanceByName(P2D.BUSNAME);
    }

    public static P2DComponentProducer getInstanceByName(String busName) {
        P2DComponentProducer ret = null;
        if (busName == null) {
            ret = P2DComponentProducer.getInstance();
        } else {
            ret = (P2DComponentProducer)((Object)producerMap.get(busName));
            if (ret == null) {
                ret = new P2DComponentProducer(busName);
                producerMap.put(busName, ret);
            }
        }
        return ret;
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        if (itemName == null) {
            return true;
        }
        if (this.isAssignable(flavor)) {
            if (itemName.indexOf(63) == -1 && itemName.indexOf(42) == -1) {
                this.fireItemRevoked((DataItem)this.components.remove(itemName));
            } else {
                Object[] arr = this.findMultipleDataItems(itemName, flavor);
                if (arr != null && arr.length != 0) {
                    for (int i = arr.length; i >= 0; --i) {
                        try {
                            P2DComponentInterface elem = (P2DComponentInterface)arr[i];
                            String name = elem.getName();
                            this.fireItemRevoked((DataItem)this.components.remove(name));
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (this.components.size() == 0) {
            producerMap.remove((Object)this);
            P2DComponentConsumer.removeInstance(this.getInfoBusName());
        }
        return true;
    }

    public void addComponent(P2DComponentInterface component, DataFlavor[] flavor) {
        if (component != null) {
            String ident = component.getName();
            this.components.put(ident, component);
            this.flavorList.put(component, flavor);
            FwkArrayInterface arr = FwkContainer.getMimeTypes(component.getClass());
            int size = arr.size();
            for (int i = 0; i < size; ++i) {
                this.addMimeType((String)arr.get(i));
            }
            component.addPropertyChangeListener("Name", this);
            this.fireItemAvailable((DataItem)component, flavor);
        }
    }

    public void removeComponent(P2DComponentInterface component) {
        if (component != null) {
            String ident = component.getName();
            this.components.remove(ident);
            this.flavorList.remove(component);
            component.removePropertyChangeListener("Name", this);
            InfoBus ib = this.getInfoBus();
            if (ib != null) {
                ib.fireItemRevoked(ident, (InfoBusDataProducer)this);
            }
            if (this.components.size() == 0) {
                producerMap.remove((Object)this);
                P2DComponentConsumer.removeInstance(this.getInfoBusName());
            }
        }
    }

    protected void firePatternItemAvailable(String pattern, DataFlavor[] flavor) {
        Object[] obj;
        if (this.isConnected() && pattern != null && (obj = this.components.values().toArray()) != null && obj.length > 0) {
            for (int i = obj.length - 1; i >= 0; --i) {
                P2DComponentInterface c = (P2DComponentInterface)obj[i];
                String ident = c.getName();
                if (!Pattern.match((String)ident, (String)pattern, (boolean)false)) continue;
                this.fireItemAvailable(ident, c, flavor);
            }
        }
    }

    protected void fireItemAvailable(String ident, P2DComponentInterface c, DataFlavor[] flavor) {
        if (this.isConnected()) {
            InfoBus ib = this.getInfoBus();
            Object[] cFlavor = (Object[])this.flavorList.get(c);
            int size = cFlavor.length;
            boolean added = false;
            for (int row = 0; row < size && !added; ++row) {
                int col = flavor.length - 1;
                while (col >= 0 && !added) {
                    if (!(added = ((DataFlavor)cFlavor[row]).equals(flavor[col--]))) continue;
                    ib.fireItemAvailable(ident, flavor, (InfoBusDataProducer)this);
                }
            }
        }
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        DataFlavor[] flavor;
        super.dataItemRequested(ev);
        if (ev.getDataItem() == null && this.isAssignable(flavor = ev.getDataFlavors()) && flavor != null) {
            String key = ev.getDataItemName();
            if (key.indexOf(42) != -1 || key.indexOf(63) != -1) {
                Object[] obj = this.components.values().toArray();
                if (obj != null && obj.length > 0) {
                    FwkArray arr = new FwkArray();
                    for (int i = obj.length - 1; i >= 0; --i) {
                        P2DComponentInterface c = (P2DComponentInterface)obj[i];
                        String ident = c.getName();
                        if (!Pattern.match((String)ident, (String)key, (boolean)false) || !P2DComponentProducer.isAssignable((DataFlavor[])flavor, (DataFlavor[])((DataFlavor[])this.flavorList.get(c)))) continue;
                        arr.add((Object)c);
                    }
                    if (arr.size() > 0) {
                        Object[] cArr = new P2DComponentInterface[arr.size()];
                        ev.setDataItem((Object)arr.toArray(cArr));
                    }
                }
            } else {
                P2DComponentInterface c = (P2DComponentInterface)this.components.get(key);
                if (c != null) {
                    ev.setDataItem((Object)c);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName() == "Name") {
            String key = (String)ev.getOldValue();
            InfoBus ib = this.getInfoBus();
            ib.fireItemRevoked(key, (InfoBusDataProducer)this);
            P2DComponentInterface ici = (P2DComponentInterface)this.components.get(key);
            if (ici != null) {
                this.components.remove(key);
                String newName = (String)ev.getNewValue();
                this.components.put(newName, ici);
                DataFlavor[] flavor = (DataFlavor[])this.flavorList.get(ici);
                ib.fireItemAvailable(newName, flavor, (InfoBusDataProducer)this);
                if (this.components.size() == 0) {
                    producerMap.remove((Object)this);
                    P2DComponentConsumer.removeInstance(this.getInfoBusName());
                }
            }
        }
    }
}

