/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DViewInterface;
import com.highqsoft.p2d.P2D;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class P2DComponentView
implements P2DViewInterface {
    public static final String version = "$Revision: 1.3 $";

    public String getVersion() {
        return version;
    }

    public P2DComponentView() {
        this.initialize();
        this.install(null);
    }

    public void release() {
    }

    public void initialize() {
    }

    public void release(P2DComponentInterface component) {
        this.release();
    }

    public void install(P2DComponentInterface component) {
    }

    public void uninstall(P2DComponentInterface component) {
        this.release(component);
    }

    public void revalidate(P2DComponentInterface component, boolean revalidate) {
    }

    public void paint(P2DComponentInterface component, Graphics2D g) {
        this.paint(component, null, g);
    }

    public void paint(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g2) {
        try {
            if (component.isVisible()) {
                Graphics2D g = (Graphics2D)g2.create();
                g.transform(component.getTransform());
                component.configure(g);
                component.registerContainer(container, g);
                Graphics2D g2d = (Graphics2D)g.create();
                this.drawBackground(component, container, g);
                g2d.dispose();
                g2d = (Graphics2D)g.create();
                this.draw(component, container, g);
                g2d.dispose();
                g2d = (Graphics2D)g.create();
                this.drawChildren(component, container, g);
                g2d.dispose();
                g2d = (Graphics2D)g.create();
                this.drawFrame(component, container, g);
                g2d.dispose();
                g.dispose();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void draw(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g) {
    }

    public void drawBackground(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g) {
        component.getBackground().paint(g);
    }

    public void drawFrame(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g) {
        if (!P2D.getPrinting()) {
            if (component.hasActiveChild(container)) {
                component.getFrame().getAppearance().configure(g);
                Point2D.Double lower = new Point2D.Double();
                Point2D.Double upper = new Point2D.Double();
                P2DBoundingBoxInterface box = component.getBoundingBox();
                box.getScaledLower(lower);
                box.getScaledUpper(upper);
                g.draw(new Rectangle2D.Double(lower.x, lower.y, upper.x - lower.x, upper.y - lower.y));
            } else {
                component.getFrame().paint(g);
            }
        } else if (!component.getSelectable()) {
            component.getFrame().paint(g);
        }
    }

    public void drawChildren(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g) {
        FwkArrayInterface arr = component.getP2DComponents();
        int size = arr.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                try {
                    P2DComponentInterface c = (P2DComponentInterface)arr.get(i);
                    c.paint(container, g);
                    continue;
                }
                catch (Throwable tChild) {
                    tChild.printStackTrace();
                }
            }
        }
    }
}

