/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkChangeRegistry;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDOMHandler;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkInfoBusMember;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkXmlInterpreter;
import com.highqsoft.fwk.command.FwkMethodCommand;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDOMHandlerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkXmlDtdInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DContainerListenerInterface;
import com.highqsoft.interfaces.p2d.P2DOrderListenerInterface;
import com.highqsoft.interfaces.p2d.P2DRepaintListenerInterface;
import com.highqsoft.p2d.P2DComponentConsumer;
import com.highqsoft.p2d.P2DContainerEvent;
import com.highqsoft.p2d.P2DOrderEvent;
import com.highqsoft.p2d.P2DXmlInterpreter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class P2DContainer
extends FwkInfoBusMember
implements P2DContainerInterface {
    public static final String version = "$Revision: 1.4 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected MouseEvent lastMouseEvent;
    protected Point2D localMousePoint;
    protected EventListenerList listeners;
    protected P2DContainerInterface parent;
    protected boolean selectable;
    protected boolean readingDOM = false;
    HashMap active;
    protected FwkArray components;
    protected final Object LOCK = new P2DTreeLock(){};

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)P2DContainer.class, (FwkDescriptionInterface)descriptor);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.removeAllP2D();
            this.parent = null;
            this.lastMouseEvent = null;
            this.localMousePoint = null;
        }
    }

    public P2DContainer() {
        this.setDescriptor(P2DContainer.getDescriptor());
        this.parent = null;
        this.selectable = true;
        this.active = new HashMap();
        this.components = new FwkArray();
        this.listeners = new EventListenerList();
    }

    public final Object getTreeLock() {
        return this.LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FwkArrayInterface getP2DComponents() {
        Object object = this.getTreeLock();
        synchronized (object) {
            FwkArray ret = new FwkArray();
            int size = this.components.size();
            for (int i = 0; i < size; ++i) {
                ret.add(this.components.get(i));
            }
            return ret;
        }
    }

    public FwkArrayInterface getP2DComponentArray() {
        return this.components;
    }

    public P2DContainerInterface addP2D(P2DContainerInterface comp) {
        return this.addP2DImpl(comp, null, -1);
    }

    public P2DContainerInterface addP2D(String name, int index) {
        P2DComponentInterface comp = P2DComponentConsumer.getInstanceByName(this.getInfoBusName()).findComponent(name, FwkContainer.getDataFlavor((Class)P2DContainerInterface.class));
        if (comp != null) {
            return this.addP2D(comp, index);
        }
        throw new FwkException(-1073676289, "$RCSfile: P2DContainer.java,v $", version, "AH 2000-11-20 12:07", "Cannot find container named <" + name + ">", (Object)this, null);
    }

    public P2DContainerInterface addP2D(String name) {
        return this.addP2D(name, -1);
    }

    public P2DContainerInterface addP2D(P2DContainerInterface comp, int index) {
        return this.addP2DImpl(comp, null, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected P2DContainerInterface addP2DImpl(P2DContainerInterface comp, Object constraints, int index) {
        if (comp == null) {
            return null;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (index > this.components.size() || index < 0 && index != -1) {
                throw new IllegalArgumentException("illegal component position");
            }
            if (comp instanceof P2DContainer) {
                for (P2DContainerInterface cn = this; cn != null; cn = cn.getParentContainer()) {
                    if (cn != comp) continue;
                    throw new IllegalArgumentException("adding container's parent to itself");
                }
            }
            if (comp instanceof P2DComponentInterface) {
                ((P2DComponentInterface)comp).register();
            }
            if (comp.getParentContainer() != null) {
                comp.getParentContainer().removeP2D(comp);
            }
            if (index == -1) {
                this.components.add((Object)comp);
            } else {
                this.components.add(index, (Object)comp);
            }
            comp.setParentContainer(this);
            if (comp instanceof MouseListener) {
                this.addMouseListener((MouseListener)((Object)comp));
            }
            if (comp instanceof MouseMotionListener) {
                this.addMouseMotionListener((MouseMotionListener)((Object)comp));
            }
            this.fireContainerAddedEvent(comp);
            this.repaint();
            return comp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DContainerInterface removeP2D(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            P2DContainerInterface comp = (P2DContainerInterface)this.components.get(index);
            return this.removeP2D(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DContainerInterface removeP2D(P2DContainerInterface comp) {
        Object object = this.getTreeLock();
        synchronized (object) {
            P2DContainerInterface ret = null;
            if (comp.getParentContainer() == this) {
                if (this.components.remove((Object)comp)) {
                    ret = comp;
                }
                Iterator it = this.active.keySet().iterator();
                Vector arr = new Vector();
                while (it.hasNext()) {
                    Object container = it.next();
                    if (comp != this.active.get(container)) continue;
                    arr.add(container);
                }
                int size = arr.size();
                for (int i = 0; i < size; ++i) {
                    this.active.remove(arr.get(i));
                }
                comp.setParentContainer(null);
                if (comp instanceof P2DComponentInterface) {
                    ((P2DComponentInterface)comp).unregister();
                }
            }
            this.fireContainerRemovedEvent(comp);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DContainerInterface getP2D(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            return (P2DContainerInterface)this.components.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DContainerInterface[] getP2D(Class clazz) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            P2DContainerInterface[] ret = new P2DContainerInterface[size];
            if (size > 0) {
                int count = 0;
                for (int i = 0; i < size; ++i) {
                    Object elem = this.components.get(i);
                    if (!clazz.isInstance(elem)) continue;
                    ret[count++] = (P2DContainerInterface)elem;
                }
                if (count < size) {
                    P2DContainerInterface[] tmp = new P2DContainerInterface[count];
                    System.arraycopy(ret, 0, tmp, 0, count);
                    ret = tmp;
                } else if (count == 0) {
                    ret = new P2DContainerInterface[]{};
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DContainerInterface[] getP2D(Class clazz, String name) {
        if (name == null) {
            return new P2DContainerInterface[0];
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            P2DContainerInterface[] ret = new P2DContainerInterface[size];
            if (size > 0) {
                int count = 0;
                for (int i = 0; i < size; ++i) {
                    P2DContainerInterface elem = (P2DContainerInterface)this.components.get(i);
                    if (!clazz.isInstance(elem) || elem.getName().compareTo(name) != 0) continue;
                    ret[count++] = elem;
                }
                if (count < size) {
                    P2DContainerInterface[] tmp = new P2DContainerInterface[count];
                    System.arraycopy(ret, 0, tmp, 0, count);
                    ret = tmp;
                } else if (count == 0) {
                    ret = new P2DContainerInterface[]{};
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllP2D() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            if (size > 0) {
                P2DContainerInterface[] arr = (P2DContainerInterface[])this.components.toArray((Object[])new P2DContainerInterface[size]);
                for (int i = 0; i < size; ++i) {
                    this.removeP2D(arr[i]);
                }
            }
            this.components.clear();
            this.active.clear();
        }
    }

    public void toFront() {
        if (this.parent != null) {
            this.parent.toFront(this);
        } else {
            this.fireOrderEvent(true);
        }
    }

    public void toFront(int index) {
        if (index >= 0 && index < this.components.size() - 1) {
            this.toFront((P2DContainerInterface)this.components.get(index));
        }
    }

    public void toFront(P2DContainerInterface container) {
        if (this.components.remove((Object)container)) {
            this.components.add((Object)container);
            container.fireOrderEvent(true);
            this.repaint();
        }
    }

    public void toBack() {
        if (this.parent != null) {
            this.parent.toBack(this);
            this.repaint();
        } else {
            this.fireOrderEvent(false);
        }
    }

    public void toBack(int index) {
        if (index >= 1 && index < this.components.size()) {
            this.toBack((P2DContainerInterface)this.components.get(index));
        }
    }

    public void toBack(P2DContainerInterface container) {
        if (this.components.remove((Object)container)) {
            this.components.add(0, (Object)container);
            container.fireOrderEvent(false);
            this.repaint();
        }
    }

    public void setParentContainer(P2DContainerInterface container) {
        this.parent = container;
    }

    public P2DContainerInterface getParentContainer() {
        return this.parent;
    }

    public FwkCommandInterface[] getCommands() {
        if (!this.commandsAvailable()) {
            super.getCommands();
            FwkCommand parent = new FwkCommand((FwkControllerInterface)this);
            parent.setTextKey("P2D.Text.Order");
            parent.setCommandName("Order");
            this.addCommand(0, (FwkCommandInterface)parent);
            FwkMethodCommand cb = new FwkMethodCommand((FwkControllerInterface)this);
            cb.setTextKey("P2D.Text.ToFront");
            cb.setCommandName("toFront");
            parent.addCommand((FwkCommandInterface)cb);
            cb = new FwkMethodCommand((FwkControllerInterface)this);
            cb.setTextKey("P2D.Text.ToBack");
            cb.setCommandName("toBack");
            parent.addCommand((FwkCommandInterface)cb);
            parent = super.getCommand("Help");
            if (parent == null) {
                parent = new FwkCommand((FwkControllerInterface)this);
                parent.setTextKey("P2D.Text.Help");
                parent.setCommandName("Help");
                this.addCommand((FwkCommandInterface)parent);
            }
            cb = new FwkCommand();
            cb.setCommandName("ContainerHelp");
            cb.setTextKey("P2D.Text.ContainerHelp");
            cb.setIconKey("Icon.FwkHelpBroker");
            cb.setHelpID("com.highqsoft.p2d.P2DContainer");
            parent.addCommand(0, (FwkCommandInterface)cb);
        }
        return super.getCommands();
    }

    public void getAllArmedComponents(P2DContainerInterface container, double x, double y, FwkArrayInterface arr) {
        this.getAllArmedComponents(container, new Point2D.Double(x, y), arr);
    }

    public void getAllArmedComponents(P2DContainerInterface container, Point2D p, FwkArrayInterface arr) {
        if (this.getSelectable() && this.components != null && this.components.size() != 0) {
            int i = this.components.size() - 1;
            while (i >= 0) {
                P2DContainerInterface comp = (P2DContainerInterface)this.components.get(i--);
                comp.getAllArmedComponents(container, p, arr);
            }
        }
    }

    public P2DContainerInterface getArmedComponent(MouseEvent ev) {
        return this.getArmedComponent(ev.getX(), ev.getY());
    }

    public P2DContainerInterface getArmedComponent(double x, double y) {
        P2DContainerInterface armed = null;
        if (this.getSelectable() && this.components != null && this.components.size() != 0) {
            int i = this.components.size() - 1;
            while (armed == null && i >= 0) {
                P2DContainerInterface comp;
                if ((comp = (P2DContainerInterface)this.components.get(i--)) instanceof P2DComponentInterface) {
                    armed = ((P2DComponentInterface)comp).getChild(x, y);
                    continue;
                }
                armed = comp.getArmedComponent(x, y);
            }
        }
        return armed;
    }

    public void setActiveComponent(P2DContainerInterface container, P2DContainerInterface component) {
        P2DContainerInterface aComp = (P2DContainerInterface)this.active.get(container);
        if (aComp != component) {
            if (component == null) {
                this.active.remove(container);
            } else {
                this.active.put(container, component);
            }
            if (this.parent != null) {
                this.parent.setActiveComponent(container, component);
            } else {
                container.setActiveComponent(container, component);
            }
        }
    }

    public P2DContainerInterface getActiveComponent(P2DContainerInterface container) {
        return (P2DContainerInterface)this.active.get(container);
    }

    public void addRepaintListener(P2DRepaintListenerInterface listener) {
        this.addListener(P2DRepaintListenerInterface.class, listener);
    }

    public void removeRepaintListener(P2DRepaintListenerInterface listener) {
        this.removeListener(P2DRepaintListenerInterface.class, listener);
    }

    public FwkArrayInterface getRepaintListenerArray() {
        return this.getListenerArray(P2DRepaintListenerInterface.class);
    }

    public void repaint() {
        if (this.parent != null) {
            this.parent.repaint();
        }
        try {
            EventListener[] l = this.listeners.getListeners(P2DRepaintListenerInterface.class);
            for (int i = l.length - 1; i >= 0; --i) {
                ((P2DRepaintListenerInterface)l[i]).repaint();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addContainerListener(P2DContainerListenerInterface listener) {
        this.addListener(P2DContainerListenerInterface.class, listener);
    }

    public void removeContainerListener(P2DContainerListenerInterface listener) {
        this.removeListener(P2DContainerListenerInterface.class, listener);
    }

    public FwkArrayInterface getContainerListenerArray() {
        return this.getListenerArray(P2DContainerListenerInterface.class);
    }

    protected void fireContainerAddedEvent(P2DContainerInterface container) {
        try {
            P2DContainerEvent event = new P2DContainerEvent(this, container);
            if (this.listeners != null) {
                EventListener[] l = this.listeners.getListeners(P2DContainerListenerInterface.class);
                for (int i = l.length - 1; i >= 0; --i) {
                    ((P2DContainerListenerInterface)l[i]).componentAdded(event);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void fireContainerRemovedEvent(P2DContainerInterface container) {
        try {
            P2DContainerEvent event = new P2DContainerEvent(this, container);
            EventListener[] l = this.listeners.getListeners(P2DContainerListenerInterface.class);
            for (int i = l.length - 1; i >= 0; --i) {
                ((P2DContainerListenerInterface)l[i]).componentRemoved(event);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setActive(P2DContainerInterface container, boolean flag) {
    }

    public boolean getActive(P2DContainerInterface container) {
        return false;
    }

    public FwkArrayInterface getFocusListenerArray() {
        return this.getListenerArray(FocusListener.class);
    }

    public void addFocusListener(FocusListener l) {
        this.addListener(FocusListener.class, l);
    }

    public void removeFocusListener(FocusListener l) {
        this.removeListener(FocusListener.class, l);
    }

    public abstract void processFocusEvent(FocusEvent var1);

    public void processMouseEvent(MouseEvent e) {
        this.saveLastMouseEvent(e);
    }

    public FwkArrayInterface getMouseListenerArray() {
        return this.getListenerArray(MouseListener.class);
    }

    public void addMouseListener(MouseListener l) {
        this.addListener(MouseListener.class, l);
    }

    public void removeMouseListener(MouseListener l) {
        this.removeListener(MouseListener.class, l);
    }

    public FwkArrayInterface getMouseMotionListenerArray() {
        return this.getListenerArray(MouseMotionListener.class);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        this.addListener(MouseMotionListener.class, l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        this.removeListener(MouseMotionListener.class, l);
    }

    public FwkArrayInterface getOrderListenerArray() {
        return this.getListenerArray(P2DOrderListenerInterface.class);
    }

    public void addOrderListener(P2DOrderListenerInterface l) {
        this.addListener(P2DOrderListenerInterface.class, l);
    }

    public void removeOrderListener(P2DOrderListenerInterface l) {
        this.removeListener(P2DOrderListenerInterface.class, l);
    }

    public void fireOrderEvent(boolean flag) {
        block8: {
            if (this.listeners == null) break block8;
            EventListener[] arr = this.listeners.getListeners(P2DOrderListenerInterface.class);
            P2DOrderEvent ev = new P2DOrderEvent(this, flag);
            if (flag) {
                for (int i = arr.length - 1; i >= 0; --i) {
                    try {
                        P2DOrderListenerInterface listener = (P2DOrderListenerInterface)arr[i];
                        listener.popToFront(ev);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            } else {
                for (int i = arr.length - 1; i >= 0; --i) {
                    try {
                        P2DOrderListenerInterface listener = (P2DOrderListenerInterface)arr[i];
                        listener.pushToBack(ev);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public FwkArrayInterface getListenerArray(Class clazz) {
        FwkArray ret = new FwkArray();
        if (this.listeners != null) {
            EventListener[] arr = this.listeners.getListeners(clazz);
            for (int i = arr.length - 1; i >= 0; --i) {
                ret.add((Object)arr[i]);
            }
        }
        return ret;
    }

    public void addListener(Class clazz, EventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(clazz, listener);
    }

    public void removeListener(Class clazz, EventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners != null) {
            this.listeners.remove(clazz, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revalidate(boolean recursive) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (recursive) {
                int size = this.components.size();
                for (int i = 0; i < size; ++i) {
                    P2DContainerInterface c = (P2DContainerInterface)this.components.get(i);
                    c.revalidate(recursive);
                }
            }
        }
    }

    public void setSelectable(boolean flag) {
        if (this.selectable != flag) {
            this.selectable = flag;
            this.firePropertyChange("Selectable", !flag, flag);
            FwkChangeRegistry.register((Object)this, (String)"Selectable");
        }
    }

    public boolean getSelectable() {
        if (this.parent != null) {
            return this.parent.getSelectable() && this.selectable;
        }
        return this.selectable;
    }

    public Element writeConstructor(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        return FwkDOMHandler.writeConstructor((Object)this, (String)"Object", (boolean)true, (Document)document, (FwkXmlDtdInterface)dtd, (Node)node, (Map)classProperties, (boolean)true);
    }

    public Element writeToDOM(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        Element thisNode = this.writeConstructor(document, dtd, node, classProperties);
        FwkDOMHandler.writeCommandsToDOM((FwkCommandInterface[])this.getCommands(), (Document)document, (FwkXmlDtdInterface)dtd, (Element)thisNode, null);
        FwkDOMHandler.writePropertiesToDOM((Object)this, (Document)document, (FwkXmlDtdInterface)dtd, (Element)thisNode, (Map)classProperties);
        int size = this.components.size();
        for (int i = 0; i < size; ++i) {
            P2DContainerInterface container = (P2DContainerInterface)this.components.get(i);
            container.writeToDOM(document, dtd, thisNode, classProperties);
        }
        return thisNode;
    }

    public Object readConstructor(Document document, Element node) {
        return FwkDOMHandler.readConstructor((Object)this, (Document)document, (Element)node);
    }

    public void readFromDOM(Document doc, Element element) {
        FwkDOMHandler.readFromDOM((Object)this, (Document)doc, (Element)element);
        if (element.hasChildNodes()) {
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                Element elem;
                String nodeName;
                if (child.getNodeType() != 1 || !(nodeName = (elem = (Element)child).getNodeName()).equals("Object")) continue;
                try {
                    P2DContainerInterface comp = (P2DContainerInterface)this.readConstructor(doc, elem);
                    comp.readFromDOM(doc, elem);
                    this.addP2D(comp);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public boolean writeToXML(String filename, boolean validate) {
        return FwkDOMHandler.writeToXML((FwkDOMHandlerInterface)this, (String)filename, (Class[])new Class[]{FwkXmlInterpreter.class, P2DXmlInterpreter.class}, (boolean)validate);
    }

    public void readingDOM(boolean flag) {
        if (flag != this.readingDOM) {
            boolean old = this.readingDOM;
            this.readingDOM = flag;
            this.firePropertyChange("readingDOM", old, flag);
        }
    }

    public boolean readingDOM() {
        return this.readingDOM;
    }

    public String getShortName() {
        return this.getName();
    }

    public void saveLastMouseEvent(MouseEvent ev) {
        this.lastMouseEvent = ev;
    }

    public MouseEvent restoreLastMouseEvent() {
        return this.lastMouseEvent;
    }

    public boolean openPopupMenu(MouseEvent ev) {
        this.saveLastMouseEvent(ev);
        return false;
    }

    public FwkCommandInterface[] getComponentCommands() {
        FwkCommand cmd;
        int size;
        Vector<Object> ret = new Vector<Object>();
        FwkCommandInterface[] arr = this.getCommands();
        if (arr != null && arr.length != 0) {
            size = arr.length;
            for (int i = 0; i < size; ++i) {
                ret.add(arr[i]);
            }
            cmd = new FwkCommand();
            cmd.setSeparator(true);
            ret.add(cmd);
        }
        size = this.components.size();
        for (int i = 0; i < size; ++i) {
            P2DContainerInterface container = (P2DContainerInterface)this.components.get(i);
            arr = container.getComponentCommands();
            if (arr == null || arr.length == 0) continue;
            cmd = new FwkCommand();
            cmd.setTextKey(FwkPropertyBus.getProperty((String)container.getTitleName()) + " " + container.getShortName());
            cmd.setIconKey(container.getIconKey());
            cmd.setCommandName(container.getClass().getName());
            cmd.setCommands(arr);
            ret.add(cmd);
        }
        arr = new FwkCommandInterface[ret.size()];
        return ret.toArray(arr);
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The P2D container");
        descriptor.setTitleName("P2DContainer.Text.Title");
        descriptor.setName(P2DContainer.class.getName());
        descriptor.setIconKey("Icon.P2DContainer");
        descriptor.setCreationDate("$Date: 2007/06/28 06:50:41 $", null);
    }

    static class P2DTreeLock {
        P2DTreeLock() {
        }
    }
}

