/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkAppearance;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DFrameInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DBoundingBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.BitSet;

public class P2DFrame
implements P2DFrameInterface {
    public static final String version = "$Revision: 1.3 $";
    public static final float handleSize = 5.0f;
    protected int armedHandle = -1;
    BitSet bitSet;
    BitSet handles;
    P2DBoundingBoxInterface boundingBox;
    Shape shape;
    FwkAppearanceInterface appearance;

    public String getVersion() {
        return version;
    }

    public P2DFrame() {
        this((FwkAppearanceInterface)((FwkAppearance)null));
    }

    public P2DFrame(Color c) {
        this((FwkAppearanceInterface)new FwkAppearance(c));
    }

    public P2DFrame(FwkAppearanceInterface ap) {
        this.appearance = ap != null ? ap : new FwkAppearance();
        if (this.appearance.getColor() == null) {
            this.appearance.setColor(P2D.black());
        }
        this.bitSet = new BitSet(2);
        this.bitSet.set(0);
        this.bitSet.set(1);
        this.handles = new BitSet(9);
        for (int i = 0; i < 9; ++i) {
            this.handles.set(i);
        }
        this.boundingBox = new P2DBoundingBox();
        this.updateGeometry();
    }

    public P2DFrame(P2DFrameInterface source) {
        this();
        this.setAppearance(source.getAppearance());
        this.setLinesVisible(source.getLinesVisible());
        this.setHandlesVisible(source.getHandlesVisible());
        for (int i = 0; i < 9; ++i) {
            this.setHandle(i, source.getHandle(i));
        }
        this.boundingBox = new P2DBoundingBox(source.getBoundingBox());
        this.updateGeometry();
    }

    public void release() {
    }

    public void paint(Graphics2D g) {
        if (this.appearance.isVisible() && (this.bitSet.get(0) || this.bitSet.get(1))) {
            Graphics2D g2 = (Graphics2D)g.create();
            this.appearance.configure(g2);
            if (this.bitSet.get(0)) {
                g2.draw(this.shape);
            }
            if (this.bitSet.get(1) && this.hasHandles()) {
                BasicStroke bs = this.appearance.scaleStroke(g2.getTransform(), 5.0f);
                Point2D.Double pd = new Point2D.Double(bs.getLineWidth(), bs.getLineWidth());
                Point2D lower = this.boundingBox.getScaledLower();
                Point2D upper = this.boundingBox.getScaledUpper();
                if (this.handles.get(0)) {
                    g2.fill(new Rectangle2D.Double(lower.getX(), upper.getY() - pd.y, pd.x, pd.y));
                }
                if (this.handles.get(1)) {
                    g2.fill(new Rectangle2D.Double((lower.getX() + upper.getX() - pd.x) / 2.0, upper.getY() - pd.y, pd.x, pd.y));
                }
                if (this.handles.get(2)) {
                    g2.fill(new Rectangle2D.Double(upper.getX() - pd.x, upper.getY() - pd.y, pd.x, pd.y));
                }
                if (this.handles.get(3)) {
                    g2.fill(new Rectangle2D.Double(lower.getX(), (lower.getY() + upper.getY() - pd.y) / 2.0, pd.x, pd.y));
                }
                if (this.handles.get(4)) {
                    g2.fill(new Rectangle2D.Double((lower.getX() + upper.getX() - pd.x) / 2.0, (lower.getY() + upper.getY() - pd.y) / 2.0, pd.x, pd.y));
                }
                if (this.handles.get(5)) {
                    g2.fill(new Rectangle2D.Double(upper.getX() - pd.x, (lower.getY() + upper.getY() - pd.y) / 2.0, pd.x, pd.y));
                }
                if (this.handles.get(6)) {
                    g2.fill(new Rectangle2D.Double(lower.getX(), lower.getY(), pd.x, pd.y));
                }
                if (this.handles.get(7)) {
                    g2.fill(new Rectangle2D.Double((lower.getX() + upper.getX() - pd.x) / 2.0, lower.getY(), pd.x, pd.y));
                }
                if (this.handles.get(8)) {
                    g2.fill(new Rectangle2D.Double(upper.getX() - pd.x, lower.getY(), pd.x, pd.y));
                }
            }
            g2.dispose();
        }
    }

    public void updateGeometry() {
        Point2D.Double lower = new Point2D.Double();
        Point2D.Double upper = new Point2D.Double();
        this.boundingBox.getScaledLower(lower);
        this.boundingBox.getScaledUpper(upper);
        this.shape = new Rectangle2D.Double(lower.x, lower.y, upper.x - lower.x, upper.y - lower.y);
    }

    public FwkAppearanceInterface getAppearance() {
        return this.appearance;
    }

    public void setAppearance(FwkAppearanceInterface appearance) {
        if (appearance.getColor() == null) {
            appearance.setColor(P2D.black());
        }
        this.appearance = appearance;
    }

    public boolean isVisible() {
        return this.appearance.isVisible();
    }

    public void setVisible(boolean flag) {
        this.appearance.setVisible(flag);
    }

    public boolean getVisible() {
        return this.appearance.isVisible();
    }

    public P2DBoundingBoxInterface getBoundingBox() {
        return new P2DBoundingBox(this.boundingBox);
    }

    public void setBoundingBox(P2DBoundingBoxInterface bb) {
        this.boundingBox = new P2DBoundingBox(bb);
        this.updateGeometry();
    }

    public boolean hasHandles() {
        return this.handles.get(0) || this.handles.get(1) || this.handles.get(2) || this.handles.get(3) || this.handles.get(4) || this.handles.get(5) || this.handles.get(6) || this.handles.get(7) || this.handles.get(8);
    }

    public void noHandles() {
        for (int i = 0; i < 9; ++i) {
            this.handles.clear(i);
        }
    }

    public void allHandles() {
        for (int i = 0; i < 9; ++i) {
            this.handles.clear(i);
        }
    }

    public void setHandle(int index, boolean flag) {
        if (flag) {
            this.handles.set(index);
        } else {
            this.handles.clear(index);
        }
    }

    public boolean getHandle(int index) {
        if (this.bitSet.get(1)) {
            return this.handles.get(index);
        }
        return false;
    }

    public void setHandlesVisible(boolean flag) {
        if (flag) {
            this.showHandles();
        } else {
            this.hideHandles();
        }
    }

    public void hideHandles() {
        this.bitSet.clear(1);
    }

    public void showHandles() {
        this.bitSet.set(1);
    }

    public boolean getHandlesVisible() {
        return this.getVisible() && this.bitSet.get(1);
    }

    public void setLinesVisible(boolean flag) {
        if (flag) {
            this.showLines();
        } else {
            this.hideLines();
        }
    }

    public void hideLines() {
        this.bitSet.clear(0);
    }

    public void showLines() {
        this.bitSet.set(0);
    }

    public boolean getLinesVisible() {
        return this.isVisible() && this.bitSet.get(0);
    }

    public void setColor(Color color) {
        if (color == null) {
            color = P2D.black();
        }
        this.appearance.setColor(color);
    }

    public Color getColor() {
        return this.appearance.getColor();
    }

    public void setTransparency(float transparency) {
        this.appearance.setTransparency(transparency);
    }

    public float getTransparency() {
        return this.appearance.getTransparency();
    }

    public void setLineWidth(float w) {
        this.appearance.setLineWidth(w);
    }

    public float getLineWidth() {
        return this.appearance.getLineWidth();
    }

    public void setDashArray(float[] arr) {
        this.appearance.setDashArray(arr);
    }

    public float[] getDashArray() {
        return this.appearance.getDashArray();
    }

    public void setDashPhase(float phase) {
        this.appearance.setDashPhase(phase);
    }

    public float getDashPhase() {
        return this.appearance.getDashPhase();
    }

    public void setEndCap(int cap) {
        this.appearance.setEndCap(cap);
    }

    public int getEndCap() {
        return this.appearance.getEndCap();
    }

    public void setLineJoin(int join) {
        this.appearance.setLineJoin(join);
    }

    public int getLineJoin() {
        return this.appearance.getLineJoin();
    }

    public void setMiterLimit(float limit) {
        this.appearance.setMiterLimit(limit);
    }

    public float getMiterLimit() {
        return this.appearance.getMiterLimit();
    }

    public void setStroke(Stroke s) {
        this.appearance.setStroke(s);
    }

    public Stroke getStroke() {
        return this.appearance.getStroke();
    }

    public int getArmedHandle() {
        return this.armedHandle;
    }

    public int getArmedHandle(Point2D ap) {
        this.armedHandle = -1;
        if (this.boundingBox.contains(ap)) {
            Point2D lower = this.boundingBox.getScaledLower();
            Point2D upper = this.boundingBox.getScaledUpper();
            double dist = Double.MAX_VALUE;
            int i = 0;
            if (this.hasHandles()) {
                double temp;
                if (this.getHandle(i) && (temp = ap.distance(lower.getX(), upper.getY())) < dist) {
                    dist = temp;
                    this.armedHandle = i;
                }
                if (this.getHandle(++i) && (temp = ap.distance((lower.getX() + upper.getX()) / 2.0, upper.getY())) < dist) {
                    dist = temp;
                    this.armedHandle = i;
                }
                if (this.getHandle(++i) && (temp = ap.distance(upper.getX(), upper.getY())) < dist) {
                    dist = temp;
                    this.armedHandle = i;
                }
                if (this.getHandle(++i) && (temp = ap.distance(lower.getX(), (upper.getY() + lower.getY()) / 2.0)) < dist) {
                    dist = temp;
                    this.armedHandle = i;
                }
                if (this.getHandle(++i) && (temp = ap.distance((lower.getX() + upper.getX()) / 2.0, (upper.getY() + lower.getY()) / 2.0)) < dist) {
                    dist = temp;
                    this.armedHandle = i;
                }
                if (this.getHandle(++i) && (temp = ap.distance(upper.getX(), (upper.getY() + lower.getY()) / 2.0)) < dist) {
                    dist = temp;
                    this.armedHandle = i;
                }
                if (this.getHandle(++i) && (temp = ap.distance(lower.getX(), lower.getY())) < dist) {
                    dist = temp;
                    this.armedHandle = i;
                }
                if (this.getHandle(++i) && (temp = ap.distance((lower.getX() + upper.getX()) / 2.0, lower.getY())) < dist) {
                    dist = temp;
                    this.armedHandle = i;
                }
                if (this.getHandle(++i) && (temp = ap.distance(upper.getX(), lower.getY())) < dist) {
                    dist = temp;
                    this.armedHandle = i;
                }
            }
        }
        return this.armedHandle;
    }

    public void resetArmedHandle() {
        this.armedHandle = -1;
    }

    public void setArmedHandle(int index) {
        if (index != -1) {
            if (index >= 0 && index <= 8) {
                if (this.handles.get(index)) {
                    this.armedHandle = index;
                } else {
                    this.resetArmedHandle();
                }
            } else {
                this.resetArmedHandle();
            }
        } else {
            this.resetArmedHandle();
        }
    }
}

