/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkChangeRegistry;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.p2d.P2DImageInterface;
import com.highqsoft.interfaces.p2d.P2DImageModelInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DComponent;
import java.awt.Image;
import java.io.File;
import java.net.URL;

public class P2DImage
extends P2DComponent
implements P2DImageInterface {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)P2DImage.class, (FwkDescriptionInterface)descriptor);
    }

    public P2DImage(String name) {
        this.setDescriptor(descriptor);
        this.setProperty("ModelClassId", "P2DImageModelId");
        this.setProperty("ViewClassId", "P2DImageViewId");
        this.setProperty("ControlClassId", "P2DImageControlId");
        try {
            this.updateModel();
            this.updateView();
            this.updateControl();
            if (name == null || name.length() == 0) {
                name = P2DImage.getDescriptor().getName() + "[" + this.hashCode() + "]@" + P2D.BUSNAME;
            }
            this.setMemberName(name);
            this.setRatioFix(true);
            this.setTransparency(1.0f);
            this.register(FwkContainer.getDataFlavors(this.getClass()));
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DImage.java,v $", this.getVersion(), "AH 1999-04-06 13:51", "Cannot set layout defaults", (Object)this, t);
        }
    }

    public String getTitle() {
        return super.getTitle() + " " + this.getShortName();
    }

    public void setImageByFile(String filename) {
        try {
            File file = new File(filename);
            this.setImageByURL(new URL("file:" + file.getCanonicalPath().replace('\\', '/')));
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DImage.java,v $", version, "AH 2000-11-20 14:49", "Cannot create url form file <" + filename + ">", (Object)this, null);
        }
    }

    public void setImageByURL(URL url) {
        String old = ((P2DImageModelInterface)this.model).getImageByResource(this);
        ((P2DImageModelInterface)this.model).setImageByURL(this, url);
        String newRes = ((P2DImageModelInterface)this.model).getImageByResource(this);
        this.firePropertyChange("ImageByResource", old, newRes);
        FwkChangeRegistry.register((Object)this, (String)"ImageByResource");
    }

    public void setImageByResource(String resource) {
        String old = ((P2DImageModelInterface)this.model).getImageByResource(this);
        ((P2DImageModelInterface)this.model).setImageByResource(this, resource);
        this.firePropertyChange("ImageByResource", old, resource);
        FwkChangeRegistry.register((Object)this, (String)"ImageByResource");
    }

    public String getImageByResource() {
        return ((P2DImageModelInterface)this.model).getImageByResource(this);
    }

    public URL getImageByURL() {
        return ((P2DImageModelInterface)this.model).getImageByURL(this);
    }

    public void setImage(Image image) {
        Image old = ((P2DImageModelInterface)this.model).getImage(this);
        ((P2DImageModelInterface)this.model).setImage(this, image);
        this.firePropertyChange("Image", old, image);
    }

    public Image getImage() {
        return ((P2DImageModelInterface)this.model).getImage(this);
    }

    public void setTransparency(float transparency) {
        Float old = new Float(((P2DImageModelInterface)this.model).getTransparency());
        ((P2DImageModelInterface)this.model).setTransparency(transparency);
        this.firePropertyChange("Transparency", old, new Float(transparency));
    }

    public float getTransparency() {
        return ((P2DImageModelInterface)this.model).getTransparency();
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The image component of the p2d package");
        descriptor.setTitleName("P2DImage.Text.Title");
        descriptor.setName(P2DImage.class.getName());
        descriptor.setIconKey("Icon.P2DImage");
        descriptor.setCreationDate("$Date: 2007/06/28 06:50:41 $", null);
    }
}

