/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkIcon;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DImageModelInterface;
import com.highqsoft.p2d.P2DComponentModel;
import java.awt.Image;
import java.net.URL;

public class P2DImageModel
extends P2DComponentModel
implements P2DImageModelInterface {
    public static final String version = "$Revision: 1.2 $";
    protected Image image;
    protected String resource;
    protected boolean transparency;

    public void intialize() {
        super.initialize();
        this.setRatioFix(null, true);
        this.transparency = true;
        this.resource = null;
        this.image = null;
    }

    public void setImageByURL(P2DComponentInterface component, URL url) {
        try {
            this.resource = url.toString();
            this.setImage(component, new FwkIcon(url).getImage());
        }
        catch (Throwable t) {
            this.resource = null;
            this.image = null;
        }
    }

    public URL getImageByURL(P2DComponentInterface component) {
        URL ret = null;
        if (this.resource != null) {
            try {
                ret = new URL(this.resource);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ret;
    }

    public void setImageByResource(P2DComponentInterface component, String resource) {
        ClassLoader loader = System.class.getClassLoader();
        FwkIconInterface icon = FwkIconFile.getIcon((ClassLoader)loader, (String)resource);
        if (icon != null) {
            this.resource = resource;
            this.setImage(component, icon.getImage());
        }
    }

    public String getImageByResource(P2DComponentInterface component) {
        return this.resource;
    }

    public void setImage(P2DComponentInterface component, Image image) {
        this.image = image;
    }

    public Image getImage(P2DComponentInterface component) {
        return this.image;
    }

    public void setTransparency(float t) {
        this.transparency = (double)t > 0.5;
    }

    public float getTransparency() {
        return this.transparency ? 1.0f : 0.0f;
    }

    public FwkCommandInterface[] getCommands(P2DComponentInterface component) {
        if (!this.commandsAvailable()) {
            super.getCommands(component);
            this.removeCommand(this.getCommand("Color"));
        }
        return super.getCommands();
    }
}

