/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkXmlDtdInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DLayoutInterface;
import com.highqsoft.interfaces.p2d.P2DLayoutModelInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DComponent;
import com.highqsoft.p2d.P2DContainer;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class P2DLayout
extends P2DComponent
implements P2DLayoutInterface {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    FwkArray layoutChildren = new FwkArray();

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)P2DLayout.class, (FwkDescriptionInterface)descriptor);
    }

    public P2DLayout(String name) {
        this.setDescriptor(descriptor);
        this.setProperty("ModelClassId", "P2DLayoutModelId");
        this.setProperty("ViewClassId", "P2DLayoutViewId");
        this.setProperty("ControlClassId", "P2DLayoutControlId");
        try {
            this.updateModel();
            this.updateView();
            this.updateControl();
            if (name == null || name.length() == 0) {
                name = P2DLayout.getDescriptor().getName() + "[" + this.hashCode() + "]@" + P2D.BUSNAME;
            }
            this.setMemberName(name);
            this.setBackgroundTransparency(1.0f);
            this.register(FwkContainer.getDataFlavors(this.getClass()));
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DLayout.java,v $", this.getVersion(), "AH 1999-04-06 13:51", "Cannot set layout defaults", (Object)this, t);
        }
    }

    public String getTitle() {
        return super.getTitle() + " " + this.getShortName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected P2DContainerInterface addP2DImpl(P2DContainerInterface comp, Object constraints, int index) {
        if (comp instanceof P2DLayoutInterface) {
            super.addP2DImpl(comp, constraints, index);
        } else {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (index > this.components.size() || index < 0 && index != -1) {
                    throw new IllegalArgumentException("illegal component position");
                }
                if (comp instanceof P2DContainer) {
                    for (P2DContainerInterface cn = this; cn != null; cn = cn.getParentContainer()) {
                        if (cn != comp) continue;
                        throw new IllegalArgumentException("adding container's parent to itself");
                    }
                }
                if (index == -1) {
                    this.layoutChildren.add((Object)comp);
                } else {
                    this.layoutChildren.add(index, (Object)comp);
                }
                comp.addRepaintListener(this);
                if (comp instanceof P2DComponentInterface) {
                    ((P2DComponentInterface)comp).register();
                }
                this.firePropertyChange("AddComponent", null, comp);
                this.repaint();
            }
        }
        return comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DContainerInterface removeP2D(P2DContainerInterface comp) {
        if (comp instanceof P2DLayoutInterface) {
            return super.removeP2D(comp);
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            comp.removeRepaintListener(this);
            this.layoutChildren.remove((Object)comp);
            if (comp instanceof P2DComponentInterface) {
                ((P2DComponentInterface)comp).unregister();
            }
            this.firePropertyChange("AddComponent", null, comp);
            this.repaint();
            return comp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllP2D() {
        super.removeAllP2D();
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.layoutChildren.size();
            if (size > 0) {
                P2DContainerInterface[] arr = (P2DContainerInterface[])this.layoutChildren.toArray((Object[])new P2DContainerInterface[size]);
                for (int i = 0; i < size; ++i) {
                    this.removeP2D(arr[i]);
                }
            }
            this.layoutChildren.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FwkArrayInterface getLayoutChildren() {
        Object object = this.getTreeLock();
        synchronized (object) {
            FwkArray ret = new FwkArray();
            int size = this.layoutChildren.size();
            for (int i = 0; i < size; ++i) {
                ret.add(this.layoutChildren.get(i));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revalidate(boolean recursive) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.revalidate(recursive);
            if (recursive) {
                int size = this.layoutChildren.size();
                for (int i = 0; i < size; ++i) {
                    P2DContainerInterface c = (P2DContainerInterface)this.layoutChildren.get(i);
                    c.revalidate(recursive);
                }
            }
        }
    }

    public Element writeToDOM(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        Element thisNode = super.writeToDOM(document, dtd, node, classProperties);
        int size = this.layoutChildren.size();
        for (int i = 0; i < size; ++i) {
            P2DContainerInterface container = (P2DContainerInterface)this.layoutChildren.get(i);
            container.writeToDOM(document, dtd, thisNode, classProperties);
        }
        return thisNode;
    }

    public String toString() {
        return this.toString("   ");
    }

    public String toString(String leading) {
        if (this.model != null) {
            return ((P2DLayoutModelInterface)this.model).toString(this, leading);
        }
        return leading + this.getClass().getName();
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The layout component of the p2d package");
        descriptor.setTitleName("P2DLayout.Text.Title");
        descriptor.setName(P2DLayout.class.getName());
        descriptor.setIconKey("Icon.P2DLayout");
        descriptor.setCreationDate("$Date: 2005/02/03 14:51:12 $", null);
    }
}

