/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DLayoutInterface;
import com.highqsoft.interfaces.p2d.P2DLayoutModelInterface;
import com.highqsoft.interfaces.p2d.P2DTextInterface;
import com.highqsoft.p2d.P2DComponent;
import com.highqsoft.p2d.P2DComponentModel;
import java.awt.geom.Point2D;

public class P2DLayoutModel
extends P2DComponentModel
implements P2DLayoutModelInterface {
    public static final String version = "$Revision: 1.3 $";
    public static final String INSERT_STRING = "   ";

    public String toString(P2DComponentInterface component, String leading) {
        int i;
        StringBuffer buf = new StringBuffer();
        P2DLayoutInterface me = (P2DLayoutInterface)component;
        P2DBoundingBoxInterface bb = me.getBoundingBox();
        P2DBoundingBoxInterface sc = bb.getScaledBoundingBox();
        double sx = bb.getWidth() / sc.getWidth();
        double sy = bb.getHeight() / sc.getHeight();
        Point2D lower = bb.getLower();
        Point2D upper = bb.getUpper();
        buf.append(leading);
        buf.append(this.getClass().getName() + "(" + me.getName() + ")");
        buf.append("[" + lower.getX() + "," + lower.getY() + "," + upper.getX() + "," + upper.getY() + "]\n");
        FwkArrayInterface arr = me.getLayoutChildren();
        int size = arr.size();
        buf.append(leading + "<embedded>\n");
        for (i = 0; i < size; ++i) {
            P2DComponentInterface comp = (P2DComponentInterface)arr.get(i);
            bb = comp.getBoundingBox();
            lower = bb.getLower();
            upper = bb.getUpper();
            buf.append(leading + INSERT_STRING);
            if (comp.getRatioFix()) {
                buf.append(comp.getClass().getName() + "(" + comp.getName() + " RatioFix)");
            } else {
                buf.append(comp.getClass().getName() + "(" + comp.getName() + ")");
            }
            buf.append("[" + lower.getX() * sx + "," + lower.getY() * sy + "," + upper.getX() * sx + "," + upper.getY() * sy + "]\n");
        }
        buf.append(leading + "</embedded>\n");
        arr = me.getP2DComponents();
        size = arr.size();
        buf.append(leading + "<children>\n");
        for (i = 0; i < size; ++i) {
            P2DLayoutInterface child = (P2DLayoutInterface)arr.get(i);
            buf.append(child.toString(leading + INSERT_STRING));
        }
        buf.append(leading + "</children>\n");
        return buf.toString();
    }

    public FwkCommandInterface[] getCommands(P2DComponentInterface component) {
        if (!this.commandsAvailable()) {
            super.getCommands(component);
            this.removeCommand(this.getCommand("Color"));
        }
        FwkCommandInterface[] ret = super.getCommands();
        FwkArrayInterface arr = ((P2DLayoutInterface)component).getLayoutChildren();
        if (arr != null && arr.size() != 0) {
            int size = arr.size();
            FwkCommandInterface[] tmp = new FwkCommandInterface[size + ret.length];
            System.arraycopy(ret, 0, tmp, size, ret.length);
            ret = tmp;
            for (int i = 0; i < size; ++i) {
                P2DComponent c = (P2DComponent)arr.get(i);
                ret[i] = new FwkCommand((FwkControllerInterface)component);
                ret[i].setText(c.getName());
                ret[i].setIcon(c.getIcon());
                tmp = c.getCommands();
                int len = tmp.length;
                for (int j = 0; j < len; ++j) {
                    ret[i].addCommand(tmp[j]);
                }
            }
        }
        return ret;
    }

    public void setBoundingBox(P2DComponentInterface component, P2DBoundingBoxInterface boundingBox) {
        super.setBoundingBox(component, boundingBox);
        FwkArrayInterface arr = ((P2DLayoutInterface)component).getLayoutChildren();
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            P2DComponentInterface child = (P2DComponentInterface)arr.get(i);
            if (!(child instanceof P2DTextInterface)) continue;
            child.setBoundingBox(boundingBox);
        }
    }
}

