/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DLayoutInterface;
import com.highqsoft.interfaces.p2d.P2DLayoutViewInterface;
import com.highqsoft.p2d.P2DComponentView;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class P2DLayoutView
extends P2DComponentView
implements P2DLayoutViewInterface {
    public static final String version = "$Revision: 1.3 $";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g) {
        Object object = component.getTreeLock();
        synchronized (object) {
            block15: {
                try {
                    if (!component.isVisible()) break block15;
                    AffineTransform at = component.getTransform();
                    FwkArrayInterface arr = ((P2DLayoutInterface)component).getLayoutChildren();
                    int size = arr.size();
                    if (size > 0) {
                        for (int i = 0; i < size; ++i) {
                            Graphics2D g2d = (Graphics2D)g.create();
                            try {
                                P2DComponentInterface c = (P2DComponentInterface)arr.get(i);
                                P2DBoundingBoxInterface box = c.getBoundingBox();
                                double sx = component.getBoundingBox().getWidth();
                                double sy = component.getBoundingBox().getHeight();
                                if (c.isMVCValid() && box.getWidth() > 0.0 && box.getHeight() > 0.0) {
                                    at = g2d.getTransform();
                                    Point2D p = box.getLower();
                                    if (c.getRatioFix()) {
                                        double scaleX = sx / box.getWidth();
                                        double scaleY = sy / box.getHeight();
                                        double scale = Math.min(scaleX, scaleY);
                                        if (scaleX < scaleY) {
                                            at.translate(0.0, (sy - scale * box.getHeight()) / 2.0);
                                        } else if (scaleY < scaleX) {
                                            at.translate((sx - scale * box.getWidth()) / 2.0, 0.0);
                                        }
                                        at.scale(scale, scale);
                                    } else {
                                        at.scale(sx / box.getWidth(), sy / box.getHeight());
                                    }
                                    at.translate(-p.getX(), -p.getY());
                                    g2d.setTransform(at);
                                    boolean fv = c.getFrameVisible();
                                    c.setFrameVisible(false);
                                    c.paint(container, g2d);
                                    c.setFrameVisible(fv);
                                }
                            }
                            catch (Throwable tChild) {
                                tChild.printStackTrace();
                            }
                            g2d.dispose();
                        }
                    }
                    this.drawFrame(component, container, g);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

