/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkApplication;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDOMHandler;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkPanel;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.command.FwkDumpToXMLCommand;
import com.highqsoft.fwk.command.FwkExitCommand;
import com.highqsoft.fwk.command.FwkPrintCommand;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import com.highqsoft.interfaces.fwk.FwkXmlDtdInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DLayoutInterface;
import com.highqsoft.p2d.P2DCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class P2DLayouter
extends FwkApplication {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    public static final String SYSTEM_ERROR_TITLE = "P2DLayouter.Text.SystemErrorTitle";
    public static final String USER_ERROR_TITLE = "P2DLayouter.Text.UserErrorTitle";
    public static final String DEFAULT_LAYOUTER_CLASS_NAME = "com.highqsoft.p2d.P2DTopLayout";
    public static final double A4RATIO = 1.4142857142857144;
    P2DLayoutInterface topLayout = null;
    P2DCanvas canvas;

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public P2DLayouter() {
        this.setDescriptor(descriptor);
        this.register();
    }

    public FwkPanelInterface getPanel() {
        if (this.panel == null) {
            this.panel = new FwkPanel();
            JPanel jPanel = (JPanel)this.panel;
            jPanel.setLayout(new BorderLayout());
            this.canvas = new P2DCanvas();
            this.canvas.setBackground(jPanel.getBackground());
            jPanel.add("Center", (Component)((Object)this.canvas));
            String layoutClassName = FwkPropertyBus.getProperty((String)"P2DLayouter.TopLayout");
            if (layoutClassName.compareTo("P2DLayouter.TopLayout") == 0) {
                layoutClassName = DEFAULT_LAYOUTER_CLASS_NAME;
            }
            try {
                this.topLayout = (P2DLayoutInterface)FwkContainer.instantiate((String)layoutClassName, (String)SYSTEM_ERROR_TITLE);
                if (this.topLayout != null) {
                    P2DBoundingBoxInterface bb = this.topLayout.getBoundingBox();
                    Point2D.Double lower = new Point2D.Double();
                    Point2D.Double upper = new Point2D.Double();
                    bb.getLower(lower);
                    bb.getUpper(upper);
                    this.canvas.setPreferredSize(new Dimension((int)(lower.getX() + upper.getX()), (int)(lower.getY() + upper.getY())));
                    this.canvas.addP2D(this.topLayout);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return this.panel;
    }

    public FwkCommandInterface[] getCommands() {
        if (!this.commandsAvailable()) {
            super.getCommands((FwkControllerInterface)this);
            FwkCommand parent = new FwkCommand((FwkControllerInterface)this);
            parent.setTextKey("MEDBrick.Text.File");
            this.addCommand(0, (FwkCommandInterface)parent);
            FwkDumpToXMLCommand cb = new FwkDumpToXMLCommand((FwkControllerInterface)this);
            parent.addCommand((FwkCommandInterface)cb);
            cb = new FwkPrintCommand((FwkControllerInterface)this.canvas);
            cb.setTextKey("Text.Print");
            cb.setCommandName("Print");
            cb.setIconKey("Icon.Printer");
            parent.addCommand((FwkCommandInterface)cb);
            cb = new FwkExitCommand((FwkControllerInterface)this);
            cb.setTextKey("MEDBrick.Text.Exit");
            cb.setCommandName("EXIT");
            cb.setIconKey("Icon.Exit");
            parent.addCommand((FwkCommandInterface)cb);
        }
        return super.getCommands();
    }

    public void run() {
    }

    public void readFromDOM(Document doc, Element element) {
        FwkDOMHandler.readFromDOM((Object)((Object)this), (Document)doc, (Element)element);
        if (element.hasChildNodes()) {
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                Element elem;
                String nodeName;
                if (child.getNodeType() != 1 || !(nodeName = (elem = (Element)child).getNodeName()).equals("Object")) continue;
                try {
                    this.topLayout = (P2DLayoutInterface)this.readConstructor(doc, elem);
                    this.topLayout.readFromDOM(doc, elem);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public Element writeToDOM(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        Element thisNode = super.writeToDOM(document, dtd, node, classProperties);
        if (this.topLayout != null) {
            this.topLayout.writeToDOM(document, dtd, thisNode, classProperties);
        }
        return thisNode;
    }

    public static void main(String[] args) {
        FwkContainer.initialize((String[])args);
        FwkContainer.openFrame((String)descriptor.getName());
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("A layouter for P2D components");
        descriptor.setTitleName("P2DLayouter.Text.Title");
        descriptor.setName(P2DLayouter.class.getName());
        descriptor.setIconKey("Icon.P2DLayouter");
        descriptor.setCreationDate("$Date: 2005/02/03 14:51:12 $", null);
    }
}

