/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import com.highqsoft.interfaces.p2d.P2DAttributorInterface;
import com.highqsoft.interfaces.p2d.P2DChannelInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DLegendInterface;
import com.highqsoft.interfaces.p2d.P2DLegendModelInterface;
import com.highqsoft.p2d.P2DAttributorSupport;
import com.highqsoft.p2d.P2DComponentConsumer;
import com.highqsoft.p2d.P2DComponentModel;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;

public class P2DLegendModel
extends P2DComponentModel
implements P2DLegendModelInterface,
FwkPropertyChangeListenerInterface {
    public static final String version = "$Revision: 1.4 $";
    protected static final int INCREMENT = 5;
    String[] chanNames;
    int chanCounter;
    protected P2DAttributorInterface attributor;
    protected float alignment = 0.0f;

    public void initialize() {
        super.initialize();
        this.chanNames = new String[5];
        this.chanCounter = 0;
        this.attributor = P2DAttributorSupport.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addName(String name) {
        String[] stringArray = this.chanNames;
        synchronized (this.chanNames) {
            if (this.chanCounter > 0) {
                boolean found = false;
                for (int i = 0; !found && i < this.chanCounter; ++i) {
                    found = this.chanNames[i].equals(name);
                }
                if (found) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
            if (this.chanCounter == this.chanNames.length) {
                String[] tmp = new String[this.chanNames.length + 5];
                System.arraycopy(this.chanNames, 0, tmp, 0, this.chanCounter);
                this.chanNames = tmp;
            }
            this.chanNames[this.chanCounter++] = name;
            if (this.chanCounter > 1) {
                Arrays.sort(this.chanNames, 0, this.chanCounter - 1);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeName(String name) {
        String[] stringArray = this.chanNames;
        synchronized (this.chanNames) {
            if (this.chanCounter > 0) {
                int index;
                boolean found = false;
                for (index = 0; !found && index < this.chanCounter; ++index) {
                    found = this.chanNames[index].equals(name);
                }
                if (found) {
                    --index;
                    if (this.chanCounter > 1) {
                        String[] tmp = new String[this.chanNames.length];
                        if (index == 0) {
                            System.arraycopy(this.chanNames, 1, tmp, 0, this.chanCounter - 1);
                        } else if (index == this.chanCounter - 1) {
                            System.arraycopy(this.chanNames, 0, tmp, 0, this.chanCounter - 1);
                        } else {
                            System.arraycopy(this.chanNames, 0, tmp, 0, index);
                            System.arraycopy(this.chanNames, index + 1, tmp, index, this.chanCounter - index - 1);
                        }
                        this.chanNames = tmp;
                    }
                    --this.chanCounter;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllNames(P2DLegendInterface component) {
        String[] stringArray = this.chanNames;
        synchronized (this.chanNames) {
            for (int i = 0; i < this.chanCounter; ++i) {
                this.removeChannel(component, this.chanNames[i]);
            }
            this.chanCounter = 0;
            if (this.chanNames.length > 5) {
                this.chanNames = new String[5];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addChannel(P2DLegendInterface component, String name) {
        P2DComponentInterface chan = P2DComponentConsumer.getInstanceByName(this.getInfoBusName()).findComponent(name, FwkContainer.getDataFlavor((Class)P2DChannelInterface.class));
        if (chan != null) {
            this.addChannel(component, (P2DChannelInterface)chan);
        }
    }

    public void addChannel(P2DLegendInterface component, P2DChannelInterface channel) {
        String chanName = channel.getMemberName();
        this.addName(chanName);
        channel.addPropertyChangeListener("MemberName", this);
    }

    public void removeAllChannels(P2DLegendInterface component) {
        this.removeAllNames(component);
    }

    public void removeChannel(P2DLegendInterface component, String name) {
        P2DComponentInterface chan = P2DComponentConsumer.getInstanceByName(this.getInfoBusName()).findComponent(name, FwkContainer.getDataFlavor((Class)P2DChannelInterface.class));
        if (chan != null) {
            ((P2DChannelInterface)chan).removePropertyChangeListener(this);
            this.removeChannel(component, (P2DChannelInterface)chan);
        }
    }

    public void removeChannel(P2DLegendInterface component, P2DChannelInterface channel) {
        channel.removePropertyChangeListener(this);
        String chanName = channel.getName();
        this.removeName(chanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getChannelNames(P2DLegendInterface component) {
        String[] stringArray = this.chanNames;
        synchronized (this.chanNames) {
            String[] ret = new String[this.chanCounter];
            if (this.chanCounter > 0) {
                System.arraycopy(this.chanNames, 0, ret, 0, this.chanCounter);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    public P2DChannelInterface[] getChannels(P2DLegendInterface component) {
        DataFlavor[] flavor = FwkContainer.getDataFlavor((Class)P2DChannelInterface.class);
        P2DChannelInterface[] ret = new P2DChannelInterface[this.chanCounter];
        for (int i = 0; i < this.chanCounter; ++i) {
            int idx = this.chanNames[i].lastIndexOf(64);
            String infoBusName = component.getInfoBusName();
            String name = this.chanNames[i];
            if (idx > 0 && idx < this.chanNames[i].length() - 2) {
                infoBusName = this.chanNames[i].substring(idx + 1).trim();
                name = this.chanNames[i].substring(0, idx).trim();
            }
            ret[i] = (P2DChannelInterface)P2DComponentConsumer.getInstanceByName(infoBusName).findComponent(name, flavor);
        }
        return ret;
    }

    public void setAttributor(P2DLegendInterface component, P2DAttributorInterface attributor) {
        this.attributor = attributor;
    }

    public P2DAttributorInterface getAttributor(P2DLegendInterface component) {
        return this.attributor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FwkArrayInterface getAttributedText(P2DLegendInterface component) {
        String[] stringArray = this.chanNames;
        synchronized (this.chanNames) {
            FwkArray ret = new FwkArray();
            if (this.chanCounter > 0 && this.attributor != null) {
                FwkAppearanceInterface ap = component.getAppearance();
                for (int i = 0; i < this.chanCounter; ++i) {
                    this.attributor.format((P2DComponentInterface)component, (FwkArrayInterface)ret, this.chanNames[i], ap);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    public void setAlignment(P2DLegendInterface component, float ali) {
        this.alignment = ali;
    }

    public float getAlignment(P2DLegendInterface component) {
        return this.alignment;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        ev.getSource();
        this.removeName((String)ev.getOldValue());
        this.addName((String)ev.getNewValue());
    }
}

