/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.p2d.P2DAttributorInterface;
import com.highqsoft.interfaces.p2d.P2DChannelInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DLegendInterface;
import com.highqsoft.interfaces.p2d.P2DLegendModelInterface;
import com.highqsoft.interfaces.p2d.P2DLegendViewInterface;
import com.highqsoft.p2d.P2DComponentView;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class P2DLegendView
extends P2DComponentView
implements P2DLegendViewInterface {
    public static final String version = "$Revision: 1.4 $";

    public void draw(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g2) {
        P2DLegendModelInterface model = (P2DLegendModelInterface)component.getModel();
        P2DChannelInterface[] cols = model.getChannels((P2DLegendInterface)component);
        int size = cols.length;
        String[] outNames = new String[size];
        for (int i = 0; i < size; ++i) {
            FwkColumnAccessInterface yColumn = cols[i].getYColumn();
            if (yColumn == null) continue;
            outNames[i] = yColumn.getShortName();
        }
        P2DAttributorInterface attributor = model.getAttributor((P2DLegendInterface)component);
        FwkAppearanceInterface ap = component.getAppearance();
        double height = component.getHeight();
        int ali = Math.round(((P2DLegendInterface)component).getAlignment());
        float wrappingWidth = (float)component.getWidth() * 0.9f;
        float strokeArea = (float)(component.getWidth() - (double)wrappingWidth);
        float strokeMargin = strokeArea * 0.1f;
        if (attributor != null) {
            FontRenderContext frc = new FontRenderContext(null, true, true);
            TextLayout layout = null;
            FwkArray arr = new FwkArray();
            int curY = 0;
            for (int i = 0; i < size && (double)curY <= height; ++i) {
                arr.clear();
                if (outNames[i] != null) {
                    attributor.format(component, (FwkArrayInterface)arr, outNames[i], ap);
                    if (arr.size() <= 0) continue;
                    AttributedString str = (AttributedString)arr.get(0);
                    AttributedCharacterIterator iter = str.getIterator();
                    LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                    boolean drawStroke = true;
                    while (measurer.getPosition() < iter.getEndIndex() && (double)curY <= height) {
                        layout = measurer.nextLayout(wrappingWidth);
                        curY = (int)((float)curY + layout.getAscent());
                        if (drawStroke) {
                            GeneralPath path = new GeneralPath();
                            if (ali == 0) {
                                path.moveTo(strokeMargin, (float)curY - layout.getAscent() / 2.0f);
                                path.lineTo(strokeArea / 2.0f, (float)curY - layout.getAscent() / 2.0f);
                                path.lineTo(strokeArea - strokeMargin, (float)curY - layout.getAscent() / 2.0f);
                            } else {
                                path.moveTo(wrappingWidth + strokeMargin, (float)curY - layout.getAscent() / 2.0f);
                                path.lineTo(wrappingWidth - strokeArea / 2.0f, (float)curY - layout.getAscent() / 2.0f);
                                path.lineTo(wrappingWidth - strokeArea - strokeMargin, (float)curY - layout.getAscent() / 2.0f);
                            }
                            Graphics2D g = (Graphics2D)g2.create();
                            FwkAppearanceInterface colAp = cols[i].getAppearance();
                            colAp.configure(g);
                            g.draw(path);
                            Stroke stroke = cols[i].getShapeStroke();
                            if (stroke != null) {
                                g.setStroke(stroke);
                                g.draw(path);
                            }
                            g.dispose();
                            drawStroke = false;
                        }
                        if ((double)curY <= height) {
                            if (ali == 0) {
                                layout.draw(g2, strokeArea, curY);
                            } else {
                                layout.draw(g2, wrappingWidth - strokeArea - layout.getAdvance(), curY);
                            }
                        }
                        curY = (int)((float)curY + (layout.getDescent() + layout.getLeading()));
                    }
                    continue;
                }
                ++curY;
            }
        }
    }
}

