/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.listener.FwkPopupMenuUnregisterListener;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusItemGroupInterface;
import com.highqsoft.interfaces.p2d.P2DAxisInterface;
import com.highqsoft.interfaces.p2d.P2DAxisTypeInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DChannelInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerControlInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerGroupInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerInterface;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DComponentControl;
import com.highqsoft.p2d.P2DMarkerConsumer;
import com.highqsoft.p2d.P2DMarkerGroup;
import com.highqsoft.p2d.P2DRange1D;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuListener;

public class P2DMarkerControl
extends P2DComponentControl
implements P2DMarkerControlInterface {
    public static final String version = "$Revision: 1.4 $";
    protected P2DMarkerGroupInterface armedGroup = null;

    public boolean openPopupMenu(P2DComponentInterface component, MouseEvent ev) {
        if (this.armedGroup != null && this.armedGroup.getMarker() == 2) {
            JPopupMenu popup;
            FwkCommandInterface[] commands = ((P2DMarkerInterface)component).getMarkerGroupCommands(this.armedGroup);
            if (commands != null && commands.length != 0 && (popup = FwkGUIFactory.createPopupMenu((String)this.armedGroup.getName(), (FwkCommandInterface[])commands, (boolean)false)) != null) {
                popup.addPopupMenuListener((PopupMenuListener)FwkPopupMenuUnregisterListener.getInstance());
                popup.show((Component)ev.getSource(), ev.getX(), ev.getY());
                return true;
            }
        } else {
            return super.openPopupMenu(component, ev);
        }
        return false;
    }

    public void mouseReleased(P2DComponentInterface component, Point2D p, MouseEvent e) {
        super.mouseReleased(component, p, e);
        if ((e.getModifiers() & 0x10) != 0) {
            super.mouseReleased(component, p, e);
            if (this.armedGroup != null && this.armedGroup.getName().compareTo("" + this.hashCode()) == 0) {
                String defaultName;
                long[] index;
                P2DAxisTypeInterface type = ((P2DMarkerInterface)component).getBind();
                P2DAxisInterface axis = type.getValue() == 120 ? ((P2DMarkerInterface)component).getXAxis() : ((P2DMarkerInterface)component).getYAxis();
                Iterator channels = axis.getChannels();
                FwkColumnAccessInterface column = null;
                try {
                    column = ((P2DChannelInterface)channels.next()).getXColumn();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                String colName = "";
                if (column != null) {
                    colName = column.getName();
                    index = column.getIndexRange(this.armedGroup.getLowerLimit(), this.armedGroup.getUpperLimit());
                } else {
                    index = new long[]{Math.round(this.armedGroup.getLowerLimit()), Math.round(this.armedGroup.getUpperLimit())};
                }
                this.armedGroup.setBoundColumn(colName);
                this.armedGroup.setRange(index[0], index[1]);
                String lookFor = defaultName = "Marker";
                int counter = 1;
                while (P2DMarkerConsumer.getInstance().findMarker(lookFor) != null) {
                    lookFor = defaultName + "_" + counter;
                    ++counter;
                }
                String newName = component.askForName((Container)e.getSource(), null, lookFor);
                if (newName != null) {
                    this.armedGroup.setName(newName);
                }
            }
            this.armedGroup = null;
        }
    }

    public void mousePressed(P2DComponentInterface component, Point2D p, MouseEvent e) {
        P2DMarkerGroupInterface group;
        super.mousePressed(component, p, e);
        P2DContainerInterface container = null;
        try {
            container = (P2DContainerInterface)e.getSource();
        }
        catch (Throwable tContainer) {
            // empty catch block
        }
        if (container != null && component.getActive(container) && (group = ((P2DMarkerInterface)component).getMarkerGroup()) != null) {
            P2DAxisTypeInterface type = ((P2DMarkerInterface)component).getBind();
            P2DAxisInterface axis = type.getValue() == 120 ? ((P2DMarkerInterface)component).getXAxis() : ((P2DMarkerInterface)component).getYAxis();
            Point2D.Double evP = new Point2D.Double(e.getX(), e.getY());
            Point2D.Double evPt = new Point2D.Double(e.getX() + 5, e.getY() + 5);
            Point2D axisPoint = axis.transformPoint(container, evP);
            Point2D tPoint = axis.transformPoint(container, evPt);
            P2DBoundingBoxInterface bb = axis.getBoundingBox();
            P2DRange1DInterface range = axis.getRange();
            this.armedGroup = null;
            if (type.getValue() == 120) {
                double tolerance = (tPoint.getX() - axisPoint.getX()) / bb.getWidth() * range.getDistance();
                if (axis.getLog()) {
                    P2DRange1D logRange = new P2DRange1D(Math.log(range.getLower()) / P2D.log10, Math.log(range.getUpper()) / P2D.log10);
                    axisPoint = new Point2D.Double(Math.pow(10.0, axisPoint.getX() / bb.getWidth() * logRange.getDistance() + logRange.getLower()), 0.0);
                } else {
                    axisPoint = new Point2D.Double(axisPoint.getX() / bb.getWidth() * range.getDistance() + range.getLower(), 0.0);
                }
                if (range.contains(axisPoint.getX())) {
                    this.armedGroup = group.findMarkerGroup(axisPoint.getX(), group.getBoundColumn(), tolerance);
                }
            } else {
                double tolerance = (tPoint.getY() - axisPoint.getY()) / bb.getHeight() * range.getDistance();
                if (axis.getLog()) {
                    P2DRange1D logRange = new P2DRange1D(Math.log(range.getLower()) / P2D.log10, Math.log(range.getUpper()) / P2D.log10);
                    axisPoint = new Point2D.Double(0.0, Math.pow(10.0, axisPoint.getX() / bb.getWidth() * logRange.getDistance() + logRange.getLower()));
                } else {
                    axisPoint = new Point2D.Double(0.0, axisPoint.getX() / bb.getWidth() * range.getDistance() + range.getLower());
                }
                if (range.contains(axisPoint.getY())) {
                    this.armedGroup = group.findMarkerGroup(axisPoint.getY(), group.getBoundColumn(), tolerance);
                }
            }
        }
    }

    public void mouseDragged(P2DComponentInterface component, Point2D p, MouseEvent e) {
        super.mouseDragged(component, p, e);
        if ((e.getModifiers() & 0x10) != 0) {
            P2DContainerInterface container = null;
            try {
                container = (P2DContainerInterface)e.getSource();
            }
            catch (Throwable tContainer) {
                // empty catch block
            }
            if (container != null && component.getActive(container)) {
                P2DAxisTypeInterface type = ((P2DMarkerInterface)component).getBind();
                P2DAxisInterface axis = type.getValue() == 120 ? ((P2DMarkerInterface)component).getXAxis() : ((P2DMarkerInterface)component).getYAxis();
                Point2D.Double evP = new Point2D.Double(e.getX(), e.getY());
                Point2D axisPoint = axis.transformPoint(container, evP);
                P2DBoundingBoxInterface bb = axis.getBoundingBox();
                P2DRange1DInterface range = axis.getRange();
                if (type.getValue() == 120) {
                    if (axis.getLog()) {
                        P2DRange1D logRange = new P2DRange1D(Math.log(range.getLower()) / P2D.log10, Math.log(range.getUpper()) / P2D.log10);
                        axisPoint = new Point2D.Double(Math.pow(10.0, axisPoint.getX() / bb.getWidth() * logRange.getDistance() + logRange.getLower()), 0.0);
                    } else {
                        axisPoint = new Point2D.Double(axisPoint.getX() / bb.getWidth() * range.getDistance() + range.getLower(), 0.0);
                    }
                    if (range.contains(axisPoint.getX())) {
                        if (this.armedGroup != null) {
                            this.armedGroup.set(axisPoint.getX());
                        } else {
                            P2DMarkerGroupInterface group = ((P2DMarkerInterface)component).getMarkerGroup();
                            if (group != null) {
                                this.armedGroup = new P2DMarkerGroup("" + this.hashCode() + "@" + component.getInfoBusName(), axisPoint.getX(), axisPoint.getX());
                                this.armedGroup.setMarker(1);
                                group.addChild((FwkInfoBusItemGroupInterface)this.armedGroup);
                            }
                        }
                        component.repaint();
                    }
                } else {
                    if (axis.getLog()) {
                        P2DRange1D logRange = new P2DRange1D(Math.log(range.getLower()) / P2D.log10, Math.log(range.getUpper()) / P2D.log10);
                        axisPoint = new Point2D.Double(0.0, Math.pow(10.0, axisPoint.getX() / bb.getWidth() * logRange.getDistance() + logRange.getLower()));
                    } else {
                        axisPoint = new Point2D.Double(0.0, axisPoint.getX() / bb.getWidth() * range.getDistance() + range.getLower());
                    }
                    if (range.contains(axisPoint.getY())) {
                        if (this.armedGroup != null) {
                            this.armedGroup.set(axisPoint.getY());
                        } else {
                            P2DMarkerGroupInterface group = ((P2DMarkerInterface)component).getMarkerGroup();
                            if (group != null) {
                                this.armedGroup = new P2DMarkerGroup("" + this.hashCode() + "@" + component.getInfoBusName(), axisPoint.getY(), axisPoint.getY());
                                this.armedGroup.setMarker(1);
                                group.addChild((FwkInfoBusItemGroupInterface)this.armedGroup);
                            }
                        }
                        component.repaint();
                    }
                }
            }
        }
    }
}

