/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkDataItemConsumer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkInfoBusMember;
import com.highqsoft.fwk.command.FwkColorSelectCommand;
import com.highqsoft.fwk.command.FwkTextFieldEditorCommand;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkChildListenerInterface;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusImmediateAccessInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusItemGroupInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerGroupInterface;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DMarkerProducer;
import com.highqsoft.p2d.P2DRange1D;
import com.highqsoft.p2d.P2DRangeCommand;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.infobus.InvalidDataException;

public class P2DMarkerGroup
extends FwkInfoBusMember
implements P2DMarkerGroupInterface {
    public static final String version = "$Revision: 1.4 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    double lower;
    double upper;
    FwkArrayInterface children = null;
    boolean validL = false;
    boolean validU = false;
    Color color;
    int marker = 0;
    String boundColumn;
    FwkArray listeners;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)P2DMarkerGroup.class, (FwkDescriptionInterface)descriptor);
    }

    public P2DMarkerGroup(String name) {
        super(name);
        this.setDescriptor(P2DMarkerGroup.getDescriptor());
        this.setMemberName(name);
        this.setBoundColumn("");
        this.color = null;
        P2DMarkerProducer.getInstance().addMarker(this);
    }

    public P2DMarkerGroup(String name, double lower, double upper) {
        this(name);
        if (lower < upper) {
            this.setLowerLimit(lower);
            this.setUpperLimit(upper);
        } else {
            this.setLowerLimit(upper);
            this.setUpperLimit(lower);
        }
    }

    public void unregister() {
        P2DMarkerProducer.getInstance().removeMarker(this);
    }

    public String getValueAsString() {
        return this.toString();
    }

    public void setValue(Object col) throws InvalidDataException, FwkException {
        throw new InvalidDataException("Currently not yet implemented.");
    }

    public boolean hasValidValues() {
        return this.validL && this.validU;
    }

    public void setValidValues(boolean flag) {
        this.validL = this.validU = flag;
    }

    public Object getValueAsObject() {
        return this;
    }

    public int getChildrenCount(boolean recursive) {
        int ret = 0;
        if (this.children != null && this.children.size() != 0) {
            int size;
            ret = size = this.children.size();
            if (recursive) {
                for (int i = 0; i < size; ++i) {
                    FwkInfoBusImmediateAccessInterface immediate = (FwkInfoBusImmediateAccessInterface)this.children.get(i);
                    ret += immediate.getChildrenCount(true);
                }
            }
        }
        return ret;
    }

    public FwkArrayInterface getChildren() {
        return this.getChildren(null);
    }

    public FwkArrayInterface getChildren(FwkArrayInterface array) {
        if (array == null) {
            array = new FwkArray();
        }
        try {
            if (this.hasChildren()) {
                int size = this.children.size();
                for (int i = 0; i < size; ++i) {
                    FwkInfoBusImmediateAccessInterface child = (FwkInfoBusImmediateAccessInterface)this.children.get(i);
                    if (child.equals(this)) continue;
                    array.add((Object)child);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return array;
    }

    public FwkArrayInterface getAllChildren() {
        return this.getAllChildren(null);
    }

    public FwkArrayInterface getAllChildren(FwkArrayInterface arr) {
        if (arr == null) {
            arr = new FwkArray();
        }
        if (this.hasChildren()) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                FwkInfoBusImmediateAccessInterface child = (FwkInfoBusImmediateAccessInterface)this.children.get(i);
                if (child.equals(this)) continue;
                if (child.isGroup()) {
                    child.getAllChildren(arr);
                    continue;
                }
                arr.add((Object)child);
            }
        }
        return arr;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() != 0;
    }

    public void setChildren(FwkArrayInterface array) {
        this.children = array;
    }

    public boolean addChild(FwkInfoBusItemGroupInterface child) {
        boolean ret = false;
        if (child instanceof P2DMarkerGroupInterface) {
            if (this.children == null) {
                this.children = new FwkArray();
            }
            if (this.findChild(child.getName()) == -1) {
                this.children.add((Object)child);
                ret = true;
            }
        }
        return ret;
    }

    public boolean containsChild(FwkInfoBusItemGroupInterface child) {
        return this.children.contains((Object)child);
    }

    public void removeChild(FwkInfoBusItemGroupInterface child) {
        if (this.children != null) {
            this.children.remove((Object)child);
        }
    }

    protected int findChild(String name) {
        int size = this.children.size();
        int found = -1;
        for (int i = 0; found == -1 && i < size; ++i) {
            FwkInfoBusItemGroupInterface item = (FwkInfoBusItemGroupInterface)this.children.get(i);
            if (!name.equals(item.getName())) continue;
            found = i;
        }
        return found;
    }

    public void removeChild(FwkInfoBusItemGroupInterface child, boolean recursive) {
        if (this.children == null) {
            return;
        }
        this.removeChild(child);
        if (recursive) {
            FwkArrayInterface children = this.getAllChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                if (child.equals(children.get(i))) continue;
                P2DMarkerGroupInterface group = (P2DMarkerGroupInterface)children.get(i);
                group.removeChild(child, recursive);
            }
        }
    }

    public void removeAllChildren() {
        this.children = null;
    }

    public void addChildListener(FwkChildListenerInterface l) {
        if (this.listeners == null) {
            this.listeners = new FwkArray();
        }
        this.listeners.add((Object)l);
    }

    public void removeChildListener(FwkChildListenerInterface l) {
        if (this.listeners != null) {
            this.listeners.remove((Object)l);
        }
    }

    public boolean isGroup() {
        return this.hasChildren();
    }

    public double getLowerLimit() {
        return this.lower;
    }

    public double getUpperLimit() {
        return this.upper;
    }

    public long getLowerIndex() {
        return this.getLowerIndex(this.boundColumn);
    }

    public long getUpperIndex() {
        return this.getUpperIndex(this.boundColumn);
    }

    public long getLowerIndex(String colName) {
        long ret = Math.round(this.getLowerLimit());
        FwkColumnAccessInterface col = null;
        if (colName == null && colName.length() == 0) {
            colName = this.boundColumn;
        }
        if ((col = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem(colName)) == null) {
            col = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem(this.boundColumn);
        }
        if (col != null) {
            ret = col.getIndex(this.getLowerLimit());
        }
        return ret;
    }

    public long getUpperIndex(String colName) {
        long ret = Math.round(this.getUpperLimit());
        FwkColumnAccessInterface col = null;
        if (colName == null && colName.length() == 0) {
            colName = this.boundColumn;
        }
        if ((col = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem(colName)) == null) {
            col = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem(this.boundColumn);
        }
        if (col != null) {
            ret = col.getIndex(this.getUpperLimit());
        }
        return ret;
    }

    public long[] getRangeIndex() {
        return this.getRangeIndex(this.boundColumn);
    }

    public long[] getRangeIndex(String colName) {
        long[] ret = new long[]{Math.round(this.getLowerLimit()), Math.round(this.getUpperLimit())};
        FwkColumnAccessInterface col = null;
        if (colName == null && colName.length() == 0) {
            colName = this.boundColumn;
        }
        if ((col = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem(colName)) == null) {
            col = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem(this.boundColumn);
        }
        if (col != null) {
            ret = col.getIndexRange(this.getLowerLimit(), this.getUpperLimit());
        }
        return ret;
    }

    public void setArea(double lower, double upper) {
        this.setLowerLimit(lower);
        this.setUpperLimit(upper);
    }

    public void setLowerLimit(double lower) {
        double old = this.lower;
        if (this.validU) {
            if (lower <= this.upper) {
                this.lower = lower;
                this.validL = true;
            } else {
                this.lower = this.upper;
                this.validL = true;
                this.setUpperLimit(lower);
                if (this.marker == 1) {
                    this.marker = 3;
                }
            }
        } else {
            this.lower = lower;
            this.validL = true;
        }
        this.firePropertyChange("Lower", old, lower);
    }

    public void setUpperLimit(double upper) {
        double old = this.upper;
        if (this.validL) {
            if (upper >= this.lower) {
                this.upper = upper;
                this.validU = true;
            } else {
                this.upper = this.lower;
                this.validU = true;
                this.setLowerLimit(upper);
                if (this.marker == 3) {
                    this.marker = 1;
                }
            }
        } else {
            this.upper = upper;
            this.validU = true;
        }
        this.firePropertyChange("Upper", old, upper);
    }

    public void set(double value) {
        if (this.marker == 1) {
            this.setLowerLimit(value);
        } else if (this.marker == 3) {
            this.setUpperLimit(value);
        } else if (this.marker == 2) {
            double delta = (this.upper + this.lower) / 2.0 - value;
            this.setLowerLimit(this.lower - delta);
            this.setUpperLimit(this.upper - delta);
        }
    }

    public void setMarker(int marker) {
        this.marker = marker;
    }

    public int getMarker() {
        return this.marker;
    }

    public void setValid(boolean flag) {
        this.validL = this.validU = flag;
    }

    public P2DRange1DInterface getRange() {
        return new P2DRange1D(this.getLowerLimit(), this.getUpperLimit());
    }

    public void setRange(P2DRange1DInterface range) {
        this.setRange(range.getLower(), range.getUpper());
    }

    public void setRange(double lower, double upper) {
        if (lower > upper) {
            double tmp = lower;
            lower = upper;
            upper = tmp;
        }
        this.lower = lower;
        this.validL = true;
        this.upper = upper;
        this.validU = true;
    }

    public P2DMarkerGroupInterface findMarkerGroup(double value, String bColumn, double tolerance) {
        if (this.validL && this.validU) {
            boolean react = false;
            if (bColumn != null && bColumn.length() != 0 && this.boundColumn != null && this.boundColumn.length() != 0) {
                react = bColumn.compareTo(this.boundColumn) == 0;
            } else {
                boolean bl = react = !(bColumn != null && bColumn.length() != 0 || this.boundColumn != null && this.boundColumn.length() != 0);
            }
            if (react) {
                double area = (this.upper - this.lower) / 4.0;
                if (this.lower + area >= value && this.lower <= value) {
                    this.marker = 1;
                    return this;
                }
                if (this.upper - area <= value && this.upper >= value) {
                    this.marker = 3;
                    return this;
                }
                double center = (this.upper + this.lower) / 2.0;
                if (center - area <= value && center + area >= value) {
                    this.marker = 2;
                    return this;
                }
                if (center - tolerance <= value && center + tolerance >= value) {
                    this.marker = 2;
                    return this;
                }
            }
        }
        if (this.children != null) {
            int size = this.children.size();
            P2DMarkerGroupInterface found = null;
            for (int i = 0; found == null && i < size; ++i) {
                P2DMarkerGroupInterface group = (P2DMarkerGroupInterface)this.children.get(i);
                if (group == null) continue;
                found = group.findMarkerGroup(value, bColumn, tolerance);
            }
            return found;
        }
        return null;
    }

    public String getUnit() {
        FwkColumnAccessInterface col;
        String ret = "";
        if (this.boundColumn != null && this.boundColumn.length() != 0 && (col = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem(this.boundColumn)) != null) {
            ret = col.getUnitString();
        }
        return ret;
    }

    public void setColor(Color c) {
        Color old = this.color;
        this.color = c;
        this.firePropertyChange("Color", old, c);
    }

    public Color getColor() {
        if (this.color == null) {
            return P2D.darkorange();
        }
        return this.color;
    }

    public FwkCommandInterface[] getCommands() {
        if (!this.commandsAvailable()) {
            super.getCommands((FwkControllerInterface)this);
            Object cmd = new FwkTextFieldEditorCommand((FwkControllerInterface)this);
            cmd.setTextKey("P2D.Text.Rename");
            cmd.setIconKey("Icon.Rename");
            cmd.setCommandName("Name");
            cmd.setProperty("DialogTitle", (Object)"P2D.Text.RenameDialogTitle");
            this.addCommand((FwkCommandInterface)cmd);
            FwkCommand parent = new FwkCommand((FwkControllerInterface)this);
            parent.setTextKey("P2D.Text.Color");
            parent.setCommandName("ColorMenu");
            this.addCommand((FwkCommandInterface)parent);
            cmd = new FwkColorSelectCommand((FwkControllerInterface)this);
            cmd.setTextKey("P2D.Text.Color");
            parent.setCommandName("Color");
            parent.addCommand((FwkCommandInterface)cmd);
            cmd = new P2DRangeCommand((FwkControllerInterface)this);
            cmd.setTextKey("P2D.Text.Range");
            this.addCommand((FwkCommandInterface)cmd);
        }
        return super.getCommands();
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.firePropertyChange(ev);
    }

    public void setBoundColumn(String columnName) {
        if (columnName == null) {
            columnName = "";
        }
        String old = this.boundColumn;
        this.boundColumn = columnName;
        this.firePropertyChange("BoundColumn", old, columnName);
    }

    public String getBoundColumn() {
        return this.boundColumn;
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The marker group implementation");
        descriptor.setTitleName("MarkerGroup");
        descriptor.setIconKey("Icon.Picker");
        descriptor.setCreationDate("$Date: 2007/06/28 06:50:41 $", null);
    }
}

