/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusItemGroupInterface;
import com.highqsoft.interfaces.p2d.P2DAxisInterface;
import com.highqsoft.interfaces.p2d.P2DAxisTypeInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerGroupInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerModelInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DAxisType;
import com.highqsoft.p2d.P2DBoundingBox;
import com.highqsoft.p2d.P2DComponentConsumer;
import com.highqsoft.p2d.P2DComponentModel;
import com.highqsoft.p2d.P2DMarkerColorCommand;
import com.highqsoft.p2d.P2DMarkerConsumer;
import com.highqsoft.p2d.P2DMarkerDeleteCommand;
import com.highqsoft.p2d.P2DMarkerGroup;
import com.highqsoft.p2d.P2DMarkerNameCommand;
import com.highqsoft.p2d.P2DMarkerRangeCommand;
import com.highqsoft.p2d.P2DMarkerStatisticsCommand;
import com.highqsoft.p2d.P2DMarkerZoomCommand;

public class P2DMarkerModel
extends P2DComponentModel
implements P2DMarkerModelInterface {
    public static final String version = "$Revision: 1.5 $";
    protected String markerGroupName;
    protected P2DMarkerGroupInterface markerGroup;
    protected String xAxisName;
    protected P2DAxisInterface xAxis;
    protected String yAxisName;
    protected P2DAxisInterface yAxis;
    protected P2DAxisTypeInterface bind = P2DAxisType.X;
    protected P2DBoundingBoxInterface displayBox;

    public void initialize() {
        super.initialize();
        this.displayBox = null;
        this.appearance.setColor(P2D.darkorange());
        this.frame.setHandle(0, false);
        this.frame.setHandle(1, false);
        this.frame.setHandle(2, false);
        this.frame.setHandle(3, false);
        this.frame.setHandle(4, false);
        this.frame.setHandle(5, false);
        this.frame.setHandle(6, false);
        this.frame.setHandle(7, false);
        this.frame.setHandle(8, false);
        this.markerGroup = new P2DMarkerGroup("MarkerGroup[" + this.hashCode() + "]");
        this.markerGroupName = this.markerGroup.getName();
    }

    public void uninstall(P2DComponentInterface component) {
        if (this.markerGroup != null) {
            this.markerGroup.unregister();
        }
        super.uninstall(component);
    }

    public void setXAxisName(P2DMarkerInterface component, String name) {
        this.xAxisName = name;
        this.xAxis = null;
    }

    public String getXAxisName(P2DMarkerInterface component) {
        return this.xAxisName;
    }

    public P2DAxisInterface getXAxis(P2DMarkerInterface component) {
        if (this.xAxis == null && this.xAxisName != null) {
            this.xAxis = (P2DAxisInterface)P2DComponentConsumer.getInstanceByName(component.getInfoBusName()).findComponent(this.xAxisName, FwkContainer.getDataFlavor((Class)P2DAxisInterface.class));
        }
        return this.xAxis;
    }

    public void setYAxisName(P2DMarkerInterface component, String name) {
        this.yAxisName = name;
        this.yAxis = null;
    }

    public String getYAxisName(P2DMarkerInterface component) {
        return this.yAxisName;
    }

    public P2DAxisInterface getYAxis(P2DMarkerInterface component) {
        if (this.yAxis == null && this.yAxisName != null) {
            this.yAxis = (P2DAxisInterface)P2DComponentConsumer.getInstanceByName(component.getInfoBusName()).findComponent(this.yAxisName, FwkContainer.getDataFlavors((Class)P2DAxisInterface.class));
        }
        return this.yAxis;
    }

    public void setBind(P2DMarkerInterface component, P2DAxisTypeInterface type) {
        this.bind = type;
    }

    public P2DAxisTypeInterface getBind(P2DMarkerInterface component) {
        return this.bind;
    }

    public P2DMarkerGroupInterface getMarkerGroup(P2DMarkerInterface component) {
        if (this.markerGroup == null && this.markerGroupName != null) {
            this.markerGroup = P2DMarkerConsumer.getInstance().findMarker(this.markerGroupName);
        }
        if (this.markerGroup != null) {
            P2DMarkerConsumer consumer = P2DMarkerConsumer.getInstance();
            FwkArrayInterface arr = this.markerGroup.getChildren();
            int size = arr.size();
            Object[] a = new P2DMarkerGroupInterface[size];
            a = (P2DMarkerGroupInterface[])arr.toArray(a);
            for (int i = 0; i < size; ++i) {
                P2DMarkerGroupInterface group = consumer.findMarker(((P2DMarkerGroupInterface)arr.get(i)).getName());
                if (group != null) continue;
                this.markerGroup.removeChild((FwkInfoBusItemGroupInterface)((P2DMarkerGroupInterface)arr.get(i)));
            }
        }
        return this.markerGroup;
    }

    public void setMarkerGroupName(P2DMarkerInterface component, String name) {
        P2DMarkerGroupInterface marker;
        if (this.markerGroupName != null && this.markerGroupName.compareTo("MarkerGroup[" + this.hashCode() + "]") == 0 && (marker = this.getMarkerGroup(null)) != null) {
            marker.unregister();
        }
        this.markerGroupName = name;
        this.markerGroup = null;
    }

    public String getMarkerGroupName(P2DMarkerInterface component) {
        return this.markerGroupName;
    }

    public FwkCommandInterface[] getMarkerGroupCommands(P2DMarkerInterface component, P2DMarkerGroupInterface group) {
        FwkCommandInterface[] ret = new FwkCommandInterface[6];
        ret[0] = new P2DMarkerNameCommand((FwkControllerInterface)group);
        ret[0].setProperty("P2DComponent", (Object)component);
        ret[1] = new P2DMarkerColorCommand((FwkControllerInterface)group);
        ret[1].setProperty("P2DComponent", (Object)component);
        ret[2] = new P2DMarkerDeleteCommand((FwkControllerInterface)group);
        ret[2].setProperty("P2DComponent", (Object)component);
        ret[3] = new P2DMarkerRangeCommand((FwkControllerInterface)group);
        ret[3].setProperty("P2DComponent", (Object)component);
        ret[4] = new P2DMarkerZoomCommand((FwkControllerInterface)group);
        ret[4].setProperty("P2DComponent", (Object)component);
        ret[5] = new P2DMarkerStatisticsCommand((FwkControllerInterface)group);
        ret[5].setProperty("P2DComponent", (Object)component);
        return ret;
    }

    public void setDisplayBoundingBox(P2DMarkerInterface component, P2DBoundingBoxInterface bb) {
        this.displayBox = bb != null ? new P2DBoundingBox(bb) : bb;
    }

    public P2DBoundingBoxInterface getDisplayBoundingBox(P2DMarkerInterface component) {
        if (this.displayBox != null) {
            return new P2DBoundingBox(this.displayBox);
        }
        return null;
    }

    public boolean hasDisplayBoundingBox(P2DMarkerInterface component) {
        return this.displayBox != null;
    }
}

