/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerGroupInterface;
import com.highqsoft.p2d.P2D;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemRequestedEvent;

public class P2DMarkerProducer
extends FwkInfoBusProducer
implements FwkPropertyChangeListenerInterface {
    public static final String version = "$Revision: 1.3 $";
    protected static HashMap markers;
    static P2DMarkerProducer producer;

    public String getVersion() {
        return version;
    }

    private P2DMarkerProducer() {
        super("P2DMarkerProducer@" + P2D.MARKERBUSNAME, FwkContainer.getMimeTypes((Class)P2DMarkerGroupInterface.class));
        markers = new HashMap();
    }

    public static P2DMarkerProducer getInstance() {
        if (producer == null) {
            producer = new P2DMarkerProducer();
        }
        return producer;
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        if (itemName == null) {
            return true;
        }
        if (this.isAssignable(flavor)) {
            if (itemName.indexOf(63) == -1 && itemName.indexOf(42) == -1) {
                this.fireItemRevoked((DataItem)markers.remove(itemName));
            } else {
                Object[] arr = this.findMultipleDataItems(itemName, flavor);
                if (arr != null && arr.length != 0) {
                    for (int i = arr.length; i >= 0; --i) {
                        try {
                            P2DComponentInterface elem = (P2DComponentInterface)arr[i];
                            String name = elem.getName();
                            this.fireItemRevoked((DataItem)markers.remove(name));
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return true;
    }

    public void addMarker(P2DMarkerGroupInterface marker) {
        if (marker != null) {
            String ident;
            String newName = ident = marker.getName();
            int counter = 1;
            while (markers.get(newName) != null) {
                newName = ident + "_" + counter++;
            }
            if (counter > 1) {
                marker.setName(newName);
            }
            markers.put(marker.getName(), marker);
            marker.addPropertyChangeListener("Name", this);
            this.fireItemAvailable((DataItem)marker, this.getDataFlavors());
        }
    }

    public void removeMarker(P2DMarkerGroupInterface marker) {
        if (marker != null) {
            String ident = marker.getName();
            markers.remove(ident);
            marker.removePropertyChangeListener("Name", this);
            InfoBus ib = this.getInfoBus();
            if (ib != null) {
                ib.fireItemRevoked(ident, (InfoBusDataProducer)this);
            }
        }
    }

    protected void firePatternItemAvailable(String pattern, DataFlavor[] flavor) {
        Object[] obj;
        if (this.isConnected() && pattern != null && (obj = markers.values().toArray()) != null && obj.length > 0) {
            for (int i = obj.length - 1; i >= 0; --i) {
                P2DMarkerGroupInterface c = (P2DMarkerGroupInterface)obj[i];
                String ident = c.getName();
                if (!Pattern.match((String)ident, (String)pattern, (boolean)false)) continue;
                this.fireItemAvailable(ident, c, flavor);
            }
        }
    }

    protected void fireItemAvailable(String ident, P2DMarkerGroupInterface c, DataFlavor[] flavor) {
        if (this.isConnected()) {
            InfoBus ib = this.getInfoBus();
            ib.fireItemAvailable(ident, flavor, (InfoBusDataProducer)this);
        }
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        DataFlavor[] flavor;
        super.dataItemRequested(ev);
        if (ev.getDataItem() == null && (flavor = ev.getDataFlavors()) != null && this.isAssignable(flavor)) {
            String key = ev.getDataItemName();
            if (key.indexOf(42) != -1 || key.indexOf(63) != -1) {
                Object[] obj = markers.values().toArray();
                if (obj != null && obj.length > 0) {
                    FwkArray arr = new FwkArray();
                    for (int i = obj.length - 1; i >= 0; --i) {
                        P2DMarkerGroupInterface c = (P2DMarkerGroupInterface)obj[i];
                        String ident = c.getName();
                        if (!Pattern.match((String)ident, (String)key, (boolean)false)) continue;
                        arr.add((Object)c);
                    }
                    if (arr.size() > 0) {
                        Object[] cArr = new P2DMarkerGroupInterface[arr.size()];
                        ev.setDataItem((Object)arr.toArray(cArr));
                    }
                }
            } else {
                P2DMarkerGroupInterface c = (P2DMarkerGroupInterface)markers.get(key);
                if (c != null) {
                    ev.setDataItem((Object)c);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName() == "Name") {
            String key = (String)ev.getOldValue();
            InfoBus ib = this.getInfoBus();
            ib.fireItemRevoked(key, (InfoBusDataProducer)this);
            P2DMarkerGroupInterface ici = (P2DMarkerGroupInterface)markers.get(key);
            if (ici != null) {
                markers.remove(key);
                String newName = (String)ev.getNewValue();
                markers.put(newName, ici);
                ib.fireItemAvailable(newName, this.getDataFlavors(), (InfoBusDataProducer)this);
            }
        }
    }
}

