/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.columndisplay.ColumnDisplay;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.p2d.P2DAxisInterface;
import com.highqsoft.interfaces.p2d.P2DAxisTypeInterface;
import com.highqsoft.interfaces.p2d.P2DChannelInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerGroupInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerInterface;
import java.util.EventObject;
import java.util.Iterator;

public class P2DMarkerStatisticsCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.2 $";

    public String getVersion() {
        return version;
    }

    public P2DMarkerStatisticsCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("P2D.Text.Statistics");
        this.setCommandName("Statistics");
        this.setIconKey("Icon.Statistics");
    }

    public boolean execute(EventObject ev) {
        P2DMarkerGroupInterface marker = (P2DMarkerGroupInterface)this.getController();
        try {
            marker = (P2DMarkerGroupInterface)this.getController();
        }
        catch (Throwable tm) {
            System.err.println("The controller must implment the P2DMarkerGroupInterface.");
            tm.printStackTrace();
            return false;
        }
        if (marker != null) {
            P2DMarkerInterface component = (P2DMarkerInterface)this.getProperty("P2DComponent");
            try {
                component = (P2DMarkerInterface)this.getProperty("P2DComponent");
            }
            catch (Throwable tc) {
                System.err.println("The marker must be placed as property \"P2DComponent\"");
                tc.printStackTrace();
                return false;
            }
            if (component != null) {
                P2DAxisTypeInterface type = component.getBind();
                P2DAxisInterface axis = type.getValue() == 120 ? component.getXAxis() : component.getYAxis();
                Iterator it = axis.getChannels();
                while (it.hasNext()) {
                    FwkColumnAccessInterface col;
                    long[] coord;
                    P2DChannelInterface channel = (P2DChannelInterface)it.next();
                    FwkColumnAccessInterface xColumn = channel.getXColumn();
                    FwkColumnAccessInterface yColumn = channel.getYColumn();
                    if (type.getValue() == 120) {
                        coord = xColumn != null ? marker.getRangeIndex(xColumn.getName()) : marker.getRangeIndex();
                        col = (FwkColumnAccessInterface)yColumn.subdivide(new int[]{(int)coord[0]}, new int[]{(int)coord[1]});
                    } else {
                        coord = yColumn != null ? marker.getRangeIndex(yColumn.getName()) : marker.getRangeIndex();
                        col = (FwkColumnAccessInterface)xColumn.subdivide(new int[]{(int)coord[0]}, new int[]{(int)coord[1]});
                    }
                    ColumnDisplay cd = new ColumnDisplay();
                    cd.setColumn(col);
                    FwkContainer.openFrame((FwkApplicationInterface)cd);
                }
            }
        }
        return false;
    }
}

