/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.p2d.P2DAxisInterface;
import com.highqsoft.interfaces.p2d.P2DAxisTypeInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DChannelInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerGroupInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerViewInterface;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DBoundingBox;
import com.highqsoft.p2d.P2DComponentView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class P2DMarkerView
extends P2DComponentView
implements P2DMarkerViewInterface {
    public static final String version = "$Revision: 1.4 $";
    static final double log10 = Math.log(10.0);
    static final int handleWidth = 5;
    static final int handleHeight = 12;

    public void paint(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g2) {
        try {
            if (component.isVisible()) {
                P2DBoundingBox bb;
                Graphics2D g = (Graphics2D)g2.create();
                P2DAxisInterface xAxis = ((P2DMarkerInterface)component).getXAxis();
                P2DAxisInterface yAxis = ((P2DMarkerInterface)component).getYAxis();
                P2DBoundingBoxInterface bx = xAxis.getBoundingBox();
                P2DBoundingBoxInterface by = yAxis.getBoundingBox();
                Point2D xLower = bx.getLower();
                Point2D yLower = by.getLower();
                Point2D xUpper = bx.getUpper();
                Point2D yUpper = by.getUpper();
                P2DAxisTypeInterface type = ((P2DMarkerInterface)component).getBind();
                P2DBoundingBoxInterface db = ((P2DMarkerInterface)component).getDisplayBoundingBox();
                if (db == null) {
                    if (type.getValue() == 120) {
                        double delta = (yUpper.getY() - yLower.getY()) * 0.1;
                        bb = new P2DBoundingBox(xLower.getX(), yLower.getY(), xUpper.getX(), yLower.getY() - delta);
                    } else {
                        double delta = (yUpper.getY() - yLower.getY()) * 0.1;
                        bb = new P2DBoundingBox(xUpper.getX(), yLower.getY(), xUpper.getX() + delta, yUpper.getY());
                    }
                } else if (type.getValue() == 120) {
                    double delta = db.getHeight() * 0.1;
                    bb = new P2DBoundingBox(xLower.getX(), db.getLower().getY() - delta, xUpper.getX(), db.getLower().getY());
                } else {
                    double delta = db.getWidth() * 0.1;
                    bb = new P2DBoundingBox(db.getUpper().getX(), yLower.getY(), db.getUpper().getX() + delta, yUpper.getY());
                }
                component.setBoundingBox(bb);
                g.transform(component.getTransform());
                component.configure(g);
                component.registerContainer(container, g);
                Graphics2D g2d = (Graphics2D)g.create();
                this.drawBackground(component, container, g);
                g2d.dispose();
                P2DMarkerGroupInterface group = ((P2DMarkerInterface)component).getMarkerGroup();
                if (group != null && (group.hasChildren() || group.hasValidValues()) && xAxis != null && yAxis != null) {
                    g2d = (Graphics2D)g2.create();
                    component.configure(g2d);
                    if (db == null) {
                        db = P2D.getAxisBoundingBox(xAxis, yAxis);
                    } else {
                        P2DBoundingBoxInterface bi = P2D.getAxisBoundingBox(xAxis, yAxis);
                        db = type.getValue() == 120 ? new P2DBoundingBox(bi.getLower().getX(), db.getLower().getY(), bi.getUpper().getX(), db.getUpper().getY()) : new P2DBoundingBox(db.getLower().getX(), bi.getLower().getY(), db.getUpper().getX(), bi.getUpper().getY());
                    }
                    this.draw(component, container, g2d, db);
                    g2d.dispose();
                    if (!P2D.getPrinting() && component.getDecorated()) {
                        g2d = (Graphics2D)g.create();
                        this.drawHandles(component, container, g, bb, xAxis, yAxis);
                        g2d.dispose();
                    }
                }
                g2d = (Graphics2D)g.create();
                this.drawChildren(component, container, g);
                g2d.dispose();
                g2d = (Graphics2D)g.create();
                this.drawFrame(component, container, g);
                g2d.dispose();
                g.dispose();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected AffineTransform getAxisTransformation(P2DAxisTypeInterface type, P2DAxisInterface xAxis, P2DAxisInterface yAxis, P2DBoundingBoxInterface displayBox) {
        AffineTransform ret = new AffineTransform();
        if (type.getValue() == 120 && xAxis != null) {
            boolean isLog = xAxis.getLog();
            P2DRange1DInterface range = xAxis.getRange();
            if (isLog) {
                range.setLower(Math.log(range.getLower()) / log10);
                range.setUpper(Math.log(range.getUpper()) / log10);
                if (range.getLower() == Double.NEGATIVE_INFINITY) {
                    range.setLower(Math.log(1.4E-45f) / log10);
                }
                if (range.getUpper() == Double.POSITIVE_INFINITY) {
                    range.setUpper(Math.log(3.4028234663852886E38) / log10);
                }
            } else {
                if (range.getLower() == Double.NEGATIVE_INFINITY) {
                    range.setLower(1.4E-45f);
                }
                if (range.getUpper() == Double.POSITIVE_INFINITY) {
                    range.setUpper(3.4028234663852886E38);
                }
            }
            ret.translate(displayBox.getLower().getX(), displayBox.getLower().getY() + displayBox.getHeight());
            ret.scale(displayBox.getWidth() / range.getDistance(), displayBox.getHeight());
            ret.translate(-range.getLower(), 0.0);
            ret.scale(1.0, -1.0);
        } else if (type.getValue() == 121 && yAxis != null) {
            boolean isLog = yAxis.getLog();
            P2DRange1DInterface range = yAxis.getRange();
            if (isLog) {
                range.setLower(Math.log(range.getLower()) / log10);
                range.setUpper(Math.log(range.getUpper()) / log10);
                if (range.getLower() == Double.NEGATIVE_INFINITY) {
                    range.setLower(Math.log(1.4E-45f) / log10);
                }
                if (range.getUpper() == Double.POSITIVE_INFINITY) {
                    range.setUpper(Math.log(3.4028234663852886E38) / log10);
                }
            } else {
                if (range.getLower() == Double.NEGATIVE_INFINITY) {
                    range.setLower(1.4E-45f);
                }
                if (range.getUpper() == Double.POSITIVE_INFINITY) {
                    range.setUpper(3.4028234663852886E38);
                }
            }
            ret.translate(displayBox.getLower().getX() + displayBox.getWidth(), displayBox.getLower().getY());
            ret.scale(displayBox.getWidth(), displayBox.getHeight() / range.getDistance());
            ret.translate(0.0, -range.getLower());
            ret.scale(1.0, -1.0);
        }
        return ret;
    }

    public void draw(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g2, P2DBoundingBoxInterface displayBox) {
        Graphics2D g = (Graphics2D)g2.create();
        P2DAxisInterface xAxis = ((P2DMarkerInterface)component).getXAxis();
        P2DAxisInterface yAxis = ((P2DMarkerInterface)component).getYAxis();
        P2DMarkerGroupInterface group = ((P2DMarkerInterface)component).getMarkerGroup();
        if (group != null && (group.hasChildren() || group.hasValidValues()) && xAxis != null && yAxis != null) {
            P2DAxisTypeInterface type = ((P2DMarkerInterface)component).getBind();
            P2DRange1DInterface xRange = xAxis.getRange();
            P2DRange1DInterface yRange = yAxis.getRange();
            g.transform(this.getAxisTransformation(type, xAxis, yAxis, displayBox));
            this.drawGroupArea(g, group, xRange, yRange, type.getValue() == 120, xAxis, yAxis);
        }
        g.dispose();
    }

    public void drawHandles(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g, P2DBoundingBoxInterface bb, P2DAxisInterface xAxis, P2DAxisInterface yAxis) {
        P2DMarkerGroupInterface group = ((P2DMarkerInterface)component).getMarkerGroup();
        if (group != null) {
            P2DAxisTypeInterface type = ((P2DMarkerInterface)component).getBind();
            AffineTransform at = g.getTransform();
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(group.getColor());
            g2d.setTransform(new AffineTransform());
            at.scale(bb.getWidth(), bb.getHeight());
            if (type.getValue() == 120) {
                P2DRange1DInterface xRange = xAxis.getRange();
                if (xAxis.getLog()) {
                    at.scale(1.0 / (Math.log(xRange.getUpper()) / P2D.log10 - Math.log(xRange.getLower()) / P2D.log10), 1.0);
                    at.translate(-Math.log(xRange.getLower()) / P2D.log10, 0.0);
                } else {
                    at.scale(1.0 / (xRange.getUpper() - xRange.getLower()), 1.0);
                    at.translate(-xRange.getLower(), 0.0);
                }
            } else {
                P2DRange1DInterface yRange = yAxis.getRange();
                if (yAxis.getLog()) {
                    at.scale(1.0, 1.0 / (Math.log(yRange.getUpper()) / P2D.log10 - Math.log(yRange.getLower()) / P2D.log10));
                    at.translate(0.0, -Math.log(yRange.getLower()) / P2D.log10);
                } else {
                    at.scale(1.0, 1.0 / (yRange.getUpper() - yRange.getLower()));
                    at.translate(0.0, -yRange.getLower());
                }
            }
            this.drawGroupHandles(g2d, at, group, xAxis.getRange(), yAxis.getRange(), type.getValue() == 120, xAxis, yAxis);
            g2d.dispose();
        }
    }

    protected void drawGroupArea(Graphics2D g, P2DMarkerGroupInterface group, P2DRange1DInterface xRange, P2DRange1DInterface yRange, boolean xType, P2DAxisInterface xAxis, P2DAxisInterface yAxis) {
        boolean xLog = xAxis.getLog();
        boolean yLog = yAxis.getLog();
        if (group.hasValidValues()) {
            double lower = group.getLowerLimit();
            double upper = group.getUpperLimit();
            GeneralPath shape = new GeneralPath();
            if (xType) {
                FwkColumnAccessInterface column;
                P2DChannelInterface channel;
                Iterator it = xAxis.getChannels();
                String boundColumn = group.getBoundColumn();
                boolean uValid = true;
                boolean lValid = true;
                if (boundColumn == null || boundColumn.trim().length() == 0) {
                    if (it.hasNext() && (channel = (P2DChannelInterface)it.next()) != null && (column = channel.getXColumn()) != null) {
                        lValid = false;
                        uValid = false;
                    }
                } else {
                    lValid = false;
                    uValid = false;
                    while (!uValid && !lValid && it.hasNext()) {
                        channel = (P2DChannelInterface)it.next();
                        if (channel == null) continue;
                        column = channel.getXColumn();
                        if (column != null) {
                            lValid = column.getUnitString().compareTo(group.getUnit()) == 0;
                            uValid = lValid;
                            continue;
                        }
                        lower = group.getLowerIndex();
                        upper = group.getUpperIndex();
                    }
                }
                if (uValid && lValid && !(upper < xRange.getLower()) && !(lower > xRange.getUpper())) {
                    if (lower < xRange.getLower()) {
                        lower = xRange.getLower();
                    }
                    if (upper > xRange.getUpper()) {
                        upper = xRange.getUpper();
                    }
                    float lx = (float)lower;
                    float ly = (float)upper;
                    float ux = (float)yRange.getLower();
                    float uy = (float)yRange.getUpper();
                    if (xLog && yLog) {
                        lx = (float)(Math.log(lx) / P2D.log10);
                        ly = (float)(Math.log(ly) / P2D.log10);
                        ux = (float)(Math.log(ux) / P2D.log10);
                        uy = (float)(Math.log(uy) / P2D.log10);
                    } else if (xLog) {
                        lx = (float)(Math.log(lx) / P2D.log10);
                        ly = (float)(Math.log(ly) / P2D.log10);
                    } else if (yLog) {
                        ux = (float)(Math.log(ux) / P2D.log10);
                        uy = (float)(Math.log(uy) / P2D.log10);
                    }
                    shape.moveTo(lx, 0.0f);
                    shape.lineTo(lx, 1.0f);
                    shape.lineTo(ly, 1.0f);
                    shape.lineTo(ly, 0.0f);
                    shape.closePath();
                }
            } else if (!(upper < yRange.getLower()) && !(lower > yRange.getUpper())) {
                if (lower < yRange.getLower()) {
                    lower = yRange.getLower();
                }
                if (upper > yRange.getUpper()) {
                    upper = yRange.getUpper();
                }
                shape.moveTo((float)xRange.getLower(), (float)lower);
                shape.lineTo((float)xRange.getUpper(), (float)lower);
                shape.lineTo((float)xRange.getUpper(), (float)upper);
                shape.lineTo((float)xRange.getLower(), (float)upper);
                shape.closePath();
            }
            if (shape.getCurrentPoint() != null) {
                g.setColor(group.getColor());
                g.fill(shape);
            }
        }
        if (group.hasChildren()) {
            FwkArrayInterface arr = group.getAllChildren();
            int size = arr.size();
            for (int i = 0; i < size; ++i) {
                this.drawGroupArea(g, (P2DMarkerGroupInterface)arr.get(i), xRange, yRange, xType, xAxis, yAxis);
            }
        }
    }

    protected void drawGroupHandles(Graphics2D g, AffineTransform at, P2DMarkerGroupInterface group, P2DRange1DInterface xRange, P2DRange1DInterface yRange, boolean xType, P2DAxisInterface xAxis, P2DAxisInterface yAxis) {
        boolean xLog = xAxis.getLog();
        boolean yLog = yAxis.getLog();
        if (group.hasValidValues()) {
            Point2D.Double u;
            Point2D.Double l;
            double lower = group.getLowerLimit();
            double upper = group.getUpperLimit();
            Point2D.Double ut = new Point2D.Double();
            Point2D.Double lt = new Point2D.Double();
            g.setColor(group.getColor());
            if (xType) {
                FwkColumnAccessInterface column;
                P2DChannelInterface channel;
                Iterator it = xAxis.getChannels();
                String boundColumn = group.getBoundColumn();
                boolean uValid = true;
                boolean lValid = true;
                if (boundColumn == null || boundColumn.trim().length() == 0) {
                    if (it.hasNext() && (channel = (P2DChannelInterface)it.next()) != null && (column = channel.getXColumn()) != null) {
                        lValid = false;
                        uValid = false;
                    }
                } else {
                    lValid = false;
                    uValid = false;
                    while (!uValid && !lValid && it.hasNext()) {
                        channel = (P2DChannelInterface)it.next();
                        if (channel == null) continue;
                        column = channel.getXColumn();
                        if (column != null) {
                            lValid = column.getUnitString().compareTo(group.getUnit()) == 0;
                            uValid = lValid;
                            continue;
                        }
                        lower = group.getLowerIndex();
                        upper = group.getUpperIndex();
                    }
                }
                if (uValid && lValid && !(upper < xRange.getLower()) && !(lower > xRange.getUpper())) {
                    if (lower < xRange.getLower()) {
                        lower = xRange.getLower();
                    }
                    if (upper > xRange.getUpper()) {
                        upper = xRange.getUpper();
                    }
                    if (xLog) {
                        l = new Point2D.Double(Math.log(lower) / P2D.log10, 0.0);
                        u = new Point2D.Double(Math.log(lower) / P2D.log10, 1.0);
                    } else {
                        l = new Point2D.Double(lower, 0.0);
                        u = new Point2D.Double(lower, 1.0);
                    }
                    at.transform(l, lt);
                    at.transform(u, ut);
                    this.drawLeftHandleImage(g, lt, ut);
                    if (xLog) {
                        l = new Point2D.Double(Math.log(upper) / P2D.log10, 0.0);
                        u = new Point2D.Double(Math.log(upper) / P2D.log10, 1.0);
                    } else {
                        l = new Point2D.Double(upper, 0.0);
                        u = new Point2D.Double(upper, 1.0);
                    }
                    at.transform(l, lt);
                    at.transform(u, ut);
                    this.drawRightHandleImage(g, lt, ut);
                    if (xLog) {
                        l = new Point2D.Double((Math.log(upper) / P2D.log10 + Math.log(lower) / P2D.log10) / 2.0, 0.0);
                        u = new Point2D.Double((Math.log(upper) / P2D.log10 + Math.log(lower) / P2D.log10) / 2.0, 1.0);
                    } else {
                        l = new Point2D.Double((upper + lower) / 2.0, 0.0);
                        u = new Point2D.Double((upper + lower) / 2.0, 1.0);
                    }
                    at.transform(l, lt);
                    at.transform(u, ut);
                    this.drawCenterHandleImage(g, lt, ut);
                }
            } else if (!(upper < yRange.getLower()) && !(lower > yRange.getUpper())) {
                if (lower < yRange.getLower()) {
                    lower = yRange.getLower();
                }
                if (upper > yRange.getUpper()) {
                    upper = yRange.getUpper();
                }
                if (yLog) {
                    l = new Point2D.Double(0.0, Math.log(lower) / P2D.log10);
                    u = new Point2D.Double(1.0, Math.log(lower) / P2D.log10);
                } else {
                    l = new Point2D.Double(0.0, lower);
                    u = new Point2D.Double(1.0, lower);
                }
                at.transform(l, lt);
                at.transform(u, ut);
                this.drawLeftHandleImage(g, lt, ut);
                if (yLog) {
                    l = new Point2D.Double(0.0, Math.log(upper) / P2D.log10);
                    u = new Point2D.Double(1.0, Math.log(upper) / P2D.log10);
                } else {
                    l = new Point2D.Double(0.0, upper);
                    u = new Point2D.Double(1.0, upper);
                }
                at.transform(l, lt);
                at.transform(u, ut);
                this.drawRightHandleImage(g, lt, ut);
                if (yLog) {
                    l = new Point2D.Double(0.0, (Math.log(upper) / P2D.log10 + Math.log(lower) / P2D.log10) / 2.0);
                    u = new Point2D.Double(1.0, (Math.log(upper) / P2D.log10 + Math.log(lower) / P2D.log10) / 2.0);
                } else {
                    l = new Point2D.Double(0.0, (upper + lower) / 2.0);
                    u = new Point2D.Double(1.0, (upper + lower) / 2.0);
                }
                at.transform(l, lt);
                at.transform(u, ut);
                this.drawCenterHandleImage(g, lt, ut);
            }
        }
        if (group.hasChildren()) {
            FwkArrayInterface arr = group.getAllChildren();
            int size = arr.size();
            for (int i = 0; i < size; ++i) {
                this.drawGroupHandles(g, at, (P2DMarkerGroupInterface)arr.get(i), xRange, yRange, xType, xAxis, yAxis);
            }
        }
    }

    protected void drawLeftHandleImage(Graphics2D g, Point2D l, Point2D u) {
        GeneralPath path = new GeneralPath();
        path.moveTo((float)l.getX(), (float)u.getY());
        path.lineTo((float)l.getX() + 5.0f, (float)u.getY() - 6.0f);
        path.lineTo((float)l.getX(), (float)u.getY() - 12.0f);
        path.closePath();
        g.fill(path);
        Color c = g.getColor();
        path.reset();
        path.moveTo((float)l.getX(), (float)u.getY());
        path.lineTo((float)l.getX() + 5.0f, (float)u.getY() - 6.0f);
        path.lineTo((float)l.getX(), (float)u.getY() - 12.0f);
        g.setColor(c.darker());
        g.draw(path);
        path.reset();
        path.moveTo((float)l.getX(), (float)u.getY());
        path.lineTo((float)l.getX(), (float)u.getY() - 12.0f);
        g.setColor(c.brighter());
        g.draw(path);
        g.setColor(c);
    }

    protected void drawRightHandleImage(Graphics2D g, Point2D l, Point2D u) {
        GeneralPath path = new GeneralPath();
        path.moveTo((float)l.getX(), (float)u.getY());
        path.lineTo((float)l.getX() - 5.0f, (float)u.getY() - 6.0f);
        path.lineTo((float)l.getX(), (float)u.getY() - 12.0f);
        path.closePath();
        g.fill(path);
        Color c = g.getColor();
        path.reset();
        path.moveTo((float)l.getX(), (float)u.getY());
        path.lineTo((float)l.getX() - 5.0f, (float)u.getY() - 6.0f);
        path.lineTo((float)l.getX(), (float)u.getY() - 12.0f);
        g.setColor(c.brighter());
        g.draw(path);
        path.reset();
        path.moveTo((float)l.getX(), (float)u.getY());
        path.lineTo((float)l.getX(), (float)u.getY() - 12.0f);
        g.setColor(c.darker());
        g.draw(path);
        g.setColor(c);
    }

    protected void drawCenterHandleImage(Graphics2D g, Point2D l, Point2D u) {
        GeneralPath path = new GeneralPath();
        path.moveTo((float)l.getX(), (float)u.getY());
        path.lineTo((float)l.getX() - 5.0f, (float)u.getY() - 6.0f);
        path.lineTo((float)l.getX(), (float)u.getY() - 12.0f);
        path.lineTo((float)l.getX() + 5.0f, (float)u.getY() - 6.0f);
        path.closePath();
        g.fill(path);
        Color c = g.getColor();
        path.reset();
        path.moveTo((float)l.getX(), (float)u.getY());
        path.lineTo((float)l.getX() - 5.0f, (float)u.getY() - 6.0f);
        path.lineTo((float)l.getX(), (float)u.getY() - 12.0f);
        g.setColor(c.brighter());
        g.draw(path);
        path.reset();
        path.moveTo((float)l.getX(), (float)u.getY() - 12.0f);
        path.lineTo((float)l.getX() + 5.0f, (float)u.getY() - 6.0f);
        path.lineTo((float)l.getX(), (float)u.getY());
        g.setColor(c.darker());
        g.draw(path);
        g.setColor(c);
    }
}

