/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.p2d.P2DAxisInterface;
import com.highqsoft.interfaces.p2d.P2DChannelInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DLegendInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerInterface;
import com.highqsoft.interfaces.p2d.P2DPlotInterface;
import com.highqsoft.interfaces.p2d.P2DPlotModelInterface;
import com.highqsoft.interfaces.p2d.P2DTextInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DComponent;

public class P2DPlot
extends P2DComponent
implements P2DPlotInterface {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)P2DPlot.class, (FwkDescriptionInterface)descriptor);
    }

    public P2DPlot(String plotName) {
        this.setDescriptor(descriptor);
        this.setProperty("ModelClassId", "P2DPlotModelId");
        this.setProperty("ViewClassId", "P2DPlotViewId");
        this.setProperty("ControlClassId", "P2DPlotControlId");
        try {
            this.updateModel();
            this.updateView();
            this.updateControl();
            if (plotName == null || plotName.length() == 0) {
                plotName = P2DPlot.getDescriptor().getName() + "[" + this.hashCode() + "]@" + P2D.BUSNAME;
            }
            this.setMemberName(plotName);
            this.register(FwkContainer.getDataFlavors(this.getClass()));
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DPlot.java,v $", this.getVersion(), "AH 1999-04-06 13:51", "Cannot set plot defaults", (Object)this, t);
        }
    }

    public String getTitle() {
        return super.getTitle() + " " + this.getShortName();
    }

    public P2DTextInterface setTitleComponent(String titleString) {
        P2DTextInterface ret = ((P2DPlotModelInterface)this.model).setTitleComponent((P2DComponentInterface)this, titleString);
        return ret;
    }

    public P2DTextInterface setTitleComponent(FwkArrayInterface arr) {
        P2DTextInterface ret = ((P2DPlotModelInterface)this.model).setTitleComponent((P2DComponentInterface)this, arr);
        return ret;
    }

    public P2DTextInterface setTitleComponent(P2DTextInterface text) {
        P2DTextInterface ret = ((P2DPlotModelInterface)this.model).setTitleComponent((P2DComponentInterface)this, text);
        return ret;
    }

    public P2DTextInterface getTitleComponent() {
        return ((P2DPlotModelInterface)this.model).getTitleComponent(this);
    }

    public P2DLegendInterface setLegendComponent(P2DLegendInterface legend) {
        P2DLegendInterface ret = ((P2DPlotModelInterface)this.model).setLegendComponent(this, legend);
        return ret;
    }

    public P2DLegendInterface getLegendComponent() {
        return ((P2DPlotModelInterface)this.model).getLegendComponent(this);
    }

    public void clearChannelComponents() {
        ((P2DPlotModelInterface)this.model).clearChannelComponents(this);
    }

    public P2DChannelInterface[] addChannelComponent(String xName, String yName) {
        P2DChannelInterface[] ret = ((P2DPlotModelInterface)this.model).addChannelComponent(this, xName, yName);
        this.revalidate(true);
        return ret;
    }

    public P2DChannelInterface[] addChannelComponent(String yName) {
        P2DChannelInterface[] ret = ((P2DPlotModelInterface)this.model).addChannelComponent(this, yName);
        this.revalidate(true);
        return ret;
    }

    public P2DChannelInterface[] setChannelComponent(String xName) {
        return ((P2DPlotModelInterface)this.model).setChannelComponent(this, xName);
    }

    public P2DChannelInterface[] setChannelComponent(String xName, String yName) {
        return ((P2DPlotModelInterface)this.model).setChannelComponent(this, xName, yName);
    }

    public boolean hasChannels() {
        return ((P2DPlotModelInterface)this.model).hasChannels(this);
    }

    public P2DChannelInterface getChannelComponent() {
        return ((P2DPlotModelInterface)this.model).getChannelComponent(this);
    }

    public P2DChannelInterface[] getChannelComponents() {
        return ((P2DPlotModelInterface)this.model).getChannelComponents(this);
    }

    public P2DChannelInterface getChannelComponent(String yName) {
        return ((P2DPlotModelInterface)this.model).getChannelComponent(this, yName);
    }

    public P2DAxisInterface getXAxisComponent() {
        return ((P2DPlotModelInterface)this.model).getXAxisComponent(this);
    }

    public P2DAxisInterface getYAxisComponent() {
        return ((P2DPlotModelInterface)this.model).getYAxisComponent(this);
    }

    public P2DAxisInterface[] getAllYAxisComponents() {
        return ((P2DPlotModelInterface)this.model).getAllYAxisComponents(this);
    }

    public P2DAxisInterface getYAxisComponent(String yName) {
        return ((P2DPlotModelInterface)this.model).getYAxisComponent(this, yName);
    }

    public P2DMarkerInterface getMarkerComponent() {
        return ((P2DPlotModelInterface)this.model).getMarkerComponent(this);
    }

    public void zoomXIn() {
        P2DAxisInterface axis = this.getXAxisComponent();
        if (axis != null) {
            axis.zoomIn();
        }
    }

    public void zoomXOut() {
        P2DAxisInterface axis = this.getXAxisComponent();
        if (axis != null) {
            axis.zoomOut();
        }
    }

    public void setXAutoRange() {
        P2DAxisInterface axis = this.getXAxisComponent();
        if (axis != null) {
            axis.setAutoRange(true);
        }
    }

    public void setYAutoRange() {
        P2DAxisInterface[] axes = this.getAllYAxisComponents();
        if (axes != null && axes.length != 0) {
            int size = axes.length;
            for (int i = 0; i < size; ++i) {
                axes[i].setAutoRange(true);
            }
        }
    }

    public void toEndOfXRange() {
        P2DAxisInterface axis = this.getXAxisComponent();
        if (axis != null) {
            axis.toEndOfRange();
        }
    }

    public void toBeginOfXRange() {
        P2DAxisInterface axis = this.getXAxisComponent();
        if (axis != null) {
            axis.toBeginOfRange();
        }
    }

    public void nextXRangeWindow() {
        P2DAxisInterface axis = this.getXAxisComponent();
        if (axis != null) {
            axis.nextRangeWindow();
        }
    }

    public void prevXRangeWindow() {
        P2DAxisInterface axis = this.getXAxisComponent();
        if (axis != null) {
            axis.prevRangeWindow();
        }
    }

    public void nextXRangeStep() {
        P2DAxisInterface axis = this.getXAxisComponent();
        if (axis != null) {
            axis.nextRangeStep();
        }
    }

    public void prevXRangeStep() {
        P2DAxisInterface axis = this.getXAxisComponent();
        if (axis != null) {
            axis.prevRangeStep();
        }
    }

    public void setFullXResolution(P2DContainerInterface container) {
        P2DAxisInterface axis = this.getXAxisComponent();
        if (axis != null) {
            axis.setFullResolution(container);
        }
    }

    public void setXChannelName(String xName) {
        if (xName != null) {
            ((P2DPlotModelInterface)this.model).setXChannelName(this, xName);
        }
    }

    public String getXChannelName() {
        return ((P2DPlotModelInterface)this.model).getXChannelName(this);
    }

    public boolean getHorizontalTile() {
        return ((P2DPlotModelInterface)this.model).getHorizontalTile(this);
    }

    public void setHorizontalTile(boolean flag) {
        boolean old = ((P2DPlotModelInterface)this.model).getHorizontalTile(this);
        this.setSingleScale(false);
        if (old != flag) {
            ((P2DPlotModelInterface)this.model).setHorizontalTile(this, flag);
            this.firePropertyChange("HorizontalTile", old, flag);
            this.revalidate(true);
            this.repaint();
        }
    }

    public boolean getSingleScale() {
        return ((P2DPlotModelInterface)this.model).getSingleScale(this);
    }

    public void setSingleScale(boolean flag) {
        boolean old = ((P2DPlotModelInterface)this.model).getSingleScale(this);
        if (old != flag) {
            ((P2DPlotModelInterface)this.model).setSingleScale(this, flag);
            this.firePropertyChange("SingleScale", old, flag);
            this.revalidate(true);
            this.repaint();
        }
    }

    public boolean getVerticalTile() {
        return ((P2DPlotModelInterface)this.model).getVerticalTile(this);
    }

    public void setVerticalTile(boolean flag) {
        boolean old = ((P2DPlotModelInterface)this.model).getHorizontalTile(this);
        this.setSingleScale(false);
        if (old != flag) {
            this.firePropertyChange("VerticalTile", old, flag);
            this.revalidate(true);
            this.repaint();
        }
    }

    public void setLegendEnabled(boolean flag) {
        boolean old = ((P2DPlotModelInterface)this.model).getLegendEnabled(this);
        if (old != flag) {
            ((P2DPlotModelInterface)this.model).setLegendEnabled(this, flag);
            this.firePropertyChange("LegendEnabled", old, flag);
            this.revalidate(true);
            this.repaint();
        }
    }

    public boolean getLegendEnabled() {
        return ((P2DPlotModelInterface)this.model).getLegendEnabled(this);
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The plot component of the p2d package");
        descriptor.setTitleName("P2DPlot.Text.Title");
        descriptor.setName(P2DPlot.class.getName());
        descriptor.setIconKey("Icon.P2DPlot");
        descriptor.setCreationDate("$Date: 2005/02/03 14:51:12 $", null);
    }
}

