/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.command.FwkToggleCommand;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.p2d.P2DAxisInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DChannelInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DLegendInterface;
import com.highqsoft.interfaces.p2d.P2DMarkerInterface;
import com.highqsoft.interfaces.p2d.P2DPlotModelInterface;
import com.highqsoft.interfaces.p2d.P2DTextInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DAttributorSupport;
import com.highqsoft.p2d.P2DAxis;
import com.highqsoft.p2d.P2DAxisType;
import com.highqsoft.p2d.P2DBoundingBox;
import com.highqsoft.p2d.P2DChannel;
import com.highqsoft.p2d.P2DComponentConsumer;
import com.highqsoft.p2d.P2DComponentModel;
import com.highqsoft.p2d.P2DLegend;
import com.highqsoft.p2d.P2DMarker;
import com.highqsoft.p2d.P2DText;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class P2DPlotModel
extends P2DComponentModel
implements P2DPlotModelInterface {
    public static final String version = "$Revision: 1.4 $";
    public static final float YAXIS_OFFSET = FwkPropertyBus.getProperty((String)"P2DPlotModel.YAxisOffset", (float)0.1f);
    protected boolean horizontalTile = false;
    protected boolean verticalTile = false;
    protected boolean singleScale = false;
    protected boolean legendEnabled = false;

    protected P2DBoundingBoxInterface getSubBoundingBox(String key, double width, double height, double x1, double y1, double x2, double y2) {
        double x1Pos = FwkPropertyBus.getProperty((String)("P2DPlotModel." + key + ".X1"), (double)x1);
        double x2Pos = FwkPropertyBus.getProperty((String)("P2DPlotModel." + key + ".X2"), (double)x2);
        double y1Pos = FwkPropertyBus.getProperty((String)("P2DPlotModel." + key + ".Y1"), (double)y1);
        double y2Pos = FwkPropertyBus.getProperty((String)("P2DPlotModel." + key + ".Y2"), (double)y2);
        if (x1Pos <= 1.0) {
            x1Pos *= width;
        }
        if (x2Pos <= 1.0) {
            x2Pos *= width;
        }
        if (y1Pos <= 1.0) {
            y1Pos *= height;
        }
        if (y2Pos <= 1.0) {
            y2Pos *= height;
        }
        return new P2DBoundingBox(x1Pos, y1Pos, x2Pos, y2Pos);
    }

    protected void calcTitleBounds(P2DComponentInterface component, P2DBoundingBoxInterface bb) {
        P2DTextInterface title = this.getTitleComponent(component);
        if (title != null) {
            if (this.legendEnabled) {
                title.setBoundingBox(this.getSubBoundingBox("Title", bb.getWidth(), bb.getHeight(), 0.0, 0.0, 0.5, 0.15));
            } else {
                title.setBoundingBox(this.getSubBoundingBox("Title", bb.getWidth(), bb.getHeight(), 0.0, 0.0, 1.0, 0.15));
            }
        }
    }

    protected void calcLegendBounds(P2DComponentInterface component, P2DBoundingBoxInterface bb) {
        P2DLegendInterface legend = this.getLegendComponent(component);
        if (legend != null) {
            legend.setBoundingBox(this.getSubBoundingBox("Legend", bb.getWidth(), bb.getHeight(), 0.5, 0.0, 1.0, 0.15));
        }
    }

    protected void calcYAxisBounds(P2DComponentInterface component, P2DBoundingBoxInterface bb) {
        P2DMarkerInterface marker;
        P2DBoundingBoxInterface tBounds = null;
        P2DTextInterface title = this.getTitleComponent(component);
        if (title != null) {
            tBounds = title.getBoundingBox();
        }
        Point2D.Double lower = null;
        Point2D.Double upper = null;
        if (tBounds != null) {
            lower = new Point2D.Double(0.0, tBounds.getUpper().getY() * 1.2);
            upper = new Point2D.Double(bb.getWidth(), 0.8 * bb.getHeight());
        } else {
            lower = new Point2D.Double(0.0, bb.getUpper().getY() * 1.2);
            upper = new Point2D.Double(bb.getWidth(), 0.8 * bb.getHeight());
        }
        P2DAxisInterface[] arr = this.getAllYAxisComponents(component);
        if (arr != null && arr.length != 0) {
            int size = arr.length;
            P2DAxisInterface axis = null;
            int count = 0;
            int val = 0;
            if (this.horizontalTile) {
                double dHeight = (0.8 * bb.getHeight() - lower.getY()) / (double)size;
                for (int i = 0; i < size; ++i) {
                    P2DBoundingBoxInterface retBB;
                    axis = arr[i];
                    if (axis.getType().getValue() != P2DAxisType.Y.getValue()) continue;
                    val = size - count - 1;
                    if (count % 2 == 0) {
                        axis.setPosition(0.0);
                        retBB = this.getSubBoundingBox("YAxis" + count, bb.getWidth(), bb.getHeight(), 0.0, lower.getY() + (double)val * dHeight, YAXIS_OFFSET, lower.getY() + (double)(val + 1) * dHeight);
                    } else {
                        axis.setPosition(1.0);
                        retBB = this.getSubBoundingBox("YAxis" + count, bb.getWidth(), bb.getHeight(), 1.0f - YAXIS_OFFSET, lower.getY() + (double)val * dHeight, 1.0, lower.getY() + (double)(val + 1) * dHeight);
                    }
                    axis.setBoundingBox(retBB);
                    ++count;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    P2DBoundingBoxInterface retBB;
                    axis = arr[i];
                    if (axis.getType().getValue() != P2DAxisType.Y.getValue()) continue;
                    axis.setPosition(count % 2);
                    int fac = count / 2;
                    if (count % 2 == 0) {
                        retBB = this.getSubBoundingBox("YAxis" + count, bb.getWidth(), bb.getHeight(), YAXIS_OFFSET * (float)fac, lower.getY(), YAXIS_OFFSET * (float)(1 + fac), 0.8);
                        lower.x = (double)(YAXIS_OFFSET * (float)(1 + fac)) * bb.getWidth();
                    } else {
                        retBB = this.getSubBoundingBox("YAxis" + count, bb.getWidth(), bb.getHeight(), 1.0f - YAXIS_OFFSET * (float)(fac + 1), lower.getY(), 1.0 - (double)(YAXIS_OFFSET * (float)fac), 0.8);
                    }
                    axis.setBoundingBox(retBB);
                    ++count;
                }
            }
        }
        if ((marker = this.getMarkerComponent(component)) != null) {
            marker.setDisplayBoundingBox(new P2DBoundingBox(lower, upper));
        }
    }

    protected void calcXAxisBounds(P2DComponentInterface component, P2DBoundingBoxInterface bb) {
        P2DAxisInterface xAxis;
        P2DBoundingBoxInterface ret = this.getSubBoundingBox("XAxis", bb.getWidth(), bb.getHeight(), YAXIS_OFFSET, 0.8, 1.0f - YAXIS_OFFSET, 0.95);
        P2DAxisInterface[] arr = this.getAllYAxisComponents(component);
        int axisNum = arr.length;
        if (axisNum > 2) {
            double x1 = 0.0;
            double x2 = ret.getUpper().getX();
            double y1 = ret.getLower().getY();
            double y2 = ret.getUpper().getY();
            if (axisNum > 1 && !this.horizontalTile) {
                x2 = Double.MAX_VALUE;
            }
            for (int i = 0; i < axisNum; ++i) {
                P2DBoundingBoxInterface bounds = arr[i].getBoundingBox();
                if (arr[i].getPosition() <= 0.0) {
                    x1 = Math.max(x1, bounds.getUpper().getX());
                    continue;
                }
                if (this.horizontalTile) continue;
                x2 = Math.min(x2, bounds.getLower().getX());
            }
            ret = new P2DBoundingBox(x1, y1, x2, y2);
        }
        if ((xAxis = this.getXAxisComponent(component)) != null) {
            xAxis.setBoundingBox(ret);
        }
    }

    protected void calculateBounds(P2DComponentInterface component) {
        P2DTextInterface title = this.getTitleComponent(component);
        if (title != null) {
            P2DBoundingBoxInterface bb = component.getBoundingBox();
            this.calcTitleBounds(component, bb);
            this.calcLegendBounds(component, bb);
            this.calcYAxisBounds(component, bb);
            this.calcXAxisBounds(component, bb);
        }
    }

    public P2DTextInterface setTitleComponent(P2DComponentInterface component, String titleString) {
        P2DTextInterface title = this.createTitleComponent(component);
        title.setText(titleString);
        return title;
    }

    public P2DTextInterface setTitleComponent(P2DComponentInterface component, FwkArrayInterface arr) {
        P2DTextInterface title = this.createTitleComponent(component);
        title.setTextArray(arr);
        return title;
    }

    public P2DTextInterface setTitleComponent(P2DComponentInterface component, P2DTextInterface text) {
        return (P2DTextInterface)component.addP2D(text);
    }

    public P2DLegendInterface setLegendComponent(P2DComponentInterface component, P2DLegendInterface legend) {
        return (P2DLegendInterface)component.addP2D(legend);
    }

    public P2DTextInterface getTitleComponent(P2DComponentInterface component) {
        P2DContainerInterface[] arr = component.getP2D(P2DTextInterface.class);
        P2DTextInterface ret = null;
        if (arr != null && arr.length != 0) {
            ret = (P2DTextInterface)arr[0];
        }
        return ret;
    }

    public P2DLegendInterface getLegendComponent(P2DComponentInterface component) {
        P2DContainerInterface[] arr = component.getP2D(P2DLegendInterface.class);
        P2DLegendInterface ret = null;
        if (arr != null && arr.length != 0) {
            ret = (P2DLegendInterface)arr[0];
        }
        return ret;
    }

    protected P2DTextInterface createTitleComponent(P2DComponentInterface component) {
        P2DTextInterface title = this.getTitleComponent(component);
        if (title == null) {
            title = new P2DText(component.getName() + "(Title)@" + component.getInfoBusName());
            title.setAlignment(0.5f);
            title.setColor(component.getColor());
            title.setBackgroundColor(component.getBackgroundColor());
            title.setFont(component.getFont());
            title.setFrameColor(component.getFrameColor());
            component.addP2D(title, 0);
        }
        return title;
    }

    protected P2DLegendInterface createLegendComponent(P2DComponentInterface component) {
        P2DLegendInterface legend = this.getLegendComponent(component);
        if (legend == null && this.legendEnabled) {
            legend = new P2DLegend(component.getName() + "(Legend)@" + component.getInfoBusName());
            legend.setColor(component.getColor());
            legend.setBackgroundColor(component.getBackgroundColor());
            legend.setFont(component.getFont());
            legend.setFrameColor(component.getFrameColor());
            component.addP2D(legend, 0);
        }
        return legend;
    }

    public void clearChannelComponents(P2DComponentInterface component) {
        try {
            P2DContainerInterface[] arr;
            P2DLegendInterface legend = this.getLegendComponent(component);
            if (legend != null) {
                legend.removeAllChannels();
            }
            if ((arr = component.getP2D(P2DChannelInterface.class)) != null && arr.length != 0) {
                int size = arr.length;
                for (int i = 0; i < size; ++i) {
                    String name = arr[i].getName();
                    P2DChannelInterface comp = (P2DChannelInterface)P2DComponentConsumer.getInstanceByName(component.getInfoBusName()).findComponent(name);
                    P2DAxisInterface xAxis = this.getXAxisComponent(component);
                    if (xAxis != null) {
                        xAxis.removeChannel(comp);
                    }
                    component.removeP2D(comp);
                }
            }
            if ((arr = component.getP2D(P2DAxisInterface.class)) != null && arr.length != 0) {
                int size = arr.length;
                for (int i = 0; i < size; ++i) {
                    P2DAxisInterface axis = (P2DAxisInterface)arr[i];
                    if (axis.getType().getValue() != P2DAxisType.Y.getValue()) continue;
                    component.removeP2D(axis);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public P2DChannelInterface[] addChannelComponent(P2DComponentInterface component, String xName, String yName) {
        P2DChannelInterface[] channel = this.addChannelComponent(component, yName);
        if (channel != null) {
            int size = channel.length;
            for (int i = 0; i < size; ++i) {
                channel[i].setXDataItemName(xName);
            }
        }
        return channel;
    }

    public P2DChannelInterface[] addChannelComponent(P2DComponentInterface component, String yName) {
        P2DContainerInterface[] contArr;
        P2DChannelInterface channel = new P2DChannel(yName + "@" + component.getInfoBusName());
        channel.setYDataItemName(yName);
        FwkColumnAccessInterface col = channel.getYColumn();
        if (col != null && col.isGroup()) {
            Object[] ret;
            FwkArray chaArray = new FwkArray();
            if (col.hasValidValues()) {
                chaArray.add((Object)col);
            }
            FwkArrayInterface array = col.getAllChildren();
            int size = array.size();
            for (int i = 0; i < size; ++i) {
                ret = this.addChannelComponent(component, ((FwkColumnAccessInterface)array.get(i)).getName());
                chaArray.addAll((Collection)new ArrayCollection(ret));
            }
            ret = new P2DChannelInterface[chaArray.size()];
            return (P2DChannelInterface[])chaArray.toArray(ret);
        }
        P2DTextInterface title = this.createTitleComponent(component);
        P2DLegendInterface legend = this.createLegendComponent(component);
        P2DMarkerInterface marker = this.getMarkerComponent(component);
        if (marker == null) {
            marker = new P2DMarker(component.getName() + "(Marker)@" + component.getInfoBusName());
            marker.setBind(P2DAxisType.X);
            component.addP2D(marker);
        }
        P2DContainerInterface[] cArr = component.getP2D(P2DChannelInterface.class);
        int count = 0;
        if (cArr != null && cArr.length != 0) {
            count = cArr.length;
        }
        P2DAxisInterface yAxis = this.getYAxisComponent(component);
        if (!this.singleScale || yAxis == null) {
            yAxis = new P2DAxis("Y-Axis " + yName + "@" + component.getInfoBusName());
            yAxis.setType(P2DAxisType.Y);
            yAxis.setGrid(false);
            if (!this.singleScale) {
                yAxis.setColor(P2D.colors[(count + 9) % P2D.colors.length]);
            }
            yAxis.setAutoRange(true);
            component.addP2D(yAxis);
        } else if (yAxis != null) {
            String axisTitle = yAxis.getTitle();
            axisTitle = axisTitle + "\n" + this.getChannelTitle(channel);
            yAxis.setTitle(axisTitle);
            if (count == 1) {
                yAxis.setTitleAttributor(new Attributor());
            }
        }
        P2DAxisInterface xAxis = this.getXAxisComponent(component);
        if (xAxis == null) {
            xAxis = new P2DAxis(component.getName() + "(X-Axis)@" + component.getInfoBusName());
            xAxis.setTitle("Index");
            xAxis.setType(P2DAxisType.X);
            xAxis.setGrid(false);
            xAxis.setAutoRange(true);
            component.addP2D(xAxis);
        }
        this.calculateBounds(component);
        marker.setXAxisName(xAxis.getName());
        marker.setYAxisName(yAxis.getName());
        channel.setXAxisName(xAxis.getName());
        channel.setYAxisName(yAxis.getName());
        channel.setYDataItemName(yName);
        String xChannelName = this.getXChannelName(component);
        if (xChannelName != null) {
            channel.setXDataItemName(xChannelName);
        }
        channel.setColor(P2D.colors[(count + 9) % P2D.colors.length]);
        component.addP2D(channel);
        channel.toBack();
        P2DChannelInterface[] ret = new P2DChannelInterface[]{channel};
        marker.toBack();
        FwkSortedArray textArr = new FwkSortedArray();
        if (legend != null) {
            legend.removeAllChannels();
        }
        if ((contArr = component.getP2D(P2DChannelInterface.class)) != null && contArr.length != 0) {
            int size = contArr.length;
            for (int i = 0; i < size; ++i) {
                FwkColumnAccessInterface column;
                channel = (P2DChannelInterface)contArr[i];
                if (channel == null) continue;
                if (legend != null) {
                    legend.addChannel(channel);
                }
                if ((column = channel.getYColumn()) == null) continue;
                textArr.add((Comparable)((Object)column.getShortName()));
            }
        }
        if (!this.legendEnabled) {
            title.setTextArray((FwkArrayInterface)textArr);
        }
        return ret;
    }

    public P2DChannelInterface[] setChannelComponent(P2DComponentInterface component, String yName) {
        P2DAxisInterface yAxis;
        FwkColumnAccessInterface column;
        P2DChannelInterface channel = this.getChannelComponent(component);
        if (channel == null) {
            channel = this.createChannelComponent(component, yName);
        }
        channel.setYDataItemName(yName);
        P2DAxisInterface xAxis = channel.getXAxis();
        if (xAxis != null) {
            xAxis.setTitle("Index");
        }
        if ((column = channel.getYColumn()) != null && (yAxis = channel.getYAxis()) != null) {
            yAxis.setTitle(column.getShortName());
        }
        component.revalidate(true);
        return new P2DChannelInterface[]{channel};
    }

    protected P2DChannelInterface createChannelComponent(P2DComponentInterface component, String yName) {
        P2DMarkerInterface marker = this.getMarkerComponent(component);
        if (marker == null) {
            marker = new P2DMarker(component.getName() + "(Marker)@" + component.getInfoBusName());
            component.addP2D(marker);
        }
        marker.setBind(P2DAxisType.X);
        P2DAxis yAxis = new P2DAxis(component.getName() + "(Y-Axis)@" + component.getInfoBusName());
        yAxis.setType(P2DAxisType.Y);
        yAxis.setGrid(false);
        yAxis.setAutoRange(true);
        component.addP2D(yAxis);
        P2DAxisInterface xAxis = this.getXAxisComponent(component);
        if (xAxis == null) {
            xAxis = new P2DAxis(component.getName() + "(X-Axis)@" + component.getInfoBusName());
            component.addP2D(xAxis);
        }
        xAxis.setType(P2DAxisType.X);
        xAxis.setGrid(false);
        xAxis.setAutoRange(true);
        this.calculateBounds(component);
        P2DChannel channel = new P2DChannel(yName + "@" + component.getInfoBusName());
        channel.setXAxisName(xAxis.getName());
        channel.setYAxisName(yAxis.getName());
        component.addP2D(channel);
        channel.toBack();
        if (marker != null) {
            marker.setXAxisName(xAxis.getName());
            marker.setYAxisName(yAxis.getName());
            marker.toBack();
        }
        return channel;
    }

    public P2DChannelInterface[] setChannelComponent(P2DComponentInterface component, String xName, String yName) {
        P2DAxisInterface yAxis;
        FwkColumnAccessInterface column;
        P2DChannelInterface channel = this.getChannelComponent(component);
        if (channel == null) {
            channel = this.createChannelComponent(component, xName + " - " + yName);
        }
        channel.setXDataItemName(xName);
        channel.setYDataItemName(yName);
        P2DAxisInterface xAxis = this.getXAxisComponent(component);
        if (xAxis != null) {
            xAxis.setTitle(xName);
        }
        if ((column = channel.getYColumn()) != null && (yAxis = this.getYAxisComponent(component)) != null) {
            yAxis.setTitle(column.getShortName());
        }
        return new P2DChannelInterface[]{channel};
    }

    public P2DChannelInterface getChannelComponent(P2DComponentInterface component) {
        P2DContainerInterface[] arr = component.getP2D(P2DChannelInterface.class);
        if (arr != null && arr.length != 0) {
            return (P2DChannelInterface)arr[arr.length - 1];
        }
        return null;
    }

    public P2DChannelInterface[] getChannelComponents(P2DComponentInterface component) {
        P2DContainerInterface[] arr = component.getP2D(P2DChannelInterface.class);
        P2DChannelInterface[] ret = null;
        if (arr == null || arr.length == 0) {
            ret = new P2DChannelInterface[]{};
        } else {
            int size = arr.length;
            ret = new P2DChannelInterface[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = (P2DChannelInterface)arr[i];
            }
        }
        return ret;
    }

    public boolean hasChannels(P2DComponentInterface component) {
        P2DContainerInterface[] ret = component.getP2D(P2DChannelInterface.class);
        return ret != null && ret.length != 0;
    }

    public P2DChannelInterface getChannelComponent(P2DComponentInterface component, String yName) {
        P2DContainerInterface[] arr = component.getP2D(P2DChannelInterface.class, yName);
        P2DChannelInterface ret = null;
        if (arr != null && arr.length != 0) {
            ret = (P2DChannelInterface)arr[0];
        }
        return ret;
    }

    public P2DAxisInterface getXAxisComponent(P2DComponentInterface component) {
        P2DAxisInterface ret = null;
        P2DContainerInterface[] arr = component.getP2D(P2DAxisInterface.class);
        if (arr != null) {
            int size = arr.length;
            for (int i = 0; i < size && ret == null; ++i) {
                P2DAxisInterface axis = (P2DAxisInterface)arr[i];
                if (axis.getType().getValue() != P2DAxisType.X.getValue()) continue;
                ret = axis;
            }
        }
        return ret;
    }

    public P2DAxisInterface getYAxisComponent(P2DComponentInterface component, String yName) {
        P2DAxisInterface ret = null;
        P2DContainerInterface[] arr = component.getP2D(P2DAxisInterface.class, yName);
        if (arr != null) {
            int size = arr.length;
            for (int i = 0; i < size && ret == null; ++i) {
                P2DAxisInterface axis = (P2DAxisInterface)arr[i];
                if (axis.getType().getValue() != P2DAxisType.Y.getValue()) continue;
                ret = axis;
            }
        }
        return ret;
    }

    public P2DAxisInterface[] getAllYAxisComponents(P2DComponentInterface component) {
        P2DAxisInterface[] ret = null;
        P2DContainerInterface[] arr = component.getP2D(P2DAxisInterface.class);
        if (arr != null && arr.length != 0) {
            int size = arr.length;
            ret = new P2DAxisInterface[size];
            int count = 0;
            for (int i = 0; i < size; ++i) {
                P2DAxisInterface axis = (P2DAxisInterface)arr[i];
                if (axis.getType().getValue() != P2DAxisType.Y.getValue()) continue;
                ret[count++] = axis;
            }
            if (count > 0) {
                P2DAxisInterface[] tmp = new P2DAxisInterface[count];
                System.arraycopy(ret, 0, tmp, 0, count);
                ret = tmp;
            } else {
                ret = new P2DAxisInterface[]{};
            }
        } else {
            ret = new P2DAxisInterface[]{};
        }
        return ret;
    }

    public P2DAxisInterface getYAxisComponent(P2DComponentInterface component) {
        P2DAxisInterface ret = null;
        P2DContainerInterface[] arr = component.getP2D(P2DAxisInterface.class);
        if (arr != null) {
            int size = arr.length;
            for (int i = size - 1; i >= 0 && ret == null; --i) {
                P2DAxisInterface axis = (P2DAxisInterface)arr[i];
                if (axis.getType().getValue() != P2DAxisType.Y.getValue()) continue;
                ret = axis;
            }
        }
        return ret;
    }

    public P2DMarkerInterface getMarkerComponent(P2DComponentInterface component) {
        P2DMarkerInterface ret = null;
        P2DContainerInterface[] arr = component.getP2D(P2DMarkerInterface.class);
        if (arr != null && arr.length != 0) {
            ret = (P2DMarkerInterface)arr[0];
        }
        return ret;
    }

    public void setXChannelName(P2DComponentInterface component, String xName) {
        P2DAxisInterface xAxis;
        P2DChannelInterface channel = null;
        P2DContainerInterface[] arr = component.getP2D(P2DChannelInterface.class);
        if (arr != null && arr.length != 0) {
            int size = arr.length;
            for (int i = 0; i < size; ++i) {
                channel = (P2DChannelInterface)arr[i];
                channel.setXDataItemName(xName);
            }
        }
        if (channel != null && (xAxis = channel.getXAxis()) != null) {
            FwkColumnAccessInterface xColumn = channel.getXColumn();
            if (xColumn != null) {
                xAxis.setTitle(xColumn.getShortName() + "[" + xColumn.getUnitString() + "]");
            } else if (xName != null && xName.length() != 0) {
                xAxis.setTitle(xName);
            } else {
                xAxis.setTitle("Index");
            }
        }
    }

    public String getXChannelName(P2DComponentInterface component) {
        String ret = null;
        P2DChannelInterface channel = null;
        P2DContainerInterface[] arr = component.getP2D(P2DChannelInterface.class);
        if (arr != null && arr.length != 0) {
            int size = arr.length;
            for (int i = 0; i < size && ret == null; ++i) {
                channel = (P2DChannelInterface)arr[i];
                ret = channel.getXDataItemName();
            }
        }
        return ret;
    }

    public boolean boundsAcceptable(P2DComponentInterface component, Point2D lower, Point2D upper) {
        return true;
    }

    public void setBoundingBox(P2DComponentInterface component, P2DBoundingBoxInterface boundingBox) {
        super.setBoundingBox(component, boundingBox);
        this.calculateBounds(component);
    }

    public boolean getHorizontalTile(P2DComponentInterface component) {
        return this.horizontalTile;
    }

    public void setHorizontalTile(P2DComponentInterface component, boolean flag) {
        this.horizontalTile = flag;
    }

    public boolean getSingleScale(P2DComponentInterface component) {
        return this.singleScale;
    }

    public void setSingleScale(P2DComponentInterface component, boolean flag) {
        if (flag != this.singleScale) {
            P2DAxisInterface[] yAxes = this.getAllYAxisComponents(component);
            if (yAxes != null && yAxes.length > 0) {
                if (flag) {
                    if (yAxes != null || yAxes.length > 1) {
                        int i;
                        P2DMarkerInterface marker = this.getMarkerComponent(component);
                        if (marker != null) {
                            marker.setYAxisName(yAxes[0].getName());
                            marker.toBack();
                        }
                        P2DContainerInterface[] channels = component.getP2D(P2DChannelInterface.class);
                        int size = channels.length;
                        String axisTitle = "";
                        Color[] colArr = new Color[size];
                        for (i = 0; i < size; ++i) {
                            ((P2DChannelInterface)channels[i]).setYAxisName(yAxes[0].getName());
                            axisTitle = axisTitle + this.getChannelTitle((P2DChannelInterface)channels[i]) + "\n";
                            colArr[i] = ((P2DChannelInterface)channels[i]).getColor();
                        }
                        yAxes[0].setTitle(axisTitle);
                        yAxes[0].setTitleAttributor(new Attributor(colArr));
                        size = yAxes.length;
                        for (i = 1; i < size; ++i) {
                            component.removeP2D(yAxes[i]);
                        }
                        yAxes[0].setColor(P2D.colors[9 % P2D.colors.length]);
                        yAxes[0].setAutoRange(true);
                    }
                } else {
                    P2DContainerInterface[] channels = component.getP2D(P2DChannelInterface.class);
                    yAxes[0].setTitleAttributor(P2DAttributorSupport.getInstance());
                    yAxes[0].setTitle(this.getChannelTitle((P2DChannelInterface)channels[0]));
                    yAxes[0].setColor(((P2DChannelInterface)channels[0]).getColor());
                    ((P2DChannelInterface)channels[0]).setYAxisName(yAxes[0].getName());
                    int size = channels.length;
                    for (int i = 1; i < size; ++i) {
                        P2DAxis yAxis = new P2DAxis("Y-Axis " + channels[i].getName() + "@" + component.getInfoBusName());
                        yAxis.setType(P2DAxisType.Y);
                        yAxis.setGrid(false);
                        yAxis.setColor(((P2DChannelInterface)channels[i]).getColor());
                        yAxis.setAutoRange(true);
                        yAxis.setTitle(this.getChannelTitle((P2DChannelInterface)channels[i]));
                        component.addP2D(yAxis);
                        ((P2DChannelInterface)channels[i]).setYAxisName(yAxis.getName());
                    }
                }
                this.calculateBounds(component);
            }
            this.singleScale = flag;
        }
    }

    public boolean getVerticalTile(P2DComponentInterface component) {
        return this.verticalTile;
    }

    public void setVerticalTile(P2DComponentInterface component, boolean flag) {
        this.verticalTile = flag;
    }

    public void setLegendEnabled(P2DComponentInterface component, boolean flag) {
        if (this.legendEnabled != flag) {
            this.legendEnabled = flag;
            if (flag) {
                P2DLegendInterface legend = this.createLegendComponent(component);
                P2DTextInterface title = this.createTitleComponent(component);
                FwkSortedArray textArr = new FwkSortedArray();
                legend.removeAllChannels();
                P2DContainerInterface[] contArr = component.getP2D(P2DChannelInterface.class);
                if (contArr != null && contArr.length != 0) {
                    int size = contArr.length;
                    for (int i = 0; i < size; ++i) {
                        P2DChannelInterface channel = (P2DChannelInterface)contArr[i];
                        if (channel == null) continue;
                        legend.addChannel(channel);
                        FwkColumnAccessInterface column = channel.getYColumn();
                        if (column == null) continue;
                        textArr.add((Comparable)((Object)column.getShortName()));
                    }
                }
                if (!this.legendEnabled) {
                    title.setTextArray((FwkArrayInterface)textArr);
                }
                component.revalidate(true);
            } else {
                P2DLegendInterface legend = this.getLegendComponent(component);
                if (legend != null) {
                    component.removeP2D(legend);
                }
            }
        }
    }

    public boolean getLegendEnabled(P2DComponentInterface component) {
        return this.legendEnabled;
    }

    public void revalidate(P2DComponentInterface component, boolean recursive) {
        super.revalidate(component, recursive);
        this.calculateBounds(component);
    }

    public FwkCommandInterface[] getCommands(P2DComponentInterface component) {
        if (!this.commandsAvailable()) {
            super.getCommands(component);
            FwkCommandInterface parent = super.getCommand("Help");
            if (parent == null) {
                parent = new FwkCommand();
                parent.setCommandName("Help");
                parent.setTextKey("P2D.Text.Help");
                this.addCommand(0, parent);
            }
            FwkCommand cmd = new FwkCommand((FwkControllerInterface)component);
            cmd.setCommandName("PlotHelp");
            cmd.setTextKey("P2D.Text.PlotHelp");
            cmd.setIconKey("Icon.FwkHelpBroker");
            cmd.setHelpID("com.highqsoft.p2d.P2DPlot");
            parent.addCommand(0, (FwkCommandInterface)cmd);
            cmd = new FwkToggleCommand((FwkControllerInterface)component);
            cmd.setCommandName("HorizontalTile");
            cmd.setTextKey("P2D.Text.HorizontalTile");
            cmd.setToggleState(this.getHorizontalTile(component));
            this.addCommand((FwkCommandInterface)cmd);
            cmd = new FwkToggleCommand((FwkControllerInterface)component);
            cmd.setCommandName("SingleScale");
            cmd.setTextKey("P2D.Text.SingleScale");
            cmd.setToggleState(this.getSingleScale(component));
            this.addCommand((FwkCommandInterface)cmd);
            cmd = new FwkToggleCommand((FwkControllerInterface)component);
            cmd.setCommandName("LegendEnabled");
            cmd.setTextKey("P2D.Text.LegendEnabled");
            cmd.setToggleState(this.getLegendEnabled(component));
            this.addCommand((FwkCommandInterface)cmd);
        }
        return super.getCommands();
    }

    protected String getChannelTitle(P2DChannelInterface channel) {
        String name;
        FwkColumnAccessInterface col = channel.getYColumn();
        String unit = null;
        if (col != null) {
            unit = col.getUnitString();
        }
        if (unit == null) {
            unit = "";
        }
        if ((name = channel.getShortName()) == null || name.length() == 0) {
            name = channel.getName();
        }
        return name + " [" + unit + "]";
    }

    public class Attributor
    extends P2DAttributorSupport {
        Color[] colArr;

        public Attributor(Color[] arr) {
            this.colArr = arr;
            if (this.colArr == null) {
                this.colArr = new Color[0];
            }
        }

        public Attributor() {
            this.colArr = new Color[0];
        }

        public FwkArrayInterface format(P2DComponentInterface component, FwkArrayInterface arr, String s, FwkAppearanceInterface ap) {
            int i;
            if (arr == null) {
                arr = new FwkArray();
            }
            if (s == null) {
                s = "";
            }
            Hashtable<TextAttribute, Serializable> attrs = new Hashtable<TextAttribute, Serializable>();
            attrs.put(TextAttribute.FONT, ap.getFont());
            String[] sarr = s.split("\n");
            for (i = 0; i < sarr.length && i < this.colArr.length; ++i) {
                attrs.put(TextAttribute.FOREGROUND, this.colArr[i]);
                arr.add((Object)new AttributedString(sarr[i], attrs));
            }
            while (i < sarr.length) {
                attrs.put(TextAttribute.FOREGROUND, P2D.colors[(i + 9) % P2D.colors.length]);
                arr.add((Object)new AttributedString(sarr[i], attrs));
                ++i;
            }
            return arr;
        }
    }

    protected class ArrayCollection
    extends AbstractCollection {
        Object[] arr;

        public ArrayCollection(Object[] arr) {
            this.arr = arr;
        }

        public void setArray(Object[] arr) {
            this.arr = arr;
        }

        public int size() {
            if (this.arr != null) {
                return this.arr.length;
            }
            return 0;
        }

        public Iterator iterator() {
            return new Iterator(){
                int count = 0;

                public boolean hasNext() {
                    return this.count < ArrayCollection.this.size();
                }

                public Object next() {
                    if (this.hasNext()) {
                        return ArrayCollection.this.arr[this.count++];
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

