/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.Fwk;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;

public class P2DRange1D
extends Fwk
implements P2DRange1DInterface {
    public static final String version = "$Revision: 1.5 $";
    public double lower;
    public double minPositiveValue;
    public double upper;

    public String getVersion() {
        return version;
    }

    public P2DRange1D() {
        this(0.0, 0.0);
    }

    public P2DRange1D(P2DRange1DInterface range) {
        this(range.getLower(), range.getUpper(), range.getMinPositiveValue());
    }

    public P2DRange1D(P2DRange1DInterface range, double minPositiveValue) {
        this(range.getLower(), range.getUpper(), minPositiveValue);
    }

    public P2DRange1D(double lower, double upper) {
        this(lower, upper, Double.NaN);
    }

    public P2DRange1D(double lower, double upper, double minPositiveValue) {
        this.setDefaults();
        if (lower < upper) {
            this.lower = lower;
            this.upper = upper;
        } else {
            this.upper = lower;
            this.lower = upper;
        }
        this.minPositiveValue = minPositiveValue > 0.0 ? minPositiveValue : (lower > 0.0 ? lower : Double.NaN);
    }

    public boolean contains(double value) {
        return this.lower <= value && value <= this.upper;
    }

    public double getLower() {
        return this.lower;
    }

    public void setLower(double lower) {
        if (lower > this.upper) {
            this.lower = this.upper;
            this.upper = lower;
        } else {
            this.lower = lower;
        }
    }

    public double getMinPositiveValue() {
        return this.minPositiveValue;
    }

    public void setMinPositiveValue(double minPositiveValue) {
        this.minPositiveValue = minPositiveValue > 0.0 ? minPositiveValue : Double.NaN;
    }

    public double getUpper() {
        return this.upper;
    }

    public void setUpper(double upper) {
        if (upper < this.lower) {
            this.upper = this.lower;
            this.lower = upper;
        } else {
            this.upper = upper;
        }
    }

    public void setRange(double lower, double upper) {
        if (lower > upper) {
            double tmp = lower;
            lower = upper;
            upper = tmp;
        }
        this.lower = lower;
        this.upper = upper;
    }

    public double getDistance() {
        return this.upper - this.lower;
    }

    public void setDistance(double distance) {
        this.setUpper(this.lower + distance);
    }

    public void move(double distance) {
        this.lower += distance;
        this.upper += distance;
    }

    public boolean equals(P2DRange1DInterface r) {
        return this.lower - r.getLower() < 1.0E-20 && this.upper - r.getUpper() < 1.0E-20;
    }

    public String getParams() {
        return "Lower=" + this.lower + " Upper=" + this.upper + " MinPositiveValue=" + this.minPositiveValue;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getParams() + "]";
    }

    public void setDefaults() {
        this.lower = 0.0;
        this.upper = 0.0;
        this.minPositiveValue = Double.NaN;
    }

    public double[] getNiceNumbers(double base, boolean isLog, int ticks_requested) {
        return this.getNiceNumbers(this.lower, this.upper, base, isLog, ticks_requested);
    }

    public double[] getNiceNumbers(double min, double max, double base, boolean isLog, int ticks_requested) {
        double[] ret = P2DRange1D.getNiceNumbersImpl(min, max, base, isLog, this.minPositiveValue, ticks_requested);
        return ret;
    }

    public static double[] getNiceNumbersImpl(double min, double max, double base, boolean isLog, double minPositive, int ticks_requested) {
        double tics;
        double delta;
        if (Double.isInfinite(min)) {
            min = min == Double.NEGATIVE_INFINITY ? -3.4028234663852886E38 : 3.4028234663852886E38;
        }
        if (Double.isInfinite(max)) {
            max = max == Double.NEGATIVE_INFINITY ? -3.4028234663852886E38 : 3.4028234663852886E38;
        }
        double[] niceNumbers = null;
        boolean overScale = false;
        if (Math.abs(min - max) < Double.MIN_VALUE) {
            if (Math.abs((min *= 0.95) - (max *= 1.05)) < Double.MIN_VALUE) {
                min = -0.1;
                max = 0.1;
            }
            overScale = true;
        }
        if (max < min) {
            double tmp = max;
            max = min;
            min = tmp;
        }
        if (min == -1.7976931348623157E308 || min == Double.MAX_VALUE || max == Double.MAX_VALUE || max == -1.7976931348623157E308) {
            niceNumbers = new double[]{min, max};
            return niceNumbers;
        }
        if (base <= 1.0) {
            base = 10.0;
        }
        double logBase = Math.log(base);
        if (isLog) {
            if (min > 0.0) {
                min = Math.log(min) / logBase;
                max = Math.log(max) / logBase;
            } else if (max > 0.0) {
                max = Math.log(max) / logBase;
                min = Double.isNaN(minPositive) ? 1.0 : minPositive;
            } else {
                max = 10.0;
                min = 1.0;
            }
        } else if (max - min > 100000.0) {
            double val = max - min;
            double exponent10 = Math.floor(Math.log(val) / Math.log(10.0));
            exponent10 = Math.pow(10.0, exponent10 - 2.0);
            double[] ret = P2DRange1D.getNiceNumbersImpl(Math.round(min / exponent10), Math.round(max / exponent10), base, false, minPositive, ticks_requested);
            int size = ret.length;
            for (int i = 0; i < size; ++i) {
                ret[i] = ret[i] * exponent10;
            }
            return ret;
        }
        double range = Math.abs(max - min);
        double l10 = Math.log(range) / logBase;
        int decade = (int)Math.floor(l10);
        double subdecade = Math.exp((l10 - (double)decade) * logBase);
        subdecade = Math.floor(subdecade * base) / base;
        long decade10 = decade < 0 ? Math.round(Math.exp(-1.0 * (double)decade * logBase)) : Math.round(Math.exp((double)decade * logBase));
        if (ticks_requested > 0) {
            delta = range / (double)ticks_requested;
            tics = decade < 0 ? delta * (double)decade10 : delta / (double)decade10;
            tics = (double)Math.round(tics * 10.0) / 10.0;
        } else {
            tics = subdecade > 5.0 ? 1.0 : (subdecade > 2.0 ? 0.5 : (subdecade > 1.0 ? 0.2 : (subdecade > 0.5 ? 0.1 : (subdecade > 0.2 ? 0.05 : Math.ceil(subdecade)))));
        }
        delta = decade < 0 ? tics / (double)decade10 : tics * (double)decade10;
        int nticks = range == delta * Math.ceil(range / delta) ? (int)Math.ceil(range / delta) : (int)Math.ceil(range / delta);
        double first = Math.floor(min / delta) * delta;
        double upper = (double)Math.round(10000.0 * (first + (double)nticks * delta) * (double)decade10) / ((double)decade10 * 10000.0);
        if (isLog) {
            while (max > upper) {
                upper = (double)Math.round((first + (double)(++nticks) * delta) * (double)decade10 * 10000.0) / ((double)decade10 * 10000.0);
            }
        } else {
            while (max > upper) {
                upper = (double)Math.round((first + (double)(++nticks) * delta) * (double)decade10 * 10000.0) / ((double)decade10 * 10000.0);
            }
        }
        if (nticks > 1) {
            if (isLog) {
                first = first < 0.0 ? -Math.ceil(-first) : Math.ceil(first);
                nticks = (int)Math.round(upper - first) + 1;
                niceNumbers = new double[nticks];
                niceNumbers[0] = first;
                for (int i = 1; i < nticks; ++i) {
                    niceNumbers[i] = niceNumbers[i - 1] + 1.0;
                }
            } else {
                try {
                    niceNumbers = new double[nticks + 1];
                    for (int i = 0; i <= nticks; ++i) {
                        niceNumbers[i] = (double)Math.round((first + (double)i * delta) * (double)decade10 * 10000.0) / ((double)decade10 * 10000.0);
                    }
                }
                catch (Throwable t) {
                    niceNumbers = null;
                }
            }
        }
        if (!isLog && !overScale) {
            if (niceNumbers != null) {
                double[] tmp;
                int size;
                double minDiff = (niceNumbers[1] - niceNumbers[0]) * 0.3;
                double sMin = min - minDiff;
                double sMax = max + minDiff;
                if (niceNumbers[0] < sMin || niceNumbers[niceNumbers.length - 1] > sMax) {
                    size = niceNumbers.length;
                    if (niceNumbers[0] < sMin && niceNumbers[size - 1] > sMax) {
                        tmp = new double[size - 2];
                        System.arraycopy(niceNumbers, 1, tmp, 0, size - 2);
                    } else if (niceNumbers[0] < sMin) {
                        tmp = new double[size - 1];
                        System.arraycopy(niceNumbers, 1, tmp, 0, size - 1);
                    } else {
                        tmp = new double[size - 1];
                        System.arraycopy(niceNumbers, 0, tmp, 0, size - 1);
                    }
                    niceNumbers = tmp;
                }
                size = niceNumbers.length;
                if (niceNumbers[0] > min && niceNumbers[0] - min < minDiff) {
                    niceNumbers[0] = min;
                }
                if (niceNumbers[size - 1] < max && max - niceNumbers[size - 1] < minDiff) {
                    niceNumbers[size - 1] = max;
                }
                if (niceNumbers[0] > min || niceNumbers[niceNumbers.length - 1] < max) {
                    if (niceNumbers[0] > min && niceNumbers[size - 1] < max) {
                        tmp = new double[size + 2];
                        System.arraycopy(niceNumbers, 0, tmp, 1, size);
                        tmp[0] = min;
                        tmp[size + 1] = max;
                    } else if (niceNumbers[0] > min) {
                        tmp = new double[size + 1];
                        System.arraycopy(niceNumbers, 0, tmp, 1, size);
                        tmp[0] = min;
                    } else {
                        tmp = new double[size + 1];
                        System.arraycopy(niceNumbers, 0, tmp, 0, size);
                        tmp[size] = max;
                    }
                    niceNumbers = tmp;
                }
            } else {
                niceNumbers = new double[]{min, max};
            }
        }
        return niceNumbers;
    }

    public static void main(String[] args) {
        double val = 9.2265234E14;
        double exponent10 = Math.log(val) / Math.log(10.0);
        double log10 = (double)Math.round(10000.0 * val / Math.exp(Math.ceil(exponent10) * Math.log(10.0))) / 10000.0;
        System.out.println(exponent10 + " " + log10);
        P2DRange1D range = new P2DRange1D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        double[] niceNumbers = range.getNiceNumbers(10.0, false, 5);
        if (niceNumbers != null) {
            for (int i = 0; i < niceNumbers.length; ++i) {
                System.out.println(niceNumbers[i]);
            }
        }
        System.exit(0);
    }
}

