/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;
import com.highqsoft.interfaces.p2d.P2DRangeInterface;
import com.highqsoft.p2d.P2DComponent;
import com.highqsoft.p2d.P2DRangeDialogPane;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JComponent;

public class P2DRangeCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.2 $";

    public String getVersion() {
        return version;
    }

    public P2DRangeCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("P2D.Text.Range");
        this.setCommandName("Range");
        this.setIconKey("Icon.Range");
    }

    public boolean execute(EventObject ev) {
        P2DRangeInterface controller = null;
        try {
            controller = (P2DRangeInterface)this.getController();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        JComponent parent = null;
        try {
            parent = (JComponent)ev.getSource();
            parent = (JComponent)parent.getTopLevelAncestor();
        }
        catch (Throwable pt) {
            // empty catch block
        }
        this.createDialog(parent, controller);
        return true;
    }

    protected void createDialog(Component parent, P2DRangeInterface p2dRange) {
        if (p2dRange != null) {
            this.showOptionDialog(parent, p2dRange, FwkPropertyBus.getProperty((String)"P2D.Text.GUI.RangeTitle"));
        }
    }

    protected void showOptionDialog(Component parentComponent, P2DRangeInterface p2dRange, String title) {
        P2DRange1DInterface range;
        P2DRangeDialogPane pane;
        FwkDialogPaneValueInterface val;
        FwkDescriptionInterface description = null;
        String name = "";
        if (p2dRange instanceof FwkDescriptionInterface) {
            description = (FwkDescriptionInterface)p2dRange;
            name = description.getName();
        }
        if ((val = FwkDialogFactory.showDialog(null, (String)title, (String)"", (FwkDialogPaneInterface)(pane = new P2DRangeDialogPane(name, p2dRange.getRange())))) != null && (range = (P2DRange1DInterface)val.getProperty("Range")) != null) {
            p2dRange.setRange(range);
            if (p2dRange instanceof P2DComponent) {
                ((P2DComponent)((Object)p2dRange)).repaint();
            }
        }
    }
}

