/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkKeyListenerInterface;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DRange1D;
import com.highqsoft.p2d.P2DRangeDialogPaneValue;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class P2DRangeDialogPane
extends FwkDialogPane {
    public static final String version = "$Revision: 1.3 $";
    JTextField lowerText;
    JTextField upperText;
    P2DRange1DInterface initialRange;

    public String getVersion() {
        return version;
    }

    public P2DRangeDialogPane() {
        this(null, null);
    }

    public P2DRangeDialogPane(String title, double lower, double upper) {
        this(title, new P2DRange1D(lower, upper));
    }

    public P2DRangeDialogPane(String title, P2DRange1DInterface range) {
        this.createPane(title, range);
    }

    protected void createPane(String t, P2DRange1DInterface range) {
        if (t != null && t.length() != 0) {
            this.setTitle(t);
        }
        this.setIdent(null);
        KeyboardListener keyListener = new KeyboardListener();
        this.setLayout(new FlowLayout());
        JLabel lab = new JLabel(FwkPropertyBus.getProperty((String)"P2D.Text.From") + ":");
        this.add(lab);
        this.lowerText = new JTextField(15);
        this.lowerText.addKeyListener(keyListener);
        JScrollPane scroll = new JScrollPane(this.lowerText);
        this.add(scroll);
        lab = new JLabel(FwkPropertyBus.getProperty((String)"P2D.Text.To") + ":");
        this.add(lab);
        this.upperText = new JTextField(15);
        this.upperText.addKeyListener(keyListener);
        scroll = new JScrollPane(this.upperText);
        this.add(scroll);
        this.setInitialRange(range);
    }

    public void setInitialRange(P2DRange1DInterface range) {
        this.initialRange = range == null ? new P2DRange1D() : new P2DRange1D(range);
        this.lowerText.setText("" + range.getLower());
        this.upperText.setText("" + range.getUpper());
    }

    public void setInitialRange(double lower, double upper) {
        this.setInitialRange(new P2DRange1D(lower, upper));
    }

    public P2DRange1DInterface getInitialRange() {
        return this.initialRange;
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        double upper;
        double lower;
        try {
            lower = new Double(this.lowerText.getText());
        }
        catch (Throwable tLower) {
            JOptionPane.showMessageDialog((Component)((Object)this), tLower.getMessage(), FwkPropertyBus.getProperty((String)"P2DRangeDialogPanel.Text.FormatError"), 2);
            throw new FwkException(-1073676289, "$RCSfile: P2DRangeDialogPane.java,v $", version, "AH 2000-04-28 09:26", "wrong range format of the lower value: " + tLower.getMessage(), (Object)this, tLower);
        }
        try {
            upper = new Double(this.upperText.getText());
        }
        catch (Throwable tUpper) {
            JOptionPane.showMessageDialog((Component)((Object)this), tUpper.getMessage(), FwkPropertyBus.getProperty((String)"P2DRangeDialogPanel.Text.FormatError"), 2);
            throw new FwkException(-1073676289, "$RCSfile: P2DRangeDialogPane.java,v $", version, "AH 2000-04-28 09:28", "wrong range format of the upper value: " + tUpper.getMessage(), (Object)this, tUpper);
        }
        return new P2DRangeDialogPaneValue(this.getIdent(), new P2DRange1D(lower, upper));
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        try {
            P2DRange1DInterface range = (P2DRange1DInterface)value.getProperty("Range");
            if (range != null) {
                this.lowerText.setText("" + range.getLower());
                this.upperText.setText("" + range.getUpper());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addKeyListener(FwkKeyListenerInterface listener) {
        this.lowerText.addKeyListener((KeyListener)listener);
        this.upperText.addKeyListener((KeyListener)listener);
    }

    public static void main(String[] args) {
        FwkContainer.initialize((String[])args);
        FwkContainer.addComponentProperties((Class)P2D.class);
        P2DRangeDialogPane pane = new P2DRangeDialogPane("junk", 10.0, 20.0);
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, (String)"P2DRangeDialogDialogPane - Test", (String)"", (FwkDialogPaneInterface)pane);
        if (val != null) {
            Iterator iterator = val.getProperties();
            System.out.println("FwkDialogPaneValueSupport Properties:");
            while (iterator.hasNext()) {
                Object key = iterator.next();
                System.out.println("Key: " + key + " / value:" + val.getProperty(key.toString()));
            }
        } else {
            System.out.println("No value returned from P2DRangeDialogPane.");
        }
    }

    public class KeyboardListener
    extends KeyAdapter
    implements FwkKeyListenerInterface {
        public void keyPressed(KeyEvent e) {
            if (e.isAltGraphDown() || e.isControlDown() || e.isMetaDown()) {
                e.consume();
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.isAltGraphDown() || e.isControlDown() || e.isMetaDown()) {
                e.consume();
            }
        }
    }
}

