/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.HashMap;
import java.util.Iterator;

public class P2DShapeStroke
implements Stroke {
    public static final int DIAMETER = 6;
    protected static final HashMap symbols = new HashMap();
    public static final String CIRCLE = "CIRCLE";
    public static final String FILLED_CIRCLE = "FILLED CIRCLE";
    public static final String RHOMBUS = "RHOMBUS";
    public static final String FILLED_RHOMBUS = "FILLED RHOMBUS";
    public static final String QUADRAT = "QUADRAT";
    public static final String FILLED_QUADRAT = "FILLED QUADRAT";
    public static final String CROSS = "CROSS";
    public static final String VLINE = "VLINE";
    public static final String HLINE = "HLINE";
    public static final String DOT = "DOT";
    protected SymbolEntry[] patternArray = new SymbolEntry[1];
    protected BasicStroke basicStroke;

    public P2DShapeStroke() {
        this(QUADRAT);
    }

    public P2DShapeStroke(String patternName) {
        this.patternArray[0] = (SymbolEntry)symbols.get(patternName);
        this.basicStroke = !patternName.startsWith("FILLED") ? (patternName.equals(DOT) ? new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{0.0f, 9.0f, 1.0f, 9.0f}, 0.0f) : new BasicStroke(2.0f)) : null;
    }

    public P2DShapeStroke(Shape pattern, boolean filled) {
        this.patternArray[0] = new SymbolEntry(pattern, filled);
        this.basicStroke = null;
    }

    public static Stroke[] getAllStrokes() {
        Iterator it = symbols.keySet().iterator();
        Stroke[] ret = new Stroke[symbols.size() + 1];
        int count = 0;
        while (it.hasNext()) {
            ret[count++] = new P2DShapeStroke((String)it.next());
        }
        ret[count] = null;
        return ret;
    }

    public Shape createStrokedShape(Shape shape) {
        GeneralPath ret = new GeneralPath();
        AffineTransform at = new AffineTransform();
        PathIterator pi = shape.getPathIterator(null);
        boolean moveBeforeDraw = false;
        float[] seg = new float[6];
        int segType = 0;
        int patternCounter = 0;
        int patternLength = this.patternArray.length;
        float moveX = 0.0f;
        float moveY = 0.0f;
        int origin = 3;
        while (!pi.isDone()) {
            segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    moveX = seg[0];
                    moveY = seg[1];
                    moveBeforeDraw = true;
                    break;
                }
                case 1: {
                    if (moveBeforeDraw) {
                        at.setToTranslation(moveX - (float)origin, moveY - (float)origin);
                        ret.append(at.createTransformedShape(this.patternArray[patternCounter++].shape), false);
                        patternCounter %= patternLength;
                        moveBeforeDraw = false;
                    }
                    at.setToTranslation(seg[0] - (float)origin, seg[1] - (float)origin);
                    ret.append(at.createTransformedShape(this.patternArray[patternCounter++].shape), false);
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
            patternCounter %= patternLength;
            pi.next();
        }
        if (this.basicStroke != null) {
            return this.basicStroke.createStrokedShape(ret);
        }
        return ret;
    }

    static {
        symbols.put(CIRCLE, new SymbolEntry(new Ellipse2D.Float(0.0f, 0.0f, 6.0f, 6.0f), false));
        symbols.put(FILLED_CIRCLE, new SymbolEntry(new Ellipse2D.Float(0.0f, 0.0f, 6.0f, 6.0f), false));
        GeneralPath gp = new GeneralPath();
        gp.moveTo(3.0f, 3.0f);
        gp.lineTo(4.0f, 4.0f);
        gp.closePath();
        symbols.put(DOT, new SymbolEntry(gp, false));
        gp = new GeneralPath();
        gp.moveTo(3.0f, 0.0f);
        gp.lineTo(6.0f, 3.0f);
        gp.lineTo(3.0f, 6.0f);
        gp.lineTo(0.0f, 3.0f);
        gp.closePath();
        symbols.put(RHOMBUS, new SymbolEntry(gp, false));
        symbols.put(FILLED_RHOMBUS, new SymbolEntry(gp, true));
        gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(6.0f, 6.0f);
        gp.moveTo(0.0f, 6.0f);
        gp.closePath();
        symbols.put(CROSS, new SymbolEntry(gp, false));
        gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(6.0f, 0.0f);
        gp.lineTo(6.0f, 6.0f);
        gp.lineTo(0.0f, 6.0f);
        gp.closePath();
        symbols.put(QUADRAT, new SymbolEntry(gp, false));
        symbols.put(FILLED_QUADRAT, new SymbolEntry(gp, true));
        gp = new GeneralPath();
        gp.moveTo(3.0f, 0.0f);
        gp.lineTo(3.0f, 6.0f);
        gp.closePath();
        symbols.put(VLINE, new SymbolEntry(gp, false));
        gp = new GeneralPath();
        gp.moveTo(0.0f, 3.0f);
        gp.lineTo(6.0f, 3.0f);
        gp.closePath();
        symbols.put(HLINE, new SymbolEntry(gp, false));
        gp = new GeneralPath();
        gp.moveTo(0.0f, 3.0f);
        gp.lineTo(6.0f, 3.0f);
        gp.closePath();
        symbols.put(DOT, new SymbolEntry(gp, false));
    }

    public static class SymbolEntry {
        public Shape shape;
        public boolean filled;

        public SymbolEntry(Shape shape, boolean filled) {
            this.shape = shape;
            this.filled = filled;
        }
    }
}

