/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkTileSelectMenuItem;
import com.highqsoft.interfaces.fwk.FwkTileInterface;
import com.highqsoft.p2d.P2DShapeStroke;
import com.highqsoft.p2d.P2DShapeStrokeSelectButton;
import com.highqsoft.p2d.P2DStrokeSelectableInterface;
import java.awt.Dimension;
import java.awt.Stroke;

public class P2DShapeStrokeSelectMenuItem
extends FwkTileSelectMenuItem
implements P2DStrokeSelectableInterface {
    public static final String version = "$Revision: 1.3 $";
    protected Stroke[] strokes;

    public String getVersion() {
        return version;
    }

    public P2DShapeStrokeSelectMenuItem() {
        this(P2DShapeStroke.getAllStrokes());
    }

    public P2DShapeStrokeSelectMenuItem(int rowCount) {
        this(P2DShapeStroke.getAllStrokes(), new Dimension(15, 15), rowCount);
    }

    public P2DShapeStrokeSelectMenuItem(Dimension tileSize, int rowCount) {
        this(P2DShapeStroke.getAllStrokes(), tileSize, rowCount);
    }

    public P2DShapeStrokeSelectMenuItem(Stroke[] strokes) {
        this(strokes, (int)Math.round(Math.sqrt(strokes.length)));
    }

    public P2DShapeStrokeSelectMenuItem(Stroke[] strokes, int rowCount) {
        this(strokes, new Dimension(15, 15), rowCount);
    }

    public P2DShapeStrokeSelectMenuItem(Stroke[] strokes, Dimension tileSize, int rowCount) {
        super(P2DShapeStrokeSelectMenuItem.createTiles(strokes, tileSize), rowCount < 1 ? 1 : rowCount);
        this.strokes = strokes;
    }

    public Stroke getSelectedStroke() {
        int index = this.getSelectedTileIndex();
        if (index >= 0 && index < this.strokes.length) {
            return this.strokes[index];
        }
        return null;
    }

    protected static FwkTileInterface[] createTiles(Stroke[] strokes, Dimension tileSize) {
        FwkTileInterface[] tiles = new FwkTileInterface[strokes.length];
        int size = strokes.length;
        for (int i = 0; i < size; ++i) {
            tiles[i] = new P2DShapeStrokeSelectButton.P2DStrokeTile(strokes[i], tileSize);
        }
        return tiles;
    }
}

