/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkTileSelectButton;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkTileInterface;
import com.highqsoft.p2d.P2DStrokeSelectableInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class P2DStrokeWidthSelectButton
extends FwkTileSelectButton
implements P2DStrokeSelectableInterface {
    public static final String version = "$Revision: 1.3 $";
    public static final int STROKE_LENGTH = 6;
    public static final BasicStroke[] STROKES = new BasicStroke[6];
    protected Stroke[] strokes;

    public String getVersion() {
        return version;
    }

    public P2DStrokeWidthSelectButton() {
        this(STROKES, new Dimension(60, 15), STROKES.length);
    }

    public P2DStrokeWidthSelectButton(int rowCount) {
        this(STROKES, new Dimension(15, 15), rowCount);
    }

    public P2DStrokeWidthSelectButton(Dimension tileSize, int rowCount) {
        this(STROKES, tileSize, rowCount);
    }

    public P2DStrokeWidthSelectButton(BasicStroke[] strokes) {
        this(strokes, (int)Math.round(Math.sqrt(strokes.length)));
    }

    public P2DStrokeWidthSelectButton(BasicStroke[] strokes, int rowCount) {
        this(strokes, new Dimension(15, 15), rowCount);
    }

    public P2DStrokeWidthSelectButton(BasicStroke[] strokes, Dimension tileSize, int rowCount) {
        super(P2DStrokeWidthSelectButton.createTiles(strokes, tileSize), rowCount < 1 ? 1 : rowCount);
        this.strokes = strokes;
    }

    public Stroke getSelectedStroke() {
        int index = this.getSelectedTileIndex();
        if (index >= 0 && index < this.strokes.length) {
            return this.strokes[index];
        }
        return null;
    }

    protected static FwkTileInterface[] createTiles(BasicStroke[] strokes, Dimension tileSize) {
        FwkTileInterface[] tiles = new FwkTileInterface[strokes.length];
        int size = strokes.length;
        for (int i = 0; i < size; ++i) {
            tiles[i] = new P2DStrokeTile(strokes[i], tileSize);
        }
        return tiles;
    }

    static {
        for (int i = 1; i <= 6; ++i) {
            P2DStrokeWidthSelectButton.STROKES[i - 1] = new BasicStroke(i, FwkAppearanceInterface.LINE_STROKE.getEndCap(), FwkAppearanceInterface.LINE_STROKE.getLineJoin(), FwkAppearanceInterface.LINE_STROKE.getMiterLimit(), FwkAppearanceInterface.LINE_STROKE.getDashArray(), FwkAppearanceInterface.LINE_STROKE.getDashPhase());
        }
    }

    public static class P2DStrokeTile
    implements FwkTileInterface {
        BufferedImage image;
        Dimension size;
        Stroke stroke;

        public P2DStrokeTile(BasicStroke stroke, Dimension size) {
            this.stroke = stroke;
            this.size = size;
            this.image = null;
        }

        public Dimension getTileSize() {
            return new Dimension(this.size);
        }

        public Object getValueAsObject() {
            return this.stroke;
        }

        public Image getImage() {
            if (this.image == null) {
                GeneralPath path = new GeneralPath();
                this.image = new BufferedImage(this.size.width, this.size.height, 2);
                Graphics2D g = this.image.createGraphics();
                g.setColor(tileBackground);
                g.fillRect(0, 0, this.size.width, this.size.height);
                g.setColor(Color.darkGray);
                path.moveTo(0.0f, (float)this.size.height / 2.0f);
                path.lineTo(this.size.width, (float)this.size.height / 2.0f);
                g.setStroke(this.stroke);
                g.draw(path);
                g.dispose();
            }
            return this.image;
        }
    }
}

