/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkTileSelectMenuItem;
import com.highqsoft.interfaces.fwk.FwkTileInterface;
import com.highqsoft.p2d.P2DStrokeSelectableInterface;
import com.highqsoft.p2d.P2DStrokeWidthSelectButton;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Stroke;

public class P2DStrokeWidthSelectMenuItem
extends FwkTileSelectMenuItem
implements P2DStrokeSelectableInterface {
    public static final String version = "$Revision: 1.3 $";
    protected Stroke[] strokes;

    public String getVersion() {
        return version;
    }

    public P2DStrokeWidthSelectMenuItem() {
        this(P2DStrokeWidthSelectButton.STROKES, new Dimension(60, 15), P2DStrokeWidthSelectButton.STROKES.length);
    }

    public P2DStrokeWidthSelectMenuItem(int rowCount) {
        this(P2DStrokeWidthSelectButton.STROKES, new Dimension(15, 15), rowCount);
    }

    public P2DStrokeWidthSelectMenuItem(Dimension tileSize, int rowCount) {
        this(P2DStrokeWidthSelectButton.STROKES, tileSize, rowCount);
    }

    public P2DStrokeWidthSelectMenuItem(BasicStroke[] strokes) {
        this(strokes, (int)Math.round(Math.sqrt(strokes.length)));
    }

    public P2DStrokeWidthSelectMenuItem(BasicStroke[] strokes, int rowCount) {
        this(strokes, new Dimension(15, 15), rowCount);
    }

    public P2DStrokeWidthSelectMenuItem(BasicStroke[] strokes, Dimension tileSize, int rowCount) {
        super(P2DStrokeWidthSelectMenuItem.createTiles(strokes, tileSize), rowCount < 1 ? 1 : rowCount);
        this.strokes = strokes;
    }

    public Stroke getSelectedStroke() {
        int index = this.getSelectedTileIndex();
        if (index >= 0 && index < this.strokes.length) {
            return this.strokes[index];
        }
        return null;
    }

    protected static FwkTileInterface[] createTiles(BasicStroke[] strokes, Dimension tileSize) {
        FwkTileInterface[] tiles = new FwkTileInterface[strokes.length];
        int size = strokes.length;
        for (int i = 0; i < size; ++i) {
            tiles[i] = new P2DStrokeWidthSelectButton.P2DStrokeTile(strokes[i], tileSize);
        }
        return tiles;
    }
}

