/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkChangeRegistry;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.p2d.P2DAttributorInterface;
import com.highqsoft.interfaces.p2d.P2DTextInterface;
import com.highqsoft.interfaces.p2d.P2DTextModelInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DComponent;

public class P2DText
extends P2DComponent
implements P2DTextInterface {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)P2DText.class, (FwkDescriptionInterface)descriptor);
    }

    public P2DText() {
        this("");
    }

    public P2DText(String name) {
        this.setDescriptor(descriptor);
        this.setProperty("ModelClassId", "P2DTextModelId");
        this.setProperty("ViewClassId", "P2DTextViewId");
        this.setProperty("ControlClassId", "P2DTextControlId");
        try {
            this.updateModel();
            this.updateView();
            this.updateControl();
            if (name == null || name.length() == 0) {
                name = P2DText.getDescriptor().getName() + "[" + this.hashCode() + "]@" + P2D.BUSNAME;
            }
            this.setMemberName(name);
            this.register(FwkContainer.getDataFlavors(this.getClass()));
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DText.java,v $", this.getVersion(), "AH 1999-21-06 16:22", "Cannot set the P2DText defaults.", (Object)this, t);
        }
    }

    public String getTitle() {
        return super.getTitle() + " " + this.getShortName();
    }

    public void setText(String text) {
        String old = ((P2DTextModelInterface)this.model).getText(this);
        ((P2DTextModelInterface)this.model).setText(this, text);
        this.firePropertyChange("Text", old, text);
        FwkChangeRegistry.register((Object)this, (String)"Text");
        this.repaint();
    }

    public void setTextArray(FwkArrayInterface text) {
        FwkArrayInterface old = ((P2DTextModelInterface)this.model).getTextArray(this);
        ((P2DTextModelInterface)this.model).setTextArray(this, text);
        this.firePropertyChange("TextArray", old, text);
        FwkChangeRegistry.register((Object)this, (String)"Text");
        this.repaint();
    }

    public String getText() {
        return ((P2DTextModelInterface)this.model).getText(this);
    }

    public FwkArrayInterface getTextArray() {
        return ((P2DTextModelInterface)this.model).getTextArray(this);
    }

    public int getSize() {
        return ((P2DTextModelInterface)this.model).getSize(this);
    }

    public String getLine(int index) {
        return ((P2DTextModelInterface)this.model).getLine(this, index);
    }

    public FwkArrayInterface getAttributedText() {
        return ((P2DTextModelInterface)this.model).getAttributedText(this);
    }

    public void setAlignment(float ali) {
        float old = ((P2DTextModelInterface)this.model).getAlignment(this);
        ((P2DTextModelInterface)this.model).setAlignment(this, ali);
        this.firePropertyChange("Alignment", old, ali);
        FwkChangeRegistry.register((Object)this, (String)"Alignment");
    }

    public float getAlignment() {
        return ((P2DTextModelInterface)this.model).getAlignment(this);
    }

    public void setAttributor(P2DAttributorInterface attributor) {
        P2DAttributorInterface old = ((P2DTextModelInterface)this.model).getAttributor(this);
        ((P2DTextModelInterface)this.model).setAttributor(this, attributor);
        this.firePropertyChange("Attributor", old, attributor);
        FwkChangeRegistry.register((Object)this, (String)"Attributor");
    }

    public P2DAttributorInterface getAttributor() {
        return ((P2DTextModelInterface)this.model).getAttributor(this);
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The text component of the p2d package");
        descriptor.setTitleName("P2DText.Text.Title");
        descriptor.setName(P2DText.class.getName());
        descriptor.setIconKey("Icon.P2DText");
        descriptor.setCreationDate("$Date: 2005/02/03 14:51:12 $", null);
    }
}

