/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.command.FwkFontCommand;
import com.highqsoft.fwk.command.FwkTextEditorCommand;
import com.highqsoft.fwk.dialog.FwkTextDialogPane;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.p2d.P2DAttributorInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DTextInterface;
import com.highqsoft.interfaces.p2d.P2DTextModelInterface;
import com.highqsoft.p2d.P2DAttributorSupport;
import com.highqsoft.p2d.P2DComponentModel;
import com.highqsoft.p2d.P2DText;
import java.util.HashMap;

public class P2DTextModel
extends P2DComponentModel
implements P2DTextModelInterface {
    public static final String version = "$Revision: 1.4 $";
    public static final String TEXT_TEXT_KEY = "P2DText.Text.Text";
    public static final String TEXT_TOOLTIP_KEY = "P2DText.Tooltip.Text";
    public static final String TEXT_AREA_IDENT = "TextArea";
    public static final int WIDTH = 40;
    public static final int HEIGHT = 5;
    protected FwkArrayInterface text;
    protected float alignment = 0.0f;
    protected P2DAttributorInterface attributor;

    public void initialize() {
        super.initialize();
        this.text = new FwkArray();
        this.attributor = P2DAttributorSupport.getInstance();
        this.ratioFix = true;
    }

    public void release() {
        if (this.attributor != null) {
            this.attributor.release();
            this.attributor = null;
        }
        if (this.text != null) {
            this.text.clear();
            this.text = null;
        }
        super.release();
    }

    public void setText(P2DTextInterface component, String t) {
        if (t == null) {
            t = "";
        }
        FwkArray arr = new FwkArray();
        int fromIndex = 0;
        int toIndex = 0;
        while ((toIndex = t.indexOf(10, fromIndex)) != -1) {
            arr.add((Object)t.substring(fromIndex, toIndex));
            fromIndex = toIndex + 1;
        }
        arr.add((Object)t.substring(fromIndex));
        this.setTextArray(component, (FwkArrayInterface)arr);
    }

    public void setTextArray(P2DTextInterface component, FwkArrayInterface arr) {
        if (arr == null) {
            arr = new FwkArray();
            arr.add((Object)"");
        }
        this.text = new FwkArray();
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            this.text.add(arr.get(i));
        }
    }

    public String getText(P2DTextInterface component) {
        String ret = null;
        if (this.text != null) {
            StringBuffer buf = new StringBuffer();
            int size = this.text.size();
            if (size > 0) {
                buf.append(this.text.get(0));
            }
            for (int i = 1; i < size; ++i) {
                buf.append("\n" + this.text.get(i));
            }
            ret = buf.toString();
        }
        return ret;
    }

    public int getSize(P2DTextInterface component) {
        if (this.text != null) {
            return this.text.size();
        }
        return 0;
    }

    public String getLine(P2DTextInterface component, int index) {
        if (this.text != null) {
            if (index >= 0 && index < this.text.size()) {
                return (String)this.text.get(index);
            }
            return "";
        }
        return "";
    }

    public FwkArrayInterface getTextArray(P2DTextInterface component) {
        return this.text;
    }

    public FwkArrayInterface getAttributedText(P2DTextInterface component) {
        FwkArray ret = new FwkArray();
        if (this.text != null && this.attributor != null) {
            FwkAppearanceInterface ap = component.getAppearance();
            int size = this.text.size();
            for (int i = 0; i < size; ++i) {
                if (((String)this.text.get(i)).length() == 0) {
                    this.attributor.format((P2DComponentInterface)component, (FwkArrayInterface)ret, " ", ap);
                    continue;
                }
                this.attributor.format((P2DComponentInterface)component, (FwkArrayInterface)ret, this.text.get(i), ap);
            }
        }
        return ret;
    }

    public void setAlignment(P2DTextInterface component, float ali) {
        this.alignment = ali;
    }

    public float getAlignment(P2DTextInterface component) {
        return this.alignment;
    }

    protected HashMap createDialogPanes(P2DComponentInterface component) {
        FwkTextDialogPane pane;
        if (staticPanes == null) {
            super.createDialogPanes(component);
        }
        if ((pane = (FwkTextDialogPane)staticPanes.get(TEXT_AREA_IDENT)) == null) {
            pane = new FwkTextDialogPane(40, 5);
            pane.setIdent(TEXT_AREA_IDENT);
            pane.setInitialText(((P2DText)component).getText());
            pane.setTitle(FwkPropertyBus.getProperty((String)TEXT_TEXT_KEY));
            pane.setTip(FwkPropertyBus.getProperty((String)TEXT_TOOLTIP_KEY));
            staticPanes.put(pane.getIdent(), pane);
        }
        return this.getDialogPaneValues(component);
    }

    public HashMap getDialogPaneValues(P2DComponentInterface component) {
        if (staticPanes == null) {
            return this.createDialogPanes(component);
        }
        HashMap ret = super.getDialogPaneValues(component);
        FwkDialogPaneInterface pane = (FwkDialogPaneInterface)staticPanes.get(TEXT_AREA_IDENT);
        if (pane != null) {
            FwkDialogPaneValueInterface value = pane.getSelectedValue();
            value.setProperty("Text", (Object)((P2DText)component).getText());
            ret.put(value.getIdent(), value);
        }
        return ret;
    }

    public void setDialogPaneValues(P2DComponentInterface component, HashMap values) {
        super.setDialogPaneValues(component, values);
        FwkDialogPaneValueInterface paneValue = (FwkDialogPaneValueInterface)values.get(TEXT_AREA_IDENT);
        if (paneValue != null) {
            try {
                String val = (String)paneValue.getProperty("Text");
                if (val != null) {
                    ((P2DText)component).setText(val);
                }
                values.remove(paneValue.getIdent());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public HashMap getDialogPanes(P2DComponentInterface component) {
        HashMap ret = super.getDialogPanes(component);
        FwkTextDialogPane pane = (FwkTextDialogPane)staticPanes.get(TEXT_AREA_IDENT);
        if (pane != null) {
            pane.setInitialText(((P2DText)component).getText());
            pane.setSize(40, 5);
            ret.put(TEXT_AREA_IDENT, pane);
        }
        return ret;
    }

    public FwkCommandInterface[] getCommands(P2DComponentInterface component) {
        if (!this.commandsAvailable()) {
            super.getCommands(component);
            FwkCommandInterface parent = this.getCommand("Help");
            if (parent == null) {
                parent = new FwkCommand((FwkControllerInterface)component);
                parent.setCommandName("Help");
                parent.setTextKey("P2D.Text.Help");
                this.addCommand(0, parent);
            }
            FwkCommand cb = new FwkCommand((FwkControllerInterface)component);
            cb.setCommandName("TextHelp");
            cb.setTextKey("P2D.Text.TextHelp");
            cb.setIconKey("Icon.FwkHelpBroker");
            cb.setHelpID("com.highqsoft.p2d.P2DText");
            parent.addCommand(0, (FwkCommandInterface)cb);
            cb = new FwkFontCommand((FwkControllerInterface)component);
            cb.setTextKey("P2D.Text.Font");
            cb.setCommandName("Font");
            component.addCommand(0, (FwkCommandInterface)cb);
            cb = new FwkTextEditorCommand((FwkControllerInterface)component);
            cb.setTextKey("P2D.Text.Text");
            cb.setCommandName("Text");
            component.addCommand(0, (FwkCommandInterface)cb);
        }
        return super.getCommands(component);
    }

    public void setAttributor(P2DComponentInterface component, P2DAttributorInterface attributor) {
        this.attributor = attributor;
    }

    public P2DAttributorInterface getAttributor(P2DComponentInterface component) {
        return this.attributor;
    }
}

