/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DTextInterface;
import com.highqsoft.interfaces.p2d.P2DTextViewInterface;
import com.highqsoft.interfaces.p2d.P2DViewInterface;
import com.highqsoft.p2d.P2DComponentView;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class P2DTextView
extends P2DComponentView
implements P2DViewInterface,
P2DTextViewInterface {
    public static final String version = "$Revision: 1.4 $";

    public void draw(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g) {
        FwkArrayInterface arr = ((P2DTextInterface)component).getAttributedText();
        if (arr != null) {
            int size = arr.size();
            int curY = 0;
            float wrappingWidth = (float)component.getWidth();
            double height = component.getHeight();
            TextLayout layout = null;
            float ali = ((P2DTextInterface)component).getAlignment();
            FontRenderContext frc = new FontRenderContext(null, true, true);
            int i = 0;
            while (i < size && (double)curY <= height) {
                AttributedString str = (AttributedString)arr.get(i++);
                AttributedCharacterIterator iter = str.getIterator();
                LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                while (measurer.getPosition() < iter.getEndIndex() && (double)curY <= height) {
                    layout = measurer.nextLayout(wrappingWidth);
                    if ((double)(curY = (int)((float)curY + layout.getAscent())) <= height) {
                        layout.draw(g, ali * (wrappingWidth - layout.getAdvance()), curY);
                    }
                    curY = (int)((float)curY + (layout.getDescent() + layout.getLeading()));
                }
            }
        }
    }
}

