/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.p2d.P2DAxisTypeInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.p2d.P2DAxisType;
import com.highqsoft.p2d.P2DBoundingBox;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class P2DXmlInterpreter {
    public static String encode_com_highqsoft_interfaces_p2d_P2DBoundingBoxInterface(P2DBoundingBoxInterface box) {
        if (box != null) {
            Point2D lower = box.getLower();
            Point2D upper = box.getUpper();
            return "" + lower.getX() + ", " + lower.getY() + ", " + upper.getX() + ", " + upper.getY();
        }
        return null;
    }

    public static P2DBoundingBoxInterface decode_com_highqsoft_interfaces_p2d_P2DBoundingBoxInterface(String s) {
        StringTokenizer tok = new StringTokenizer(s, ",");
        int count = 0;
        float[] arr = new float[4];
        try {
            while (tok.hasMoreTokens()) {
                arr[count] = Float.parseFloat(tok.nextToken());
                ++count;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (count == 4) {
            return new P2DBoundingBox(arr[0], arr[1], arr[2], arr[3]);
        }
        return null;
    }

    public static String encode_com_highqsoft_interfaces_p2d_P2DAxisTypeInterface(P2DAxisTypeInterface type) {
        if (type.isLog()) {
            return "log(" + type.getStringValue() + ")";
        }
        return "" + type.getStringValue();
    }

    public static P2DAxisTypeInterface decode_com_highqsoft_interfaces_p2d_P2DAxisTypeInterface(String s) {
        String val = s.toUpperCase();
        if (val.startsWith("LOG")) {
            int index = val.indexOf(40);
            if (index >= 0) {
                if ((val = val.substring(index + 1).trim()).startsWith("X")) {
                    return P2DAxisType.LOG_X;
                }
                if (val.startsWith("Y")) {
                    return P2DAxisType.LOG_Y;
                }
                if (val.startsWith("Z")) {
                    return P2DAxisType.LOG_Z;
                }
            }
        } else {
            if (val.startsWith("X")) {
                return P2DAxisType.X;
            }
            if (val.startsWith("Y")) {
                return P2DAxisType.Y;
            }
            if (val.startsWith("Z")) {
                return P2DAxisType.Z;
            }
        }
        return null;
    }

    public static String encode_java_awt_Shape(Shape shape) {
        double[] p = new double[6];
        StringBuffer ret = new StringBuffer();
        PathIterator it = shape.getPathIterator(new AffineTransform());
        ret.append("wr=" + it.getWindingRule());
        while (!it.isDone()) {
            int type = it.currentSegment(p);
            switch (type) {
                case 4: {
                    ret.append(";c");
                    break;
                }
                case 3: {
                    ret.append(";ct=" + p[0] + "," + p[1] + "," + p[2] + "," + p[3] + "," + p[4] + "," + p[5]);
                    break;
                }
                case 1: {
                    ret.append(";lt=" + p[0] + "," + p[1]);
                    break;
                }
                case 0: {
                    ret.append(";mt=" + p[0] + "," + p[1]);
                    break;
                }
                case 2: {
                    ret.append(";qt=" + p[0] + "," + p[1] + "," + p[2] + "," + p[3]);
                    break;
                }
            }
            it.next();
        }
        return ret.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Shape decode_java_awt_Shape(String s) {
        int counter = 0;
        int type = -1;
        float[] p = new float[6];
        GeneralPath ret = new GeneralPath();
        StringTokenizer tok = new StringTokenizer(s, ";=");
        try {
            block16: while (tok.hasMoreTokens()) {
                String token = tok.nextToken().trim();
                int index = token.indexOf(44);
                if (index > 0) {
                    StringTokenizer st = new StringTokenizer(token, ",");
                    switch (type) {
                        case 3: {
                            try {
                                counter = 0;
                                while (counter < 6 && st.hasMoreTokens()) {
                                    p[counter++] = Float.parseFloat(st.nextToken().trim());
                                }
                                ret.curveTo(p[0], p[1], p[2], p[3], p[4], p[5]);
                            }
                            catch (Throwable tCubic) {
                                System.err.println("P2DWmlInterpreter.decode_java_awt_Shape");
                                System.err.println("\tError while reading a cubicTo segment!");
                            }
                            continue block16;
                        }
                        case 1: {
                            try {
                                counter = 0;
                                while (counter < 2 && st.hasMoreTokens()) {
                                    p[counter++] = Float.parseFloat(st.nextToken().trim());
                                }
                                ret.lineTo(p[0], p[1]);
                            }
                            catch (Throwable tCubic) {
                                System.err.println("P2DWmlInterpreter.decode_java_awt_Shape");
                                System.err.println("\tError while reading a lineTo segment!");
                            }
                            continue block16;
                        }
                        case 0: {
                            try {
                                counter = 0;
                                while (counter < 2 && st.hasMoreTokens()) {
                                    p[counter++] = Float.parseFloat(st.nextToken().trim());
                                }
                                ret.moveTo(p[0], p[1]);
                            }
                            catch (Throwable tCubic) {
                                System.err.println("P2DWmlInterpreter.decode_java_awt_Shape");
                                System.err.println("\tError while reading a moveTo segment!");
                            }
                            continue block16;
                        }
                        case 2: {
                            try {
                                counter = 0;
                                while (counter < 4 && st.hasMoreTokens()) {
                                    p[counter++] = Float.parseFloat(st.nextToken().trim());
                                }
                                ret.quadTo(p[0], p[1], p[2], p[3]);
                            }
                            catch (Throwable tCubic) {
                                System.err.println("P2DWmlInterpreter.decode_java_awt_Shape");
                                System.err.println("\tError while reading a cubicTo segment!");
                            }
                            continue block16;
                        }
                    }
                    System.err.println("P2DWmlInterpreter.decode_java_awt_Shape");
                    System.err.println("\tError while reading from shape string!");
                    continue;
                }
                if (token.compareTo("c") == 0) {
                    ret.closePath();
                    continue;
                }
                if (token.compareTo("ct") == 0) {
                    type = 3;
                    continue;
                }
                if (token.compareTo("lt") == 0) {
                    type = 1;
                    continue;
                }
                if (token.compareTo("mt") == 0) {
                    type = 0;
                    continue;
                }
                if (token.compareTo("qt") == 0) {
                    type = 2;
                    continue;
                }
                if (token.compareTo("wr") != 0) continue;
                ret.setWindingRule(Integer.parseInt(tok.nextToken().trim()));
            }
            return ret;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret;
    }

    public static FwkArrayInterface readXML(NodeList list, FwkArrayInterface arr) {
        if (arr == null) {
            arr = new FwkArray();
        }
        return arr;
    }

    public static P2DComponentInterface[] readXML(String filename) {
        P2DComponentInterface[] ret = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(filename));
            doc.getDocumentElement().normalize();
            FwkArray arr = new FwkArray();
            P2DXmlInterpreter.readXML(doc.getDocumentElement().getChildNodes(), (FwkArrayInterface)arr);
        }
        catch (SAXParseException err) {
            System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println("   " + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret;
    }
}

