/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.AthosConfigModelIF;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddServiceDialog
extends JDialog {
    JTextField textField;
    JTextArea description;
    JList productList;
    Element[] driverNodes;
    AthosConfigModelIF model;
    NodeList products;
    NodeList noneDriverNodeList;
    boolean cancelled;

    public AddServiceDialog(JFrame parent, AthosConfigModelIF model) {
        super((Frame)parent, true);
        this.createPanel(parent, model);
    }

    public AddServiceDialog(JDialog parent, AthosConfigModelIF model) {
        super((Dialog)parent, true);
        this.createPanel(parent, model);
    }

    protected void createPanel(Window parent, AthosConfigModelIF model) {
        this.cancelled = true;
        this.model = model;
        this.products = null;
        this.noneDriverNodeList = null;
        try {
            this.products = model.getAvailableProducts();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.noneDriverNodeList = model.getNoneDriverNodes();
        }
        catch (Throwable t) {
            // empty catch block
        }
        int size = 0;
        if (this.products != null) {
            size = this.products.getLength();
        }
        Vector<String> pVec = new Vector<String>();
        Vector<Node> nVec = new Vector<Node>();
        for (int i = 0; i < size; ++i) {
            Element product = (Element)this.products.item(i);
            if (!product.getAttribute("package").equalsIgnoreCase("drivers")) continue;
            pVec.add(((Element)this.products.item(i)).getAttribute("name"));
            nVec.add(this.products.item(i));
        }
        String[] pList = pVec.toArray(new String[pVec.size()]);
        this.driverNodes = nVec.toArray(new Element[nVec.size()]);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        JLabel lab = new JLabel(model.getProperty("AthosConfig.Text.NewServiceName", "Name of the Service") + ":");
        this.textField = new JTextField(20);
        this.description = new JTextArea(10, 20);
        this.description.setFont(lab.getFont());
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setBackground(panel.getBackground());
        this.productList = new JList<String>(pList);
        this.productList.setBackground(panel.getBackground());
        this.productList.setSelectionMode(0);
        this.productList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int idx = AddServiceDialog.this.productList.getSelectedIndex();
                if (idx >= 0) {
                    Element elem = AddServiceDialog.this.driverNodes[idx];
                    AddServiceDialog.this.description.setText(elem.getAttribute("description"));
                } else {
                    AddServiceDialog.this.description.setText("");
                }
            }
        });
        JButton cancel = new JButton(model.getProperty("AthosConfig.Text.Cancel", "Cancel"));
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AddServiceDialog.this.setVisible(false);
                AddServiceDialog.this.dispose();
            }
        });
        JButton ok = new JButton(model.getProperty("AthosConfig.Text.Ok", "Ok"));
        ok.setDefaultCapable(true);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AddServiceDialog.this.cancelled = !AddServiceDialog.this.checkInput();
            }
        });
        JPanel inPanel = new JPanel(new GridBagLayout());
        gbc.weightx = 1.0;
        inPanel.add((Component)lab, gbc);
        ++gbc.gridx;
        gbc.weightx = 100.0;
        inPanel.add((Component)this.textField, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 100.0;
        panel.add((Component)inPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        JScrollPane scroller = new JScrollPane(this.productList);
        JPanel borderPanel = new JPanel(new BorderLayout());
        TitledBorder border = BorderFactory.createTitledBorder(model.getProperty("AthosConfig.Text.ProductTitle", "List of Products"));
        borderPanel.setBorder(border);
        borderPanel.add("Center", scroller);
        panel.add((Component)borderPanel, gbc);
        ++gbc.gridy;
        borderPanel = new JPanel(new BorderLayout());
        border = BorderFactory.createTitledBorder(model.getProperty("AthosConfig.Text.Description", "Description"));
        borderPanel.setBorder(border);
        borderPanel.add("Center", new JScrollPane(this.description));
        panel.add((Component)borderPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 50.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        panel.add((Component)cancel, gbc);
        ++gbc.gridx;
        panel.add((Component)ok, gbc);
        this.getContentPane().add(panel);
        this.setTitle(model.getProperty("AthosConfig.Text.NewService", "New Service"));
        this.getRootPane().setDefaultButton(ok);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    protected boolean checkInput() {
        int selected;
        String name = this.textField.getText().trim();
        if (name.length() == 0) {
            this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Text.NoServiceName", "No Service Name"), this.model.getProperty("AthosConfig.Text.EnterServiceFirst", "Please, enter a valid service name."));
            return false;
        }
        Document doc = this.model.getDocument();
        NodeList nodeList = doc.getElementsByTagName("product");
        if (nodeList != null && nodeList.getLength() > 0) {
            int size = nodeList.getLength();
            boolean found = false;
            for (int i = 0; !found && i < size; ++i) {
                String pName = ((Element)nodeList.item(i)).getAttribute("name");
                found = pName.compareTo(name) == 0;
            }
            if (found) {
                this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Text.ServiceNameExists", "Service Name exists"), this.model.getProperty("AthosConfig.Text.UseAnotherServiceName", "Please, use another service name."));
                return false;
            }
        }
        if ((selected = this.productList.getSelectedIndex()) < 0 || selected >= this.products.getLength()) {
            this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Text.NoProductSelected", "No product selected"), this.model.getProperty("AthosConfig.Text.SelectProductFirst", "Please, select a product first."));
            return false;
        }
        this.setVisible(false);
        this.dispose();
        return true;
    }

    protected Element getServiceNode() {
        Element element = null;
        if (!this.cancelled && this.textField.getText().trim().length() > 0 && this.productList.getSelectedIndex() >= 0) {
            try {
                element = this.model.addService(this.driverNodes[this.productList.getSelectedIndex()], this.textField.getText().trim(), this.noneDriverNodeList);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return element;
    }
}

