/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.AddServiceDialog;
import com.highqsoft.athosconfig.AdoptListener;
import com.highqsoft.athosconfig.AthosConfigModel;
import com.highqsoft.athosconfig.AthosConfigModelIF;
import com.highqsoft.athosconfig.CopyServiceDialog;
import com.highqsoft.athosconfig.GUIFactoryIF;
import com.highqsoft.athosconfig.RenameServiceDialog;
import com.highqsoft.athosconfig.SystemEnvironment;
import com.highqsoft.athosconfig.VariableIF;
import com.highqsoft.athosconfig.gui.Icon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AthosConfig
extends JFrame
implements PropertyChangeListener {
    protected JPanel centerPane;
    protected JPanel designPane;
    protected AthosConfigModel model = new AthosConfigModel(this);
    protected JTable serviceTable;
    protected JTable variableTable;
    protected JTextArea infoArea;
    protected JTextArea commentArea;
    protected JCheckBox[] appCheckBox;
    protected NodeList appNodeList;
    protected Font normalFont;
    protected Font boldFont;
    protected boolean isChanged = false;
    protected static JFileChooser openFileChooser;
    protected static JFileChooser saveFileChooser;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public AthosConfig() throws Exception {
        this.setDefaultCloseOperation(2);
        String iconResource = this.model.getProperty("AthosConfig.Icon.Resource", "com/highqsoft/athosconfig/gui/gear.gif");
        Container content = super.getContentPane();
        content.setLayout(new BorderLayout());
        this.centerPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 12;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.serviceTable = new JTable(new ServiceTableModel());
        this.serviceTable.setBackground(this.centerPane.getBackground());
        this.serviceTable.setShowGrid(false);
        this.serviceTable.setSelectionMode(0);
        this.serviceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                block6: {
                    if (e.getValueIsAdjusting()) break block6;
                    ((VariableTableModel)AthosConfig.this.variableTable.getModel()).fireTableDataChanged();
                    int row = AthosConfig.this.serviceTable.getSelectedRow();
                    boolean enabled = row > 0;
                    ServiceTableModel serviceModel = (ServiceTableModel)AthosConfig.this.serviceTable.getModel();
                    AthosConfig.this.variableTable.repaint();
                    if (enabled) {
                        for (int i = 0; i < AthosConfig.this.appCheckBox.length; ++i) {
                            try {
                                AthosConfig.this.appCheckBox[i].setEnabled(true);
                                AthosConfig.this.appCheckBox[i].setSelected(AthosConfig.this.model.isDesignedFor(serviceModel.getElementAt(row), AthosConfig.this.appNodeList.item(i)));
                                continue;
                            }
                            catch (Exception exc) {
                                AthosConfig.this.appCheckBox[i].setEnabled(false);
                                AthosConfig.this.appCheckBox[i].setSelected(false);
                                exc.printStackTrace();
                            }
                        }
                    } else {
                        for (int i = 0; i < AthosConfig.this.appCheckBox.length; ++i) {
                            AthosConfig.this.appCheckBox[i].setEnabled(false);
                            AthosConfig.this.appCheckBox[i].setSelected(false);
                        }
                    }
                }
            }
        });
        JPanel servicePanel = new JPanel(new BorderLayout());
        TitledBorder border = BorderFactory.createTitledBorder(this.model.getProperty("AthosConfig.Text.ServiceTitle", "List of Services"));
        servicePanel.setBorder(border);
        JPanel butPanel = new JPanel(new GridBagLayout());
        this.designPane = new JPanel(new GridBagLayout());
        border = BorderFactory.createTitledBorder(this.model.getProperty("AthosConfig.Text.DesignedFor", "Designed for"));
        this.designPane.setBorder(border);
        this.appNodeList = this.model.getAvailableApplications();
        GridBagConstraints nlg = new GridBagConstraints();
        nlg.fill = 1;
        nlg.anchor = 12;
        nlg.insets = new Insets(5, 5, 5, 5);
        nlg.gridy = 0;
        nlg.gridx = 0;
        nlg.weightx = 10.0;
        Vector<JCheckBox> vec = new Vector<JCheckBox>();
        for (int i = 0; i < this.appNodeList.getLength(); ++i) {
            Element node = (Element)this.appNodeList.item(i);
            JCheckBox checkBox = new JCheckBox(node.getAttribute("name"), false);
            checkBox.setEnabled(false);
            vec.add(checkBox);
            checkBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    boolean found = false;
                    Object source = ev.getSource();
                    if (!AthosConfig.this.isChanged) {
                        AthosConfig.this.isChanged = true;
                        AthosConfig.this.setTitle();
                    }
                    int i = 0;
                    while (i < AthosConfig.this.appCheckBox.length && !found) {
                        found = AthosConfig.this.appCheckBox[i].equals(source);
                        if (found) continue;
                        ++i;
                    }
                    if (found) {
                        ServiceTableModel serviceModel = (ServiceTableModel)AthosConfig.this.serviceTable.getModel();
                        int row = AthosConfig.this.serviceTable.getSelectedRow();
                        if (AthosConfig.this.appCheckBox[i].isSelected()) {
                            AthosConfig.this.model.extend(serviceModel.getElementAt(row), AthosConfig.this.appNodeList.item(i));
                        } else {
                            AthosConfig.this.model.reduce(serviceModel.getElementAt(row), AthosConfig.this.appNodeList.item(i), AthosConfig.this.appNodeList);
                        }
                        ((VariableTableModel)AthosConfig.this.variableTable.getModel()).fireTableDataChanged();
                        AthosConfig.this.variableTable.repaint();
                    }
                }
            });
            this.designPane.add((Component)checkBox, nlg);
            ++nlg.gridx;
        }
        this.appCheckBox = vec.toArray(new JCheckBox[vec.size()]);
        gbc.gridwidth = 4;
        gbc.weightx = 100.0;
        butPanel.add((Component)this.designPane, gbc);
        JScrollPane scroller = new JScrollPane(this.serviceTable);
        servicePanel.add("Center", scroller);
        servicePanel.add("South", butPanel);
        JPanel variableListPanel = new JPanel(new BorderLayout());
        border = BorderFactory.createTitledBorder(this.model.getProperty("AthosConfig.Text.VariableTitle", "List of Variables"));
        variableListPanel.setBorder(border);
        this.variableTable = new VariableTable();
        this.variableTable.setShowGrid(false);
        this.variableTable.setBackground(this.centerPane.getBackground());
        this.variableTable.setSelectionMode(0);
        this.variableTable.setDefaultRenderer(Object.class, new VariableRenderer());
        this.normalFont = this.variableTable.getFont();
        this.boldFont = new Font(this.normalFont.getName(), 1, this.normalFont.getSize());
        JPanel editorPanel = new JPanel(new BorderLayout());
        JButton def = new JButton(this.model.getProperty("AthosConfig.Text.DefaultValue", "Set all to default"), new Icon("magenta-ball.gif"));
        def.setToolTipText(this.model.getProperty("AthosConfig.ToolTip.DefaultValue", "Set all to default value."));
        def.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ((VariableTableModel)AthosConfig.this.variableTable.getModel()).setAllToDefault();
                if (!AthosConfig.this.isChanged) {
                    AthosConfig.this.isChanged = true;
                    AthosConfig.this.setTitle();
                }
            }
        });
        VariableEditorPanel variableEditorPanel = new VariableEditorPanel();
        this.variableTable.getSelectionModel().addListSelectionListener(variableEditorPanel);
        editorPanel.add("Center", variableEditorPanel);
        editorPanel.add("South", def);
        scroller = new JScrollPane(this.variableTable);
        variableListPanel.add("Center", scroller);
        variableListPanel.add("South", editorPanel);
        JSplitPane hSplitter = new JSplitPane(1, servicePanel, variableListPanel);
        hSplitter.setBorder(null);
        hSplitter.setOpaque(false);
        JPanel variableDescriptionPanel = new JPanel(new BorderLayout());
        border = BorderFactory.createTitledBorder(this.model.getProperty("AthosConfig.Text.VarDescriptionTitle", "Variable Description"));
        variableDescriptionPanel.setBorder(border);
        VariableCommentListener varCommentListener = new VariableCommentListener();
        this.variableTable.getSelectionModel().addListSelectionListener(varCommentListener);
        ServiceCommentListener servCommentListener = new ServiceCommentListener();
        this.serviceTable.getSelectionModel().addListSelectionListener(servCommentListener);
        this.infoArea = new JTextArea();
        this.infoArea.setFont(def.getFont());
        this.infoArea.setRows(4);
        this.infoArea.setEditable(false);
        this.infoArea.setBackground(this.centerPane.getBackground());
        this.infoArea.setWrapStyleWord(true);
        this.infoArea.setLineWrap(true);
        this.infoArea.setFont(this.variableTable.getFont());
        JPanel commentPanel = new JPanel(new BorderLayout());
        this.commentArea = new JTextArea();
        this.commentArea.setBorder(BorderFactory.createTitledBorder(this.model.getProperty("AthosConfig.Text.VarCommentTitle", "Specific Comment")));
        this.commentArea.setRows(4);
        this.commentArea.setEditable(true);
        this.commentArea.setWrapStyleWord(true);
        this.commentArea.setLineWrap(true);
        this.commentArea.setFont(this.variableTable.getFont());
        commentPanel.add("Center", new JScrollPane(this.commentArea));
        JButton ok = new JButton(this.model.getProperty("AthosConfig.Text.Adopt", "Adopt"), new Icon("Adopt.gif"));
        ok.setToolTipText(this.model.getProperty("AthosConfig.ToolTip.AdoptComment", "Takover the comment changes."));
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                int row = AthosConfig.this.variableTable.getSelectedRow();
                String comment = AthosConfig.this.commentArea.getText();
                if (row >= 0) {
                    VariableTableModel model = (VariableTableModel)AthosConfig.this.variableTable.getModel();
                    model.setCommentAt(row, AthosConfig.this.commentArea.getText());
                } else {
                    row = AthosConfig.this.serviceTable.getSelectedRow();
                    ServiceTableModel model = (ServiceTableModel)AthosConfig.this.serviceTable.getModel();
                    model.setCommentAt(row, AthosConfig.this.commentArea.getText());
                }
                if (!AthosConfig.this.isChanged) {
                    AthosConfig.this.isChanged = true;
                    AthosConfig.this.setTitle();
                }
            }
        });
        JPanel adoptPanel = new JPanel(new BorderLayout());
        adoptPanel.add("Center", new JPanel());
        adoptPanel.add("East", ok);
        commentPanel.add("South", adoptPanel);
        JSplitPane splitter = new JSplitPane(0, new JScrollPane(this.infoArea), commentPanel);
        splitter.setBorder(null);
        splitter.setOpaque(false);
        variableDescriptionPanel.add("Center", splitter);
        gbc.fill = 1;
        gbc.anchor = 12;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 100.0;
        gbc.weighty = 20.0;
        JSplitPane vSplitter = new JSplitPane(0, hSplitter, variableDescriptionPanel);
        vSplitter.setBorder(null);
        vSplitter.setOpaque(false);
        this.centerPane.add((Component)vSplitter, gbc);
        content.add("Center", this.centerPane);
        GUIFactoryIF f = this.model.getFactory();
        try {
            JMenuBar menuBar = (JMenuBar)f.create((Object)this, ".*MenuBar");
            this.setJMenuBar(menuBar);
        }
        catch (ClassCastException cce) {
            System.err.println("Found menubar is of type javax.swing.JMenuBar.");
        }
        catch (Throwable t) {
            System.err.println("No JMenuBar found for frame.");
        }
        try {
            JToolBar toolBar = (JToolBar)f.create((Object)this, ".*ToolBar");
            content.add("North", toolBar);
        }
        catch (ClassCastException cce) {
            System.err.println("Found toolbar is of type javax.swing.JToolBar.");
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("No JToolBar found for frame.");
        }
        this.setIconImage(new Icon(iconResource).getImage());
        this.setTitle();
        this.pack();
        this.model.addPropertyChangeListener(this);
        Dimension dim = this.getPreferredSize();
        Dimension ss = AthosConfig.getScreenSize();
        this.setLocation((ss.width - dim.width) / 4, (ss.height - dim.height) / 4);
        splitter.setDividerLocation(0.5);
        vSplitter.setDividerLocation(0.5);
    }

    public void setTitle() {
        String fName = this.model.getFilename();
        if (fName == null) {
            fName = "athos.ini*";
        } else if (this.isChanged) {
            fName = fName + "*";
        }
        this.setTitle(this.model.getProperty("AthosConfig.Text.Title", "AthosConfig") + " [" + fName + "]");
    }

    public Container getContentPane() {
        return this.centerPane;
    }

    public static Dimension getScreenSize() {
        Dimension ret = Toolkit.getDefaultToolkit().getScreenSize();
        return ret;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String prop = ev.getPropertyName();
        if (prop.equals("document")) {
            this.setTitle();
            ((ServiceTableModel)this.serviceTable.getModel()).fireTableDataChanged();
            this.serviceTable.repaint();
        } else if (prop.equals("filename")) {
            this.setTitle();
        }
    }

    public void open() {
        int ret;
        try {
            this.saveChanges();
        }
        catch (Throwable t) {
            return;
        }
        Cursor cursor = null;
        if (openFileChooser == null) {
            cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            openFileChooser = new JFileChooser();
            openFileChooser.setMultiSelectionEnabled(false);
            openFileChooser.setFileSelectionMode(0);
            FileFilter ff = null;
            while ((ff = openFileChooser.getFileFilter()) != null) {
                openFileChooser.removeChoosableFileFilter(ff);
            }
            openFileChooser.addChoosableFileFilter(new XMLFileFilter());
            openFileChooser.addChoosableFileFilter(new INIFileFilter());
            String athos_ini = SystemEnvironment.getEnv("ATHOS_INI", null);
            if (athos_ini != null) {
                File fini = new File(athos_ini);
                openFileChooser.setSelectedFile(fini);
            } else {
                athos_ini = SystemEnvironment.getEnv("ATHOS_ROOT", null);
                if (athos_ini != null) {
                    openFileChooser.setCurrentDirectory(new File(athos_ini));
                }
            }
            if (cursor != null) {
                this.setCursor(cursor);
            }
        }
        if ((ret = openFileChooser.showOpenDialog(this)) == 0) {
            try {
                if (cursor != null) {
                    this.setCursor(new Cursor(3));
                }
                this.open(openFileChooser.getSelectedFile());
                if (cursor != null) {
                    this.setCursor(cursor);
                }
            }
            catch (Throwable t) {
                if (cursor != null) {
                    this.setCursor(cursor);
                }
                StringBuffer buf = new StringBuffer();
                buf.append(this.model.getProperty("AthosConfig.Text.UnableToReadFile", "Unable to read file:")).append("\n");
                buf.append(openFileChooser.getSelectedFile());
                this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Title.UnableToReadFile", "Unable to Read File"), buf.toString());
                t.printStackTrace();
            }
        }
    }

    public void open(File file) throws Exception {
        this.model.openFile(file);
        this.setTitle();
        this.isChanged = false;
        if (openFileChooser != null) {
            openFileChooser.setSelectedFile(file);
        }
        this.serviceTable.revalidate();
        this.variableTable.revalidate();
    }

    public void save(boolean saveAs) {
        NodeList nodeList = this.model.checkConsistence();
        if (nodeList != null && nodeList.getLength() > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.model.getProperty("AthosConfig.Text.InconsistentVariables", "There are some inconsistent variables:"));
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Element element = (Element)nodeList.item(i);
                Element parent = (Element)element.getParentNode();
                buf.append("\n");
                buf.append(parent.getAttribute("name")).append(" -- > ");
                buf.append(element.getAttribute("name"));
            }
            String postMessage = this.model.getProperty("AthosConfig.Text.CorrectBeforSave", "Edit these variables before save the configuration or \ncancel this dialog to continue.");
            String[] arr = postMessage.split("\n\r");
            buf.append("\n");
            for (int i = 0; i < arr.length; ++i) {
                buf.append(arr[i]).append("\n");
            }
            int ret = JOptionPane.showConfirmDialog(this, buf, this.model.getProperty("AthosConfig.Text.ConsistenceError", "Consistence Error"), 2);
            if (ret == 0) {
                return;
            }
        }
        Cursor cursor = null;
        if (saveFileChooser == null) {
            cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            saveFileChooser = new JFileChooser();
            saveFileChooser.setMultiSelectionEnabled(false);
            saveFileChooser.setFileSelectionMode(0);
            FileFilter ff = null;
            while ((ff = saveFileChooser.getFileFilter()) != null) {
                saveFileChooser.removeChoosableFileFilter(ff);
            }
            saveFileChooser.addChoosableFileFilter(new XMLFileFilter());
            saveFileChooser.addChoosableFileFilter(new INIFileFilter());
            if (cursor != null) {
                this.setCursor(cursor);
            }
        }
        String fName = this.model.getFilename();
        boolean wasChanged = this.isChanged;
        if (saveAs || fName == null) {
            int ret;
            if (fName == null) {
                fName = SystemEnvironment.getEnv("ATHOS_INI", null);
            }
            if (fName != null) {
                File fini = new File(fName);
                saveFileChooser.setSelectedFile(fini);
                saveFileChooser.setCurrentDirectory(fini);
            }
            if ((ret = saveFileChooser.showSaveDialog(this)) == 0) {
                int opt;
                File file = saveFileChooser.getSelectedFile();
                if (saveAs && file.exists() && (opt = JOptionPane.showConfirmDialog(this, this.model.getProperty("AthosConfig.Text.FileExistsMessage", "The file you've selected alsready exists! Do you want to overwrite it?"), this.model.getProperty("AthosConfig.Text.FileExists", "File exists"), 1)) != 0) {
                    if (opt == 1) {
                        this.save(saveAs);
                    } else if (opt == 2) {
                        return;
                    }
                }
                try {
                    if (cursor != null) {
                        this.setCursor(new Cursor(3));
                    }
                    this.isChanged = false;
                    this.model.saveFile(file);
                    if (cursor != null) {
                        this.setCursor(cursor);
                    }
                }
                catch (Throwable t) {
                    this.isChanged = wasChanged;
                    this.setTitle();
                    if (cursor != null) {
                        this.setCursor(cursor);
                    }
                    this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Text.WriteError", "Write Error"), this.model.getProperty("AthosConfig.Text.WriteErrorMessage", "Cannot write file") + ":\n" + fName + "\n" + t.getClass().getName() + "\n" + t.getMessage());
                }
            }
        } else {
            try {
                if (cursor != null) {
                    this.setCursor(new Cursor(3));
                }
                this.isChanged = false;
                this.model.saveFile(fName);
                if (cursor != null) {
                    this.setCursor(cursor);
                }
            }
            catch (Throwable t) {
                this.isChanged = wasChanged;
                this.setTitle();
                if (cursor != null) {
                    this.setCursor(cursor);
                }
                this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Text.WriteError", "Write Error"), this.model.getProperty("AthosConfig.Text.WriteErrorMessage", "Cannot write file") + ":\n" + fName + "\n" + t.getMessage());
            }
        }
    }

    public void saveChanges() throws Exception {
        if (this.isChanged) {
            int ret = JOptionPane.showConfirmDialog(this, this.model.getProperty("AthosConfig.Text.SaveChangedDocument", "The current document is modified. Do you want to save changes?"), this.model.getProperty("AthosConfig.Text.CurrentDocumentChanged", "The current document has been changed"), 1);
            if (ret == 0) {
                this.save(false);
            } else {
                if (ret == 1) {
                    return;
                }
                if (ret == 2) {
                    throw new Exception("Canelled");
                }
            }
        }
    }

    public void exit() {
        try {
            this.saveChanges();
        }
        catch (Throwable t) {
            return;
        }
        System.exit(0);
    }

    public void newConfig() {
        this.model.newConfig();
    }

    public void addService() {
        AddServiceDialog addServiceDialog = new AddServiceDialog(this, (AthosConfigModelIF)this.model);
        addServiceDialog.setVisible(true);
        Element added = addServiceDialog.getServiceNode();
        if (added != null) {
            int index = ((ServiceTableModel)this.serviceTable.getModel()).indexOf(added);
            ((ServiceTableModel)this.serviceTable.getModel()).fireTableDataChange();
            this.serviceTable.repaint();
            if (!this.isChanged) {
                this.isChanged = true;
                this.setTitle();
            }
            if (index >= 0) {
                this.serviceTable.getSelectionModel().setSelectionInterval(index, index);
            }
        }
    }

    public void copyService() {
        int row = this.serviceTable.getSelectedRow();
        if (row > 0) {
            ServiceTableModel sModel = (ServiceTableModel)this.serviceTable.getModel();
            Element element = sModel.getElementAt(row);
            if (element != null) {
                CopyServiceDialog copyServiceDialog = new CopyServiceDialog(this, (AthosConfigModelIF)this.model, element);
                copyServiceDialog.setVisible(true);
                Element newService = copyServiceDialog.getServiceNode();
                if (newService != null) {
                    ((ServiceTableModel)this.serviceTable.getModel()).fireTableDataChange();
                    this.serviceTable.repaint();
                    if (!this.isChanged) {
                        this.isChanged = true;
                        this.setTitle();
                    }
                }
            }
        } else {
            this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Text.NoServiceSelected", "No service selected"), this.model.getProperty("AthosConfig.Text.SelectServiceFirst", "Please, select a service first."));
        }
    }

    public void renameService() {
        int row = this.serviceTable.getSelectedRow();
        if (row > 0) {
            ServiceTableModel sModel = (ServiceTableModel)this.serviceTable.getModel();
            Element element = sModel.getElementAt(row);
            if (element != null) {
                RenameServiceDialog renameServiceDialog = new RenameServiceDialog(this, (AthosConfigModelIF)this.model, element);
                renameServiceDialog.setVisible(true);
                this.serviceTable.repaint();
            }
        } else {
            this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Text.NoServiceSelected", "No service selected"), this.model.getProperty("AthosConfig.Text.SelectServiceFirst", "Please, select a service first."));
        }
    }

    public void deleteService() {
        int row = this.serviceTable.getSelectedRow();
        if (row > 0) {
            ServiceTableModel sModel = (ServiceTableModel)this.serviceTable.getModel();
            Element element = sModel.getElementAt(row);
            if (element != null) {
                int opt = JOptionPane.showConfirmDialog(this, this.model.getProperty("AthosConfig.Text.DeleteServiceMessage", "Are you sure that you want to delete the service?"), this.model.getProperty("AthosConfig.Text.DeleteService", "Delete Service"), 0);
                if (opt != 0 && opt == 1) {
                    return;
                }
                ((ServiceTableModel)this.serviceTable.getModel()).removeRow(row);
                this.serviceTable.repaint();
                try {
                    this.serviceTable.setRowSelectionInterval(row, row);
                }
                catch (Throwable t) {
                    this.serviceTable.setRowSelectionInterval(row - 1, row - 1);
                }
                if (!this.isChanged) {
                    this.isChanged = true;
                    this.setTitle();
                }
            }
        } else if (row == 0) {
            this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Text.RootIsNotRemovable", "Root is unremovable"), this.model.getProperty("AthosConfig.Text.Sorry", "Sorry!"));
        } else {
            this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Text.NoServiceSelected", "No service selected"), this.model.getProperty("AthosConfig.Text.SelectServiceFirst", "Please, select a service first."));
        }
    }

    public static void main(String[] args) {
        try {
            AthosConfig config = new AthosConfig();
            config.setVisible(true);
            if (args.length > 0) {
                config.open(new File(args[0]));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public class INIFileFilter
    extends FileFilter {
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().toUpperCase().endsWith(".INI");
        }

        public String getDescription() {
            return AthosConfig.this.model.getProperty("AthosConfig.Text.INIConfiguration", "(*.ini) INI Configuration used by ATHOS");
        }
    }

    public class XMLFileFilter
    extends FileFilter {
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().toUpperCase().endsWith(".XML");
        }

        public String getDescription() {
            return AthosConfig.this.model.getProperty("AthosConfig.Text.XMLConfiguration", "(*.xml) XML Configuration for reload");
        }
    }

    protected class ServiceCommentListener
    implements ListSelectionListener {
        protected ServiceCommentListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int row;
            if (!e.getValueIsAdjusting() && AthosConfig.this.commentArea != null && (row = AthosConfig.this.serviceTable.getSelectedRow()) >= 0) {
                ServiceTableModel model = (ServiceTableModel)AthosConfig.this.serviceTable.getModel();
                AthosConfig.this.commentArea.setText(model.getCommentAt(row));
                AthosConfig.this.commentArea.setCaretPosition(0);
            }
        }
    }

    protected class VariableCommentListener
    implements ListSelectionListener {
        protected VariableCommentListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int row;
            if (!e.getValueIsAdjusting() && AthosConfig.this.commentArea != null && (row = AthosConfig.this.variableTable.getSelectedRow()) >= 0) {
                VariableTableModel model = (VariableTableModel)AthosConfig.this.variableTable.getModel();
                AthosConfig.this.commentArea.setText(model.getCommentAt(row));
                AthosConfig.this.commentArea.setCaretPosition(0);
            }
        }
    }

    protected class VariableEditorPanel
    extends JPanel
    implements ListSelectionListener {
        VariableIF var;
        GridBagConstraints gbc;

        public VariableEditorPanel() {
            this.setLayout(new GridBagLayout());
            this.gbc = new GridBagConstraints();
            this.gbc.fill = 1;
            this.gbc.anchor = 13;
            this.gbc.gridy = 0;
            this.gbc.gridx = 0;
            this.gbc.weightx = 100.0;
            this.setVariable(null);
        }

        public void setVariable(VariableIF var) {
            this.var = var;
            if (var != null) {
                this.removeAll();
                JPanel p = new JPanel(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 1;
                gbc.anchor = 13;
                gbc.insets = new Insets(5, 0, 5, 0);
                gbc.gridy = 0;
                gbc.gridx = 0;
                JComponent component = var.getLabel();
                if (component != null) {
                    gbc.insets = new Insets(5, 5, 5, 5);
                    p.add((Component)component, gbc);
                    gbc.insets = new Insets(5, 0, 5, 0);
                    ++gbc.gridx;
                }
                var.addAdoptListener(new AdoptListener(){

                    public void adopt() {
                        VariableEditorPanel.this.takeover();
                    }
                });
                JComponent input = var.getInput();
                gbc.weightx = 100.0;
                gbc.gridwidth = 2;
                p.add((Component)input, gbc);
                gbc.gridx += gbc.gridwidth;
                gbc.gridwidth = 1;
                gbc.weightx = 0.0;
                component = var.getResetComponent();
                if (component != null) {
                    p.add((Component)component, gbc);
                    ++gbc.gridx;
                }
                if ((component = var.getDefaultComponent()) != null) {
                    p.add((Component)component, gbc);
                    ++gbc.gridx;
                }
                JButton ok = new JButton(AthosConfig.this.model.getProperty("AthosConfig.Text.Adopt", "Adopt"), new Icon("Adopt.gif"));
                ok.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        VariableEditorPanel.this.takeover();
                    }
                });
                gbc.insets = new Insets(5, 0, 5, 5);
                p.add((Component)ok, gbc);
                this.add((Component)new JScrollPane(p), this.gbc);
                AthosConfig.this.infoArea.setText(var.getDescription());
                AthosConfig.this.infoArea.setCaretPosition(0);
            } else {
                this.removeAll();
                JTextField junk = new JTextField();
                junk.setEditable(false);
                junk.setBackground(this.getBackground());
                this.add((Component)junk, this.gbc);
                if (AthosConfig.this.infoArea != null) {
                    AthosConfig.this.infoArea.setText("");
                }
            }
            this.revalidate();
        }

        protected void takeover() {
            try {
                this.var.setElementValue();
                int row = AthosConfig.this.variableTable.getSelectedRow();
                ((VariableTableModel)AthosConfig.this.variableTable.getModel()).updateRow(row);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (!AthosConfig.this.isChanged) {
                AthosConfig.this.isChanged = true;
                AthosConfig.this.setTitle();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int row = AthosConfig.this.variableTable.getSelectedRow();
                if (row >= 0) {
                    VariableTableModel model = (VariableTableModel)AthosConfig.this.variableTable.getModel();
                    VariableIF var = model.getElementAt(row);
                    this.setVariable(var);
                } else {
                    this.setVariable(null);
                }
            }
        }
    }

    protected class VariableRenderer
    extends DefaultTableCellRenderer {
        protected VariableRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel ret = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                VariableIF var = (VariableIF)value;
                if (var.isObligatory()) {
                    if (isSelected || hasFocus) {
                        if (var.isDefault()) {
                            ret.setFont(AthosConfig.this.normalFont);
                            ret.setForeground(Color.orange);
                        } else {
                            ret.setFont(AthosConfig.this.boldFont);
                            ret.setForeground(Color.yellow);
                        }
                    } else if (var.isDefault()) {
                        ret.setFont(AthosConfig.this.normalFont);
                        ret.setForeground(Color.red.darker());
                    } else {
                        ret.setFont(AthosConfig.this.boldFont);
                        ret.setForeground(Color.red);
                    }
                } else if (isSelected || hasFocus) {
                    if (var.isDefault()) {
                        ret.setFont(AthosConfig.this.normalFont);
                        ret.setForeground(Color.white);
                    } else {
                        ret.setFont(AthosConfig.this.boldFont);
                        ret.setForeground(Color.yellow);
                    }
                } else if (var.isDefault()) {
                    ret.setFont(AthosConfig.this.normalFont);
                    ret.setForeground(Color.black);
                } else {
                    ret.setFont(AthosConfig.this.boldFont);
                    ret.setForeground(Color.blue);
                }
                if (column == 1) {
                    ret.setText(var.getCurrentValue());
                }
            }
            return ret;
        }
    }

    protected class VarNodeComparator
    implements Comparator {
        NodeList nodeList;

        public VarNodeComparator(NodeList nodeList) {
            this.nodeList = nodeList;
        }

        public int compare(Object o1, Object o2) {
            Element e1 = (Element)this.nodeList.item((Integer)o1);
            Element e2 = (Element)this.nodeList.item((Integer)o2);
            return e1.getAttribute("name").compareTo(e2.getAttribute("name"));
        }

        public boolean equals(Object obj) {
            return obj.equals(this);
        }
    }

    public class VariableTableModel
    extends AbstractTableModel {
        Integer[] sorted;
        VariableIF[] vars;

        public void fireTableDataChanged() {
            Cursor cursor = AthosConfig.this.getCursor();
            AthosConfig.this.setCursor(new Cursor(3));
            this.sort();
            super.fireTableDataChanged();
            AthosConfig.this.setCursor(cursor);
        }

        public void setAllToDefault() {
            int size = 0;
            if (this.vars != null) {
                size = this.vars.length;
            }
            for (int i = 0; i < size; ++i) {
                this.getElementAt(i).setElementToDefault();
                this.fireTableCellUpdated(i, 1);
            }
        }

        public void updateRow(int row) {
            this.fireTableCellUpdated(row, 1);
        }

        public int getRowCount() {
            if (this.sorted == null) {
                return 0;
            }
            return this.sorted.length;
        }

        public String getColumnName(int column) {
            String ret = "";
            switch (column) {
                case 0: {
                    ret = AthosConfig.this.model.getProperty("variable.name", "name");
                    break;
                }
                case 1: {
                    ret = AthosConfig.this.model.getProperty("variable.value", "value");
                }
            }
            return ret;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int row, int column) {
            return this.getElementAt(row);
        }

        public int indexOf(Element elem) {
            int ret = -1;
            String name = elem.getAttribute("name");
            int count = this.getRowCount();
            for (int i = 0; ret < 0 && i < count; ++i) {
                if (!name.equals(this.getValueAt(i, 0))) continue;
                ret = 1;
            }
            return ret;
        }

        public VariableIF getElementAt(int row) {
            if (row >= 0 && row < this.vars.length) {
                if (this.vars[row] == null) {
                    Element elem = this.getNodeAt(row);
                    String dType = elem.getAttribute("datatype").toUpperCase();
                    try {
                        if (dType.length() == 0) {
                            dType = "DT_STRING";
                        }
                        Class<?> clazz = Class.forName("com.highqsoft.athosconfig.gui." + dType);
                        Constructor<?> constructor = clazz.getConstructor(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = AthosConfig.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
                        this.vars[row] = (VariableIF)constructor.newInstance(elem);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                return this.vars[row];
            }
            return null;
        }

        public String getCommentAt(int row) {
            VariableIF var = this.getElementAt(row);
            if (var != null) {
                return var.getComment();
            }
            return "";
        }

        public void setCommentAt(int row, String sval) {
            VariableIF var = this.getElementAt(row);
            if (var != null) {
                var.setComment(sval);
            }
        }

        public Element getNodeAt(int index) {
            NodeList nodeList = this.getVariableList();
            Element ret = null;
            if (nodeList != null) {
                ret = (Element)nodeList.item(this.sorted[index]);
            }
            return ret;
        }

        public NodeList getVariableList() {
            ServiceTableModel stm;
            Element element;
            NodeList ret = null;
            int selected = AthosConfig.this.serviceTable.getSelectedRow();
            if (selected >= 0 && AthosConfig.this.model != null && (element = (stm = (ServiceTableModel)AthosConfig.this.serviceTable.getModel()).getElementAt(selected)) != null) {
                ret = element.getElementsByTagName("variable");
            }
            return ret;
        }

        protected void sort() {
            NodeList nodeList = this.getVariableList();
            if (nodeList != null) {
                this.sorted = new Integer[nodeList.getLength()];
                this.vars = new VariableIF[this.sorted.length];
                for (int i = 0; i < this.sorted.length; ++i) {
                    this.sorted[i] = new Integer(i);
                }
                Arrays.sort(this.sorted, new VarNodeComparator(nodeList));
            } else {
                this.sorted = new Integer[0];
                this.vars = new VariableIF[0];
            }
        }
    }

    public class VariableTable
    extends JTable {
        public VariableTable() {
            super(new VariableTableModel());
        }

        public String getToolTipText(MouseEvent event) {
            VariableIF var;
            String ret = null;
            int row = this.rowAtPoint(new Point(event.getX(), event.getY()));
            if (row > 0 && (var = ((VariableTableModel)this.getModel()).getElementAt(row)) != null && (ret = var.getDescription()).length() == 0) {
                ret = null;
            }
            return ret;
        }
    }

    public class ServiceTableModel
    extends AbstractTableModel {
        public void fireTableDataChange() {
            Cursor cursor = AthosConfig.this.getCursor();
            AthosConfig.this.setCursor(new Cursor(3));
            super.fireTableDataChanged();
            AthosConfig.this.setCursor(cursor);
        }

        public int getRowCount() {
            Element global;
            int ret = 0;
            NodeList nodeList = this.getProductList();
            if (nodeList != null) {
                ret = nodeList.getLength();
            }
            if ((global = AthosConfig.this.model.getGlobal()) != null) {
                ++ret;
            }
            return ret;
        }

        public String getColumnName(int column) {
            String ret = "";
            switch (column) {
                case 0: {
                    ret = AthosConfig.this.model.getProperty("product.service", "service");
                    break;
                }
                case 1: {
                    ret = AthosConfig.this.model.getProperty("product.description", "description");
                }
            }
            return ret;
        }

        public int getColumnCount() {
            return 2;
        }

        public int indexOf(Element elem) {
            int ret = -1;
            String name = elem.getAttribute("name");
            int count = this.getRowCount();
            for (int i = 0; ret < 0 && i < count; ++i) {
                if (!name.equals(this.getValueAt(i, 0))) continue;
                ret = 1;
            }
            return ret;
        }

        public void removeRow(int row) {
            int size;
            NodeList nodeList;
            if (--row >= 0 && (nodeList = this.getProductList()) != null && row < (size = nodeList.getLength())) {
                Element elem = (Element)nodeList.item(row);
                if (elem.hasAttribute("package") && elem.getAttribute("package").equals("kernel")) {
                    AthosConfig.this.model.getFactory().showErrorMessage(AthosConfig.this, AthosConfig.this.model.getProperty("AthosConfig.Text.Unremovable", "Element is not removable"), AthosConfig.this.model.getProperty("AthosConfig.Text.KernelIsUnremovable", "The kernel service is not removable."));
                } else {
                    Node parent = elem.getParentNode();
                    if (parent != null) {
                        parent.removeChild(elem);
                        this.fireTableDataChange();
                    }
                }
            }
        }

        public Element getElementAt(int row) {
            Element ret = null;
            if (row > 0) {
                NodeList nodeList = this.getProductList();
                ret = (Element)nodeList.item(row - 1);
            } else {
                ret = AthosConfig.this.model.getGlobal();
            }
            return ret;
        }

        public Object getValueAt(int row, int column) {
            Element element = this.getElementAt(row);
            String ret = null;
            if (element != null) {
                switch (column) {
                    case 0: {
                        ret = element.getAttribute("name");
                        break;
                    }
                    case 1: {
                        ret = element.getAttribute("description");
                    }
                }
            }
            return ret;
        }

        public String getCommentAt(int row) {
            Node node;
            Element element = this.getElementAt(row);
            if (element != null && (node = element.getPreviousSibling()) != null) {
                if (node.getNodeType() == 3) {
                    node = node.getPreviousSibling();
                }
                if (node.getNodeType() == 8) {
                    return ((CharacterData)node).getData();
                }
            }
            return "";
        }

        public void setCommentAt(int row, String sval) {
            Element element = this.getElementAt(row);
            if (sval == null) {
                sval = "";
            }
            sval = sval.trim();
            if (element != null) {
                Node sibling = element.getPreviousSibling();
                if (sibling == null || sibling.getNodeType() != 8) {
                    if (sval.length() > 0) {
                        Comment comment = element.getOwnerDocument().createComment(sval);
                        element.getParentNode().insertBefore(comment, element);
                    }
                } else if (sval.length() > 0) {
                    Comment comment = (Comment)sibling;
                    comment.setData(sval);
                } else {
                    sibling.getParentNode().removeChild(sibling);
                }
            } else if (sval.length() > 0) {
                Document doc = AthosConfig.this.model.getDocument();
                Comment comment = doc.createComment(sval);
                NodeList root = doc.getElementsByTagName("product");
                if (root != null && root.getLength() > 0 && comment != null) {
                    root.item(0).appendChild(comment);
                }
            }
        }

        public NodeList getProductList() {
            Document doc;
            NodeList ret = null;
            if (AthosConfig.this.model != null && (doc = AthosConfig.this.model.getDocument()) != null) {
                ret = doc.getElementsByTagName("product");
            }
            return ret;
        }
    }
}

