/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.AthosConfig;
import com.highqsoft.athosconfig.AthosConfigModelIF;
import com.highqsoft.athosconfig.ConfigurationFactory;
import com.highqsoft.athosconfig.ConfigurationIF;
import com.highqsoft.athosconfig.Constants;
import com.highqsoft.athosconfig.GUIFactoryIF;
import com.highqsoft.athosconfig.INIConfiguration;
import com.highqsoft.athosconfig.Merger;
import com.highqsoft.athosconfig.XMLConfiguration;
import com.highqsoft.athosconfig.xml.Factory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AthosConfigModel
implements AthosConfigModelIF {
    protected Vector pListeners = null;
    protected HashMap propListeners = null;
    protected Vector vListeners = null;
    protected HashMap vetoListeners = null;
    protected Document theDocument = null;
    protected XMLConfiguration xmlConfig;
    protected Object ref;

    public AthosConfigModel(Object ref) throws Exception {
        Document doc;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            doc = db.parse(AthosConfig.class.getClassLoader().getResourceAsStream(Constants.ATHOS_CONFIG_GUI));
        }
        catch (ParserConfigurationException pce) {
            throw new Exception(pce.getMessage(), pce);
        }
        catch (SAXException saxe) {
            throw new Exception(saxe.getMessage(), saxe);
        }
        catch (IOException ioe) {
            throw new Exception("Resource \"" + Constants.ATHOS_CONFIG_GUI + "\" not found.", ioe);
        }
        Factory f = Factory.getInstance();
        f.initialize(ref, doc);
        this.ref = ref;
    }

    public void newConfig() {
        this.theDocument = null;
        this.getDocument();
    }

    public String getProperty(String key, String def) {
        return Factory.getInstance().getProperty(this.ref, key, def);
    }

    public GUIFactoryIF getFactory() {
        return Factory.getInstance();
    }

    public Document getDocument() {
        Element root = null;
        if (this.xmlConfig == null) {
            this.xmlConfig = new XMLConfiguration();
        }
        if (this.theDocument == null) {
            INIConfiguration config = new INIConfiguration();
            try {
                Document doc = Merger.mergeConfig(config.getDocument(), this.xmlConfig.getDocument());
                Element global = doc.createElement("globals");
                NodeList nl = doc.getElementsByTagName("athos_variables");
                root = (Element)nl.item(0);
                global.setAttribute("name", "ATHOS");
                root.appendChild(global);
                Node kernel = this.xmlConfig.getKernel();
                if (kernel != null) {
                    Merger.mergeElement(global, (Element)kernel);
                    this.removeLocal(global);
                    this.removeEnvironment(global);
                }
                this.setDocument(doc);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return this.theDocument;
    }

    public void setFilename(String filename) throws Exception {
        if (this.theDocument == null) {
            this.openFile(filename);
        } else {
            String old = null;
            NodeList nodeList = this.theDocument.getChildNodes();
            int size = nodeList.getLength();
            for (int i = 0; old == null && i < size; ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("athos_variables")) continue;
                Element root = (Element)node;
                old = root.getAttribute("filename");
                root.setAttribute("filename", filename);
            }
            if (old == null) {
                old = "";
            }
            this.firePropertyChange("filename", old, filename);
        }
    }

    public void setDocument(Document doc) {
        Document old = this.theDocument;
        this.theDocument = (Document)doc.cloneNode(true);
        this.firePropertyChange("document", old, doc);
    }

    public void openFile(String filename) throws Exception {
        if (this.xmlConfig == null) {
            this.xmlConfig = new XMLConfiguration();
        }
        ConfigurationIF config = null;
        Document doc = null;
        if (filename.toUpperCase().endsWith(".INI")) {
            config = new INIConfiguration(filename);
            this.createDoc(config.getDocument());
        } else {
            config = new XMLConfiguration(filename);
            doc = config.getDocument();
            this.setDocument(doc);
        }
    }

    public void openFile(File file) throws Exception {
        this.openFile(file.getAbsolutePath());
    }

    public void saveFile(String filename) throws Exception {
        this.saveFile(new File(filename));
    }

    public void saveFile(File file) throws Exception {
        PrintStream out = new PrintStream(new FileOutputStream(file));
        if (file.getName().toUpperCase().endsWith(".INI")) {
            INIConfiguration.write(out, this.getDocument());
        } else {
            ConfigurationFactory.writeXML(out, this.getDocument());
        }
        out.close();
        this.setFilename(file.toString());
    }

    public Element getGlobal() {
        Document doc = this.getDocument();
        NodeList nodeList = doc.getElementsByTagName("globals");
        Element ret = null;
        if (nodeList != null && nodeList.getLength() > 0) {
            ret = (Element)nodeList.item(0);
        }
        return ret;
    }

    public Element addService(Element pattern, String name, NodeList appNodeList) {
        Element element = null;
        try {
            Document doc = this.getDocument();
            NodeList nodeList = doc.getElementsByTagName("athos_variables");
            if (nodeList != null && nodeList.getLength() > 0) {
                Element elem;
                Element root = (Element)nodeList.item(0);
                element = Merger.cloneElement(doc, pattern);
                element.setAttribute("name", name);
                Vector vec = ConfigurationFactory.getDependencies(pattern);
                int count = vec.size();
                for (int i = 0; i < count; ++i) {
                    elem = (Element)vec.get(i);
                    Merger.mergeElement(element, elem);
                }
                Node kernel = this.xmlConfig.getKernel();
                if (kernel != null) {
                    Merger.mergeElement(element, (Element)kernel);
                }
                this.removeGlobal(element);
                root.appendChild(element);
                if (appNodeList != null && appNodeList.getLength() > 0) {
                    count = appNodeList.getLength();
                    for (int i = 0; i < count; ++i) {
                        if (!this.isDesignedFor(element, appNodeList.item(i))) continue;
                        this.extend(element, appNodeList.item(i));
                    }
                }
                if (kernel != null) {
                    Element global = this.getGlobal();
                    Merger.mergeElement(global, element);
                    this.removeLocal(global);
                    this.removeEnvironment(global);
                }
                this.removeGlobal(element);
                this.removeEnvironment(element);
                String driver = pattern.getAttribute("drivername");
                if (driver != null && driver.length() > 0 && (nodeList = element.getElementsByTagName("variable")) != null && nodeList.getLength() > 0) {
                    count = nodeList.getLength();
                    Element driverNode = null;
                    for (int i = 0; i < count && driverNode == null; ++i) {
                        elem = (Element)nodeList.item(i);
                        if (!elem.getAttribute("name").equalsIgnoreCase("DRIVER")) continue;
                        elem.setAttribute("value", driver);
                        driverNode = elem;
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return element;
    }

    public Element getProduct(NodeList products, String driverName) throws Exception {
        Element ret = null;
        int nLen = products.getLength();
        driverName = driverName.trim().toUpperCase();
        for (int i = 0; ret == null && i < nLen; ++i) {
            Element element = (Element)products.item(i);
            if (!element.hasAttribute("drivername") || !element.getAttribute("drivername").toUpperCase().equals(driverName)) continue;
            ret = element;
        }
        return ret;
    }

    public NodeList getAvailableProducts() throws Exception {
        if (this.xmlConfig == null) {
            this.xmlConfig = new XMLConfiguration();
        }
        return this.xmlConfig.getDocument().getElementsByTagName("product");
    }

    public NodeList getNoneDriverNodes() throws Exception {
        if (this.xmlConfig == null) {
            this.xmlConfig = new XMLConfiguration();
        }
        NodeList ret = new NodeList(){
            Vector vec = null;

            public Vector getVector() {
                if (this.vec == null) {
                    this.vec = new Vector();
                    try {
                        NodeList nodeList = AthosConfigModel.this.xmlConfig.getDocument().getElementsByTagName("product");
                        int count = nodeList.getLength();
                        for (int i = 0; i < count; ++i) {
                            Element elem;
                            if (nodeList.item(i).getNodeType() != 1 || (elem = (Element)nodeList.item(i)).getAttribute("package").equals("drivers")) continue;
                            this.vec.add(elem);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                return this.vec;
            }

            public int getLength() {
                return this.getVector().size();
            }

            public Node item(int i) {
                return (Node)this.getVector().get(i);
            }
        };
        ret.getLength();
        return ret;
    }

    public NodeList getAvailableApplications() throws Exception {
        if (this.xmlConfig == null) {
            this.xmlConfig = new XMLConfiguration();
        }
        return this.xmlConfig.getPackages("application");
    }

    public void extend(Node serviceNode, Node application) {
        Element element = (Element)application;
        try {
            Document doc = this.xmlConfig.getDocument();
            NodeList nodeList = doc.getElementsByTagName("product");
            int count = nodeList.getLength();
            while (element != null) {
                Merger.mergeElement((Element)serviceNode, element);
                String depends = element.getAttribute("depends");
                element = null;
                if (depends == null) continue;
                for (int i = 0; i < count && element == null; ++i) {
                    String name;
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1 || (name = ((Element)node).getAttribute("package")).compareToIgnoreCase(depends) != 0) continue;
                    element = (Element)node;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.removeEnvironment(serviceNode);
    }

    protected void removeEnvironment(Node product) {
        NodeList nodeList = ((Element)product).getElementsByTagName("variable");
        if (nodeList != null && nodeList.getLength() > 0) {
            Element elem;
            int i;
            int size = nodeList.getLength();
            int count = 0;
            Node[] nodes = new Node[size];
            for (i = 0; i < size; ++i) {
                elem = (Element)nodeList.item(i);
                if (!AthosConfigModel.isEnvironment(elem) || AthosConfigModel.isINI(elem)) continue;
                nodes[count++] = nodeList.item(i);
            }
            for (i = 0; i < count; ++i) {
                elem = (Element)nodes[i];
                product.removeChild(nodes[i]);
            }
        }
    }

    protected void removeLocal(Node node) {
        NodeList nodeList = ((Element)node).getElementsByTagName("variable");
        if (nodeList != null && nodeList.getLength() > 0) {
            int i;
            int size = nodeList.getLength();
            int count = 0;
            Node[] nodes = new Node[size];
            for (i = 0; i < size; ++i) {
                if (AthosConfigModel.isGlobal((Element)nodeList.item(i))) continue;
                nodes[count++] = nodeList.item(i);
            }
            for (i = 0; i < count; ++i) {
                node.removeChild(nodes[i]);
            }
        }
    }

    protected void removeGlobal(Node node) {
        NodeList nodeList = ((Element)node).getElementsByTagName("variable");
        if (nodeList != null && nodeList.getLength() > 0) {
            int i;
            int size = nodeList.getLength();
            int count = 0;
            Node[] nodes = new Node[size];
            for (i = 0; i < size; ++i) {
                if (!AthosConfigModel.isGlobal((Element)nodeList.item(i))) continue;
                nodes[count++] = nodeList.item(i);
            }
            for (i = 0; i < count; ++i) {
                node.removeChild(nodes[i]);
            }
        }
    }

    public void reduce(Node serviceNode, Node application, NodeList otherApp) {
        Element element = (Element)application;
        try {
            Document doc = this.xmlConfig.getDocument();
            NodeList nodeList = doc.getElementsByTagName("product");
            int count = nodeList.getLength();
            while (element != null) {
                this.reduceApplicationAttributes(serviceNode, element, otherApp);
                String depends = element.getAttribute("depends");
                element = null;
                if (depends == null || depends.compareToIgnoreCase("kernel") == 0) continue;
                for (int i = 0; i < count && element == null; ++i) {
                    String name;
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1 || (name = ((Element)node).getAttribute("package")).compareToIgnoreCase(depends) != 0) continue;
                    element = (Element)node;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void reduceApplicationAttributes(Node serviceNode, Node application, NodeList otherApp) {
        Element elem;
        HashMap map = Merger.getMergingElement((Element)serviceNode, (Element)application);
        if (otherApp != null && otherApp.getLength() > 0) {
            for (int i = 0; i < otherApp.getLength(); ++i) {
                elem = (Element)otherApp.item(i);
                if (elem.equals(application)) continue;
                HashMap m = Merger.getMergingElement((Element)serviceNode, elem);
                Iterator it = m.keySet().iterator();
                while (it.hasNext()) {
                    map.remove(it.next());
                }
            }
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            elem = (Element)map.get(it.next());
            serviceNode.removeChild(elem);
        }
    }

    public boolean isDesignedFor(Node serviceNode, Node application) throws Exception {
        String productName;
        boolean ret = false;
        if (application != null && serviceNode != null && !(productName = ((Element)serviceNode).getAttribute("name")).equals("") && !productName.equals("kernel")) {
            NodeList appVarNodes = application.getChildNodes();
            NodeList srvVarNodes = serviceNode.getChildNodes();
            ret = true;
            for (int i = 0; ret && i < appVarNodes.getLength(); ++i) {
                Element elem;
                if (appVarNodes.item(i).getNodeType() != 1 || !AthosConfigModel.isObligatory(elem = (Element)appVarNodes.item(i)) || AthosConfigModel.isEnvironment(elem)) continue;
                ret = this.hasVariable(srvVarNodes, elem.getAttribute("name"));
            }
        }
        return ret;
    }

    public static boolean isObligatory(Element variable) {
        String val = "flase";
        if (variable != null && variable.hasAttribute("obligatory") && (val = variable.getAttribute("obligatory")).length() == 0) {
            val = "flase";
        }
        return AthosConfigModel.booleanValue(val);
    }

    public static boolean isEnvironment(Element variable) {
        String val = "flase";
        if (variable != null && variable.hasAttribute("environment") && (val = variable.getAttribute("environment")).length() == 0) {
            val = "flase";
        }
        return AthosConfigModel.booleanValue(val);
    }

    public static boolean isGlobal(Element variable) {
        String val = "flase";
        if (variable != null && variable.hasAttribute("global") && (val = variable.getAttribute("global")).length() == 0) {
            val = "flase";
        }
        return AthosConfigModel.booleanValue(val);
    }

    public static boolean isINI(Element variable) {
        String val = "flase";
        if (variable != null && variable.hasAttribute("ini_file") && (val = variable.getAttribute("ini_file")).length() == 0) {
            val = "flase";
        }
        return AthosConfigModel.booleanValue(val);
    }

    protected boolean hasVariable(NodeList nodeList, String name) {
        boolean ret = false;
        int size = nodeList.getLength();
        for (int i = 0; !ret && i < size; ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element elem = (Element)nodeList.item(i);
            String varName = elem.getAttribute("name");
            ret = varName.compareToIgnoreCase(name) == 0;
        }
        return ret;
    }

    public NodeList checkConsistence() {
        ReturnNodeList ret = new ReturnNodeList();
        Element global = this.getGlobal();
        this.checkConsistence(ret, global);
        NodeList nodeList = this.getDocument().getElementsByTagName("product");
        if (nodeList != null && nodeList.getLength() > 0) {
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                this.checkConsistence(ret, (Element)nodeList.item(i));
            }
        }
        return ret;
    }

    public void checkConsistence(ReturnNodeList ret, Element node) {
        NodeList nodeList = node.getElementsByTagName("variable");
        if (nodeList != null && nodeList.getLength() > 0) {
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Element var = (Element)nodeList.item(i);
                if (!AthosConfigModel.isObligatory(var)) continue;
                String value = null;
                if (var.hasAttribute("value")) {
                    value = var.getAttribute("value");
                }
                if ((value == null || value.length() == 0) && var.hasAttribute("default") && (value = var.getAttribute("default")).toUpperCase().equals("NO DEFAULT")) {
                    value = null;
                }
                if (value != null && value.length() != 0) continue;
                ret.add(var);
            }
        }
    }

    public String getFilename() {
        String ret = null;
        Document doc = this.getDocument();
        NodeList nodeList = doc.getElementsByTagName("athos_variables");
        if (nodeList != null && nodeList.getLength() > 0) {
            Element root = (Element)nodeList.item(0);
            ret = root.getAttribute("filename");
        }
        if (ret.length() == 0) {
            ret = null;
        }
        return ret;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pListeners == null) {
            this.pListeners = new Vector();
        }
        if (!this.pListeners.contains(l)) {
            this.pListeners.add(l);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        Vector<PropertyChangeListener> listener;
        if (this.propListeners == null) {
            this.propListeners = new HashMap();
        }
        if ((listener = (Vector<PropertyChangeListener>)this.propListeners.get(propertyName)) == null) {
            listener = new Vector<PropertyChangeListener>();
            this.propListeners.put(propertyName, listener);
        }
        if (!listener.contains(l)) {
            listener.add(l);
        }
    }

    public PropertyChangeListener[] getPropertyChangepListeners() {
        Vector ret = new Vector();
        if (this.pListeners != null) {
            ret.addAll(this.pListeners);
        }
        if (this.propListeners != null) {
            Iterator it = this.propListeners.keySet().iterator();
            while (it.hasNext()) {
                Vector l = (Vector)this.propListeners.get(it.next());
                ret.addAll(l);
            }
        }
        return ret.toArray(new PropertyChangeListener[ret.size()]);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.pListeners != null) {
            this.pListeners.remove(l);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        Vector pListeners;
        if (this.propListeners != null && (pListeners = (Vector)this.propListeners.get(propertyName)) != null) {
            pListeners.remove(l);
            if (pListeners.size() == 0) {
                this.propListeners.remove(propertyName);
            }
        }
        Iterator it = this.propListeners.keySet().iterator();
        Vector v = new Vector();
        while (it.hasNext()) {
            v.add(it.next());
        }
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            this.removePropertyChangeListener(v.get(i).toString(), l);
        }
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        Vector list;
        PropertyChangeEvent ev = new PropertyChangeEvent(this, propName, oldValue, newValue);
        if (this.pListeners != null) {
            int size = this.pListeners.size();
            for (int i = 0; i < size; ++i) {
                PropertyChangeListener l = (PropertyChangeListener)this.pListeners.get(i);
                l.propertyChange(ev);
            }
        }
        if (this.propListeners != null && (list = (Vector)this.propListeners.get(propName)) != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                PropertyChangeListener l = (PropertyChangeListener)list.get(i);
                l.propertyChange(ev);
            }
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        if (this.vListeners == null) {
            this.vListeners = new Vector();
        }
        if (!this.vListeners.contains(l)) {
            this.vListeners.add(l);
        }
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener l) {
        Vector<VetoableChangeListener> listener;
        if (this.vetoListeners == null) {
            this.vetoListeners = new HashMap();
        }
        if ((listener = (Vector<VetoableChangeListener>)this.propListeners.get(propertyName)) == null) {
            listener = new Vector<VetoableChangeListener>();
            this.vetoListeners.put(propertyName, listener);
        }
        if (!listener.contains(l)) {
            listener.add(l);
        }
    }

    public VetoableChangeListener[] getVetoableChangepListeners() {
        Vector ret = new Vector();
        if (this.vListeners != null) {
            ret.addAll(this.vListeners);
        }
        if (this.vetoListeners != null) {
            Iterator it = this.vetoListeners.keySet().iterator();
            while (it.hasNext()) {
                Vector l = (Vector)this.vetoListeners.get(it.next());
                ret.addAll(l);
            }
        }
        return ret.toArray(new VetoableChangeListener[ret.size()]);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this.vListeners != null) {
            this.vListeners.remove(l);
        }
        Iterator it = this.vetoListeners.keySet().iterator();
        Vector v = new Vector();
        while (it.hasNext()) {
            v.add(it.next());
        }
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            this.removeVetoableChangeListener(v.get(i).toString(), l);
        }
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener l) {
        Vector vListeners;
        if (this.vetoListeners != null && (vListeners = (Vector)this.vetoListeners.get(propertyName)) != null) {
            vListeners.remove(l);
            if (vListeners.size() == 0) {
                this.vetoListeners.remove(propertyName);
            }
        }
    }

    protected void fireVetoableChange(String propName, Object oldValue, Object newValue) throws PropertyVetoException {
        Vector list;
        PropertyChangeEvent ev = new PropertyChangeEvent(this, propName, oldValue, newValue);
        if (this.pListeners != null) {
            int size = this.pListeners.size();
            for (int i = 0; i < size; ++i) {
                VetoableChangeListener l = (VetoableChangeListener)this.pListeners.get(i);
                l.vetoableChange(ev);
            }
        }
        if (this.vetoListeners != null && (list = (Vector)this.vetoListeners.get(propName)) != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                VetoableChangeListener l = (VetoableChangeListener)list.get(i);
                l.vetoableChange(ev);
            }
        }
    }

    protected static boolean booleanValue(String value) {
        boolean ret = false;
        if (value != null && value.length() > 0) {
            char c = value.toUpperCase().charAt(0);
            ret = c == 'Y' || c == 'J' || c == 'T' || c == 'W' || c == '1';
        }
        return ret;
    }

    protected void createDoc(Document iniDoc) throws Exception {
        Comment cNode;
        Node node;
        this.newConfig();
        Document doc = this.getDocument();
        Node root = null;
        Node globals = null;
        NodeList nodeList = doc.getElementsByTagName("athos_variables");
        if (nodeList == null || nodeList.getLength() <= 0) {
            throw new Exception("Newly created document has no root.");
        }
        root = nodeList.item(0);
        nodeList = doc.getElementsByTagName("globals");
        if (nodeList == null || nodeList.getLength() <= 0) {
            throw new Exception("Newly created document has no globals.");
        }
        globals = nodeList.item(0);
        nodeList = iniDoc.getChildNodes();
        int nLen = nodeList.getLength();
        Node iniRoot = null;
        for (int i = 0; i < nLen; ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() == 8 || node.getNodeType() == 3) {
                cNode = null;
                if (node.getNodeType() == 8) {
                    cNode = doc.createComment(((Comment)node).getData());
                } else if (node.getNodeType() == 3) {
                    cNode = doc.createComment(((CharacterData)node).getData());
                }
                if (iniRoot == null) {
                    doc.insertBefore(cNode, root);
                    continue;
                }
                doc.appendChild(cNode);
                continue;
            }
            iniRoot = node;
        }
        NodeList products = this.getAvailableProducts();
        if (iniRoot != null) {
            nodeList = iniRoot.getChildNodes();
            nLen = nodeList.getLength();
            int count = 0;
            for (int i = 0; i < nLen; ++i) {
                node = nodeList.item(i);
                if (node.getNodeType() == 8) {
                    cNode = doc.createComment(((Comment)node).getData());
                    if (count == 0) {
                        root.insertBefore(cNode, globals);
                        continue;
                    }
                    root.appendChild(cNode);
                    continue;
                }
                if (node.getNodeType() == 3) {
                    cNode = doc.createComment(((CharacterData)node).getData());
                    if (count == 0) {
                        root.insertBefore(cNode, globals);
                        continue;
                    }
                    root.appendChild(cNode);
                    continue;
                }
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                if (element.getTagName().equals("product")) {
                    Element product;
                    if (!element.hasAttribute("drivername") || (product = this.getProduct(products, element.getAttribute("drivername"))) == null || !element.hasAttribute("name")) continue;
                    Element service = this.addService(product, element.getAttribute("name"), this.getAvailableApplications());
                    Merger.mergeElement(service, element);
                    ++count;
                    continue;
                }
                if (!element.getTagName().equals("list")) continue;
                Element lNode = Merger.cloneElement(doc, element);
                root.appendChild(lNode);
            }
            nodeList = doc.getElementsByTagName("globals");
            if (nodeList == null || nodeList.getLength() <= 0) {
                throw new Exception("Newly created document has no globals.");
            }
            globals = nodeList.item(0);
            nodeList = iniDoc.getElementsByTagName("globals");
            if (nodeList != null && nodeList.getLength() > 0) {
                Merger.mergeElement((Element)globals, (Element)nodeList.item(0));
            }
            ((Element)root).setAttribute("filename", ((Element)iniRoot).getAttribute("filename"));
            ((Element)root).setAttribute("type", "inifile");
        }
    }

    public static void main(String[] args) {
        try {
            AthosConfigModel model = new AthosConfigModel(new Object());
            model.openFile("D:/athos/etc/demo.ini");
            Document doc = model.getDocument();
            ConfigurationFactory.writeXML(System.out, doc);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected class ReturnNodeList
    implements NodeList {
        Vector vec = new Vector();

        public void add(Node node) {
            this.vec.add(node);
        }

        public int getLength() {
            return this.vec.size();
        }

        public Node item(int idx) {
            return (Node)this.vec.get(idx);
        }
    }
}

