/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.ConfigurationIF;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationFactory {
    public static final String[][] XML_REPLACEMENTS = new String[][]{{"<", "&lt;"}, {">", "&gt;"}, {"\\n", "&#x0a;"}, {"\\r", "&#x0d;"}, {"\"", "&quot;"}, {"'", "&apos;"}, {"\u0007", "/"}};
    public static final String[][] REVERSE_XML_REPLACEMENTS = new String[][]{{"&lt;", "<"}, {"&gt;", ">"}, {"&#x0d;", "\\n"}, {"&quot;", "\""}, {"&apos;", "'"}};

    public static ConfigurationIF getFromDatabase() {
        return null;
    }

    public static String convertToXML(String in) {
        String ret = in;
        if (in != null) {
            ret = in.replaceAll(XML_REPLACEMENTS[0][0], XML_REPLACEMENTS[0][1]);
            int size = XML_REPLACEMENTS.length;
            for (int i = 1; i < size; ++i) {
                ret = ret.replaceAll(XML_REPLACEMENTS[i][0], XML_REPLACEMENTS[i][1]);
            }
        }
        return ret;
    }

    public static String reverse_convertToXML(String in) {
        String ret = in.replaceAll(REVERSE_XML_REPLACEMENTS[0][0], REVERSE_XML_REPLACEMENTS[0][1]);
        int size = REVERSE_XML_REPLACEMENTS.length;
        for (int i = 1; i < size; ++i) {
            ret = ret.replaceAll(REVERSE_XML_REPLACEMENTS[i][0], REVERSE_XML_REPLACEMENTS[i][1]);
        }
        return ret;
    }

    public static Vector getDependencies(Element element) {
        String elemName = element.getAttribute("name");
        Element parent = (Element)element.getParentNode();
        NodeList list = parent.getChildNodes();
        Vector<Element> vec = new Vector<Element>();
        Element elem = null;
        HashMap<String, String> foundMap = new HashMap<String, String>();
        foundMap.put(elemName, elemName);
        String depend = element.getAttribute("depends");
        int len = list.getLength();
        while (depend != null && depend.trim().length() > 0) {
            foundMap.put(depend, depend);
            boolean found = false;
            String name = null;
            for (int i = 0; !found && i < len; ++i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1) continue;
                elem = (Element)list.item(i);
                name = elem.getAttribute("drivername");
                found = name.equalsIgnoreCase(depend);
            }
            if (found) {
                vec.insertElementAt(elem, 0);
                depend = elem.getAttribute("depends");
                if (foundMap.get(depend) == null) continue;
                depend = null;
                continue;
            }
            depend = null;
        }
        vec.add(element);
        return vec;
    }

    public static void printOutNode(PrintStream out, String prefix, Node node, boolean recursive) {
        if (node != null) {
            if (node.getNodeType() != 8) {
                Node aNode;
                String name = node.getNodeName();
                NamedNodeMap attr = node.getAttributes();
                NodeList children = node.getChildNodes();
                int attrCount = 0;
                if (attr != null) {
                    attrCount = attr.getLength();
                }
                int childCount = 0;
                if (children != null) {
                    childCount = children.getLength();
                }
                if (attrCount > 0) {
                    StringBuffer sBuf = new StringBuffer();
                    sBuf.append(prefix).append("<").append(ConfigurationFactory.convertToXML(name));
                    for (int i = 0; i < attrCount - 1; ++i) {
                        Node aNode2 = attr.item(i);
                        sBuf.append(" ").append(ConfigurationFactory.convertToXML(aNode2.getNodeName()));
                        sBuf.append("=\"").append(ConfigurationFactory.convertToXML(aNode2.getNodeValue())).append("\"");
                    }
                    aNode = attr.item(attrCount - 1);
                    sBuf.append(" ").append(ConfigurationFactory.convertToXML(aNode.getNodeName()));
                    sBuf.append("=\"").append(ConfigurationFactory.convertToXML(aNode.getNodeValue()));
                    if (childCount == 0) {
                        sBuf.append("\"/>");
                    } else {
                        sBuf.append("\">");
                    }
                    out.println(sBuf.toString());
                } else if (childCount == 0) {
                    out.println(prefix + "<" + ConfigurationFactory.convertToXML(name) + "/>");
                } else {
                    out.println(prefix + "<" + ConfigurationFactory.convertToXML(name) + ">");
                }
                if (recursive && childCount > 0) {
                    for (int i = 0; i < childCount; ++i) {
                        aNode = children.item(i);
                        if (aNode.getNodeType() == 3) continue;
                        ConfigurationFactory.printOutNode(out, prefix + "   ", aNode, recursive);
                    }
                    out.println(prefix + "</" + ConfigurationFactory.convertToXML(name) + ">");
                }
            } else {
                Comment comment = (Comment)node;
                String data = comment.getData().trim();
                if (data.length() > 0) {
                    if (data.indexOf(10) >= 0) {
                        out.println(prefix + "<!-- ");
                        String[] arr = data.split("\n");
                        for (int i = 0; i < arr.length; ++i) {
                            out.print(prefix + "     ");
                            out.println(arr[i]);
                        }
                        out.println(prefix + "-->");
                    } else {
                        out.print(prefix + "<!-- ");
                        out.print(data);
                        out.println(" -->");
                    }
                }
            }
        }
    }

    public static void writeXML(File file, Document doc) throws Exception {
        PrintStream out = new PrintStream(new FileOutputStream(file));
        ConfigurationFactory.writeXML(out, doc);
        out.close();
    }

    public static void writeXML(PrintStream out, Document doc) throws Exception {
        out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
        NodeList list = doc.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            ConfigurationFactory.printOutNode(out, "", list.item(i), true);
        }
    }
}

