/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.AthosConfigModelIF;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CopyServiceDialog
extends JDialog {
    JTextField textField;
    AthosConfigModelIF model;
    boolean cancelled;
    Element element;

    public CopyServiceDialog(JFrame parent, AthosConfigModelIF model, Element element) {
        super((Frame)parent, true);
        this.createPanel(parent, model, element);
    }

    public CopyServiceDialog(JDialog parent, AthosConfigModelIF model, Element element) {
        super((Dialog)parent, true);
        this.createPanel(parent, model, element);
    }

    protected void createPanel(Window parent, AthosConfigModelIF model, Element element) {
        this.cancelled = true;
        this.model = model;
        this.element = element;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        JLabel lab = new JLabel(model.getProperty("AthosConfig.Text.NewServiceName", "Name of the Service") + ":");
        this.textField = new JTextField(element.getAttribute("name"), 20);
        this.textField.setSelectionStart(0);
        this.textField.setSelectionEnd(this.textField.getText().length());
        JButton cancel = new JButton(model.getProperty("AthosConfig.Text.Cancel", "Cancel"));
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CopyServiceDialog.this.setVisible(false);
                CopyServiceDialog.this.dispose();
            }
        });
        JButton ok = new JButton(model.getProperty("AthosConfig.Text.Ok", "Ok"));
        ok.setDefaultCapable(true);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CopyServiceDialog.this.cancelled = !CopyServiceDialog.this.checkInput();
            }
        });
        JPanel inPanel = new JPanel(new GridBagLayout());
        gbc.weightx = 1.0;
        inPanel.add((Component)lab, gbc);
        ++gbc.gridx;
        gbc.weightx = 100.0;
        inPanel.add((Component)this.textField, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 100.0;
        panel.add((Component)inPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 50.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        panel.add((Component)cancel, gbc);
        ++gbc.gridx;
        panel.add((Component)ok, gbc);
        this.getContentPane().add(panel);
        this.setTitle(model.getProperty("AthosConfig.Text.NewService", "New Service"));
        this.getRootPane().setDefaultButton(ok);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    protected boolean checkInput() {
        String name = this.textField.getText().trim();
        if (name.length() == 0) {
            this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Text.NoServiceName", "No Service Name"), this.model.getProperty("AthosConfig.Text.EnterServiceFirst", "Please, enter a valid service name."));
            return false;
        }
        Document doc = this.model.getDocument();
        NodeList nodeList = doc.getElementsByTagName("product");
        if (nodeList != null && nodeList.getLength() > 0) {
            int size = nodeList.getLength();
            boolean found = false;
            for (int i = 0; !found && i < size; ++i) {
                String pName = ((Element)nodeList.item(i)).getAttribute("name");
                found = pName.compareTo(name) == 0;
            }
            if (found) {
                this.model.getFactory().showErrorMessage(this, this.model.getProperty("AthosConfig.Text.ServiceNameExists", "Service Name exists"), this.model.getProperty("AthosConfig.Text.UseAnotherServiceName", "Please, use another service name."));
                return false;
            }
        }
        this.setVisible(false);
        this.dispose();
        return true;
    }

    protected Element getServiceNode() {
        Element ret = null;
        if (!this.cancelled && this.textField.getText().trim().length() > 0) {
            try {
                Document doc = this.model.getDocument();
                ret = (Element)this.element.cloneNode(true);
                ret.setAttribute("name", this.textField.getText().trim());
                NodeList nodeList = doc.getElementsByTagName("athos_variables");
                if (nodeList != null && nodeList.getLength() > 0) {
                    Element root = (Element)nodeList.item(0);
                    root.appendChild(ret);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return ret;
    }
}

