/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.AthosConfig;
import com.highqsoft.athosconfig.ConfigurationFactory;
import com.highqsoft.athosconfig.ConfigurationIF;
import com.highqsoft.athosconfig.Constants;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DBConfiguration
implements ConfigurationIF {
    public static final String DB_URL = "jdbc:odbc:ConfigVars";
    public static final String ODBC_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    String dbURL = "jdbc:odbc:ConfigVars";
    String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
    Document doc = null;
    Element root = null;

    public DBConfiguration() {
    }

    public DBConfiguration(String dburl) {
        this();
        this.dbURL = dburl;
    }

    public DBConfiguration(String driver, String dburl) {
        this();
        this.dbURL = dburl;
        this.driver = driver;
    }

    protected Connection getConnection() throws Exception {
        Connection ret = null;
        try {
            Class.forName(this.driver);
        }
        catch (Throwable t) {
            throw new Exception("Database driver class <" + this.driver + "> not found (" + t.getMessage() + ").");
        }
        try {
            ret = DriverManager.getConnection(this.dbURL, "", "");
        }
        catch (Throwable t) {
            throw new Exception("cannot connect to database <" + this.dbURL + "> (" + t.getMessage() + ").");
        }
        return ret;
    }

    protected Statement getStatement(Connection connection) {
        Statement ret = null;
        try {
            ret = connection.createStatement();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    protected HashMap readVariables(Connection connection) throws Exception {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Statement stm = this.getStatement(connection);
        ResultSet rs = stm.executeQuery("SELECT * FROM Environmentvariables WHERE Product;");
        if (rs != null && rs.next()) {
            Vector node;
            int orderCount = 0;
            int maxOrder = 10000;
            do {
                String column;
                if ((column = rs.getString("Product")) == null || column.trim().length() <= 0) continue;
                String name = column.trim();
                node = (Vector)ret.get(name);
                if (node == null) {
                    node = new Vector();
                    ret.put(name, node);
                }
                Vector<VarValue> varNode = new Vector<VarValue>();
                column = rs.getString("Name");
                if (column == null || column.trim().length() <= 0) continue;
                name = column.trim();
                varNode.add(new VarValue("name", name));
                column = rs.getString("Description");
                if (column != null && column.trim().length() > 0) {
                    varNode.add(new VarValue("description", column.trim()));
                }
                if ((column = rs.getString("Description_" + Constants.LANGUAGE)) != null && column.trim().length() > 0) {
                    varNode.add(new VarValue("description_" + Constants.LANGUAGE, column.trim()));
                }
                if ((column = rs.getString("Defaultvalue")) != null && column.trim().length() > 0) {
                    varNode.add(new VarValue("default", column.trim()));
                }
                if ((column = rs.getString("Datatype")) != null && column.trim().length() > 0) {
                    varNode.add(new VarValue("datatype", column.trim().toUpperCase()));
                }
                if ((column = rs.getString("Range")) != null && column.trim().length() > 0) {
                    varNode.add(new VarValue("range", column.trim()));
                }
                if ((column = rs.getString("Source")) != null && column.trim().length() > 0) {
                    String val = column.toUpperCase();
                    if (val.indexOf("ENVI") >= 0) {
                        varNode.add(new VarValue("environment", "true"));
                    }
                    if (val.indexOf("INI-") >= 0) {
                        varNode.add(new VarValue("ini_file", "true"));
                        if (val.indexOf("GLOBAL") >= 0) {
                            varNode.add(new VarValue("global", "true"));
                        }
                    }
                }
                try {
                    boolean obligatory = rs.getBoolean("Obligatory");
                    varNode.add(new VarValue("obligatory", Boolean.toString(obligatory)));
                }
                catch (Throwable noObli) {
                    // empty catch block
                }
                int curOrder = 0;
                try {
                    column = rs.getString("Order");
                    if (column != null && column.trim().length() > 0) {
                        curOrder = Integer.parseInt(column.trim());
                        orderCount = Math.max(curOrder, orderCount);
                    }
                }
                catch (Throwable t) {
                    curOrder = maxOrder++;
                }
                varNode.add(new VarValue("order", "" + curOrder));
                node.add(new DBVar(varNode, curOrder));
            } while (rs.next());
            Iterator it = ret.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                node = (Vector)ret.get(key);
                Object[] arr = node.toArray(new DBVar[node.size()]);
                Arrays.sort(arr);
                ret.put((String)key, arr);
            }
        }
        return ret;
    }

    protected void readProducts() throws Exception {
        Connection connection = this.getConnection();
        Statement stm = this.getStatement(connection);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        this.doc = db.newDocument();
        this.root = this.doc.createElement("athos_variables");
        this.root.setAttribute("type", "database");
        this.root.setAttribute("dbdriver", this.driver);
        this.root.setAttribute("dburl", this.dbURL);
        this.doc.appendChild(this.root);
        HashMap map = this.readVariables(connection);
        ResultSet rs = stm.executeQuery("SELECT * FROM products ORDER BY Product;");
        if (rs.next()) {
            do {
                DBVar[] vars;
                String column;
                if ((column = rs.getString("Product")) == null || column.trim().length() <= 0) continue;
                Element productNode = this.doc.createElement("product");
                this.root.appendChild(productNode);
                String name = column.trim();
                productNode.setAttribute("name", name);
                productNode.setAttribute("description", name);
                column = rs.getString("ProductName");
                if (column != null && column.trim().length() > 0) {
                    column = column.trim();
                    productNode.setAttribute("name", column);
                    productNode.setAttribute("description", column);
                    if (column.toUpperCase().startsWith("Translator ".toUpperCase())) {
                        String val = column.substring("Translator ".length(), column.length()).trim();
                        productNode.setAttribute("drivername", val);
                    }
                }
                if ((column = rs.getString("Package")) != null && column.trim().length() > 0) {
                    productNode.setAttribute("package", column.trim());
                }
                if ((column = rs.getString("DependsOn")) != null && column.trim().length() > 0) {
                    productNode.setAttribute("depends", column.trim());
                }
                if ((vars = (DBVar[])map.get(name)) == null || vars.length <= 0) continue;
                int size = vars.length;
                for (int v = 0; v < size; ++v) {
                    Vector vals = vars[v].attr;
                    int vSize = vals.size();
                    if (vSize <= 0) continue;
                    Element varNode = this.doc.createElement("variable");
                    for (int i = 0; i < vSize; ++i) {
                        VarValue val = (VarValue)vals.get(i);
                        varNode.setAttribute(val.name, val.value);
                    }
                    productNode.appendChild(varNode);
                }
            } while (rs.next());
        }
        connection.close();
    }

    public Document getDocument() throws Exception {
        if (this.doc == null) {
            this.readProducts();
        }
        return (Document)this.doc.cloneNode(true);
    }

    public String getType() throws Exception {
        if (this.doc == null) {
            this.readProducts();
        }
        return this.doc.getFirstChild().getNodeName();
    }

    public Document getServices() throws Exception {
        if (this.root == null) {
            this.readProducts();
        }
        return this.doc;
    }

    public void unload() {
        this.doc = null;
        this.root = null;
    }

    public static void main(String[] args) {
        String filename = null;
        if (args.length > 0) {
            filename = args[0];
        } else {
            try {
                URL url = AthosConfig.class.getClassLoader().getResource(Constants.ATHOS_CONFIG);
                filename = url.getPath();
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(1);
            }
        }
        try {
            PrintStream out;
            DBConfiguration config = new DBConfiguration();
            Document doc = config.getDocument();
            try {
                out = new PrintStream(new FileOutputStream(filename));
            }
            catch (Throwable t) {
                System.err.println(t.getMessage());
                out = System.out;
            }
            ConfigurationFactory.writeXML(out, doc);
            if (!out.equals(System.out)) {
                out.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected class DBVar
    implements Comparable {
        Vector attr;
        int order;

        public DBVar(Vector attr, int order) {
            this.attr = attr;
            if (order <= 0) {
                order = Integer.MAX_VALUE;
            }
            this.order = order;
        }

        public int compareTo(Object obj) {
            if (obj instanceof DBVar) {
                return this.order - ((DBVar)obj).order;
            }
            return Integer.MAX_VALUE;
        }
    }

    protected class VarValue {
        String name;
        String value;

        public VarValue(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

