/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.AthosConfigModel;
import com.highqsoft.athosconfig.ConfigurationIF;
import com.highqsoft.athosconfig.SystemEnvironment;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class INIConfiguration
implements ConfigurationIF {
    Document doc = null;
    Element root = null;
    String iniFile;

    public INIConfiguration() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            this.doc = db.newDocument();
        }
        catch (Throwable t) {
            System.err.println("INIConfiguration.<init()> Error building document");
        }
        this.iniFile = "";
        this.root = this.doc.createElement("athos_variables");
        this.root.setAttribute("filename", this.iniFile);
        this.root.setAttribute("type", "inifile");
        this.doc.appendChild(this.root);
    }

    public INIConfiguration(String iniFile) {
        this.iniFile = iniFile;
    }

    public Document getDocument() throws Exception {
        if (this.doc == null) {
            this.doc = this.read();
        }
        return (Document)this.doc.cloneNode(true);
    }

    public String getType() throws Exception {
        if (this.doc == null) {
            this.doc = this.read();
        }
        return this.doc.getFirstChild().getNodeName();
    }

    protected Document read() throws FileNotFoundException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            this.doc = db.newDocument();
        }
        catch (Throwable t) {
            System.err.println("AthosIni.read() Error building document");
        }
        this.root = this.doc.createElement("athos_variables");
        this.root.setAttribute("type", "inifile");
        this.root.setAttribute("filename", this.iniFile);
        this.doc.appendChild(this.root);
        FileReader r = new FileReader(SystemEnvironment.getEnv(this.iniFile, this.iniFile));
        BufferedReader reader = new BufferedReader(r);
        String line = reader.readLine();
        int count = -1;
        Node product = null;
        Node list = null;
        while (line != null) {
            ++count;
            int len = (line = line.trim()).length();
            if (len > 0 && line.charAt(0) != ';' && line.charAt(0) != '#') {
                if (line.charAt(0) == '[') {
                    int idx = line.indexOf(93);
                    if (idx >= 0) {
                        Node n;
                        Comment comment;
                        int idx2;
                        String productName = null;
                        String listName = null;
                        String description = null;
                        String tag = "product";
                        if ((idx = (line = line.substring(1, idx).trim()).indexOf(32)) > 0) {
                            if (line.substring(0, idx).toUpperCase().equals("SERVICE")) {
                                productName = line.substring(idx + 1, line.length()).trim();
                            } else if (line.substring(0, idx).toUpperCase().equals("LIST")) {
                                listName = line.substring(idx + 1, line.length()).trim();
                                tag = "list";
                            } else if ((line = line.toUpperCase()).equals("ATHOS")) {
                                productName = "ATHOS";
                                description = "Global Settings";
                                tag = "globals";
                            }
                        } else if ((line = line.toUpperCase()).equals("ATHOS")) {
                            productName = "ATHOS";
                            description = "Global Settings";
                            tag = "globals";
                        } else {
                            System.err.println("Syntax error at line " + count + "\n--> " + line);
                            System.err.flush();
                        }
                        if (productName != null) {
                            list = null;
                            int idx1 = productName.indexOf("\"");
                            idx2 = productName.lastIndexOf("\"");
                            if (idx2 > idx1) {
                                productName = productName.substring(idx1 + 1, idx2).trim();
                            }
                            comment = null;
                            if (product != null && (n = product.getLastChild()) != null && n.getNodeType() == 8) {
                                comment = (Comment)product.removeChild(n);
                            }
                            product = this.doc.createElement(tag);
                            if (description != null) {
                                product.setAttribute("description", description);
                            }
                            product.setAttribute("name", productName);
                            product.setAttribute("service", productName);
                            if (comment != null) {
                                this.root.appendChild(comment);
                            }
                            this.root.appendChild(product);
                        } else if (listName != null) {
                            product = null;
                            int idx1 = listName.indexOf("\"");
                            idx2 = listName.lastIndexOf("\"");
                            if (idx2 > idx1) {
                                listName = listName.substring(idx1 + 1, idx2).trim();
                            }
                            comment = null;
                            if (product != null && (n = product.getLastChild()).getNodeType() == 8) {
                                comment = (Comment)product.removeChild(n);
                            }
                            list = this.doc.createElement(tag);
                            if (description != null) {
                                list.setAttribute("description", description);
                            }
                            list.setAttribute("name", listName);
                            if (comment != null) {
                                this.root.appendChild(comment);
                            }
                            this.root.appendChild(list);
                        } else {
                            System.err.println("Syntax error at line " + count + "\n--> " + line);
                            System.err.flush();
                        }
                    } else {
                        System.err.println("Syntax error at line " + count + "\n--> " + line);
                        System.err.flush();
                    }
                } else {
                    int idx = line.indexOf(61);
                    if (idx > 0) {
                        String key = line.substring(0, idx).trim();
                        String value = line.substring(idx + 1, len).trim();
                        int idx1 = value.indexOf("\"");
                        int idx2 = value.lastIndexOf("\"");
                        if (idx2 > idx1) {
                            value = value.substring(idx1 + 1, idx2).trim();
                        }
                        if (key.compareToIgnoreCase("DRIVER") != 0 & key.compareToIgnoreCase("PRODUCT_CONFIGURATION") != 0) {
                            Element entry = this.doc.createElement("variable");
                            entry.setAttribute("name", key);
                            entry.setAttribute("value", value);
                            product.appendChild(entry);
                        }
                        if (key.compareToIgnoreCase("DRIVER") == 0) {
                            product.setAttribute("package", "driver");
                            product.setAttribute("description", "Translator " + value);
                            product.setAttribute("drivername", value);
                            Element entry = this.doc.createElement("variable");
                            entry.setAttribute("name", "DRIVER");
                            entry.setAttribute("value", value);
                            product.appendChild(entry);
                        }
                    } else if (list != null) {
                        Element listEntry = this.doc.createElement("listentry");
                        listEntry.setAttribute("value", line);
                        list.appendChild(listEntry);
                    } else {
                        System.err.println("Syntax error at line " + count + "\n--> " + line);
                        System.err.flush();
                    }
                }
            } else if (len > 0) {
                Comment comment;
                Node last = product == null ? this.root.getLastChild() : product.getLastChild();
                if (last != null && last.getNodeType() == 8) {
                    comment = (Comment)last;
                    comment.appendData("\n");
                    comment.appendData(line.substring(1, len).trim());
                } else {
                    comment = this.doc.createComment(line.substring(1, len).trim());
                    last = null;
                }
                if (last == null) {
                    if (product != null) {
                        product.appendChild(comment);
                    } else {
                        this.root.appendChild(comment);
                    }
                }
            }
            line = reader.readLine();
        }
        return this.doc;
    }

    protected static void write(PrintStream out, Comment comment) {
        String data = comment.getData().trim();
        if (data.length() > 0) {
            String[] arr = data.split("[\n\r]");
            for (int j = 0; j < arr.length; ++j) {
                out.print("; ");
                out.println(arr[j]);
            }
        }
    }

    protected static void write(PrintStream out, Element elem) {
        NodeList nodeList = elem.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)nodeList.item(i);
                if (element.getTagName().equals("variable")) {
                    String name;
                    String value = element.getAttribute("value");
                    if ((value == null || value.length() == 0) && AthosConfigModel.isObligatory(element)) {
                        value = element.getAttribute("default");
                    }
                    if (value == null || value.length() <= 0 || (name = element.getAttribute("name")) == null || name.length() <= 0) continue;
                    String dataType = element.getAttribute("datatype").toUpperCase();
                    if (dataType == null || dataType.length() == 0) {
                        dataType = "DT_STRING";
                    }
                    if (dataType.equals("DT_STRING")) {
                        if (value.charAt(0) == '\"') {
                            value = value.substring(1, value.length() - 1).trim();
                        }
                        if (value.matches("\\s")) {
                            out.println(name + " = \"" + value + "\"");
                            continue;
                        }
                        out.println(name + " = " + value);
                        continue;
                    }
                    if (dataType.equals("DT_FILE") || dataType.equals("DT_DIRECTORY")) {
                        if (value.charAt(0) == '\"') {
                            value = value.substring(1, value.length() - 1).trim();
                        }
                        out.println(name + " = \"" + value + "\"");
                        continue;
                    }
                    out.println(name + " = " + value);
                    continue;
                }
                if (!element.getTagName().equals("listentry")) continue;
                out.println(element.getAttribute("value"));
                continue;
            }
            if (node.getNodeType() != 8) continue;
            INIConfiguration.write(out, (Comment)node);
        }
    }

    public static void write(PrintStream out, Document doc) {
        NodeList nodeList = doc.getElementsByTagName("athos_variables");
        if (nodeList != null && nodeList.getLength() > 0) {
            Element root = (Element)nodeList.item(0);
            nodeList = root.getChildNodes();
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                String service;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String name = element.getAttribute("name");
                Node sibling = element.getPreviousSibling();
                if (sibling != null && sibling.getNodeType() == 8) {
                    out.println();
                    INIConfiguration.write(out, (Comment)sibling);
                } else {
                    out.println();
                }
                if (element.getTagName().equals("globals")) {
                    service = element.getAttribute("name");
                    out.println("\n[" + service + "]");
                } else if (element.getTagName().equals("list")) {
                    String list = element.getAttribute("name");
                    out.println("\n[LIST \"" + list + "\"]");
                } else {
                    service = element.getAttribute("name");
                    out.println("[SERVICE \"" + service + "\"]");
                }
                INIConfiguration.write(out, element);
            }
        }
    }

    public static void main(String[] args) {
        INIConfiguration config = new INIConfiguration("D:/tmp/athos.ini");
        try {
            Document doc = config.getDocument();
            INIConfiguration.write(System.out, doc);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

