/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.ConfigurationFactory;
import com.highqsoft.athosconfig.INIConfiguration;
import com.highqsoft.athosconfig.VariableIF;
import com.highqsoft.athosconfig.gui.Icon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ListedPanelFactory {
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public static JComponent getPanel(Element element) throws Exception {
        Vector vec = ConfigurationFactory.getDependencies(element);
        JList<Object> list = new JList<Object>(new ItemModel(vec));
        list.setSelectionMode(0);
        JPanel ret = new JPanel(new BorderLayout());
        list.setBackground(ret.getBackground());
        ret.add("Center", new JScrollPane(list));
        VarPanel varPanel = new VarPanel();
        ret.add("South", varPanel);
        list.addListSelectionListener(varPanel);
        list.setCellRenderer(new VarRenderer());
        return ret;
    }

    public static void main(String[] args) {
        INIConfiguration config = new INIConfiguration();
        try {
            Document doc = config.getDocument();
            NodeList list = doc.getFirstChild().getChildNodes();
            int len = list.getLength();
            boolean found = false;
            Element elem = null;
            for (int i = 0; !found && i < len; ++i) {
                elem = (Element)list.item(i);
                String name = elem.getAttribute("name");
                found = name.equals("atf13");
            }
            if (found) {
                JFrame frame = new JFrame();
                frame.setIconImage(new Icon("gear.gif").getImage());
                frame.setDefaultCloseOperation(2);
                Container panel = frame.getContentPane();
                panel.setLayout(new BorderLayout());
                panel.add("Center", ListedPanelFactory.getPanel(elem));
                frame.pack();
                frame.setVisible(true);
            }
            System.out.println(config.getType());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected static class ItemModel
    implements ListModel {
        VariableIF[] var;
        Integer[] sort = null;
        boolean sorted = false;

        public ItemModel(Vector vec) {
            Element element;
            int i;
            int size = vec.size();
            int count = 0;
            for (i = 0; i < size; ++i) {
                element = (Element)vec.get(i);
                count += element.getChildNodes().getLength();
            }
            this.var = new VariableIF[count];
            count = 0;
            for (i = 0; i < size; ++i) {
                element = (Element)vec.get(i);
                NodeList list = element.getChildNodes();
                int len = list.getLength();
                for (int j = 0; j < len; ++j) {
                    Element elem = (Element)list.item(j);
                    String dType = elem.getAttribute("datatype").toUpperCase();
                    try {
                        if (dType.length() == 0) {
                            dType = "DT_STRING";
                        }
                        Class<?> clazz = Class.forName("com.highqsoft.athosconfig.gui." + dType);
                        Constructor<?> constructor = clazz.getConstructor(class$org$w3c$dom$Element == null ? ListedPanelFactory.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                        this.var[count++] = (VariableIF)constructor.newInstance(elem);
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            this.sort();
        }

        public void addListDataListener(ListDataListener l) {
        }

        public Object getElementAt(int index) {
            if (this.sorted) {
                return this.var[this.sort[index]];
            }
            return this.var[index];
        }

        public int getSize() {
            return this.var.length;
        }

        public void removeListDataListener(ListDataListener l) {
        }

        public void unsort() {
            this.sorted = false;
        }

        public void sort() {
            if (this.sort == null) {
                this.sort = new Integer[this.var.length];
                for (int i = 0; i < this.var.length; ++i) {
                    this.sort[i] = new Integer(i);
                }
            }
            Arrays.sort(this.sort, new Comparator(){

                public int compare(Object o1, Object o2) {
                    VariableIF v1 = ItemModel.this.var[(Integer)o1];
                    VariableIF v2 = ItemModel.this.var[(Integer)o2];
                    return v1.toString().compareTo(v2.toString());
                }

                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            });
            this.sorted = true;
        }
    }

    protected static class VarRenderer
    extends DefaultListCellRenderer {
        protected VarRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component ret = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            VariableIF var = (VariableIF)value;
            JComponent lab = var.getLabel();
            Color foreground = lab.getForeground();
            if (isSelected && cellHasFocus) {
                if (foreground.getRGB() == -16777216) {
                    ret.setForeground(Color.white);
                } else {
                    ret.setForeground(foreground.brighter().brighter());
                }
            } else {
                ret.setForeground(foreground);
            }
            return ret;
        }
    }

    protected static class VarPanel
    extends JPanel
    implements ListSelectionListener {
        VariableIF var;

        public VarPanel() {
            this.setLayout(new GridBagLayout());
            this.setVariable(null);
        }

        public void setVariable(VariableIF var) {
            this.var = var;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 12;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.gridy = 0;
            gbc.gridx = 0;
            if (var != null) {
                this.removeAll();
                JComponent component = var.getResetComponent();
                if (component != null) {
                    this.add((Component)component, gbc);
                    ++gbc.gridx;
                }
                if ((component = var.getDefaultComponent()) != null) {
                    this.add((Component)component, gbc);
                    ++gbc.gridx;
                }
                gbc.gridwidth = 2;
                gbc.weightx = 100.0;
                this.add((Component)var.getInput(), gbc);
            } else {
                this.removeAll();
            }
            this.updateUI();
        }

        public void valueChanged(ListSelectionEvent e) {
            int idx;
            if (!e.getValueIsAdjusting() && (idx = e.getFirstIndex()) >= 0) {
                VariableIF var = (VariableIF)((JList)e.getSource()).getSelectedValue();
                this.setVariable(var);
            }
        }
    }
}

