/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.ConfigurationFactory;
import com.highqsoft.athosconfig.INIConfiguration;
import com.highqsoft.athosconfig.XMLConfiguration;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Merger {
    public static Document mergeConfig(Document c1, Document c2) throws Exception {
        Document dbDoc = c1;
        Document iniDoc = c2;
        Element dbRoot = (Element)c1.getFirstChild();
        Element iniRoot = (Element)c2.getFirstChild();
        if (dbRoot.getAttribute("type").equalsIgnoreCase("database")) {
            if (!iniRoot.getAttribute("type").equalsIgnoreCase("inifile")) {
                throw new Exception("Second document is not fo type \"inifile\".");
            }
        } else if (dbRoot.getAttribute("type").equalsIgnoreCase("inifile")) {
            if (!iniRoot.getAttribute("type").equalsIgnoreCase("database")) {
                throw new Exception("Second document is not fo type \"database\".");
            }
            dbDoc = c2;
            iniDoc = c1;
            Element e = dbRoot;
            dbRoot = iniRoot;
            iniRoot = e;
        } else {
            throw new Exception("Unknown athos_variables type attribute \"" + dbRoot.getAttribute("type") + "\".");
        }
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (Throwable t) {
            System.err.println("AthosIni.read() Error building document");
        }
        Element root = doc.createElement("athos_variables");
        NamedNodeMap map = iniRoot.getAttributes();
        int size = map.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)map.item(i);
            root.setAttribute(attr.getName(), attr.getValue());
        }
        root.setAttribute("type", "inifile");
        doc.appendChild(root);
        NodeList iniNodeList = iniRoot.getChildNodes();
        NodeList dbNodeList = dbRoot.getChildNodes();
        size = iniNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = iniNodeList.item(i);
            if (node.getNodeType() == 1) {
                Element elem = Merger.cloneElement(doc, (Element)iniNodeList.item(i));
                if (elem == null) continue;
                String dName = elem.getAttribute("drivername");
                int count = 0;
                boolean found = false;
                Element dbElem = null;
                while (!found && count < dbNodeList.getLength()) {
                    node = dbNodeList.item(count);
                    if (node.getNodeType() == 1) {
                        dbElem = (Element)node;
                        found = dName.equalsIgnoreCase(dbElem.getAttribute("drivername"));
                    }
                    if (found) continue;
                    ++count;
                }
                if (found && dbElem != null) {
                    Merger.mergeElement(elem, dbElem);
                }
                root.appendChild(elem);
                continue;
            }
            if (node.getNodeType() == 8) {
                root.appendChild(doc.createComment(((Comment)node).getData()));
                continue;
            }
            if (node.getNodeType() != 3) continue;
            root.appendChild(doc.createComment(((CharacterData)node).getData()));
        }
        return doc;
    }

    public static void mergeElement(Element dest, Element source) {
        NamedNodeMap map = source.getAttributes();
        int size = map.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)map.item(i);
            if (dest.hasAttribute(attr.getName())) continue;
            dest.setAttribute(attr.getName(), attr.getValue());
        }
        NodeList srcNodeList = source.getChildNodes();
        NodeList destNodeList = dest.getChildNodes();
        size = srcNodeList.getLength();
        int destCount = destNodeList.getLength();
        HashMap<Element, Element> handledDestNodes = new HashMap<Element, Element>();
        for (int i = 0; i < size; ++i) {
            Node node = srcNodeList.item(i);
            if (node.getNodeType() == 1) {
                Element srcElem = (Element)node;
                String srcName = srcElem.getAttribute("name");
                if (srcName == null || srcName.length() <= 0) continue;
                int count = 0;
                boolean found = false;
                Element destElem = null;
                while (!found && count < destCount) {
                    if (destNodeList.item(count).getNodeType() == 1) {
                        destElem = (Element)destNodeList.item(count);
                        String destName = destElem.getAttribute("name");
                        found = destName != null && destName.length() > 0 && destName.equalsIgnoreCase(srcName);
                        if (found) continue;
                        ++count;
                        continue;
                    }
                    ++count;
                }
                if (found) {
                    Merger.mergeElement(destElem, srcElem);
                    handledDestNodes.put(destElem, destElem);
                    continue;
                }
                if (srcElem == null) continue;
                Element cloned = Merger.cloneElement(dest.getOwnerDocument(), srcElem);
                if (cloned != null) {
                    dest.appendChild(cloned);
                }
                handledDestNodes.put(cloned, cloned);
                continue;
            }
            if (node.getNodeType() == 8) {
                dest.appendChild(dest.getOwnerDocument().createComment(((Comment)node).getData()));
                continue;
            }
            if (node.getNodeType() != 3) continue;
            dest.appendChild(dest.getOwnerDocument().createComment(((CharacterData)node).getData()));
        }
        destNodeList = dest.getChildNodes();
        destCount = destNodeList.getLength();
        if (destCount > handledDestNodes.size()) {
            // empty if block
        }
    }

    public static Element cloneElement(Document doc, Element elem) {
        Element ret = null;
        if (doc != null && elem != null && !elem.getAttribute("name").startsWith("@")) {
            ret = doc.createElement(elem.getTagName());
            NamedNodeMap map = elem.getAttributes();
            int size = map.getLength();
            for (int i = 0; i < size; ++i) {
                Attr attr = (Attr)map.item(i);
                ret.setAttribute(attr.getName(), attr.getValue());
            }
            NodeList nodeList = elem.getChildNodes();
            size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = nodeList.item(i);
                if (node != null && node.getNodeType() == 1) {
                    elem = Merger.cloneElement(doc, (Element)node);
                    if (elem == null) continue;
                    ret.appendChild(elem);
                    continue;
                }
                if (node.getNodeType() == 8) {
                    ret.appendChild(doc.createComment(((Comment)node).getData()));
                    continue;
                }
                if (node.getNodeType() != 3) continue;
                ret.appendChild(doc.createComment(((CharacterData)node).getData()));
            }
        }
        return ret;
    }

    public static HashMap getMergingElement(Element dest, Element source) {
        Element elem;
        HashMap ret = new HashMap();
        NodeList nodeList = dest.getElementsByTagName("variable");
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elem = (Element)nodeList.item(i);
            map.put(elem.getAttribute("name"), elem);
        }
        nodeList = source.getElementsByTagName("variable");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elem = (Element)nodeList.item(i);
            String name = elem.getAttribute("name");
            if (!map.containsKey(name)) continue;
            ret.put(name, map.remove(name));
        }
        return ret;
    }

    public static void main(String[] args) {
        INIConfiguration iniConfig = new INIConfiguration("D:/athos/etc/demo.ini");
        XMLConfiguration dbConfig = new XMLConfiguration();
        try {
            Document doc = Merger.mergeConfig(dbConfig.getDocument(), iniConfig.getDocument());
            ConfigurationFactory.writeXML(System.out, doc);
            INIConfiguration.write(System.out, doc);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

