/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.ConfigurationFactory;
import com.highqsoft.athosconfig.DBConfiguration;
import com.highqsoft.athosconfig.VariableIF;
import com.highqsoft.athosconfig.gui.Icon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PanelFactory {
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public static void getPanelForElement(JPanel panel, GridBagConstraints gbc, Element element) throws Exception {
        gbc.gridwidth = 5;
        String text = element.getAttribute("name").toUpperCase();
        JLabel lab = new JLabel();
        Border border = BorderFactory.createRaisedBevelBorder();
        lab.setBorder(border);
        lab.setOpaque(true);
        lab.setAlignmentX(0.5f);
        lab.setText(text);
        lab.setForeground(Color.white);
        lab.setBackground(Color.blue.darker());
        gbc.weightx = 100.0;
        panel.add((Component)lab, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        NodeList list = element.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Element elem = (Element)list.item(i);
            String dType = elem.getAttribute("datatype").toUpperCase();
            try {
                if (dType.length() == 0) {
                    dType = "DT_STRING";
                }
                Class<?> clazz = Class.forName("com.highqsoft.athosconfig.gui." + dType);
                Constructor<?> constructor = clazz.getConstructor(class$org$w3c$dom$Element == null ? PanelFactory.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                VariableIF variable = (VariableIF)constructor.newInstance(elem);
                JComponent component = variable.getLabel();
                if (component != null) {
                    panel.add((Component)component, gbc);
                }
                ++gbc.gridx;
                component = variable.getInput();
                gbc.gridwidth = 2;
                gbc.weightx = 100.0;
                if (component != null) {
                    panel.add((Component)component, gbc);
                }
                gbc.gridwidth = 1;
                gbc.weightx = 1.0;
                gbc.gridx += 2;
                component = variable.getResetComponent();
                if (component != null) {
                    panel.add((Component)component, gbc);
                    ++gbc.gridx;
                }
                if ((component = variable.getDefaultComponent()) != null) {
                    panel.add((Component)component, gbc);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                JLabel label = new JLabel("Unknown datatype <" + dType + "> for variable \"" + elem.getAttribute("name").toUpperCase() + "\".");
                gbc.gridwidth = 4;
                panel.add((Component)label, gbc);
            }
            gbc.gridwidth = 1;
            gbc.gridx = 0;
            ++gbc.gridy;
        }
    }

    public static JComponent getPanel(Element element) throws Exception {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        Vector vec = ConfigurationFactory.getDependencies(element);
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            Element elem = (Element)vec.get(i);
            PanelFactory.getPanelForElement(ret, gbc, elem);
        }
        return new JScrollPane(ret);
    }

    public static void main(String[] args) {
        DBConfiguration config = new DBConfiguration();
        try {
            Document doc = config.getDocument();
            NodeList list = doc.getFirstChild().getChildNodes();
            int len = list.getLength();
            boolean found = false;
            Element elem = null;
            for (int i = 0; !found && i < len; ++i) {
                elem = (Element)list.item(i);
                String name = elem.getAttribute("name");
                found = name.equals("aod2");
            }
            if (found) {
                JFrame frame = new JFrame();
                frame.setIconImage(new Icon("gear.gif").getImage());
                frame.setDefaultCloseOperation(2);
                Container panel = frame.getContentPane();
                panel.setLayout(new BorderLayout());
                panel.add("Center", PanelFactory.getPanel(elem));
                frame.pack();
                frame.setVisible(true);
            }
            System.out.println(config.getType());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

