/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;

public class SystemEnvironment
extends Properties {
    private static final String osName = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String osArch = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String osVersion = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String pathSep = System.getProperty("path.separator");
    protected static SystemEnvironment instance = null;

    protected SystemEnvironment() {
        this.getEnvironment();
    }

    public static SystemEnvironment getInstance() {
        if (instance == null) {
            instance = new SystemEnvironment();
        }
        return instance;
    }

    public static String getEnv(String key, String defaultVal) {
        SystemEnvironment env = SystemEnvironment.getInstance();
        return env.getProperty(key, defaultVal);
    }

    public static String getEnv(String key) {
        return SystemEnvironment.getEnv(key, null);
    }

    public static String findEnv(String val) {
        SystemEnvironment env = SystemEnvironment.getInstance();
        Iterator<Object> it = env.keySet().iterator();
        Object current = null;
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = env.getProperty(key);
            int idx = val.indexOf(value);
            if (idx < 0) continue;
            val = val.substring(0, idx) + "$(" + key + ")" + val.substring(idx + value.length(), val.length());
        }
        return val;
    }

    protected void getEnvironment() {
        try {
            String line;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PumpStreamHandler pump = new PumpStreamHandler(out);
            Process process = Runtime.getRuntime().exec(SystemEnvironment.getProcEnvCommand());
            try {
                pump.setProcessInputStream(process.getOutputStream());
                pump.setProcessOutputStream(process.getInputStream());
                pump.setProcessErrorStream(process.getErrorStream());
            }
            catch (Throwable e) {
                process.destroy();
                e.printStackTrace();
            }
            pump.start();
            int status = -1;
            try {
                process.waitFor();
                status = process.exitValue();
            }
            catch (InterruptedException e) {
                process.destroy();
            }
            pump.stop();
            BufferedReader in = null;
            if (SystemEnvironment.isFamily("z/os")) {
                try {
                    in = new BufferedReader(new StringReader(out.toString("Cp1047")));
                }
                catch (UnsupportedEncodingException e) {}
            } else {
                in = new BufferedReader(new StringReader(out.toString()));
            }
            String var = null;
            String lineSep = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                if (line.indexOf(61) == -1) {
                    if (var == null) {
                        var = lineSep + line;
                        continue;
                    }
                    var = var + lineSep + line;
                    continue;
                }
                if (var != null) {
                    this.addEnvironment(var);
                }
                var = line;
            }
            if (var != null) {
                this.addEnvironment(var);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        catch (Throwable ace) {
            System.err.println("No system environment access.");
        }
    }

    protected void addEnvironment(String line) {
        int idx = line.indexOf(61);
        if (idx > 0) {
            this.put(line.substring(0, idx), line.substring(idx + 1, line.length()));
        }
    }

    private static String[] getProcEnvCommand() {
        if (SystemEnvironment.isFamily("os/2")) {
            String[] cmd = new String[]{"cmd", "/c", "set"};
            return cmd;
        }
        if (SystemEnvironment.isFamily("windows")) {
            if (!SystemEnvironment.isFamily("win9x")) {
                String[] cmd = new String[]{"cmd", "/c", "set"};
                return cmd;
            }
            String[] cmd = new String[]{"command.com", "/c", "set"};
            return cmd;
        }
        if (SystemEnvironment.isFamily("z/os")) {
            String[] cmd = new String[]{"/bin/env"};
            return cmd;
        }
        if (SystemEnvironment.isFamily("unix")) {
            String[] cmd = new String[]{"/usr/bin/env"};
            return cmd;
        }
        if (SystemEnvironment.isFamily("netware")) {
            String[] cmd = new String[]{"env"};
            return cmd;
        }
        String[] cmd = null;
        return cmd;
    }

    public static boolean isFamily(String family) {
        return SystemEnvironment.isOs(family, null, null, null);
    }

    public static boolean isName(String name) {
        return SystemEnvironment.isOs(null, name, null, null);
    }

    public static boolean isArch(String arch) {
        return SystemEnvironment.isOs(null, null, arch, null);
    }

    public static boolean isVersion(String version) {
        return SystemEnvironment.isOs(null, null, null, version);
    }

    public static boolean isOs(String family, String name, String arch, String version) {
        boolean retValue = false;
        if (family != null || name != null || arch != null || version != null) {
            boolean isFamily = true;
            boolean isName = true;
            boolean isArch = true;
            boolean isVersion = true;
            if (family != null) {
                if (family.equals("windows")) {
                    isFamily = osName.indexOf("windows") > -1;
                } else if (family.equals("os/2")) {
                    isFamily = osName.indexOf("os/2") > -1;
                } else if (family.equals("netware")) {
                    isFamily = osName.indexOf("netware") > -1;
                } else if (family.equals("dos")) {
                    isFamily = pathSep.equals(";") && !SystemEnvironment.isFamily("netware");
                } else if (family.equals("mac")) {
                    isFamily = osName.indexOf("mac") > -1;
                } else if (family.equals("unix")) {
                    isFamily = pathSep.equals(":") && (!SystemEnvironment.isFamily("mac") || osName.endsWith("x"));
                } else if (family.equals("win9x")) {
                    isFamily = SystemEnvironment.isFamily("windows") && osName.indexOf("nt") < 0 && osName.indexOf("2000") < 0 && osName.indexOf("2003") < 0 && osName.indexOf("xp") < 0;
                } else if (family.equals("z/os")) {
                    isFamily = osName.indexOf("z/os") > -1 || osName.indexOf("os/390") > -1;
                } else {
                    System.err.println("Don't know how to detect os family \"" + family + "\"");
                }
            }
            if (name != null) {
                isName = name.equals(osName);
            }
            if (arch != null) {
                isArch = arch.equals(osArch);
            }
            if (version != null) {
                isVersion = version.equals(osVersion);
            }
            retValue = isFamily && isName && isArch && isVersion;
        }
        return retValue;
    }

    public static String replaceEnvironments(String s) {
        int idx1;
        String env;
        int idx;
        int i;
        s = s.replace('\\', '/');
        String[] arr = s.split("\\$");
        StringBuffer sBuf = new StringBuffer(arr[0]);
        for (i = 1; i < arr.length; ++i) {
            idx = arr[i].indexOf(47);
            if (idx > 0) {
                env = arr[i].substring(0, idx);
                sBuf.append(SystemEnvironment.getEnv(env, "$" + env));
                sBuf.append(arr[i].substring(idx, arr[i].length()));
                continue;
            }
            env = arr[i];
            sBuf.append(SystemEnvironment.getEnv(env, "$" + env));
        }
        arr = sBuf.toString().split("\\%");
        sBuf = new StringBuffer();
        for (i = 0; i < arr.length; ++i) {
            if (i % 2 != 0) {
                env = SystemEnvironment.getEnv(arr[i], null);
                if (env != null) {
                    sBuf.append(env);
                    continue;
                }
                sBuf.append("%").append(arr[i]).append("%");
                continue;
            }
            sBuf.append(arr[i]);
        }
        s = sBuf.toString();
        idx = s.indexOf("${");
        while (idx >= 0) {
            idx1 = s.indexOf(125, idx);
            if (idx1 > idx) {
                env = s.substring(idx + 2, idx1);
                s = (env = SystemEnvironment.getEnv(env, null)) != null ? s.substring(0, idx) + env + s.substring(idx1 + 1, s.length()) : s.substring(0, idx) + s.substring(idx + 1, s.length());
                idx = s.indexOf("${");
                continue;
            }
            idx = -1;
        }
        idx = s.indexOf("$(");
        while (idx >= 0) {
            idx1 = s.indexOf(41, idx);
            if (idx1 > idx) {
                env = s.substring(idx + 2, idx1);
                s = (env = SystemEnvironment.getEnv(env, null)) != null ? s.substring(0, idx) + env + s.substring(idx1 + 1, s.length()) : s.substring(0, idx) + s.substring(idx1 + 1, s.length());
                idx = s.indexOf("$(");
                continue;
            }
            idx = -1;
        }
        return s;
    }

    public static void main(String[] args) {
        System.out.println(SystemEnvironment.getEnv("ATHOS_ROOT"));
        String s = SystemEnvironment.replaceEnvironments("file:///$(ATHOS_ROOT)/etc/$(OSTYPE)/asamev.atf").replace('\\', '/');
        System.out.println(s);
        try {
            URL url = new URL(s);
            File file = new File(url.getFile());
            System.out.println(file);
            System.out.println(SystemEnvironment.findEnv(file.toString()));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public class StreamPumper
    implements Runnable {
        private static final int SLEEP = 5;
        private static final int SIZE = 128;
        private InputStream is;
        private OutputStream os;
        private boolean finished;

        public StreamPumper(InputStream is, OutputStream os) {
            this.is = is;
            this.os = os;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.finished = false;
            }
            byte[] buf = new byte[128];
            try {
                int length;
                while ((length = this.is.read(buf)) > 0) {
                    this.os.write(buf, 0, length);
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Exception exception) {
                StreamPumper streamPumper2 = this;
                synchronized (streamPumper2) {
                    this.finished = true;
                    this.notify();
                }
            }
            finally {
                StreamPumper e = this;
                synchronized (e) {
                    this.finished = true;
                    this.notify();
                }
            }
        }

        public synchronized boolean isFinished() {
            return this.finished;
        }

        public synchronized void waitFor() throws InterruptedException {
            while (!this.isFinished()) {
                this.wait();
            }
        }
    }

    public class PumpStreamHandler {
        private Thread inputThread;
        private Thread errorThread;
        private OutputStream out;
        private OutputStream err;

        public PumpStreamHandler(OutputStream out, OutputStream err) {
            this.out = out;
            this.err = err;
        }

        public PumpStreamHandler(OutputStream outAndErr) {
            this(outAndErr, outAndErr);
        }

        public PumpStreamHandler() {
            this(System.out, System.err);
        }

        public void setProcessOutputStream(InputStream is) {
            this.createProcessOutputPump(is, this.out);
        }

        public void setProcessErrorStream(InputStream is) {
            this.createProcessErrorPump(is, this.err);
        }

        public void setProcessInputStream(OutputStream os) {
        }

        public void start() {
            this.inputThread.start();
            this.errorThread.start();
        }

        public void stop() {
            try {
                this.inputThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.errorThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.err.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected OutputStream getErr() {
            return this.err;
        }

        protected OutputStream getOut() {
            return this.out;
        }

        protected void createProcessOutputPump(InputStream is, OutputStream os) {
            this.inputThread = this.createPump(is, os);
        }

        protected void createProcessErrorPump(InputStream is, OutputStream os) {
            this.errorThread = this.createPump(is, os);
        }

        protected Thread createPump(InputStream is, OutputStream os) {
            Thread result = new Thread(new StreamPumper(is, os));
            result.setDaemon(true);
            return result;
        }
    }
}

