/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.ConfigurationFactory;
import com.highqsoft.athosconfig.DBConfiguration;
import com.highqsoft.athosconfig.PanelFactory;
import com.highqsoft.athosconfig.gui.Icon;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TabbedPanelFactory {
    public static JComponent getPanel(Element element) throws Exception {
        Vector vec = ConfigurationFactory.getDependencies(element);
        int size = vec.size();
        JTabbedPane ret = null;
        if (size > 0) {
            ret = new JTabbedPane();
        }
        GridBagConstraints gbc = new GridBagConstraints();
        for (int i = 0; i < size; ++i) {
            Element elem = (Element)vec.get(i);
            JPanel container = new JPanel(new BorderLayout());
            JPanel panel = new JPanel(new GridBagLayout());
            gbc.fill = 2;
            gbc.anchor = 12;
            gbc.gridx = 0;
            gbc.gridy = 0;
            PanelFactory.getPanelForElement(panel, gbc, elem);
            container.add("North", panel);
            ret.addTab(elem.getAttribute("name"), new JScrollPane(container));
        }
        return ret;
    }

    public static void main(String[] args) {
        DBConfiguration config = new DBConfiguration();
        try {
            Document doc = config.getDocument();
            NodeList list = doc.getFirstChild().getChildNodes();
            int len = list.getLength();
            boolean found = false;
            Element elem = null;
            for (int i = 0; !found && i < len; ++i) {
                elem = (Element)list.item(i);
                String name = elem.getAttribute("name");
                found = name.equals("aod2");
            }
            if (found) {
                JFrame frame = new JFrame();
                frame.setIconImage(new Icon("gear.gif").getImage());
                frame.setDefaultCloseOperation(2);
                Container panel = frame.getContentPane();
                panel.setLayout(new BorderLayout());
                panel.add("Center", TabbedPanelFactory.getPanel(elem));
                frame.pack();
                frame.setVisible(true);
            }
            System.out.println(config.getType());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

