/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig;

import com.highqsoft.athosconfig.AthosConfig;
import com.highqsoft.athosconfig.ConfigurationIF;
import com.highqsoft.athosconfig.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfiguration
implements ConfigurationIF {
    Document doc = null;
    Element root = null;
    Node kernel;
    String xmlFile;

    public XMLConfiguration() {
        this.xmlFile = null;
    }

    public XMLConfiguration(String xmlFile) {
        this.xmlFile = xmlFile;
    }

    public Document getDocument() throws Exception {
        if (this.doc == null) {
            this.doc = this.read();
        }
        return (Document)this.doc.cloneNode(true);
    }

    public String getType() throws Exception {
        if (this.doc == null) {
            this.doc = this.read();
        }
        return this.doc.getFirstChild().getNodeName();
    }

    public NodeList getPackages(String pattern) throws Exception {
        NodeList nodeList;
        ReturnList ret = new ReturnList();
        if (this.doc == null) {
            this.doc = this.read();
        }
        if ((nodeList = this.doc.getElementsByTagName("product")) != null && nodeList.getLength() > 0) {
            pattern = pattern.trim().toUpperCase();
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Element node = (Element)nodeList.item(i);
                String attr = node.getAttribute("package").toUpperCase();
                if (attr == null || attr.length() <= 0 || !attr.matches(pattern)) continue;
                ret.add(node);
            }
        }
        return ret;
    }

    public Node getKernel() {
        if (this.kernel == null) {
            NodeList nodeList = this.doc.getElementsByTagName("product");
            for (int i = 0; this.kernel == null && i < nodeList.getLength(); ++i) {
                Element elem = (Element)nodeList.item(i);
                if (!elem.getAttribute("package").equalsIgnoreCase("kernel")) continue;
                this.kernel = elem;
            }
        }
        return this.kernel;
    }

    protected Document read() throws FileNotFoundException, IOException {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            if (this.xmlFile != null) {
                doc = db.parse(new File(this.xmlFile));
            } else {
                try {
                    this.xmlFile = AthosConfig.class.getClassLoader().getResource(Constants.ATHOS_CONFIG).toString();
                    doc = db.parse(AthosConfig.class.getClassLoader().getResourceAsStream(Constants.ATHOS_CONFIG));
                }
                catch (Throwable t) {
                    throw new IOException("Resource \"" + Constants.ATHOS_CONFIG + "\" not found.");
                }
            }
            Element root = (Element)doc.getFirstChild();
            root.setAttribute("filename", this.xmlFile);
        }
        catch (Throwable t) {
            System.err.println("Unable to read \"" + this.xmlFile + "\".");
        }
        return doc;
    }

    public static void main(String[] args) {
        XMLConfiguration config = args.length == 0 ? new XMLConfiguration() : new XMLConfiguration(args[0]);
        try {
            Document doc = config.getDocument();
            NodeList list = config.getPackages("application");
            for (int i = 0; i < list.getLength(); ++i) {
                System.out.println(((Element)list.item(i)).getAttribute("name"));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected class ReturnList
    implements NodeList {
        Vector vec = new Vector();

        public void add(Node node) {
            this.vec.add(node);
        }

        public int getLength() {
            return this.vec.size();
        }

        public Node item(int idx) {
            return (Node)this.vec.get(idx);
        }
    }
}

