/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig.gui;

import com.highqsoft.athosconfig.AdoptListener;
import com.highqsoft.athosconfig.VariableIF;
import com.highqsoft.athosconfig.gui.Variable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.w3c.dom.Element;

public class DT_STRING
extends Variable
implements VariableIF {
    protected JTextField textField = null;
    protected JComboBox box = null;

    public DT_STRING(Element elem) {
        super(elem);
    }

    public JComponent getInput() {
        JComponent ret = null;
        String type = this.getVariable().getAttribute("datatype");
        Vector<String> vec = null;
        boolean editable = false;
        if (type.equals("DT_STRING")) {
            String range = this.getVariable().getAttribute("range");
            if (range == null) {
                range = "";
            }
            range = range.trim();
            Object[] arr = null;
            vec = new Vector<String>();
            if (range.length() > 0) {
                arr = range.split(",");
                for (int i = 0; i < arr.length; ++i) {
                    if (arr[i].trim().length() <= 0) continue;
                    vec.add(arr[i].trim());
                }
                editable = range.endsWith(",");
                String def = this.getDefaultValue();
                if (def.length() != 0) {
                    Arrays.sort(arr);
                    if (Arrays.binarySearch(arr, def) < 0) {
                        vec.insertElementAt(def, 0);
                    }
                }
            }
        }
        if (vec != null && vec.size() > 0) {
            this.box = new JComboBox(vec);
            this.box.setEditable(editable);
            ret = this.box;
        } else {
            ret = this.textField = new JTextField(10);
            this.textField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    Iterator it = DT_STRING.this.listenerList.keySet().iterator();
                    while (it.hasNext()) {
                        ((AdoptListener)it.next()).adopt();
                    }
                }
            });
        }
        this.setValue(this.getCurrentValue());
        return ret;
    }

    public void setValue(String def) {
        if (this.textField != null) {
            this.textField.setText(def);
            this.textField.setSelectionStart(0);
            this.textField.setSelectionEnd(def.length());
            this.textField.requestFocus();
        } else if (this.box != null) {
            if (def.length() == 0) {
                this.box.setSelectedIndex(0);
            } else {
                this.box.setSelectedItem(def);
            }
        }
    }

    public String getValue() {
        if (this.textField != null) {
            return this.textField.getText().trim();
        }
        if (this.box != null) {
            return this.box.getSelectedItem().toString();
        }
        return "";
    }
}

