/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig.gui;

import com.highqsoft.athosconfig.AdoptListener;
import com.highqsoft.athosconfig.Constants;
import com.highqsoft.athosconfig.VariableIF;
import com.highqsoft.athosconfig.gui.Icon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Variable
implements VariableIF {
    static HashMap prefaults;
    static HashMap defaults;
    Element variable;
    HashMap listenerList = new HashMap();

    public Variable(Element var) {
        if (var == null) {
            throw new RuntimeException("The variable is not available!");
        }
        String name = var.getNodeName();
        if (name == null) {
            throw new RuntimeException("The node name is not avaiable.");
        }
        if (!name.equalsIgnoreCase("variable")) {
            throw new RuntimeException("The node must have the type <variable> instead of <" + name + ">.");
        }
        name = var.getAttribute("name");
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeException("The node has no <name> attribute.");
        }
        this.variable = var;
    }

    public Element getVariable() {
        return this.variable;
    }

    public JComponent getLabel() {
        JLabel ret = null;
        ret = new JLabel(this.variable.getAttribute("name") + ":");
        ret.setAlignmentX(0.0f);
        if (this.isObligatory()) {
            ret.setForeground(Color.red.darker());
        }
        return ret;
    }

    public abstract JComponent getInput();

    public JComponent getDefaultComponent() {
        JComponent ret = null;
        if (this.isThereADefault()) {
            JButton but = new JButton(new Icon("magenta-ball.gif"));
            but.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    Variable.this.setToDefault();
                }
            });
            but.setToolTipText("Default");
            ret = but;
        } else {
            ret = new JLabel();
        }
        Dimension dim = ret.getPreferredSize();
        ret.setPreferredSize(new Dimension(dim.height, dim.height));
        return ret;
    }

    public JComponent getResetComponent() {
        JButton ret = new JButton(new Icon("green-ball.gif"));
        ret.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Variable.this.reset();
            }
        });
        ret.setToolTipText("Reset");
        Dimension dim = ret.getPreferredSize();
        ret.setPreferredSize(new Dimension(dim.height, dim.height));
        return ret;
    }

    protected boolean isThereADefault() {
        return this.getDefaultValue().length() != 0;
    }

    public boolean isDefault() {
        String def;
        boolean ret = true;
        String value = this.variable.getAttribute("value");
        if (value != null && value.length() > 0 && (def = this.variable.getAttribute("default")) != null && def.length() > 0) {
            ret = value.equals(def);
        }
        return ret;
    }

    public boolean isObligatory() {
        char c;
        String val = "false";
        if (this.variable.hasAttribute("obligatory") && (val = this.variable.getAttribute("obligatory")).length() == 0) {
            val = "false";
        }
        return (c = val.toLowerCase().charAt(0)) == 't' || c == 'y' || c == '1' || c == 'w' || c == 'j';
    }

    public boolean isKernel() {
        String val = "false";
        Element parent = (Element)this.variable.getParentNode();
        return parent != null && parent.hasAttribute("package") && parent.getAttribute("package").equals("kernel");
    }

    protected String getDefaultValue() {
        String name = this.variable.getAttribute("name");
        String ret = (String)prefaults.get(name);
        if (ret == null) {
            ret = this.variable.getAttribute("default");
            if (ret == null) {
                ret = "";
            }
            if ((ret = ret.trim()).length() == 0 || ret.toUpperCase().indexOf("NO DEFAULT") == 0) {
                Object val = defaults.get(name);
                ret = val != null ? val.toString() : "";
            }
        }
        return ret;
    }

    public void setElementValue() throws Exception {
        String val = this.getValue();
        if (val.equals(this.getDefaultValue())) {
            if (this.variable.hasAttribute("value")) {
                this.variable.removeAttribute("value");
            }
        } else {
            this.variable.setAttribute("value", this.getValue());
        }
    }

    public void setElementToDefault() {
        if (!this.isObligatory()) {
            if (this.variable.hasAttribute("value")) {
                this.variable.removeAttribute("value");
            }
        } else if (this.isThereADefault()) {
            this.variable.setAttribute("value", this.getDefaultValue());
        }
    }

    public String getElementValue() {
        if (this.variable.hasAttribute("value")) {
            return this.variable.getAttribute("value");
        }
        return null;
    }

    public boolean isGlobal() {
        return Variable.isVarGlobal(this.variable);
    }

    public boolean isEnvironment() {
        return Variable.isVarEnvironment(this.variable);
    }

    public boolean isIniFile() {
        return this.isVarIniFile(this.variable);
    }

    public static boolean isVarGlobal(Element variable) {
        char c;
        String val = variable.getAttribute("global");
        if (val == null) {
            val = "false";
        }
        return (c = val.toLowerCase().charAt(0)) == 't' || c == 'y' || c == '1' || c == 'w' || c == 'j';
    }

    public static boolean isVarEnvironment(Element variable) {
        char c;
        String val = variable.getAttribute("environment");
        if (val == null) {
            val = "false";
        }
        return (c = val.toLowerCase().charAt(0)) == 't' || c == 'y' || c == '1' || c == 'w' || c == 'j';
    }

    public boolean isVarIniFile(Element variable) {
        char c;
        String val = variable.getAttribute("ini_file");
        if (val == null) {
            val = "false";
        }
        return (c = val.toLowerCase().charAt(0)) == 't' || c == 'y' || c == '1' || c == 'w' || c == 'j';
    }

    public void setToDefault() {
        this.setValue(this.getDefaultValue());
    }

    public void reset() {
        String val = this.getElementValue();
        if (val != null) {
            this.setValue(val);
        } else {
            this.setToDefault();
        }
    }

    public String getCurrentValue() {
        String val = this.getElementValue();
        if (val == null) {
            val = this.getDefaultValue();
        }
        return val;
    }

    public String toString() {
        return this.variable.getAttribute("name");
    }

    public String getDescription() {
        if (this.variable.hasAttribute("description_" + Constants.LANGUAGE)) {
            return this.variable.getAttribute("description_" + Constants.LANGUAGE);
        }
        return this.variable.getAttribute("description");
    }

    public String getComment() {
        Node node = this.variable.getPreviousSibling();
        if (node != null) {
            if (node.getNodeType() == 3) {
                node = node.getPreviousSibling();
            }
            if (node.getNodeType() == 8) {
                return ((CharacterData)node).getData();
            }
        }
        return "";
    }

    public void setComment(String sval) {
        if (sval == null) {
            sval = "";
        }
        if ((sval = sval.trim()).length() == 0) {
            this.removeComment();
        } else {
            Node node = this.variable.getPreviousSibling();
            if (node == null || node.getNodeType() != 8) {
                if (sval.length() > 0) {
                    Comment comment = this.variable.getOwnerDocument().createComment(sval);
                    this.variable.getParentNode().insertBefore(comment, this.variable);
                }
            } else {
                Comment comment = (Comment)node;
                comment.setData(sval);
            }
        }
    }

    public void removeComment() {
        Node parent;
        Node node = this.variable.getPreviousSibling();
        if (node != null && (parent = this.variable.getParentNode()) != null) {
            if (node.getNodeType() == 3) {
                Node n = node.getPreviousSibling();
                parent.removeChild(node);
                node = n;
            }
            if (node.getNodeType() == 8) {
                parent.removeChild(node);
            }
        }
    }

    public abstract void setValue(String var1);

    public void addAdoptListener(AdoptListener listener) {
        if (listener != null) {
            this.listenerList.put(listener, listener);
        }
    }

    public void removeAdoptListener(AdoptListener listener) {
        if (listener != null) {
            this.listenerList.remove(listener);
        }
    }

    static {
        defaults = new HashMap();
        prefaults = new HashMap();
        if (System.getProperty("os.name").toUpperCase().startsWith("WIN")) {
            defaults.put("OSTYPE", "win32");
            prefaults.put("ERR_DEVICE", "EventLog");
        } else {
            defaults.put("OSTYPE", "Linux");
            prefaults.put("ERR_DEVICE", "FILE");
        }
        prefaults.put("MULTITHREADABLE", "YES");
        prefaults.put("USER", "");
        prefaults.put("PASSWORD", "");
        prefaults.put("RUN_SINGLETHREADED", "NO");
        prefaults.put("WORKING_DIR", System.getProperty("user.home"));
        prefaults.put("BIN_PATH", ".");
    }
}

