/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.athosconfig.xml;

import com.highqsoft.athosconfig.GUIFactoryIF;
import com.highqsoft.athosconfig.xml.Aliases;
import com.highqsoft.athosconfig.xml.Properties;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Factory
implements GUIFactoryIF {
    static Factory instance = null;
    static final String PACKAGE = Factory.class.getPackage().getName();
    protected HashMap baseRef;
    protected HashMap objRef = new HashMap();

    public Factory() {
        this.baseRef = new HashMap();
    }

    public static Factory getInstance() {
        if (instance == null) {
            instance = new Factory();
        }
        return instance;
    }

    public void initialize(Object ref, Document doc) throws Exception {
        Base base = (Base)this.baseRef.get(ref);
        if (base == null) {
            base = new Base();
            this.baseRef.put(ref, base);
            base.doc = doc;
            if (System.getProperty("os.name").toUpperCase().indexOf("WINDOWS") >= 0) {
                UIManager.LookAndFeelInfo[] arr = UIManager.getInstalledLookAndFeels();
                boolean found = false;
                for (int i = 0; !found && i < arr.length; ++i) {
                    boolean bl = found = arr[i].getName().toUpperCase().indexOf("WINDOWS") >= 0;
                    if (!found) continue;
                    UIManager.setLookAndFeel(arr[i].getClassName());
                }
                UIManager.put("ToolTipUI", ToolTipUI.class.getName());
            }
            base.doc = doc;
            NodeList nodeList = doc.getElementsByTagName("com.highqsoft.athosconfig.xml.Aliases");
            int size = nodeList.getLength();
            base.aliases = size > 0 ? (Aliases)this.create(ref, nodeList.item(0)) : new Aliases();
            nodeList = doc.getElementsByTagName("com.highqsoft.athosconfig.xml.Properties");
            size = nodeList.getLength();
            if (size == 0) {
                Iterator<Object> it = base.aliases.keySet().iterator();
                Object key = null;
                boolean found = false;
                while (!found && it.hasNext()) {
                    key = it.next();
                    found = base.aliases.get(key).toString().equals("com.highqsoft.athosconfig.xml.Properties");
                }
                if (found && key != null) {
                    nodeList = doc.getElementsByTagName(key.toString());
                    size = nodeList.getLength();
                }
            }
            Element prop = null;
            if (size > 0) {
                Locale locale = Locale.getDefault();
                String lang = locale.getLanguage();
                String country = lang + "_" + locale.getCountry();
                Element defaultProp = null;
                for (int i = 0; prop == null && i < size; ++i) {
                    Element p = (Element)nodeList.item(i);
                    if (p.hasAttribute("locale")) {
                        String attr = p.getAttribute("locale");
                        if (attr.equals(country)) {
                            prop = p;
                            continue;
                        }
                        if (!attr.equals(lang)) continue;
                        prop = p;
                        continue;
                    }
                    if (defaultProp != null) continue;
                    defaultProp = p;
                }
                if (prop == null) {
                    prop = defaultProp;
                }
            }
            base.properties = prop == null ? new Properties() : (Properties)this.create(ref, prop);
        }
    }

    protected String replaceProperty(Properties properties, String val) {
        int idx = val.indexOf("${");
        if (idx >= 0) {
            StringBuffer buf = new StringBuffer();
            int idx2 = 0;
            boolean stop = false;
            while (!stop && idx >= 0) {
                buf.append(val.substring(idx2, idx));
                idx2 = val.indexOf(125, idx);
                if (idx2 > 0) {
                    String prop = val.substring(idx + 2, idx2);
                    String propVal = properties.getProperty(prop, "${" + prop + "}");
                    buf.append(propVal);
                    idx = val.indexOf("${", idx2);
                    if (idx >= 0) continue;
                    if (idx2 + 1 < val.length()) {
                        buf.append(val.substring(idx2 + 1, val.length()));
                        continue;
                    }
                    stop = true;
                    continue;
                }
                buf.append(val.substring(idx, val.length()));
                stop = true;
            }
            if (stop) {
                return buf.toString();
            }
            idx = buf.toString().indexOf("${");
            if (idx < 0) {
                return buf.toString();
            }
            return this.replaceProperty(properties, buf.toString());
        }
        return val;
    }

    protected String getMethodName(Attr attr) {
        String name = attr.getName();
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    public String getProperty(Object ref, String key, String def) {
        String ret = def;
        Base base = (Base)this.baseRef.get(ref);
        if (base != null) {
            ret = base.properties.getProperty(key, def);
            ret = this.replaceProperty(base.properties, ret);
        }
        return ret;
    }

    public Object create(Object ref, String pattern) throws Exception {
        Object ret = null;
        Base base = (Base)this.baseRef.get(ref);
        if (base != null) {
            NodeList nodeList = base.doc.getFirstChild().getChildNodes();
            int size = nodeList.getLength();
            Element used = null;
            for (int i = 0; used == null && i < size; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (used = (Element)nodeList.item(i)).getTagName().matches(pattern)) continue;
                used = null;
            }
            if (used != null) {
                ret = this.create(ref, used);
            } else {
                Iterator<Object> it = base.aliases.keySet().iterator();
                boolean found = false;
                String key = null;
                String val = null;
                while (!found && it.hasNext()) {
                    key = it.next().toString();
                    val = base.aliases.getProperty(key);
                    found = val != null && val.matches(pattern);
                }
                if (found && key != null) {
                    ret = this.create(ref, key);
                } else {
                    System.err.println("Element with pattern \"" + pattern + "\" not found.");
                }
            }
        }
        return ret;
    }

    public Object create(Object ref, Node node) throws Exception {
        Object ret = null;
        Base base = (Base)this.baseRef.get(ref);
        if (base != null && node.getNodeType() == 1) {
            Method m;
            String className = ((Element)node).getTagName();
            if (base.aliases != null && base.aliases.getProperty(className) != null) {
                className = base.aliases.getProperty(className);
            }
            if (className.indexOf(46) < 0) {
                className = PACKAGE + "." + className;
            }
            Class<?> clazz = Class.forName(className);
            ret = clazz.newInstance();
            this.objRef.put(ret, ref);
            Class[] params = new Class[]{String.class};
            NamedNodeMap map = node.getAttributes();
            int size = map.getLength();
            for (int i = 0; i < size; ++i) {
                Attr attr = (Attr)map.item(i);
                try {
                    m = clazz.getMethod(this.getMethodName(attr), params);
                    try {
                        m.invoke(ret, (Object[])new String[]{this.replaceProperty(base.properties, attr.getValue())});
                    }
                    catch (Throwable callingError) {
                        System.err.println("Cannot call setter method \"" + this.getMethodName(attr) + "\" for attribute \"" + attr.getName() + "\" in class \"" + clazz.getName() + "\".");
                    }
                    continue;
                }
                catch (Throwable noAttr) {
                    System.err.println("No setter method for attribute \"" + attr.getName() + "\" in class \"" + clazz.getName() + "\".");
                }
            }
            NodeList nodeList = node.getChildNodes();
            size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Object child = this.create(ref, nodeList.item(i));
                if (child == null) continue;
                params = new Class[]{child.getClass()};
                m = this.getMethodForClass(clazz, child.getClass());
                if (m == null) {
                    Class<?>[] arr = child.getClass().getInterfaces();
                    boolean found = false;
                    m = null;
                    for (int n = arr.length - 1; !found && n >= 0; --n) {
                        String mName = arr[n].getName();
                        params = new Class[]{arr[n]};
                        int idx = mName.lastIndexOf(46);
                        if (idx > 0) {
                            mName = mName.substring(idx + 1, mName.length());
                        }
                        try {
                            m = clazz.getMethod("add" + mName, params);
                            found = true;
                            continue;
                        }
                        catch (NoSuchMethodException notFound) {
                            System.err.println(notFound.getMessage());
                        }
                    }
                }
                if (m != null) {
                    m.invoke(ret, child);
                    continue;
                }
                System.err.println("No method for " + child.getClass().getName() + " found.");
            }
        }
        return ret;
    }

    public Object getReference(Object key) {
        return this.objRef.get(key);
    }

    public Document getDocument(Object ref) {
        Document ret = null;
        Base base = (Base)this.baseRef.get(ref);
        if (base != null) {
            ret = base.doc;
        }
        return ret;
    }

    protected Method getMethodForClass(Class clazz, Class param) {
        Method ret = null;
        if (param != null) {
            try {
                ret = clazz.getMethod("add", param);
            }
            catch (Throwable t) {
                ret = this.getMethodForClass(clazz, param.getSuperclass());
            }
        }
        return ret;
    }

    public void showErrorMessage(Container parent, String title, String message) {
        JOptionPane.showMessageDialog(parent, message, title, 0);
    }

    public void showWarningMessage(Container parent, String title, String message) {
        JOptionPane.showMessageDialog(parent, message, title, 2);
    }

    public void showInfoMessage(Container parent, String title, String message) {
        JOptionPane.showMessageDialog(parent, message, title, 1);
    }

    public static class ToolTipUI
    extends BasicToolTipUI {
        static ToolTipUI sharedInstance = new ToolTipUI();
        static int MAX_WIDTH = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
        static int BORDERWIDTH = 2;

        public static ComponentUI createUI(JComponent c) {
            return sharedInstance;
        }

        public void paint(Graphics g1, JComponent c) {
            Graphics2D g = (Graphics2D)g1;
            TextLayout layout = null;
            float ali = 0.0f;
            FontRenderContext frc = new FontRenderContext(null, true, true);
            boolean width = false;
            String text = ((JToolTip)c).getTipText();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setPaint(c.getForeground());
            int yPos = 0;
            boolean xPos = false;
            Dimension dim = c.getSize();
            if (text != null && text.length() > 0) {
                String[] arr = text.split("\n");
                boolean nLines = false;
                float ascent = 0.0f;
                for (int i = 0; i < arr.length; ++i) {
                    AttributedString str = new AttributedString(arr[i]);
                    str.addAttribute(TextAttribute.FONT, c.getFont());
                    AttributedCharacterIterator iter = str.getIterator();
                    LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                    while (measurer.getPosition() < iter.getEndIndex()) {
                        layout = measurer.nextLayout(dim.width - 2 * BORDERWIDTH);
                        yPos = (int)((float)yPos + (layout.getAscent() + layout.getDescent() + layout.getLeading()));
                        layout.draw(g, BORDERWIDTH, yPos);
                    }
                }
            }
        }

        public Dimension getPreferredSize(JComponent c) {
            int yPos;
            int width;
            block3: {
                String[] arr;
                FontRenderContext frc;
                TextLayout layout;
                block4: {
                    layout = null;
                    float ali = 0.0f;
                    frc = new FontRenderContext(null, true, true);
                    width = 0;
                    String text = ((JToolTip)c).getTipText();
                    yPos = 0;
                    boolean xPos = false;
                    if (text == null || text.length() <= 0) break block3;
                    arr = text.split("\n");
                    boolean nLines = false;
                    float ascent = 0.0f;
                    if (arr.length != 1) break block4;
                    AttributedString str = new AttributedString(arr[0]);
                    str.addAttribute(TextAttribute.FONT, c.getFont());
                    AttributedCharacterIterator iter = str.getIterator();
                    LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                    layout = measurer.nextLayout(2.1474836E9f);
                    yPos = (int)((float)yPos + (layout.getAscent() + layout.getDescent() + layout.getLeading()));
                    width = (int)Math.ceil(layout.getVisibleAdvance());
                    if (width <= MAX_WIDTH) break block3;
                    measurer = new LineBreakMeasurer(iter, frc);
                    yPos = 0;
                    width = 0;
                    while (measurer.getPosition() < iter.getEndIndex()) {
                        layout = measurer.nextLayout(MAX_WIDTH);
                        yPos = (int)((float)yPos + (layout.getAscent() + layout.getDescent() + layout.getLeading()));
                        width = Math.max(width, (int)Math.ceil(layout.getVisibleAdvance()));
                    }
                    break block3;
                }
                for (int i = 0; i < arr.length; ++i) {
                    AttributedString str = new AttributedString(arr[i]);
                    str.addAttribute(TextAttribute.FONT, c.getFont());
                    AttributedCharacterIterator iter = str.getIterator();
                    LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                    while (measurer.getPosition() < iter.getEndIndex()) {
                        layout = measurer.nextLayout(MAX_WIDTH);
                        yPos = (int)((float)yPos + (layout.getAscent() + layout.getDescent() + layout.getLeading()));
                        width = Math.max(width, (int)Math.ceil(layout.getVisibleAdvance()));
                    }
                }
            }
            return new Dimension(width + 2 * BORDERWIDTH, yPos + 2 * BORDERWIDTH);
        }
    }

    protected class Base {
        protected Properties properties;
        protected Aliases aliases;
        protected Document doc;

        protected Base() {
        }
    }
}

