/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.VariableSubstitutor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FinishPanel
extends IzPanel
implements ActionListener {
    private BoxLayout layout;
    private JButton autoButton;
    private JPanel centerPanel;
    private VariableSubstitutor vs;

    public FinishPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        this.vs = new VariableSubstitutor(idata.getVariables());
        GridBagLayout superLayout = new GridBagLayout();
        this.setLayout(superLayout);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        gbConstraints.fill = 0;
        gbConstraints.anchor = 10;
        this.centerPanel = new JPanel();
        this.layout = new BoxLayout(this.centerPanel, 1);
        this.centerPanel.setLayout(this.layout);
        superLayout.addLayoutComponent(this.centerPanel, gbConstraints);
        this.add(this.centerPanel);
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.parent.langpack.getString("FinishPanel.done"));
        if (this.idata.installSuccess) {
            this.centerPanel.add(LabelFactory.create(this.parent.langpack.getString("FinishPanel.success"), this.parent.icons.getImageIcon("information"), 11));
            this.centerPanel.add(Box.createVerticalStrut(20));
            if (this.idata.uninstallOutJar != null) {
                String path = this.translatePath("$INSTALL_PATH") + File.separator + "Uninstaller";
                this.centerPanel.add(LabelFactory.create(this.parent.langpack.getString("FinishPanel.uninst.info"), this.parent.icons.getImageIcon("information"), 11));
                this.centerPanel.add(LabelFactory.create(path, this.parent.icons.getImageIcon("empty"), 11));
            }
            this.centerPanel.add(Box.createVerticalStrut(20));
            this.autoButton = ButtonFactory.createButton(this.parent.langpack.getString("FinishPanel.auto"), this.parent.icons.getImageIcon("edit"), this.idata.buttonsHColor);
            this.autoButton.setToolTipText(this.parent.langpack.getString("FinishPanel.auto.tip"));
            this.autoButton.addActionListener(this);
            this.centerPanel.add(this.autoButton);
        } else {
            this.centerPanel.add(LabelFactory.create(this.parent.langpack.getString("FinishPanel.fail"), this.parent.icons.getImageIcon("information"), 11));
        }
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(this.idata.getInstallPath()));
        fc.setMultiSelectionEnabled(false);
        fc.addChoosableFileFilter(fc.getAcceptAllFileFilter());
        try {
            if (fc.showSaveDialog(this) == 0) {
                File file = fc.getSelectedFile();
                FileOutputStream out = new FileOutputStream(file);
                BufferedOutputStream outBuff = new BufferedOutputStream(out, 5120);
                this.parent.writeXMLTree(this.idata.xmlData, outBuff);
                outBuff.flush();
                outBuff.close();
                this.autoButton.setEnabled(false);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            JOptionPane.showMessageDialog(this, err.toString(), this.parent.langpack.getString("installer.error"), 0);
        }
    }

    private String translatePath(String destination) {
        destination = this.vs.substitute(destination, null);
        return destination.replace('/', File.separatorChar);
    }
}

